/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.app.AbstractEditUIHandler;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.app.IdList;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.config.ConfigControllerFactory;

public class EditUIHandler
extends AbstractEditUIHandler {
    public static final String ADDNEW = "ADDNEW";
    public static final String VIEW = "VIEW";
    public static final String EDIT = "EDIT";
    public static final String COPYADDNEW = "COPYADDNEW";

    @Override
    public void handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._handleInit(request, response, context);
    }

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        ConfigControllerFactory.getLocalInstance(context).getUserConfigData("SubmitAndAdd", request.getMetaDataPK().getFullName());
        ConfigControllerFactory.getLocalInstance(context).getUserConfigData("SubmitAndPrint", request.getMetaDataPK().getFullName());
        this.requestData(request, response, context);
    }

    protected ICoreBase getBizInterface(RequestContext request, Context context) throws Exception {
        BOSObjectType bosType = request.getBosType();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)context, (BOSObjectType)bosType);
        return coreBase;
    }

    protected CoreBaseInfo getValue(RequestContext request, Context context, IObjectPK pk) throws Exception {
        SelectorItemCollection selector = request.getSelectorItemCollection();
        return this.getBizInterface(request, context).getValue(pk, selector);
    }

    private void requestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        BaseFrameService service = new BaseFrameService();
        service.checkFieldPermission(request, response, context);
        service.getTableConfig(request, response, context);
    }

    private void checkOUSealUp(RequestContext request, ResponseContext response, Context context) throws Exception {
        BOSObjectType bosType = request.getBosType();
        int orgType = FrameWorkUtils.getOrgTypeExtendedPropertyies(context, bosType);
        String orgId = null;
        orgId = request.getMainOrg() == null ? request.getOrg().toString() : request.getMainOrg();
        if (orgId != null) {
            NewOrgUnitFacadeFactory.getLocalInstance((Context)context).checkIsOUSealUp(orgId, orgType);
        }
    }

    protected void switchRequestOrg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        return null;
    }

    protected void applyDefaultValue(IObjectValue vo) throws Exception {
    }

    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void verifyInput(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void storeFields(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private void handleTurnPage(RequestContext request, ResponseContext response, Context context) throws Exception {
        IdList.getBillIDList(request, response, context);
        BaseFrameService service = new BaseFrameService();
        String id = request.getNewId();
        String status = request.getState();
        SelectorItemCollection selector = request.getSelectorItemCollection();
        if (status != null && status.equals(EDIT)) {
            request.setId(request.getOldId());
            service.repleaseMutextControl(request, response, context);
        }
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CoreBaseInfo value = this.getValue(request, context, (IObjectPK)pk);
        request.setValue(value);
        Class[] typeClass = new Class[]{IObjectPK.class, SelectorItemCollection.class};
        Object[] paramsValue = new Object[]{pk, selector};
        BaseFrameService.getMultiKey(response, ICoreBase.class, "getValue", typeClass, paramsValue, value);
        this.loadFields(request, response, context);
        if (status != null && status.equals(EDIT)) {
            request.setId(id);
            service.requestMutextControl(request, response, context);
        }
    }

    @Override
    protected void _handleActionFirst(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleTurnPage(request, response, context);
    }

    @Override
    public void _handleActionNext(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleTurnPage(request, response, context);
    }

    @Override
    public void _handleActionLast(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleTurnPage(request, response, context);
    }

    @Override
    public void _handleActionPre(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleTurnPage(request, response, context);
    }

    @Override
    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        String status = request.getState();
        if (status != null && status.equals(EDIT)) {
            String controlType = request.getControlType();
            String curCuid = request.getCuid();
            if (controlType != null && controlType.equalsIgnoreCase("S1")) {
                if (curCuid == null || !curCuid.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                    return;
                }
            } else if (controlType != null && controlType.equalsIgnoreCase("S3")) {
                String id = request.getId();
                ICUIDGetterFacade cuidFacade = CUIDGetterFacadeFactory.getLocalInstance((Context)context);
                String cuid = cuidFacade.getCUID(id);
                if (curCuid == null || cuid == null || !curCuid.equals(cuid)) {
                    return;
                }
            }
            this.requestData(request, response, context);
        }
    }

    @Override
    public void _handleActionRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        String controlType = request.getControlType();
        String curCuid = request.getCuid();
        if (controlType != null && controlType.equalsIgnoreCase("S1")) {
            if (curCuid == null || !curCuid.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                return;
            }
        } else if (controlType != null && controlType.equalsIgnoreCase("S3")) {
            String id = request.getId();
            ICUIDGetterFacade cuidFacade = CUIDGetterFacadeFactory.getLocalInstance((Context)context);
            String cuid = cuidFacade.getCUID(id);
            Class[] typeClass = new Class[]{String.class};
            Object[] paramsValue = new Object[]{id};
            BaseFrameService.getMultiKey(response, ICUIDGetterFacade.class, "getCUID", typeClass, paramsValue, cuid);
            if (curCuid == null || cuid == null || !curCuid.equals(cuid)) {
                return;
            }
        }
    }

    public void handleRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        BaseFrameService service = new BaseFrameService();
        request.setId(request.getOldId());
        service.requestMutextControl(request, response, context);
        String id = request.getId();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ICoreBase coreBase = this.getBizInterface(request, context);
        coreBase.delete((IObjectPK)pk);
        if (request.getNewId() != null) {
            this.handleTurnPage(request, response, context);
        } else {
            service.repleaseMutextControl(request, response, context);
            request.setId(request.getNewId());
            IObjectValue info = this.createNewData(request, response, context);
            this.applyDefaultValue(info);
            request.setValue((CoreBaseInfo)info);
            this.loadFields(request, response, context);
        }
    }

    @Override
    protected void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        BaseFrameService service = new BaseFrameService();
        service.repleaseMutextControl(request, response, context);
        this.loadFields(request, response, context);
    }

    @Override
    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        String status = request.getState();
        if (status != null && (status.equals(EDIT) || status.equals(VIEW))) {
            BaseFrameService service = new BaseFrameService();
            service.repleaseMutextControl(request, response, context);
        }
        request.setState(ADDNEW);
        IObjectValue info = this.createNewData(request, response, context);
        if (info != null) {
            request.setValue((CoreBaseInfo)info);
        }
        this.loadFields(request, response, context);
    }

    @Override
    protected void _handleActionAttachment(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCancel(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.storeFields(request, response, context);
        this.verifyInput(request, response, context);
        BaseFrameService service = new BaseFrameService();
        String id = request.getId();
        String status = request.getState();
        CoreBaseInfo info = request.getValue();
        if (id == null || info == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ICoreBase coreBase = this.getBizInterface(request, context);
        coreBase.cancel((IObjectPK)pk, info);
        this.getValue(request, context, (IObjectPK)pk);
        service.repleaseMutextControl(request, response, context);
        if (status != null && status.equals(EDIT)) {
            request.setId(id);
            service.requestMutextControl(request, response, context);
        }
        this.loadFields(request, response, context);
    }

    @Override
    protected void _handleActionCancelCancel(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.storeFields(request, response, context);
        this.verifyInput(request, response, context);
        String id = request.getId();
        String status = request.getState();
        CoreBaseInfo info = request.getValue();
        if (id == null || info == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ICoreBase coreBase = this.getBizInterface(request, context);
        coreBase.cancelCancel((IObjectPK)pk, info);
        this.getValue(request, context, (IObjectPK)pk);
        BaseFrameService service = new BaseFrameService();
        service.repleaseMutextControl(request, response, context);
        if (status.equals(EDIT)) {
            service.requestMutextControl(request, response, context);
        }
        this.loadFields(request, response, context);
    }

    @Override
    protected void _handleActionPrint(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionPrintPreview(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.storeFields(request, response, context);
        this.verifyInput(request, response, context);
        CoreBaseInfo info = request.getValue();
        if (info == null) {
            return;
        }
        BaseFrameService service = new BaseFrameService();
        if (info.getId() != null) {
            request.setId(info.getId().toString());
            service.repleaseMutextControl(request, response, context);
        }
        IObjectPK retPk = this.runSave(request, context);
        request.setState(EDIT);
        if (retPk == null) {
            return;
        }
        response.put("Fw_ObjectPK", retPk);
        this.doAfterSave(request, response, context);
    }

    protected void doAfterSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        IObjectPK retPk = (IObjectPK)response.get("Fw_ObjectPK");
        String status = request.getState();
        CoreBaseInfo value = this.getValue(request, context, retPk);
        if (status.equals(EDIT)) {
            request.setValue(value);
            request.setId(retPk.toString());
            BaseFrameService service = new BaseFrameService();
            service.requestMutextControl(request, response, context);
        }
        this.loadFields(request, response, context);
    }

    protected IObjectPK runSave(RequestContext request, Context context) throws Exception {
        CoreBaseInfo info = request.getValue();
        ICoreBase coreBase = this.getBizInterface(request, context);
        IObjectPK retPk = coreBase.save(info);
        return retPk;
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.storeFields(request, response, context);
        this.verifyInput(request, response, context);
        this.doBeforeSubmit(request, response, context);
    }

    public void doRealSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        CoreBaseInfo info = request.getValue();
        if (info == null) {
            return;
        }
        IObjectPK retPk = this.runSubmit(request, context);
        if (retPk == null) {
            return;
        }
        response.put("Fw_ObjectPK", retPk);
        this.doAfterSubmit(request, response, context);
    }

    protected void doBeforeSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._doBeforeSubmitForWF(request, response, context);
    }

    protected void doAfterSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        IObjectPK retPk = (IObjectPK)response.get("Fw_ObjectPK");
        String status = request.getState();
        if (status != null) {
            boolean addNew = request.isSubmitAddNew();
            if (!status.equals(ADDNEW) || !addNew) {
                BaseFrameService service = new BaseFrameService();
                service.repleaseMutextControl(request, response, context);
                CoreBaseInfo value = this.getValue(request, context, retPk);
                request.setValue(value);
                request.setId(retPk.toString());
                service.requestMutextControl(request, response, context);
            } else if (status.equals(ADDNEW) || addNew) {
                IObjectValue value = this.createNewData(request, response, context);
                request.setValue((CoreBaseInfo)value);
            }
            this.loadFields(request, response, context);
        }
        this.doTransferGUItoHTML(request, response, context);
    }

    private void doTransferGUItoHTML(RequestContext request, ResponseContext response, Context ctx) throws EASBizException, BOSException {
    }

    protected IObjectPK runSubmit(RequestContext request, Context context) throws Exception {
        CoreBaseInfo info = request.getValue();
        ICoreBase coreBase = this.getBizInterface(request, context);
        IObjectPK retPk = coreBase.submit(info);
        return retPk;
    }

    @Override
    protected void _handleActionSubmitOption(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionMsgFormat(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionReset(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId, Context context) throws Exception {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)context);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if (iCodingRuleManager.isExist(caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber(caller, orgId)) {
                if (iCodingRuleManager.isUserSelect(caller, orgId)) {
                    if (iCodingRuleManager.isDHExist(caller, orgId)) {
                        // empty if block
                    }
                } else {
                    iCodingRuleManager.readNumber(caller, orgId);
                }
            } else {
                iCodingRuleManager.getNumber(caller, orgId);
            }
            iCodingRuleManager.isModifiable(caller, orgId);
        }
    }
}

