/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.util.Uuid;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ItemActionUIHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.batchHandler.server.ItemActionUIHandler");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseContext actionPerformed(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.beforeAction(request, response, context);
        String MethodName = request.getMethodName();
        String handler = request.getClassName();
        if (MethodName != null && handler != null) {
            try {
                Class<?> handlerClass = Class.forName(handler);
                Object handlerInstance = handlerClass.newInstance();
                Method actionMethod = handlerClass.getMethod(MethodName, RequestContext.class, ResponseContext.class, Context.class);
                actionMethod.invoke(handlerInstance, request, response, context);
            }
            catch (InvocationTargetException e) {
                Throwable throwAble = e.getTargetException();
                if (throwAble instanceof Exception) {
                    throw (Exception)throwAble;
                }
                throw e;
            }
            catch (NoSuchMethodException ex) {
                logger.error((Object)"NoSuchMethodException", (Throwable)ex);
            }
            finally {
                this.afterAction(request, response, context);
            }
        }
        return response;
    }

    private void beforeAction(RequestContext request, ResponseContext response, Context context) throws Exception {
        String MethodName = request.getMethodName();
        if (MethodName != null && !MethodName.equals("handleInit")) {
            this.treatActionService(request, response, context);
        }
    }

    private void afterAction(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (request.isReleasNet()) {
            BaseFrameService service = new BaseFrameService();
            service.repleaseNetFunction(request, response, context);
        }
    }

    private void treatActionService(RequestContext request, ResponseContext response, Context context) throws Exception {
        BaseFrameService service = new BaseFrameService();
        service.checkActionPermission(request, response, context);
        this.prepareContext(request, context);
        service.netFunction(request, response, context);
    }

    private void prepareContext(RequestContext request, Context context) {
        boolean bool = true;
        String mutexStr = request.getMutexStr();
        if (mutexStr == null || mutexStr.trim().length() < 1) {
            return;
        }
        String[] mutexArray = mutexStr.split(";");
        String[][] mutexs = new String[mutexArray.length][2];
        for (int i = 0; i < mutexs.length; ++i) {
            String[] mutex = mutexArray[i].split(",");
            for (int j = 0; j < 2; ++j) {
                int testnumber;
                mutexs[i][j] = mutex[j];
                if (j != 1 || (testnumber = new Integer(mutexs[i][j]).intValue()) <= 1) continue;
                bool = false;
            }
        }
        if (bool) {
            MutexParameter mutextParam = request.getNetParam();
            if (mutextParam == null) {
                mutextParam = new MutexParameter();
            }
            Uuid uuid = request.getNetUuid();
            mutextParam.setRequestId(uuid);
            mutextParam.setActionName(request.getActionText());
            mutextParam.setUserID(BOSUuid.read((String)request.getUserPK().toString()));
            mutextParam.setDcName(request.getDcName());
            if (request.getObjectValueOrg() != null) {
                mutextParam.setOrgUnitID(BOSUuid.read((String)request.getObjectValueOrg().toString()));
            }
            for (int i = 0; i < mutexs.length; ++i) {
                mutextParam.setMutexName(mutexs[i][0]);
                if (mutexs[i][1].equals("0")) {
                    mutextParam.setMutexLockType(MutexLockType.SHARE_LOCK);
                    continue;
                }
                mutextParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            }
            request.setNetParam(mutextParam);
        }
    }
}

