/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.IUserCustomConfig;
import com.kingdee.eas.framework.config.IUserCustomConfigItemUI;
import com.kingdee.eas.framework.config.UserCustomConfigData;
import com.kingdee.eas.framework.config.UserCustomConfigFactory;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.framework.config.UserCustomConfigItem;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserCustomConfigLoader;
import com.kingdee.eas.framework.config.UserXMLHelper;
import com.kingdee.eas.framework.config.client.PreferencesUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;

public class UserCustomConfigHelper {
    private Map configItems = new LinkedHashMap();
    private Map tables = new LinkedHashMap();
    private static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    private ResourceBundleHelper resHelper = new ResourceBundleHelper(RESNAME);
    private CoreUI ui;
    private KDMenuItem menuItemPreferences;
    private UserCustomConfigData configData;
    private List configItemList;
    private boolean needSave;

    public UserCustomConfigHelper(CoreUI ui) {
        this.ui = ui;
    }

    public void init() {
        Component[] components = this.ui.getComponents();
        this.tables.clear();
        this.findAllTables(components);
        Object[] objs = this.tables.values().toArray();
        for (int i = 0; i < objs.length; ++i) {
            KDTable table = (KDTable)objs[i];
            try {
                this.registerConfigItem(table.getName() + i, "table", (Component)table);
                continue;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.configItemList = this.getConfigItemList(this.configItems);
        if (this.tables.size() > 0) {
            this.configData = this.loadDataFromDB();
            if (this.configData != null && !this.configData.isLoadByDefault()) {
                this.applyUserConfig();
            }
        }
    }

    public List getConfigItemList() {
        return this.configItemList;
    }

    private List getConfigItemList(Map items) {
        ArrayList<UserCustomConfigItem> result = new ArrayList<UserCustomConfigItem>();
        for (String key : items.keySet()) {
            UserCustomConfigItem item = (UserCustomConfigItem)this.configItems.get(key);
            result.add(item);
            this.addSubItem(result, item);
        }
        return result;
    }

    private void addSubItem(List result, UserCustomConfigItem item) {
        for (int i = 0; i < item.getSubItems().size(); ++i) {
            UserCustomConfigItem subItem = (UserCustomConfigItem)item.getSubItems().get(i);
            result.add(subItem);
            this.addSubItem(result, subItem);
        }
    }

    private UserCustomConfigData loadDataFromDB() {
        UserCustomConfigInfo userConfigInfo;
        ObjectMultiPK pk = new ObjectMultiPK();
        pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
        pk.setKeyValue("uiClassName", (Object)this.ui.getClass().getName());
        UserCustomConfigLoader config = new UserCustomConfigLoader();
        try {
            userConfigInfo = this.getBizInterface().getValue((IObjectPK)pk);
        }
        catch (Exception e) {
            return config.getUserConfigData("");
        }
        if (userConfigInfo.getConfigXML() == null) {
            return null;
        }
        UserCustomConfigData ucData = config.getUserConfigData(userConfigInfo.getConfigXML());
        return ucData;
    }

    private UserCustomConfigData loadDataFromFile() {
        UserCustomConfigLoader config = new UserCustomConfigLoader();
        UserCustomConfigData ucData = config.getUserConfigData(SysContext.getSysContext().getCurrentUserInfo(), this.ui.getClass());
        return ucData;
    }

    private void findAllTables(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof KDTable) {
                this.tables.put(components[i].getName() + this.tables.size(), components[i]);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            Container container = (Container)components[i];
            this.findAllTables(container.getComponents());
        }
    }

    public Map getConfigItems() {
        return this.configItems;
    }

    public Map getTables() {
        return this.tables;
    }

    private void registerConfigItem(String itemName, String keyName, Component component) {
        try {
            this.configItems.put(itemName, UserXMLHelper.getConfigItem(itemName, keyName, component));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public KDMenuItem getMenuItem() {
        if (this.menuItemPreferences != null) {
            return this.menuItemPreferences;
        }
        this.menuItemPreferences = new KDMenuItem();
        this.menuItemPreferences.setName("menuItemPreferences");
        this.menuItemPreferences.setAction((Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                UserCustomConfigHelper.this.ui.getUIContext().put("Owner", UserCustomConfigHelper.this.ui);
                UserCustomConfigHelper.this.ui.getUIContext().put("ID", null);
                UserCustomConfigHelper.this.ui.getUIContext().put("ConfigItems", UserCustomConfigHelper.this.configItems);
                UserCustomConfigHelper.this.ui.getUIContext().put("ConfigData", UserCustomConfigHelper.this.configData);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PreferencesUI.class.getName(), UserCustomConfigHelper.this.ui.getUIContext(), null, OprtState.VIEW);
                }
                catch (UIException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                if (uiWindow != null) {
                    uiWindow.show();
                }
                UserCustomConfigHelper.this.applyUserConfig();
            }
        });
        this.menuItemPreferences.setText(this.resHelper.getString("UITitle"));
        this.menuItemPreferences.setToolTipText(this.resHelper.getString("UITitle"));
        return this.menuItemPreferences;
    }

    public void applyUserConfig() {
        if (this.configData == null) {
            return;
        }
        for (int i = 0; i < this.configItemList.size(); ++i) {
            UserCustomConfigItem item = (UserCustomConfigItem)this.configItemList.get(i);
            if (item.getItemUI() == null || !(item.getItemUI() instanceof IUserCustomConfigItemUI)) continue;
            ((IUserCustomConfigItemUI)item.getItemUI()).applyConfig(this.configData, item);
        }
    }

    public UserCustomConfigData getConfigData() {
        return this.configData;
    }

    public void setConfigData(UserCustomConfigData configData) {
        this.configData = configData;
    }

    public void saveDataToFile() {
        UserCustomConfigData ucData = this.loadDataFromFile();
        this.prepareItems(ucData, this.configItems);
        if (this.needSave) {
            this.saveToFile(ucData);
        }
    }

    private void prepareItems(UserCustomConfigData ucData, Map items) {
        this.needSave = false;
        for (int i = 0; i < this.configItemList.size(); ++i) {
            UserCustomConfigItem item = (UserCustomConfigItem)this.configItemList.get(i);
            if (item.getItemUI() == null || !(item.getItemUI() instanceof IUserCustomConfigItemUI)) continue;
            this.prepareItemData(ucData, ucData.getDefaultSolution().getName(), item.getName(), ((IUserCustomConfigItemUI)item.getItemUI()).getItemDataFromUI(item));
            this.needSave = true;
        }
    }

    public void saveDataToDB() throws Exception {
        if (this.tables.size() == 0) {
            return;
        }
        UserCustomConfigData ucData = this.loadDataFromDB();
        if (ucData == null) {
            ucData = new UserCustomConfigData();
        }
        this.prepareItems(ucData, this.configItems);
        if (this.needSave) {
            this.saveDataToDB(ucData);
        }
    }

    public void saveDataToDB(UserCustomConfigData data) throws Exception {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            UserXMLHelper.saveData(data, (Writer)writer, "UTF-8");
            ObjectMultiPK pk = new ObjectMultiPK();
            pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
            pk.setKeyValue("uiClassName", (Object)this.ui.getClass().getName());
            UserCustomConfigInfo userConfigInfo = new UserCustomConfigInfo();
            userConfigInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
            userConfigInfo.setUiClassName(this.ui.getClass().getName());
            userConfigInfo.setConfigXML(writer.toString());
            if (this.getBizInterface().exists((IObjectPK)pk)) {
                this.getBizInterface().update((IObjectPK)pk, userConfigInfo);
            } else {
                this.getBizInterface().addnew(userConfigInfo);
            }
        }
        catch (IOException err) {
            throw err;
        }
        finally {
            writer.close();
        }
        if (data != null) {
            this.setConfigData(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(UserCustomConfigData data) {
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        try {
            out = new FileOutputStream(new File("D:/userconfig.xml"));
            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            UserXMLHelper.saveData(data, (Writer)writer, "UTF-8");
        }
        catch (IOException err) {
            ExceptionHandler.handle((Throwable)err);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    private void prepareItemData(UserCustomConfigData data, String solutionName, String itemName, UserCustomConfigItemData itemData) {
        data.setItemData(solutionName, itemName, itemData);
    }

    public IUserCustomConfig getBizInterface() throws Exception {
        return UserCustomConfigFactory.getRemoteInstance();
    }
}

