/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.EventType;
import com.kingdee.eas.ep.client.runtime.RequireUtil;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.framework.expression.BizExpressionExecutor;
import com.kingdee.eas.framework.expression.GeneralRuleListener;
import com.kingdee.util.StringUtils;
import java.awt.Container;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class BizRuleExecutor {
    private AbstractRuleInfo rule;
    private Map localCtx;
    private Interpreter interpreter;
    private CoreUI targetUI;
    private boolean isExecuting = false;
    private Object eventObject = null;
    private EventListener eventListener = null;
    private RequireUtil requireUtil = new RequireUtil();
    private static final Logger logger = Logger.getLogger(BizRuleExecutor.class);

    public BizRuleExecutor(CoreUI targetUI, Interpreter interpreter, Map localCtx, AbstractRuleInfo rule) {
        this.targetUI = targetUI;
        this.interpreter = interpreter;
        this.localCtx = localCtx;
        this.rule = rule;
    }

    public BizRuleExecutor(CoreUI targetUI, Interpreter interpreter, Map localCtx, AbstractRuleInfo rule, RequireUtil requireUtil) {
        this.targetUI = targetUI;
        this.interpreter = interpreter;
        this.localCtx = localCtx;
        this.rule = rule;
        this.requireUtil = requireUtil;
    }

    public void execute() throws Exception {
        if (!this.isExecuting && this.targetUI != null && this.interpreter != null && this.rule != null && this.rule instanceof ConditionRuleInfo) {
            ConditionRuleInfo caRule = (ConditionRuleInfo)this.rule;
            if (EventType.INITIAL.equals((Object)caRule.getEventType()) || EventType.SUBMIT.equals((Object)caRule.getEventType())) {
                this.eventObject = this.targetUI;
                this.eventListener = this.registerListener(this.targetUI, caRule.getEventType(), caRule.getEventName());
            } else {
                this.eventObject = BizRuleExecutor.searchEventObject(this.targetUI, this.localCtx, caRule.getEventObjectName());
                if (this.eventObject != null) {
                    this.eventListener = this.registerListener(this.eventObject, caRule.getEventType(), caRule.getEventName());
                }
            }
        }
        this.isExecuting = true;
    }

    private Object execute(AbstractExpressionInfo exp) throws Exception {
        BizExpressionExecutor executor = new BizExpressionExecutor(this.interpreter, this.localCtx, exp);
        return executor.execute();
    }

    void actionPerformed(Map args) throws Exception {
        block6: {
            ActionCollection actions;
            this.addArgsToLocalContext(args);
            if (!(this.rule instanceof ConditionRuleInfo)) break block6;
            boolean conditionResult = true;
            ConditionRuleInfo caRule = (ConditionRuleInfo)this.rule;
            if (caRule.getCondition() != null && caRule.getCondition().getExpression() != null) {
                Object result = this.execute(caRule.getCondition().getExpression());
                conditionResult = result != null && result instanceof Boolean && (Boolean)result != false;
            }
            if (conditionResult) {
                actions = caRule.getActions();
                int n = actions.size();
                for (int i = 0; i < n; ++i) {
                    this.execute(actions.get(i).getExpression());
                    if (actions.get(i).getExpression().getSource().indexOf("required = false") < 0) continue;
                    Object comp = BizRuleExecutor.searchEventObject(this.targetUI, this.localCtx, ((ConditionRuleInfo)this.rule).getEventObjectName());
                    if (comp instanceof KDTable) {
                        KDTable requireTable = (KDTable)comp;
                        String requireField = ((ConditionRuleInfo)this.rule).getEventObjectName();
                        if (StringUtils.indexOfIgnoreCase((String)requireField, (String)".") <= 0) continue;
                        int index = requireField.indexOf(".");
                        requireField = requireField.substring(index + 1);
                        this.requireUtil.removeTableRequiredField(requireTable, requireField);
                        continue;
                    }
                    if (!(comp instanceof IKDTextComponent)) continue;
                    this.requireUtil.removeRequiredComponent((JComponent)comp);
                }
            } else {
                actions = caRule.getExceptionActions();
                int n = actions.size();
                for (int i = 0; i < n; ++i) {
                    this.execute(actions.get(i).getExpression());
                }
            }
        }
    }

    private static Object searchEventObject(CoreUI targetUI, Map localCtx, String eventObjectName) {
        if (StringUtils.isEmpty((String)eventObjectName)) {
            return null;
        }
        if ("this".equals(eventObjectName)) {
            return targetUI;
        }
        String realEventObject = eventObjectName;
        if (!StringUtils.isEmpty((String)eventObjectName) && eventObjectName.indexOf(".") > 0) {
            realEventObject = eventObjectName.substring(0, eventObjectName.indexOf("."));
        }
        if (localCtx != null) {
            for (Object key : localCtx.keySet()) {
                if (!realEventObject.equals(key)) continue;
                return localCtx.get(key);
            }
        }
        return null;
    }

    private void addArgsToLocalContext(Map args) {
        if (this.localCtx.get("editData") == null && this.targetUI != null) {
            this.localCtx.put("editData", this.targetUI.getDataObject());
        }
        if (args == null) {
            return;
        }
        for (Object key : args.keySet()) {
            this.localCtx.put(key, args.get(key));
        }
    }

    private void unRegisterListener(Object obj, EventType eventType, String eventName, EventListener listener) {
        if (!EventType.INITIAL.equals((Object)eventType)) {
            if (EventType.SUBMIT.equals((Object)eventType)) {
                if (this.targetUI != null && this.targetUI instanceof EditUI) {
                    EditUI editUI = (EditUI)this.targetUI;
                    editUI.getUILifeCycleHandler().removeRuleListener((IUILifeCycleListener)listener);
                }
            } else if (EventType.CHANGE.equals((Object)eventType)) {
                if (obj instanceof KDFormattedTextField) {
                    KDFormattedTextField control = (KDFormattedTextField)obj;
                    control.removeDataChangeListener((DataChangeListener)listener);
                } else if (obj instanceof IKDEditor) {
                    IKDEditor control = (IKDEditor)obj;
                    control.removeDataChangeListener((DataChangeListener)listener);
                } else if (obj instanceof JTextComponent) {
                    JTextComponent control = (JTextComponent)obj;
                    control.getDocument().removeDocumentListener((DocumentListener)listener);
                } else if (obj instanceof KDSpinner) {
                    KDSpinner control = (KDSpinner)obj;
                    control.removeChangeListener((ChangeListener)listener);
                } else if (obj instanceof KDTable) {
                    KDTable control = (KDTable)obj;
                    control.removeKDTPropertyChangeListener((KDTPropertyChangeListener)listener);
                    if (this.targetUI != null && this.targetUI instanceof EditUI) {
                        ((EditUI)this.targetUI).getUILifeCycleHandler().removeEntryRuleListener((IUILifeCycleListener)listener);
                    }
                }
            } else if (EventType.CUSTOM.equals((Object)eventType) && "onCreateNewData".equals(eventName) && this.targetUI != null && this.targetUI instanceof EditUI) {
                EditUI editUI = (EditUI)this.targetUI;
                editUI.getUILifeCycleHandler().removeRuleListener((IUILifeCycleListener)listener);
                editUI.getUILifeCycleHandler().removeEntryRuleListener((IUILifeCycleListener)listener);
            }
        }
    }

    private EventListener registerListener(Object obj, EventType eventType, String eventName) {
        GeneralRuleListener listener;
        block32: {
            listener = null;
            if (EventType.INITIAL.equals((Object)eventType)) {
                try {
                    if (this.rule.getRuleType() != null && this.rule.getRuleType().equalsIgnoreCase("LINK_PROPERTY")) {
                        EditUI editUI = (EditUI)this.targetUI;
                        listener = new GeneralRuleListener(this.targetUI, this, eventType, null);
                        editUI.getUILifeCycleHandler().addLinkRuleListener((IUILifeCycleListener)listener);
                        break block32;
                    }
                    this.actionPerformed(null);
                }
                catch (Exception e) {
                    logger.error((Object)"registerListener error: ", (Throwable)e);
                }
            } else if (EventType.SUBMIT.equals((Object)eventType)) {
                if (this.targetUI != null && this.targetUI instanceof EditUI) {
                    Object comp = BizRuleExecutor.searchEventObject(this.targetUI, this.localCtx, ((ConditionRuleInfo)this.rule).getEventObjectName());
                    if (comp instanceof KDTable) {
                        KDTable requireTable = (KDTable)comp;
                        String requireField = ((ConditionRuleInfo)this.rule).getEventObjectName();
                        if (StringUtils.indexOfIgnoreCase((String)requireField, (String)".") > 0) {
                            int index = requireField.indexOf(".");
                            requireField = requireField.substring(index + 1);
                            this.requireUtil.addTableRequiredField(requireTable, requireField);
                        }
                    } else if (comp instanceof IKDTextComponent) {
                        ((IKDTextComponent)comp).setRequired(true);
                        this.requireUtil.addRequiredComponent((JComponent)comp);
                    } else {
                        EditUI editUI = (EditUI)this.targetUI;
                        listener = new GeneralRuleListener(this.targetUI, this, EventType.SUBMIT, null);
                        editUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)listener);
                    }
                }
            } else if (EventType.CHANGE.equals((Object)eventType)) {
                if (this.targetUI != null && this.targetUI instanceof EditUI) {
                    EditUI editUI = (EditUI)this.targetUI;
                    listener = new GeneralRuleListener(this.targetUI, this);
                    editUI.getUILifeCycleHandler().addChangeEventListener(listener, obj);
                    if (obj instanceof KDTable) {
                        String eventObjectName;
                        KDTable control = (KDTable)obj;
                        listener = new GeneralRuleListener(this.targetUI, this);
                        control.addKDTPropertyChangeListener((KDTPropertyChangeListener)listener);
                        if (this.rule instanceof ConditionRuleInfo && !StringUtils.isEmpty((String)(eventObjectName = ((ConditionRuleInfo)this.rule).getEventObjectName())) && eventObjectName.indexOf(46) != -1) {
                            String subEventObjectName = eventObjectName.substring(eventObjectName.indexOf(46) + 1);
                            listener.setSubEventObjectName(subEventObjectName);
                            if (this.targetUI != null && this.targetUI instanceof EditUI) {
                                listener.setTable(control);
                                ((EditUI)this.targetUI).getUILifeCycleHandler().addEntryRuleListener((IUILifeCycleListener)listener);
                            }
                        }
                    }
                }
            } else if (EventType.CUSTOM.equals((Object)eventType) && "onCreateNewData".equals(eventName)) {
                if (obj != null && obj instanceof KDTable) {
                    CoreBillEditUI editui;
                    if (((KDTable)obj).getParent() != null && ((KDTable)obj).getParent().getParent() != null && ((KDTable)obj).getParent().getParent() instanceof DetailPanel) {
                        DetailPanel panel = (DetailPanel)((KDTable)obj).getParent().getParent();
                        listener = new GeneralRuleListener(this.targetUI, this, eventType, eventName);
                        panel.addAddListener((IDetailPanelListener)listener);
                    }
                    if (((KDTable)obj).getParent() != null && (editui = this.getCoreBillEditUI(((KDTable)obj).getParent())) != null) {
                        listener = new GeneralRuleListener(this.targetUI, this, eventType, eventName);
                        editui.getUILifeCycleHandler().addEntryRuleListener((IUILifeCycleListener)listener);
                        if ("ADDNEW".equals(this.targetUI.getOprtState()) && ((KDTable)obj).getRowCount() > 0) {
                            HashMap<String, IObjectValue> args = new HashMap<String, IObjectValue>();
                            for (int i = 0; i < ((KDTable)obj).getRowCount(); ++i) {
                                Object userObject = ((KDTable)obj).getRow(i).getUserObject();
                                if (userObject == null || !(userObject instanceof IObjectValue)) continue;
                                try {
                                    args.put("editData", (IObjectValue)userObject);
                                    this.actionPerformed(args);
                                    editui.reloadLineFields((KDTable)obj, ((KDTable)obj).getRow(i), (IObjectValue)userObject);
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error((Object)"registerListener error: ", (Throwable)e);
                                }
                            }
                            args.put("editData", this.targetUI.getDataObject());
                            this.addArgsToLocalContext(args);
                        }
                    }
                } else if (this.targetUI instanceof EditUI) {
                    if ("ADDNEW".equals(this.targetUI.getOprtState())) {
                        try {
                            this.actionPerformed(null);
                        }
                        catch (Exception e) {
                            logger.error((Object)"registerListener error: ", (Throwable)e);
                        }
                    }
                    EditUI editUI = (EditUI)this.targetUI;
                    listener = new GeneralRuleListener((CoreUI)editUI, this, eventType, eventName);
                    editUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)listener);
                }
            }
        }
        return listener;
    }

    private CoreBillEditUI getCoreBillEditUI(Container con) {
        while (con != null && !(con instanceof CoreBillEditUI)) {
            con = con.getParent();
        }
        return (CoreBillEditUI)con;
    }

    public void destroy() {
        if (this.targetUI != null && this.interpreter != null && this.rule != null && this.rule instanceof ConditionRuleInfo) {
            ConditionRuleInfo caRule = (ConditionRuleInfo)this.rule;
            this.unRegisterListener(this.eventObject, caRule.getEventType(), caRule.getEventName(), this.eventListener);
        }
    }
}

