/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.pat;

import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Hashtable;

public class IDManager {
    private static IDManager idManager = null;
    private Hashtable idGroup = new Hashtable();

    public static synchronized IDManager getInstance() {
        if (idManager == null) {
            idManager = new IDManager();
        }
        return idManager;
    }

    public synchronized void loadIDList(String IDGroup) throws Exception {
        String sql = "select * from T_PF_IDList where FIDGroup = '" + IDGroup + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        ArrayList<IDEntry> list = new ArrayList<IDEntry>(100);
        while (rs.next()) {
            list.add(new IDEntry(rs.getString("FID"), rs.getInt("FWeight")));
        }
        if (list.size() == 0) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"81_IDManager") + IDGroup);
        }
        this.idGroup.put(IDGroup, list);
    }

    public synchronized String getRandomID(String IDGroup) {
        ArrayList list = (ArrayList)this.idGroup.get(IDGroup);
        if (this.allFetched(list)) {
            this.reset(list);
        }
        IDEntry entry = this.getRandomEntry(list);
        String randomID = entry.getID();
        entry.setWeight(entry.getWeight() - 1);
        return randomID;
    }

    private boolean allFetched(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            if (((IDEntry)list.get(i)).getWeight() <= 0) continue;
            return false;
        }
        return true;
    }

    private IDEntry getRandomEntry(ArrayList list) {
        int total = 0;
        for (int i = 0; i < list.size(); ++i) {
            total += ((IDEntry)list.get(i)).getWeight();
        }
        int index = (int)Math.floor((double)total * Math.random());
        IDEntry entry = null;
        for (int i = 0; i < list.size() && ((entry = (IDEntry)list.get(i)).getWeight() <= 0 || (index -= entry.getWeight()) > 0); ++i) {
        }
        return entry;
    }

    private void reset(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            ((IDEntry)list.get(i)).reset();
        }
    }

    private class IDEntry {
        private String id = null;
        private int weight;
        private int originWeight;

        public IDEntry(String id, int weight) {
            this.id = id;
            this.weight = weight;
            this.originWeight = weight;
        }

        public String getID() {
            return this.id;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setID(String string) {
            this.id = string;
        }

        public void setWeight(int i) {
            this.weight = i;
        }

        public void reset() {
            this.weight = this.originWeight;
        }
    }
}

