/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.print;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.framework.print.IMultiapproveDataFilter;
import com.kingdee.eas.framework.print.STMultiapproveDataFilter;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MultiapproveDataProvider
extends AbstractPrintDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)MultiapproveDataProvider.class.getName());
    private static final String MULTIAPPROVE_QUERY_METADATAPK = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
    private static final String MULTIAPPROVE_HISTORY_QUERY_METADATAPK = "com.kingdee.eas.base.multiapprove.app.MultiapproveHstQuery";
    private static final String MULTIAPPROVE_MERGE_QUERY_METADATAPK = "com.kingdee.eas.base.multiapprove.app.MultiapproveMergeQuery";
    private static final String MULTIAPPROVE_PRINT_SHOW_HISTORY = "showHistory";
    private static final String MULTIAPPROVE_PRINT_PARAM_BILLID = "billId";
    private static final String MULTIAPPROVE_PRINT_ALL_REF_LC = "allRefLc";
    private static final String MULTIAPPROVE_PRINT_USETYPE = "useType";
    private static final String ONLY_PRINT_LAST_APPROVE_RESULT = "WfApproveDataProviderOnlyReturnLastResults";
    private Set ids = null;
    private R1PrintDataSortItem[] sortItems;
    private boolean showHistory = false;
    private Object paramBillIdValue;
    private String paramName = "billId";
    private boolean allRefLc = false;
    private Object useType = "old";
    private IMultiapproveDataFilter multiapproveDataFilter = null;
    private IMultiapproveDataFilter printLastApproveResultFilter = null;
    private Context context = null;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public MultiapproveDataProvider(List id, boolean needShowHistory, String paramName) {
        this.ids = new HashSet(id);
        this.showHistory = needShowHistory;
        this.paramName = paramName;
    }

    public MultiapproveDataProvider(List id, boolean needShowHistory) {
        this.ids = new HashSet(id);
        this.showHistory = needShowHistory;
    }

    public MultiapproveDataProvider(Set id, boolean needShowHistory) {
        this.ids = id;
        this.showHistory = needShowHistory;
    }

    public MultiapproveDataProvider(Set id, boolean needShowHistory, String paramName) {
        this.ids = id;
        this.showHistory = needShowHistory;
        this.paramName = paramName;
    }

    private void retrieveParameterFromDataSourceParams(BOSQueryDataSource ds) {
        ArrayList params = ds.getParams();
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                DSParam param = (DSParam)params.get(i);
                if (MULTIAPPROVE_PRINT_SHOW_HISTORY.equalsIgnoreCase(param.getColName()) && param.getValue() != null && param.getValue().getValue() != null && "true".equalsIgnoreCase(param.getValue().getValue().toString())) {
                    this.showHistory = true;
                    continue;
                }
                if (MULTIAPPROVE_PRINT_PARAM_BILLID.equalsIgnoreCase(param.getColName()) && param.getValue() != null && param.getValue().getValue() != null) {
                    this.paramBillIdValue = param.getValue().getValue();
                    continue;
                }
                if (MULTIAPPROVE_PRINT_ALL_REF_LC.equalsIgnoreCase(param.getColName()) && param.getValue() != null && param.getValue().getValue() != null && "true".equalsIgnoreCase(param.getValue().getValue().toString())) {
                    this.allRefLc = true;
                    continue;
                }
                if (!MULTIAPPROVE_PRINT_USETYPE.equalsIgnoreCase(param.getColName()) || param.getValue() == null || param.getValue().getValue() == null) continue;
                this.useType = param.getValue().getValue();
            }
        }
    }

    private EntityViewInfo getMultiapproveEntityView(boolean isShowHistory) {
        FilterInfo filterInfo;
        EntityViewInfo entityViewInfo;
        block16: {
            entityViewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            if (this.paramBillIdValue != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("MultiApprove.billId", this.paramBillIdValue, CompareType.EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo(this.paramName, (Object)this.ids, CompareType.INCLUDE));
            }
            try {
                if ("new".equalsIgnoreCase((String)this.useType)) {
                    String multiApproveIdSet = this.getMergeIdSet(isShowHistory);
                    if (multiApproveIdSet.trim().length() < 1) {
                        multiApproveIdSet = "''";
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("MultiApprove.id", (Object)multiApproveIdSet, CompareType.INNER));
                    break block16;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                String procinstid = "";
                StringBuffer tStrSql = new StringBuffer();
                if (isShowHistory) {
                    tStrSql.append(" select  d.FPROCINSTID from t_wfr_procinstrefHst c,t_wfr_procinstHst d where");
                    tStrSql.append(" c.FPROCINSTID =  d.FPROCINSTID and c.FREFID = '" + this.paramBillIdValue + "' and d.FPARENTPROCINSTID  is null order by d.FCREATEDTIME  desc ");
                } else {
                    tStrSql.append(" select  b.FPROCINSTID from t_wfr_procinstref a,t_wfr_procinst b where");
                    tStrSql.append(" a.FPROCINSTID =  b.FPROCINSTID and a.FREFID = '" + this.paramBillIdValue + "' and b.FPARENTPROCINSTID  is null order by b.FCREATEDTIME  desc ");
                }
                HashSet<String> procinstIdSet = new HashSet<String>();
                try {
                    ISQLExecutor sqlExecutor = null;
                    sqlExecutor = this.context == null ? SQLExecutorFactory.getRemoteInstance((String)tStrSql.toString()) : SQLExecutorFactory.getLocalInstance((Context)this.context, (String)tStrSql.toString());
                    IRowSet rowSet = sqlExecutor.executeSQL();
                    if (rowSet.next()) {
                        procinstid = rowSet.getString(1);
                        procinstIdSet.add(procinstid);
                    }
                    if (this.allRefLc) {
                        while (rowSet.next()) {
                            procinstIdSet.add(rowSet.getString(1));
                        }
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                if (!StringUtils.isEmpty((String)procinstid)) {
                    String procinstIds = "";
                    procinstIds = procinstIdSet.size() > 1 ? this.getInSqlProcId(procinstIdSet, isShowHistory) : this.getInSqlProcId(procinstid, isShowHistory);
                    StringBuffer tStrBufferSql = new StringBuffer();
                    tStrBufferSql.append(" select a.fid from ");
                    if (isShowHistory) {
                        tStrBufferSql.append("t_bas_multiapproveHst a left join T_WFR_AssignHst b on a.fassignmentid=b.fassignid ");
                        tStrBufferSql.append(" where b.FPROCINSTID in (" + procinstIds + ")");
                    } else {
                        tStrBufferSql.append("t_bas_multiapprove a left join T_WFR_Assigndetail b on a.fassignmentid=b.fassignid ");
                        tStrBufferSql.append(" where b.FPROCINSTID in (" + procinstIds + ")");
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("ID", (Object)tStrBufferSql.toString(), CompareType.INNER));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    private String getInSqlProcId(HashSet<String> procinstIdSet, boolean isShowHistory) {
        StringBuffer procinstIds = new StringBuffer();
        Iterator<String> iter = procinstIdSet.iterator();
        while (iter.hasNext()) {
            String idsTmp = this.getInSqlProcId(iter.next(), isShowHistory);
            if (procinstIds.length() > 0) {
                procinstIds.append(",");
            }
            procinstIds.append(idsTmp);
        }
        return procinstIds.toString();
    }

    private String getInSqlProcId(String procinstId, boolean isShowHistory) {
        HashSet<String> procinstIdSet = new HashSet<String>();
        procinstIdSet.add(procinstId);
        try {
            this.getChildProcIds(procinstId, procinstIdSet, isShowHistory);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        StringBuffer sbProcinstids = new StringBuffer();
        for (Object e : procinstIdSet) {
            if (sbProcinstids.length() > 0) {
                sbProcinstids.append(",");
            }
            sbProcinstids.append("'").append(e).append("'");
        }
        return sbProcinstids.toString();
    }

    private void getChildProcIds(String procinstId, HashSet procinstIdSet, boolean isShowHistory) throws BOSException, SQLException {
        String procInstIds = "'" + procinstId + "'";
        while (true) {
            String sqlclild = "";
            sqlclild = isShowHistory ? "select fprocinstid from  t_wfr_procinsthst where fparentprocinstid in(" + procInstIds + ")" : "select fprocinstid from  t_wfr_procinst where fparentprocinstid in(" + procInstIds + ")";
            ISQLExecutor sqlExecutor = null;
            sqlExecutor = this.context == null ? SQLExecutorFactory.getRemoteInstance((String)sqlclild) : SQLExecutorFactory.getLocalInstance((Context)this.context, (String)sqlclild);
            IRowSet rowSet = sqlExecutor.executeSQL();
            StringBuffer sb = new StringBuffer();
            while (rowSet.next()) {
                String clildProcInstId = rowSet.getString(1);
                procinstIdSet.add(clildProcInstId);
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(clildProcInstId).append("'");
            }
            if (sb.length() == 0) break;
            procInstIds = sb.toString();
        }
    }

    private IRowSet executeQuery(String queryPkString, boolean isShowHistory) throws BOSException {
        EntityViewInfo entityViewInfo = this.getMultiapproveEntityView(isShowHistory);
        MetaDataPK queryMultiApproveQueryPK = new MetaDataPK(queryPkString);
        IQueryExecutor exec = null;
        exec = this.context == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryMultiApproveQueryPK) : QueryExecutorFactory.getLocalInstance((Context)this.context, (IMetaDataPK)queryMultiApproveQueryPK);
        if (this.sortItems != null && this.sortItems.length > 0) {
            for (int i = 0; i < this.sortItems.length; ++i) {
                String fieldName = this.sortItems[i].getSortField();
                if (StringUtils.isEmpty((String)fieldName)) continue;
                SorterItemInfo sort = new SorterItemInfo(fieldName);
                if (0 == this.sortItems[i].getSortType()) {
                    sort.setSortType(SortType.ASCEND);
                } else {
                    sort.setSortType(SortType.DESCEND);
                }
                entityViewInfo.getSorter().add(sort);
            }
            exec.option().isIgnoreOrder = true;
        } else {
            exec.option().isIgnoreOrder = false;
        }
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(entityViewInfo);
        return exec.executeQuery();
    }

    private IRowSet mergeRowSet(IRowSet currentRowSet, IRowSet historyRowSet) throws Exception {
        if (currentRowSet == null || currentRowSet.size() <= 0) {
            return historyRowSet;
        }
        if (historyRowSet == null || historyRowSet.size() <= 0) {
            return currentRowSet;
        }
        Collection col = historyRowSet.toCollection();
        for (Vector row : col) {
            currentRowSet.last();
            currentRowSet.moveToInsertRow();
            for (int i = 0; i < row.size(); ++i) {
                currentRowSet.updateObject(i + 1, row.get(i));
            }
            currentRowSet.insertRow();
            currentRowSet.moveToCurrentRow();
        }
        currentRowSet.beforeFirst();
        return currentRowSet;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        this.retrieveParameterFromDataSourceParams(ds);
        IRowSet iRowSet = null;
        try {
            IRowSet currentRowSet = this.executeQuery(MULTIAPPROVE_QUERY_METADATAPK, false);
            if (!this.showHistory) {
                iRowSet = currentRowSet;
            } else {
                IRowSet historyRowSet = this.executeQuery(MULTIAPPROVE_HISTORY_QUERY_METADATAPK, true);
                iRowSet = this.mergeRowSet(currentRowSet, historyRowSet);
            }
            if (this.isEnablePrintLastApproveResultFilter()) {
                this.printLastApproveResultFilter = new STMultiapproveDataFilter();
                iRowSet = this.printLastApproveResultFilter.filtrateMultiapproveData(iRowSet);
            }
            if (this.multiapproveDataFilter != null) {
                iRowSet = this.multiapproveDataFilter.filtrateMultiapproveData(iRowSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iRowSet;
    }

    public IMultiapproveDataFilter getMultiapproveDataFilter() {
        return this.multiapproveDataFilter;
    }

    public void setMultiapproveDataFilter(IMultiapproveDataFilter multiapproveDataFilter) {
        this.multiapproveDataFilter = multiapproveDataFilter;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        this.retrieveParameterFromDataSourceParams(dataSource);
        IRowSet iRowSet = null;
        try {
            if ("new".equalsIgnoreCase((String)this.useType)) {
                iRowSet = this.executeQuery(MULTIAPPROVE_MERGE_QUERY_METADATAPK, this.showHistory);
            } else {
                IRowSet currentRowSet = this.executeQuery(MULTIAPPROVE_QUERY_METADATAPK, false);
                if (!this.showHistory) {
                    iRowSet = currentRowSet;
                } else {
                    IRowSet historyRowSet = this.executeQuery(MULTIAPPROVE_HISTORY_QUERY_METADATAPK, true);
                    iRowSet = this.mergeRowSet(currentRowSet, historyRowSet);
                }
            }
            if (this.isEnablePrintLastApproveResultFilter()) {
                this.printLastApproveResultFilter = new STMultiapproveDataFilter();
                iRowSet = this.printLastApproveResultFilter.filtrateMultiapproveData(iRowSet);
            }
            if (this.multiapproveDataFilter != null) {
                iRowSet = this.multiapproveDataFilter.filtrateMultiapproveData(iRowSet);
            }
            if (iRowSet != null && iRowSet.size() > 0) {
                while (iRowSet.next()) {
                    if (iRowSet.getString("MultiApprove.opinion") != null && iRowSet.getString("MultiApprove.opinion").endsWith("rollback")) {
                        String opinion = iRowSet.getString("MultiApprove.opinion").replaceAll("rollback", "");
                        iRowSet.updateString("MultiApprove.opinion", opinion);
                    }
                    if ("new".equalsIgnoreCase((String)this.useType)) {
                        String isPass = iRowSet.getString("MultiApprove.isPass");
                        iRowSet.updateString("MultiApprove.isPass", ApproveResult.getEnum((String)isPass).getAlias());
                    }
                    if (iRowSet.getString("esignature") == null || iRowSet.getString("esignature") == null) continue;
                    String esignature = iRowSet.getString("esignature");
                    IRowSetMetaData irsmd = iRowSet.getRowSetMetaData();
                    int columnIndex = irsmd.getColumnIndex("esignature");
                    iRowSet.getRowSetMetaData().setColumnType(columnIndex, -2);
                    iRowSet.updateBytes("esignature", AttachmentManagerFacadeFactory.getRemoteInstance().downLoad(esignature));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iRowSet;
    }

    private String getMergeIdSet(boolean isShowHistory) {
        StringBuffer currentIdSet = this.getIdSet(false);
        String megreIdSet = currentIdSet.toString();
        if (isShowHistory) {
            String hstIdSetStr = this.getIdSet(true).toString();
            if (megreIdSet.trim().length() > 0) {
                currentIdSet.append(" UNION ");
            }
            if (hstIdSetStr.trim().length() > 0) {
                megreIdSet = currentIdSet.append(hstIdSetStr).toString();
            }
        }
        return megreIdSet;
    }

    private String getStrIdsBySet(Set ids) {
        String objsToStr = "";
        Object[] objs = ids.toArray();
        if (objs.length > 0) {
            for (Object obj : objs) {
                if (objsToStr.length() > 0) {
                    objsToStr = objsToStr + ",";
                }
                objsToStr = objsToStr + "'" + obj + "'";
            }
        }
        return objsToStr;
    }

    private StringBuffer getIdSet(boolean isShowHistory) {
        StringBuffer tStrSql = new StringBuffer();
        StringBuffer tStrBufferSql = new StringBuffer();
        try {
            String procinstid = "";
            if (isShowHistory) {
                tStrSql.append(" select  d.FPROCINSTID from t_wfr_procinstrefHst c,t_wfr_procinstHst d where");
                tStrSql.append(" c.FPROCINSTID =  d.FPROCINSTID and c.FREFID = '" + this.paramBillIdValue + "' and d.FPARENTPROCINSTID  is null order by d.FCREATEDTIME  desc ");
            } else {
                tStrSql.append(" select  b.FPROCINSTID from t_wfr_procinstref a,t_wfr_procinst b where");
                tStrSql.append(" a.FPROCINSTID =  b.FPROCINSTID and a.FREFID = '" + this.paramBillIdValue + "' and b.FPARENTPROCINSTID  is null order by b.FCREATEDTIME  desc ");
            }
            HashSet<String> procinstIdSet = new HashSet<String>();
            try {
                ISQLExecutor sqlExecutor = null;
                sqlExecutor = this.context == null ? SQLExecutorFactory.getRemoteInstance((String)tStrSql.toString()) : SQLExecutorFactory.getLocalInstance((Context)this.context, (String)tStrSql.toString());
                IRowSet rowSet = sqlExecutor.executeSQL();
                if (rowSet.next()) {
                    procinstid = rowSet.getString(1);
                    procinstIdSet.add(procinstid);
                }
                if (this.allRefLc) {
                    while (rowSet.next()) {
                        procinstIdSet.add(rowSet.getString(1));
                    }
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (!StringUtils.isEmpty((String)procinstid)) {
                String procinstIds = "";
                procinstIds = procinstIdSet.size() > 1 ? this.getInSqlProcId(procinstIdSet, isShowHistory) : this.getInSqlProcId(procinstid, isShowHistory);
                tStrBufferSql.append(" select a.fid from ");
                if (isShowHistory) {
                    tStrBufferSql.append("t_bas_multiapproveHst a left join T_WFR_AssignHst b on a.fassignmentid=b.fassignid ");
                    tStrBufferSql.append(" where b.FPROCINSTID in (" + procinstIds + ")");
                } else {
                    tStrBufferSql.append("t_bas_multiapprove a left join T_WFR_Assigndetail b on a.fassignmentid=b.fassignid ");
                    tStrBufferSql.append(" where b.FPROCINSTID in (" + procinstIds + ")");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return tStrBufferSql;
    }

    private void retrieveParameterFromDataSourceParams(R1PrintDataSource ds) {
        if (ds == null) {
            logger.info((Object)"MultiapprovedataProvide get parsing, R1PrintDataSource is null , pls check it. \n");
            return;
        }
        R1PrintDataParameter[] params = ds.getParams();
        this.sortItems = ds.getSortFields();
        if (params != null && params.length > 0) {
            for (int j = 0; j < params.length; ++j) {
                R1PrintDataParameter param = params[j];
                if (MULTIAPPROVE_PRINT_SHOW_HISTORY.equalsIgnoreCase(param.getId()) && param.getValue() != null && param.getValue().getValue() != null && "true".equalsIgnoreCase(param.getValue().getValue().toString())) {
                    this.showHistory = true;
                    continue;
                }
                if (MULTIAPPROVE_PRINT_PARAM_BILLID.equalsIgnoreCase(param.getId()) && param.getValue() != null && param.getValue().getValue() != null) {
                    this.paramBillIdValue = param.getValue().getValue();
                    continue;
                }
                if (MULTIAPPROVE_PRINT_ALL_REF_LC.equalsIgnoreCase(param.getId()) && param.getValue() != null && param.getValue().getValue() != null && "true".equalsIgnoreCase(param.getValue().getValue().toString())) {
                    this.allRefLc = true;
                    continue;
                }
                if (!MULTIAPPROVE_PRINT_USETYPE.equalsIgnoreCase(param.getId()) || param.getValue() == null || param.getValue().getValue() == null) continue;
                this.useType = param.getValue().getValue();
            }
        }
    }

    private boolean isEnablePrintLastApproveResultFilter() {
        try {
            String value = ParamManager.getParamValue(null, null, (String)ONLY_PRINT_LAST_APPROVE_RESULT);
            if (Boolean.valueOf(value).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

