/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.print;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.framework.print.IMultiapproveDataFilter;
import com.kingdee.eas.framework.print.MultiapproveQueryData;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class STMultiapproveDataFilter
implements IMultiapproveDataFilter {
    private static final Logger logger = Logger.getLogger((String)STMultiapproveDataFilter.class.getName());

    @Override
    public IRowSet filtrateMultiapproveData(IRowSet oldRowset) {
        if (oldRowset == null || oldRowset.size() <= 0) {
            return oldRowset;
        }
        List filtedDatas = this.getFiltedDatas(oldRowset);
        if (oldRowset instanceof DynamicRowSet) {
            return this.constructMultiapproveRowset(filtedDatas, oldRowset);
        }
        return this.constructMultiapproveRowset(filtedDatas);
    }

    private List getFiltedDatas(IRowSet oldRowset) {
        ArrayList<MultiapproveQueryData> all = new ArrayList<MultiapproveQueryData>();
        try {
            Object[] rows = oldRowset.toCollection().toArray();
            int length = rows.length;
            for (int i = 0; i < length; ++i) {
                Vector row = (Vector)rows[i];
                MultiapproveQueryData data = this.rowToDataObj(row);
                if (data == null || all.contains(data)) continue;
                all.add(data);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u591a\u7ea7\u5ba1\u6279\u5957\u6253\u6570\u636e\u6e90\u53bb\u91cd\u8fc7\u6ee4\u5668\u51fa\u9519\uff1a", (Throwable)e);
        }
        return this.getFiltedDatas(all);
    }

    private List getFiltedDatas(List all) {
        if (all == null || all.size() <= 0) {
            return null;
        }
        ArrayList result = new ArrayList();
        result.addAll(all);
        HashMap<Object, MultiapproveQueryData> duplicateData = new HashMap<Object, MultiapproveQueryData>();
        for (int i = 0; i < all.size(); ++i) {
            MultiapproveQueryData data = (MultiapproveQueryData)all.get(i);
            if (ApproveResult.NOT_PASS.getAlias().equalsIgnoreCase(data.getMultiApproveIsPass().toString())) {
                result.remove(data);
                continue;
            }
            if (duplicateData.get(this.generateKey(data)) != null) {
                MultiapproveQueryData existData = (MultiapproveQueryData)duplicateData.get(this.generateKey(data));
                if (data.getMultiApproveCreateTime().after(existData.getMultiApproveCreateTime())) {
                    result.remove(existData);
                    duplicateData.put(this.generateKey(data), data);
                    continue;
                }
                result.remove(data);
                continue;
            }
            duplicateData.put(this.generateKey(data), data);
        }
        return result;
    }

    private Object generateKey(MultiapproveQueryData data) {
        return data.getAssignDetailActdefName() + "_" + data.getPersonName();
    }

    private MultiapproveQueryData rowToDataObj(Vector row) {
        if (row == null || row.size() <= 0 || row.size() < 14) {
            return null;
        }
        MultiapproveQueryData data = new MultiapproveQueryData();
        data.setMultiApproveId((String)row.get(0));
        data.setMultiApproveCreateTime((Timestamp)row.get(1));
        data.setPersonName((String)row.get(2));
        data.setMultiApproveOpinion((String)row.get(3));
        data.setMultiApproveHandlerOpinion((String)row.get(4));
        data.setMultiApproveBillId((String)row.get(5));
        try {
            data.setMultiApproveIsPass((IObjectValue)row.get(6));
        }
        catch (Exception e) {
            BizEnumValueInfo enumObj = new BizEnumValueInfo();
            enumObj.setAlias(((String)row.get(6)).matches("[\u4e00-\u9fa5]+") ? (String)row.get(6) : ApproveResult.getEnum((String)((String)row.get(6))).getAlias());
            BizEnumValueDTO bizEnum = BizEnumValueDTO.createDTO((BizEnumValueInfo)enumObj);
            data.setMultiApproveIsPass((IObjectValue)bizEnum);
        }
        data.setAssignDetailActdefName((String)row.get(7));
        data.setMultiApproveBosType((String)row.get(8));
        data.setAttachmentId((String)row.get(9));
        data.setAttachmentName((String)row.get(10));
        data.setEsignature((String)row.get(13));
        return data;
    }

    private IRowSet constructMultiapproveRowset(List filtedDatas) {
        String[] columnNames = new String[]{"MultiApprove.id", "MultiApprove.createTime", "personId.name", "MultiApprove.opinion", "MultiApprove.handlerOpinion", "MultiApprove.billId", "MultiApprove.isPass", "AssignDetail.actdefName", "MultiApprove.bosType", "Attachment.id", "Attachment.name", "status", "creator.number", "esignature"};
        int colCount = columnNames.length;
        DynamicRowSet rowSet = null;
        try {
            int i;
            rowSet = new DynamicRowSet(colCount);
            for (i = 0; i < colCount; ++i) {
                ColInfo colInfo = new ColInfo();
                colInfo.colType = 12;
                colInfo.columnName = columnNames[i];
                colInfo.nullable = 1;
                rowSet.setColInfo(i + 1, colInfo);
            }
            rowSet.beforeFirst();
            for (i = 0; i < filtedDatas.size(); ++i) {
                if (filtedDatas.get(i) == null) continue;
                this.fillRowData(rowSet, (MultiapproveQueryData)filtedDatas.get(i));
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)"\u591a\u7ea7\u5ba1\u6279\u5957\u6253\u53bb\u91cd constructMultiapproveRowset \u51fa\u9519", (Throwable)e);
            return null;
        }
        return rowSet;
    }

    private IRowSet constructMultiapproveRowset(List filtedDatas, IRowSet oldRowset) {
        DynamicRowSet rowSet = null;
        try {
            int colCount = oldRowset.getMetaData().getColumnCount();
            rowSet = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo colInfo = new ColInfo();
                colInfo.colType = 12;
                colInfo.columnName = oldRowset.getMetaData().getColumnName(i + 1);
                colInfo.nullable = 1;
                rowSet.setColInfo(i + 1, colInfo);
            }
            Object[] rows = oldRowset.toCollection().toArray();
            rowSet.beforeFirst();
            block3: for (int i = 0; i < filtedDatas.size(); ++i) {
                if (filtedDatas.get(i) == null) continue;
                String id = ((MultiapproveQueryData)filtedDatas.get(i)).getMultiApproveId();
                int length = rows.length;
                for (int j = 0; j < length; ++j) {
                    Vector row = (Vector)rows[j];
                    if (!id.equals(row.get(0))) continue;
                    this.fillRowData(rowSet, row);
                    continue block3;
                }
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)"\u591a\u7ea7\u5ba1\u6279\u5957\u6253\u53bb\u91cd constructMultiapproveRowset \u51fa\u9519", (Throwable)e);
            return null;
        }
        return rowSet;
    }

    private void fillRowData(DynamicRowSet rowSet, MultiapproveQueryData data) throws SQLException {
        if (rowSet == null || data == null) {
            throw new IllegalArgumentException();
        }
        rowSet.moveToInsertRow();
        rowSet.updateString(1, data.getMultiApproveId());
        rowSet.updateTimestamp(2, data.getMultiApproveCreateTime());
        rowSet.updateString(3, data.getPersonName());
        rowSet.updateString(4, data.getMultiApproveOpinion());
        rowSet.updateString(5, data.getMultiApproveHandlerOpinion());
        rowSet.updateString(6, data.getMultiApproveBillId());
        rowSet.updateObject(7, (Object)data.getMultiApproveIsPass());
        rowSet.updateString(8, data.getAssignDetailActdefName());
        rowSet.updateString(9, data.getMultiApproveBosType());
        rowSet.updateString(10, data.getAttachmentId());
        rowSet.updateString(11, data.getAttachmentName());
        rowSet.updateString(12, data.getEsignature());
        rowSet.insertRow();
    }

    private void fillRowData(DynamicRowSet rowSet, Vector row) throws SQLException {
        if (rowSet == null || row == null) {
            throw new IllegalArgumentException();
        }
        rowSet.moveToInsertRow();
        int colCount = rowSet.getMetaData().getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if ("MultiApprove.createTime".equals(rowSet.getMetaData().getColumnName(i + 1))) {
                rowSet.updateTimestamp(i + 1, (Timestamp)row.get(i));
                continue;
            }
            if ("MultiApprove.isPass".equals(rowSet.getMetaData().getColumnName(i + 1))) {
                try {
                    rowSet.updateObject(i + 1, (Object)((IObjectValue)row.get(i)));
                }
                catch (Exception e) {
                    BizEnumValueInfo enumObj = new BizEnumValueInfo();
                    enumObj.setAlias(((String)row.get(i)).matches("[\u4e00-\u9fa5]+") ? (String)row.get(i) : ApproveResult.getEnum((String)((String)row.get(i))).getAlias());
                    BizEnumValueDTO bizEnum = BizEnumValueDTO.createDTO((BizEnumValueInfo)enumObj);
                    rowSet.updateObject(i + 1, (Object)bizEnum);
                }
                continue;
            }
            try {
                rowSet.updateString(i + 1, (String)row.get(i));
                continue;
            }
            catch (Exception e) {
                rowSet.updateString(i + 1, null);
                logger.error((Object)("value=" + row.get(i) + " i=" + i + " \u5217\u540d\uff1a" + rowSet.getMetaData().getColumnName(i + 1) + "  "));
            }
        }
        rowSet.insertRow();
    }
}

