/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.FilterItemPanel;
import com.kingdee.eas.framework.query.IQueryFieldSelection;
import com.kingdee.eas.framework.query.QuickSearchItems;
import com.kingdee.eas.framework.query.component.DottedLineBorder;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class CommonDynFilterPanel
extends KDPanel
implements IQueryFieldSelection {
    private static final Logger logger = Logger.getLogger(CommonDynFilterPanel.class);
    private KDPanel filterItemContainer = new KDPanel();
    private static final int FILTERITEMHEIGHT = 40;
    static final int MAX_ITEMS = 5;
    private int X = 8;
    private int Y = 20;
    private MetaDataPK queryInfo;
    private ListUI listUI;
    boolean isInListUI;
    ArrayList<FilterItemPanel> filterItemPanelList = new ArrayList();
    List<KDLabel> holders = new ArrayList<KDLabel>();
    private QuickSearchItems quickSearchItems = new QuickSearchItems();
    private Map initValues = new HashMap();

    public CommonDynFilterPanel(ListUI listUI, MetaDataPK queryInfo, FilterInfo filter) throws BOSException {
        this.listUI = listUI;
        this.queryInfo = queryInfo;
        this.init(filter);
    }

    private void initFilter(FilterInfo filter) {
        if (filter == null || filter.getFilterItems().size() <= 0) {
            return;
        }
        int size = filter.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            Object value = item.getCompareValue();
            if (value == null || StringUtils.isEmpty((String)value.toString().trim())) continue;
            this.initValues.put(item.getPropertyName(), value);
        }
    }

    private void init(FilterInfo filter) throws BOSException {
        this.initFilter(filter);
        this.setLayout(new BorderLayout());
        this.filterItemContainer.setLayout(null);
        this.add((Component)this.filterItemContainer, "Center");
        this.loadQuickSearchItems();
    }

    private void clear() {
        this.clearPanel();
        this.filterItemPanelList.clear();
        this.holders.clear();
    }

    private void clearPanel() {
        int size = this.filterItemPanelList.size();
        for (int i = 0; i < size; ++i) {
            FilterItemPanel panel = this.filterItemPanelList.get(i);
            this.filterItemContainer.remove((Component)panel.getParent());
        }
        for (KDLabel holder : this.holders) {
            this.filterItemContainer.remove((Component)holder);
        }
        this.Y = 20;
        this.updateUI();
    }

    private void loadQuickSearchItems() throws BOSException {
        this.clear();
        Object configs = null;
        if (configs == null || configs[0] == null) {
            return;
        }
        FilterItemCollection filterItemCol = (FilterItemCollection)configs[0];
        String[] signs = (String[])configs[1];
        int size = filterItemCol.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItemInfo = filterItemCol.get(i);
            FilterItemPanel filterItemPanel = new FilterItemPanel(this.queryInfo, filterItemInfo, signs[i], this.initValues.get(filterItemInfo.getPropertyName()));
            this.addFilterItemPanel(filterItemPanel);
        }
        this.drawPlaceholder();
        this.updateUI();
    }

    private void drawPlaceholder() {
        int size;
        for (int i = size = this.filterItemPanelList.size(); i < 5; ++i) {
            KDLabel holder = new KDLabel(QuickFilterResources.getMessage("PLACEITEM"));
            holder.setForeground(Color.gray);
            holder.setBounds(new Rectangle(53, this.Y + 40 * (i - size) + 5, 240, 30));
            holder.setBorder((Border)new DottedLineBorder(Color.gray));
            this.filterItemContainer.add((Component)holder);
            this.holders.add(holder);
        }
    }

    private JButton getDeleteButton() {
        final JButton deleteButton = new JButton();
        deleteButton.setBorderPainted(false);
        deleteButton.setIcon(QuickFilterResources.icon_remove);
        deleteButton.setRolloverEnabled(true);
        deleteButton.setFocusable(false);
        deleteButton.setOpaque(false);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonDynFilterPanel.this.deleteActionPerformed(e);
            }
        });
        deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteButton.setIcon(QuickFilterResources.icon_remove_over);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteButton.setIcon(QuickFilterResources.icon_remove);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                deleteButton.setIcon(QuickFilterResources.icon_remove_click);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                deleteButton.setIcon(QuickFilterResources.icon_remove_over);
            }
        });
        return deleteButton;
    }

    private void deleteActionPerformed(ActionEvent e) {
        ItemPanel itemPanel = (ItemPanel)((Object)((JButton)e.getSource()).getParent());
        ArrayList temp = (ArrayList)this.filterItemPanelList.clone();
        this.clear();
        temp.remove(itemPanel.getFilterItemPanel());
        int size = temp.size();
        for (int i = 0; i < size; ++i) {
            this.addFilterItemPanel((FilterItemPanel)temp.get(i));
        }
        this.drawPlaceholder();
        this.updateUI();
    }

    private void addFilterItemPanel(MetaDataPK queryInfo, String fieldName) throws BOSException {
        FilterItemPanel filterItemPanel = new FilterItemPanel(queryInfo, fieldName);
        this.addFilterItemPanel(filterItemPanel);
    }

    private void addFilterItemPanel(FilterItemPanel filterItemPanel) {
        if (this.filterItemPanelList.size() >= 5) {
            return;
        }
        this.filterItemPanelList.add(filterItemPanel);
        ItemPanel itemPanel = new ItemPanel(filterItemPanel, this.getDeleteButton());
        itemPanel.setBounds(new Rectangle(this.X, this.Y, 500, 40));
        this.filterItemContainer.add((Component)((Object)itemPanel));
        this.Y += 40;
    }

    FilterInfo getFilterInfoWithoutValue() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        int size = this.filterItemPanelList.size();
        for (int i = 0; i < size; ++i) {
            FilterItemPanel panel = this.filterItemPanelList.get(i);
            filterInfo.getFilterItems().add(panel.getFilterItemInfo(true));
        }
        return filterInfo;
    }

    String[] getCompareSigns() {
        int size = this.filterItemPanelList.size();
        String[] signs = new String[size];
        for (int i = 0; i < size; ++i) {
            FilterItemPanel panel = this.filterItemPanelList.get(i);
            signs[i] = panel.getCompareSignString();
        }
        return signs;
    }

    private FilterItemPanel getFilterItemPanelByFieldName(String fieldName) {
        int size = this.filterItemPanelList.size();
        for (int i = 0; i < size; ++i) {
            FilterItemPanel temp = this.filterItemPanelList.get(i);
            if (!StringUtils.equals((String)fieldName, (String)temp.getFieldName())) continue;
            return temp;
        }
        return null;
    }

    void saveQuickSearchItems() throws BOSException {
        this.quickSearchItems.saveQuickSearchItems(this.listUI, this.getFilterInfoWithoutValue().getFilterItems(), this.getCompareSigns());
    }

    @Override
    public void aFieldSelected(String fieldName) throws BOSException {
        if (this.holders.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)QuickFilterResources.getMessage("LIMITEDFORITEMS"));
            return;
        }
        KDLabel holder = this.holders.get(0);
        if (holder != null) {
            this.filterItemContainer.remove((Component)holder);
            this.holders.remove(0);
            this.addFilterItemPanel(this.queryInfo, fieldName);
            this.updateUI();
        }
    }

    @Override
    public void aFieldDropped(String fieldName, Point p) throws BOSException {
        if (p == null || !this.contains(p)) {
            return;
        }
        this.aFieldSelected(fieldName);
    }

    class ItemPanel
    extends KDPanel {
        FilterItemPanel filterItemPanel;
        JButton deleteButton;

        public ItemPanel(FilterItemPanel filterItemPanel, JButton deleteButton) {
            this.filterItemPanel = filterItemPanel;
            this.deleteButton = deleteButton;
            this.init();
        }

        private void init() {
            this.add(this.deleteButton);
            this.deleteButton.setBounds(8, 8, 22, 22);
            this.deleteButton.setSize(new Dimension(22, 22));
            this.deleteButton.repaint();
            this.filterItemPanel.setBounds(40, 5, 450, 30);
            this.add((Component)((Object)this.filterItemPanel));
            this.setLayout(null);
        }

        public FilterItemPanel getFilterItemPanel() {
            return this.filterItemPanel;
        }
    }
}

