/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.framework.query.FastQueryOptionUI;
import com.kingdee.eas.framework.query.IFastQuery;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.SolutionItem;
import com.kingdee.eas.framework.query.component.CompositeListPopupItem;
import com.kingdee.eas.framework.query.component.FixedPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IPopupInvoker;
import com.kingdee.eas.framework.query.component.ListPopup;
import com.kingdee.eas.framework.query.component.ListPopupTitleItem;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class QuickFilteringPopupMenuManager
implements IPopupInvoker {
    private int preferredHeight = 100;
    private FastQueryOptionUI fastQueryOptionUI;
    private ListPopup popup;
    private IFastQuery fastQuery;
    private List<IListPopupItem> popupItems;
    IListPopupItem ITEM_RECENTONEWEEK;
    private QuickFilteringSupportItems supportItems;
    private IListPopupItem selectedPopupItem;
    private List<IListPopupItem> recentBillItems;

    public QuickFilteringPopupMenuManager(FastQueryOptionUI fastQueryOptionUI, IFastQuery fastQuery, QuickFilteringSupportItems supportItems) {
        this.fastQueryOptionUI = fastQueryOptionUI;
        this.fastQuery = fastQuery;
        this.supportItems = supportItems;
        this.popup = new ListPopup(this);
        fastQueryOptionUI.lblPopup.addMouseListener(this.popup.getMouseListener());
        fastQueryOptionUI.lblSolutionName.addMouseListener(this.popup.getMouseListener());
    }

    void initPopupValue(QuickFilteringSupportItems supportItems) {
        int size = 0;
        this.popupItems = new ArrayList<IListPopupItem>();
        size += this.initRecentBillItems();
        size += this.initMySolutionList();
        size += this.initShareySolutionList();
        this.popup.setList(this.popupItems);
        this.setPopupPreferredHeight(25 * (size += this.initRecentQuickSearchItems()) + 5);
    }

    private int initMySolutionList() {
        List<SolutionItem> _solutionItems = this.fastQuery.getFastFilter().getSolutionItems();
        ArrayList<SolutionItem> mySolutionItems = new ArrayList<SolutionItem>();
        for (SolutionItem item : _solutionItems) {
            if (item.getSolutionInfo().getShareType() != ShareTypeEnum.USER_LEVEL) continue;
            mySolutionItems.add(item);
        }
        this.popupItems.add(new ListPopupTitleItem(QuickFilterResources.getMessage("MYSOLUTION")));
        this.popupItems.addAll(mySolutionItems);
        return mySolutionItems.size() + 1;
    }

    private int initShareySolutionList() {
        List<SolutionItem> _solutionItems = this.fastQuery.getFastFilter().getSolutionItems();
        ArrayList<SolutionItem> shareSolutionItems = new ArrayList<SolutionItem>();
        for (SolutionItem item : _solutionItems) {
            if (item.getSolutionInfo().getShareType() != ShareTypeEnum.ORG_LEVEL) continue;
            shareSolutionItems.add(item);
        }
        this.popupItems.add(new ListPopupTitleItem(QuickFilterResources.getMessage("SHARESOLUTION")));
        this.popupItems.addAll(shareSolutionItems);
        return shareSolutionItems.size() + 1;
    }

    private int initRecentQuickSearchItems() {
        int size = 0;
        this.popupItems.add(new ListPopupTitleItem(QuickFilterResources.getMessage("RECENTSEARCHITEMS")));
        if (this.fastQuery.getRecentQuickSearchItemsMananger().getRecentQuickSearchItems() != null) {
            this.popupItems.addAll(this.fastQuery.getRecentQuickSearchItemsMananger().getRecentQuickSearchItems());
            size += this.fastQuery.getRecentQuickSearchItemsMananger().getRecentQuickSearchItems().size();
            ++size;
        }
        return size;
    }

    private int initRecentBillItems() {
        if (this.recentBillItems == null) {
            this.recentBillItems = new ArrayList<IListPopupItem>();
            String bizDateField = this.supportItems.getBizDateField();
            if (!StringUtils.isEmpty((String)bizDateField)) {
                this.recentBillItems.add(new ListPopupTitleItem(QuickFilterResources.getMessage("RECENTBILLS")));
                this.ITEM_RECENTONEWEEK = new FixedPopupItem(this.fastQuery, QuickFilterResources.getMessage("RECENTONEWEEK"), FilterUtility.createFilterByDate(bizDateField, null, DateEnum.RECENTONEWEEK));
                this.recentBillItems.add(this.ITEM_RECENTONEWEEK);
                FixedPopupItem item = new FixedPopupItem(this.fastQuery, QuickFilterResources.getMessage("RECENT") + QuickFilterResources.getMessage("ONEMONTH"), FilterUtility.createFilterByDate(bizDateField, null, DateEnum.RECENTONEMONTH));
                this.recentBillItems.add(item);
                item = new FixedPopupItem(this.fastQuery, QuickFilterResources.getMessage("RECENT") + QuickFilterResources.getMessage("THREEMONTHS"), FilterUtility.createFilterByDate(bizDateField, null, DateEnum.RECENTTHREEMONTHS));
                this.recentBillItems.add(item);
            }
        }
        this.popupItems.addAll(this.recentBillItems);
        return this.recentBillItems.size();
    }

    private void setPopupPreferredHeight(int h) {
        this.preferredHeight = h;
    }

    IListPopupItem getSelectedPopupItem() {
        return this.selectedPopupItem;
    }

    void setSelectedPopupItem(IListPopupItem selectedPopupItem) {
        if (selectedPopupItem instanceof CompositeListPopupItem || this.popup.getSelectedValue() != selectedPopupItem) {
            this.setSelectedPopupItemExactly(selectedPopupItem);
        } else {
            this.selectedPopupItem = selectedPopupItem;
            if (selectedPopupItem == null) {
                this.popup.setSelectedIndex(-1);
            }
        }
    }

    private void setSelectedPopupItemExactly(IListPopupItem selectedPopupItem) {
        if (selectedPopupItem == null) {
            this.selectedPopupItem = null;
            this.popup.setSelectedIndex(-1);
            return;
        }
        int i = 0;
        for (IListPopupItem item : this.popupItems) {
            if (item instanceof CompositeListPopupItem) {
                this.popup.setSelectedIndex(i);
                this.selectedPopupItem = item;
                break;
            }
            if (item == selectedPopupItem) {
                this.selectedPopupItem = selectedPopupItem;
                this.popup.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    void setSelectedSolutionItem(QuerySolutionInfo solutionInfo) {
        if (solutionInfo == null) {
            return;
        }
        int i = 0;
        for (IListPopupItem item : this.popupItems) {
            if (item instanceof SolutionItem && solutionInfo.getId().equals((Object)((SolutionItem)item).getSolutionInfo().getId())) {
                this.popup.setSelectedIndex(i);
                this.selectedPopupItem = item;
                break;
            }
            ++i;
        }
    }

    @Override
    public JComponent getOwner() {
        return this.fastQueryOptionUI;
    }

    @Override
    public Point getPopupLocation() {
        return new Point(2, this.fastQueryOptionUI.lblSolutionName.getHeight() + 8);
    }

    @Override
    public Dimension getPopupSize() {
        return new Dimension(this.fastQueryOptionUI.getWidth() - 4, this.preferredHeight);
    }

    @Override
    public Rectangle getFocusedBounds() {
        return this.getOwner().getBounds();
    }
}

