/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.query.IFastFilter;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.SolutionItem;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.BizOrgUtility;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import java.util.ArrayList;
import java.util.List;

public class SystemSolutionItem
extends SolutionItem {
    private FilterItems defaultFilter = new FilterItems();
    private QuickFilteringSupportItems supportItems;
    private OrgUnitInfo mainOrg;

    SystemSolutionItem(QuickFilteringSupportItems supportItems) {
        this.supportItems = supportItems;
    }

    void setFastFilter(IFastFilter fastFilter) {
        this.fastFilter = fastFilter;
    }

    public FilterItems getDefaultFilter() {
        return this.defaultFilter;
    }

    List getMainOrgs() {
        ArrayList<String> mainOrgs = new ArrayList<String>();
        if (this.mainOrg != null) {
            mainOrgs.add(this.mainOrg.getId().toString());
        }
        return mainOrgs;
    }

    private OrgUnitInfo loadDefaultMainOrg() {
        if (this.supportItems.getDefaultMainOrgInfo() != null) {
            return this.supportItems.getDefaultMainOrgInfo();
        }
        OrgUnitCollection bizOrgs = this.fastFilter.getAuthOrgsByType();
        return BizOrgUtility.loadDefaultMainOrg(bizOrgs);
    }

    public class FilterItems {
        private List<FilterItem> items;

        public boolean hasFilterItem() {
            return this.items != null && this.items.size() > 0;
        }

        public int size() {
            if (this.items == null) {
                return 0;
            }
            return this.items.size();
        }

        FilterInfo getFilter() {
            FilterInfo filter = new FilterInfo();
            if (this.items == null) {
                return filter;
            }
            for (FilterItem item : this.items) {
                this.addFilter(filter, item);
            }
            return filter;
        }

        private void addFilter(FilterInfo filter, FilterItem item) {
            if ((item.compareValue.equals((Object)DateEnum.RECENTONEMONTH) || item.compareValue.equals((Object)DateEnum.THISMONTH)) && (item.compareType == null || item.compareType.equals((Object)CompareType.IS) || item.compareType.equals((Object)CompareType.EQUALS))) {
                try {
                    filter.mergeFilter(FilterUtility.createFilterByDate(item.fieldName, null, (DateEnum)((Object)item.compareValue)), "AND");
                }
                catch (BOSException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if (item.compareValue.equals((Object)BizOrgEnum.DEFAULTMAINORG)) {
                String mainOrgId = "";
                SystemSolutionItem.this.mainOrg = SystemSolutionItem.this.loadDefaultMainOrg();
                if (SystemSolutionItem.this.mainOrg != null) {
                    mainOrgId = SystemSolutionItem.this.mainOrg.getId().toString();
                }
                filter.getFilterItems().add(new FilterItemInfo(item.fieldName, (Object)mainOrgId, item.compareType));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(item.fieldName, item.compareValue, item.compareType));
            }
        }

        public FilterItems add(String fieldName, CompareType compareType, Object compareValue) {
            if (this.items == null) {
                this.items = new ArrayList<FilterItem>();
            }
            this.items.add(new FilterItem(fieldName, compareType, compareValue));
            return this;
        }

        class FilterItem {
            String fieldName;
            CompareType compareType;
            Object compareValue;

            FilterItem(String fieldName, CompareType compareType, Object compareValue) {
                this.fieldName = fieldName;
                this.compareType = compareType;
                this.compareValue = compareValue;
            }
        }
    }
}

