/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;

public abstract class AbstractListPopupItem
implements IListPopupItem,
Cloneable {
    private String displayValue;
    private IListPopupItemExecute executor;
    protected FilterInfo filterInfo;

    public AbstractListPopupItem(IListPopupItemExecute executor) {
        this.executor = executor;
    }

    public AbstractListPopupItem(IListPopupItemExecute executor, String displayCompareValue) {
        this.executor = executor;
        this.displayValue = displayCompareValue;
    }

    public AbstractListPopupItem(IListPopupItemExecute executor, String displayCompareValue, FilterInfo filterInfo) {
        this.executor = executor;
        this.displayValue = displayCompareValue;
        this.filterInfo = filterInfo;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isTitle() {
        return false;
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayCompareValue) {
        this.displayValue = displayCompareValue;
    }

    @Override
    public void execute(boolean isOnRefresh) {
        if (this.executor == null) {
            return;
        }
        this.executor.executeItem(this, isOnRefresh);
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setCompareValue(Object compareValue) {
        if (compareValue == null) {
            this.setDisplayValue("");
        } else {
            this.setDisplayValue(compareValue.toString());
        }
    }

    public String getFieldAlias() {
        return "";
    }

    protected void setFilterItemCompareValue(FilterItemInfo filterItemInfo, Object compareValue) {
        if (filterItemInfo.getCompareType() == CompareType.LIKE) {
            if (filterItemInfo.getCompareValue().toString().startsWith("%")) {
                compareValue = "%" + compareValue;
            }
            if (filterItemInfo.getCompareValue().toString().endsWith("%")) {
                compareValue = compareValue + "%";
            }
        }
        filterItemInfo.setCompareValue(compareValue);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbstractListPopupItem)) {
            return false;
        }
        FilterInfo f1 = this.getFilterInfo();
        FilterInfo f2 = ((AbstractListPopupItem)obj).getFilterInfo();
        if (f1 == null && f2 == null) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1.toSql().equals(f2.toSql());
    }

    void setExecutor(IListPopupItemExecute executor) {
        this.executor = executor;
    }
}

