/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.component.DateRangePopupManager;
import com.kingdee.eas.framework.query.component.IAutoCompletionPopup;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.component.ItemLabel;
import com.kingdee.eas.framework.query.component.ListPopup;
import com.kingdee.eas.framework.query.component.QueryTextField;
import com.kingdee.util.StringUtils;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoCompletionTextField
extends QueryTextField
implements DocumentListener,
MouseListener,
KeyListener {
    private LinkedList<IListPopupItem> popupItems = new LinkedList();
    private DateRangePopupManager dateRangePopupManager;
    private IAutoCompletionPopup popup;

    public AutoCompletionTextField() throws BOSException {
        this.getDocument().addDocumentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)((Object)this), (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusBackwardTraversalKeys((JComponent)((Object)this), (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.setNeetInputMethodRequest(false);
    }

    public void setPopup(IAutoCompletionPopup popup) {
        this.popup = popup;
    }

    public IAutoCompletionPopup getPopup() {
        return this.popup;
    }

    public IListPopupItem getSelectedDateRangeItem() {
        if (this.dateRangePopupManager == null) {
            return null;
        }
        return this.dateRangePopupManager.getSelectedDateRangeItem();
    }

    @Override
    public void initDateRangePopup(QuickFilteringSupportItems supportItems, IListPopupItemExecute executor) {
        String bizDateField = supportItems.getBizDateField();
        if (StringUtils.isEmpty((String)bizDateField)) {
            if (this.searchInfoTips != null) {
                this.setInfoLabelText("<HTML><font color=#C0C0C0 size=3>" + this.searchInfoTips + "</font></HTML>");
            }
            return;
        }
        super.initDateRangePopup(supportItems, executor);
        this.dateRangePopupManager = new DateRangePopupManager(this, this.dateRangeBox, bizDateField, executor);
        this.dateRangePopupManager.initDateRangePopupModel(supportItems);
    }

    @Override
    protected void invokeDateRangeMouseListener(MouseEvent e) {
        if (this.dateRangePopupManager != null) {
            this.dateRangePopupManager.invokeDateRangeMouseListener(e);
        }
    }

    private void textChanged() {
        if (!this.getPopup().isPopupVisible() && this.getText().length() > 0) {
            this.getPopup().showPopup();
            this.requestFocus();
        }
        this.getPopup().changeList();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && !this.getPopup().isPopupVisible()) {
            this.textChanged();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void addSelectedPopupItem(IListPopupItem item) {
        if (this.getText().length() == 0 || item == null || item == ListPopup.SEPERATOR) {
            return;
        }
        IListPopupItem lpi = this.getPopup().prepareSelectedPopupItem(item);
        if (item != null) {
            this.setText("");
        }
        this.addUserObject(lpi);
        this.getPopup().executeSelectedPopupItem(lpi);
        this.getPopup().setPopupVisible(false);
        this.setCaretPosition(this.getText().length());
    }

    @Override
    protected void handleIconClick() {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.getPopup().isPopupVisible() && e.getKeyCode() == 40 && !this.doNotAllowInput()) {
            this.getPopup().showPopup();
            this.requestFocus();
            this.getPopup().changeList();
        } else {
            this.getPopup().processKeyPress(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    protected boolean doNotAllowInput() {
        boolean result = super.doNotAllowInput();
        if (result) {
            return result;
        }
        return this.getPopup().doNotAllowInput();
    }

    @Override
    protected ItemLabel createItemLabel(IListPopupItem userObj) {
        ItemLabel itemLabel = this.getPopup().createItemLabel(this, userObj);
        return itemLabel != null ? itemLabel : super.createItemLabel(userObj);
    }

    public DateRangePopupManager getDateRangePopupManager() {
        return this.dateRangePopupManager;
    }

    @Override
    public void removeItemLabel(int index) {
        super.removeItemLabel(index);
        this.getPopup().showPopup();
        this.requestFocus();
        this.getPopup().changeList();
    }
}

