/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.eas.framework.report.util.RptRowSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class AccessLock
implements MethodInterceptor {
    private Enhancer enhancer = new Enhancer();
    private Object bean;
    private Map map = new HashMap();
    private List regexList = new ArrayList();
    private boolean trace = false;

    public Object intercept(Object arg0, Method method, Object[] args, MethodProxy arg3) throws Throwable {
        String mm = method.getName();
        if (this.trace) {
            System.out.println("Access: " + mm);
        }
        if (this.map.containsKey(mm)) {
            throw new AccessLockMethodException("Method \"" + mm + "\" has be locked.");
        }
        int n = this.regexList.size();
        for (int i = 0; i < n; ++i) {
            String pp = (String)this.regexList.get(i);
            if (!mm.matches(pp)) continue;
            throw new AccessLockMethodException("Method \"" + mm + "\" has be locked.");
        }
        return method.invoke(this.bean, args);
    }

    public void setTrace(boolean on) {
        this.trace = on;
    }

    public void addLock(String method) {
        this.addLock(method, false);
    }

    public void addLock(String method, boolean isRegex) {
        this.map.put(method, Boolean.TRUE);
        if (isRegex) {
            this.regexList.add(method);
        }
    }

    public void removeLock(String method) {
        this.map.remove(method);
        this.regexList.remove(method);
    }

    public String getLockInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Lock object: ");
        if (this.bean != null) {
            sb.append(this.bean.getClass().getName());
        }
        sb.append("\nLock method: ");
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void remove(String method) {
        this.map.remove(method);
        this.regexList.remove(method);
    }

    public Object assignLock(Object bean) {
        this.bean = bean;
        this.enhancer.setSuperclass(bean.getClass());
        this.enhancer.setCallback((Callback)this);
        return this.enhancer.create();
    }

    public static void main(String[] args) {
        String[] hh = new String[]{"A", "B"};
        Object[][] data = new Object[][]{{"A1", "B1"}, {"A2", "B2"}};
        AccessLock lock = new AccessLock();
        lock.setTrace(true);
        lock.addLock("set.+", true);
        lock.addLock("add.+", true);
        lock.addLock("remove.+", true);
        lock.addLock("clear.+", true);
        System.out.println(lock.getLockInfo());
        RptRowSet rs = new RptRowSet(hh, data);
        rs = (RptRowSet)lock.assignLock(rs);
        rs.next();
        System.out.println("#RowCount=" + rs.getRowCount());
        System.out.println("#1 col=" + rs.getObject(0));
        System.out.println("#Try remove rows...");
        rs.removeAllRow();
    }

    class AccessLockMethodException
    extends RuntimeException {
        AccessLockMethodException(String msg) {
            super(msg);
        }
    }
}

