/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.util.DyBeanFactory;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RptRowSet
implements Serializable,
Cloneable,
IMarshalObject,
IRptFilterObject {
    private static final long serialVersionUID = -1573025776190503436L;
    private Map userMap = new HashMap(2);
    private String[] columns;
    private Map columnIndexMap;
    private int recordCount;
    private List recordList;
    private int recordIndex;
    private int virtualRowCount = -1;

    public RptRowSet() {
    }

    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public void copyRow(int fromRowIndex, int toRowIndex) {
        List list = (List)this.recordList.get(fromRowIndex);
        this.recordList.set(toRowIndex, new ArrayList(list));
    }

    public RptRowSet copy() {
        RptRowSet rs = new RptRowSet(this.columns, this.toArray());
        rs.moveTo(this.recordIndex);
        return rs;
    }

    public RptRowSet(String[] columns, Object[][] data) {
        this.columns = this.copyStringArray(columns);
        this.recordCount = data.length;
        this.recordList = new ArrayList(this.recordCount);
        for (int i = 0; i < this.recordCount; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int j = 0; j < data[i].length; ++j) {
                row.add(data[i][j]);
            }
            this.recordList.add(row);
        }
        this.initMe();
    }

    public RptRowSet(String[] columns, List data) {
        this.columns = this.copyStringArray(columns);
        this.recordCount = data.size();
        this.recordList = data;
        this.initMe();
    }

    public static RptRowSet parse(ResultSet rs) throws SQLException {
        return RptRowSet.parse(rs, 0, -1);
    }

    public static RptRowSet parse(ResultSet rs, int startIndex, int length) throws SQLException {
        RptRowSet rst = new RptRowSet();
        ResultSetMetaData rsm = rs.getMetaData();
        rst.columns = new String[rsm.getColumnCount()];
        int[] types = new int[rsm.getColumnCount()];
        for (int i = 0; i < rsm.getColumnCount(); ++i) {
            rst.columns[i] = rsm.getColumnName(i + 1).toUpperCase();
            types[i] = rsm.getColumnType(i + 1);
        }
        rst.recordList = new ArrayList(100);
        boolean limitEnd = length >= 0;
        int endIndex = startIndex + length;
        if (rs.absolute(startIndex + 1)) {
            for (int n = startIndex; !limitEnd || n < endIndex; ++n) {
                ArrayList<Object> row = new ArrayList<Object>(rsm.getColumnCount());
                block8: for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                    switch (types[i - 1]) {
                        case 2004: {
                            Blob bb = rs.getBlob(i);
                            if (bb == null) {
                                row.add(null);
                                continue block8;
                            }
                            row.add(bb.getBytes(1L, (int)bb.length()));
                            continue block8;
                        }
                        case 2005: {
                            Clob cc = rs.getClob(i);
                            if (cc == null) {
                                row.add(null);
                                continue block8;
                            }
                            Reader r = cc.getCharacterStream();
                            char[] chs = new char[(int)cc.length()];
                            try {
                                r.read(chs);
                            }
                            catch (IOException _) {
                                _.printStackTrace();
                            }
                            row.add(new String(chs));
                            continue block8;
                        }
                        default: {
                            row.add(rs.getObject(i));
                        }
                    }
                }
                rst.recordList.add(row);
                if (rs.next()) continue;
            }
        }
        rst.recordCount = rst.recordList.size();
        rst.initMe();
        return rst;
    }

    private void initMe() {
        this.recordCount = this.recordList.size();
        this.recordIndex = -1;
        int n = this.columns.length;
        this.columnIndexMap = new HashMap((int)((float)n / 0.75f));
        for (int i = 0; i < this.columns.length; ++i) {
            this.columnIndexMap.put(this.columns[i].toLowerCase(), new Integer(i));
        }
    }

    public void moveRow(int indexFrom, int indexTo) {
        this.recordList.add(indexTo, this.recordList.remove(indexFrom));
    }

    public int getRowCount() {
        return this.recordList.size();
    }

    public int getVirtualRowCount() {
        return this.virtualRowCount >= 0 ? this.virtualRowCount : this.getRowCount();
    }

    public void setVirtualRowCount(int aVirtualRowCount) {
        this.virtualRowCount = aVirtualRowCount;
    }

    public String[] getColumnNames() {
        String[] cns = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            cns[i] = this.columns[i];
        }
        return cns;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public String getColumnName(int index) {
        return this.columns[index];
    }

    public void reset() {
        this.recordIndex = -1;
    }

    public boolean next() {
        if (this.recordIndex >= this.recordCount - 1) {
            return false;
        }
        ++this.recordIndex;
        return true;
    }

    public boolean first() {
        if (this.recordCount > 0) {
            this.recordIndex = 0;
            return true;
        }
        this.recordIndex = -1;
        return false;
    }

    public boolean last() {
        this.recordIndex = this.recordCount - 1;
        return this.recordIndex >= 0;
    }

    public boolean previous() {
        if (this.recordIndex > 0) {
            --this.recordIndex;
            return true;
        }
        return false;
    }

    public int getRow() {
        return this.recordIndex;
    }

    public boolean isBof() {
        return this.recordIndex == 0;
    }

    public boolean isEof() {
        return this.recordIndex == this.recordList.size() - 1;
    }

    public void moveTo(int rowIndex) {
        this.recordIndex = rowIndex;
    }

    public Object getObject(int index, Object nullWith) {
        Object obj = this.getObject(index);
        return obj == null ? nullWith : obj;
    }

    public Object getObject(int index) {
        return ((List)this.recordList.get(this.recordIndex)).get(index);
    }

    public String getString(int index) {
        return (String)this.getObject(index);
    }

    public int getInt(int index) {
        Object obj = this.getObject(index);
        return this.convertToInt(obj);
    }

    private int convertToInt(Object obj) {
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        return (Integer)obj;
    }

    public int getInt(int index, int nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        return this.convertToInt(obj);
    }

    public long getLong(int index) {
        Object obj = this.getObject(index);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return new Long(String.valueOf(obj));
    }

    public long getLong(int index, long nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return new Long(String.valueOf(obj));
    }

    public BigDecimal getBigDecimal(int index) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(String.valueOf(obj));
    }

    public float getFloat(int index) {
        Object obj = this.getObject(index);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).floatValue();
        }
        return new Float(String.valueOf(obj)).floatValue();
    }

    public float getFloat(int index, float nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).floatValue();
        }
        return new Float(String.valueOf(obj)).floatValue();
    }

    public double getDouble(int index) {
        Object obj = this.getObject(index);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        return new Double(String.valueOf(obj));
    }

    public double getDouble(int index, double nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        return new Double(String.valueOf(obj));
    }

    public boolean getBoolean(int index, boolean nullWith) {
        Object bb = this.getObject(index);
        if (bb == null) {
            return nullWith;
        }
        if (bb instanceof Boolean) {
            return (Boolean)bb;
        }
        return Boolean.valueOf(String.valueOf(bb));
    }

    public boolean isNull(int index) {
        return null == this.getObject(index);
    }

    public boolean isNumber(int index) {
        Object obj = this.getObject(index);
        return obj != null && (obj instanceof BigDecimal || obj instanceof Integer || obj instanceof Float || obj instanceof Double);
    }

    private int getColumnIndexByName(String columnName) {
        Integer index = (Integer)this.columnIndexMap.get(columnName.toLowerCase());
        if (index == null) {
            throw new RuntimeException("Unknow column \"" + columnName + "\".");
        }
        return index;
    }

    public Object getObject(String columnName, Object nullWith) {
        Object obj = this.getObject(columnName);
        return obj == null ? nullWith : obj;
    }

    public Object getObject(String columnName) {
        return this.getObject(this.getColumnIndexByName(columnName));
    }

    public String getString(String columnName) {
        return this.getString(this.getColumnIndexByName(columnName));
    }

    public int getInt(String columnName) {
        return this.getInt(this.getColumnIndexByName(columnName));
    }

    public int getInt(String columnName, int nullWith) {
        return this.getInt(this.getColumnIndexByName(columnName), nullWith);
    }

    public long getLong(String columnName) {
        return this.getLong(this.getColumnIndexByName(columnName));
    }

    public long getLong(String columnName, long nullWith) {
        return this.getLong(this.getColumnIndexByName(columnName), nullWith);
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.getColumnIndexByName(columnName));
    }

    public float getFloat(String columnName, float nullWith) {
        return this.getFloat(this.getColumnIndexByName(columnName), nullWith);
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.getColumnIndexByName(columnName));
    }

    public double getDouble(String columnName, double nullWith) {
        return this.getDouble(this.getColumnIndexByName(columnName), nullWith);
    }

    public BigDecimal getBigDecimal(String columnName) {
        return this.getBigDecimal(this.getColumnIndexByName(columnName));
    }

    public boolean getBoolean(String columnName, boolean nullWith) {
        return this.getBoolean(this.getColumnIndexByName(columnName), nullWith);
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndexByName(columnName));
    }

    public Object[][] toArray() {
        Object[][] result = new Object[this.getRowCount()][this.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = this.getObject(i, j);
            }
        }
        return result;
    }

    public Object[] toRowArray() {
        return ((List)this.recordList.get(this.recordIndex)).toArray();
    }

    public Map toRowMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            map.put(this.columns[i], this.getObject(i));
        }
        return map;
    }

    public Object toBean(Class cl) {
        return DyBeanFactory.createDyBean(cl, this.toRowMap());
    }

    public Object toBean(Class cl, Map keyAttributeMap) {
        HashMap map = new HashMap();
        Map rowMap = this.toRowMap();
        String key2 = null;
        for (String key2 : rowMap.keySet()) {
            if (keyAttributeMap.containsKey(key2)) {
                map.put(keyAttributeMap.get(key2), rowMap.get(key2));
                continue;
            }
            map.put(key2, rowMap.get(key2));
        }
        return DyBeanFactory.createDyBean(cl, map);
    }

    public Object getObject(int row, int col, Object nullWith) {
        Object obj = this.getObject(row, col);
        return obj == null ? nullWith : obj;
    }

    private Object getObject(int row, int col) {
        return ((List)this.recordList.get(row)).get(col);
    }

    public void setValueAt(int row, int col, Object value) {
        ((List)this.recordList.get(row)).set(col, value);
    }

    public void setValue(int col, Object value) {
        this.setValueAt(this.recordIndex, col, value);
    }

    public void setValueAt(int row, String columnName, Object value) {
        this.setValueAt(row, this.getColumnIndexByName(columnName), value);
    }

    public void setValue(String columnName, Object value) {
        this.setValueAt(this.recordIndex, this.getColumnIndexByName(columnName), value);
    }

    public Object[] toArray(int colIndex) {
        Object[] result = new Object[this.getRowCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getObject(i, colIndex);
        }
        return result;
    }

    public Object[] toArray(String columnName) {
        return this.toArray(this.getColumnIndexByName(columnName));
    }

    public void setProperty(String key, Object value) {
        this.userMap.put(key, value);
    }

    public Object getProperty(String key) {
        return this.userMap.get(key);
    }

    public String getDumpRowString() {
        return this.recordList.get(this.recordIndex).toString();
    }

    public String getDumpHeadString() {
        return Arrays.asList(this.columns).toString();
    }

    public String getDumpTableString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDumpHeadString());
        int oldIndex = this.getRow();
        if (this.first()) {
            do {
                sb.append("\n").append(this.getDumpRowString());
            } while (this.next());
        }
        this.moveTo(oldIndex);
        return sb.toString();
    }

    private String[] copyStringArray(String[] values) {
        String[] result = new String[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public void addRow(Object[] rowObject) {
        this.insertRow(this.recordCount, rowObject);
    }

    public void addRows(Object[][] rowObjects) {
        this.insertRows(this.recordCount, rowObjects);
    }

    public void insertRow(int index, Object[] rowObject) {
        if (rowObject == null || this.columns.length != rowObject.length) {
            throw new IllegalArgumentException("Row object count can not match column count!");
        }
        this.recordList.add(index, Arrays.asList(rowObject));
        ++this.recordCount;
    }

    public void insertRows(int index, Object[][] rowObjects) {
        int n = rowObjects.length;
        for (int i = 0; i < n; ++i) {
            this.insertRow(index, rowObjects[i]);
        }
    }

    public List remove() {
        return this.removeRow(this.recordIndex--);
    }

    public List removeRow(int rowIndex) {
        List row = (List)this.recordList.remove(rowIndex);
        --this.recordCount;
        return row;
    }

    public void removeAllRow() {
        this.recordList.clear();
        this.recordCount = 0;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeShort((int)((short)this.userMap.keySet().size()));
        for (Map.Entry entry : this.userMap.entrySet()) {
            marshaller.writeObject(entry.getKey());
            marshaller.writeObject(entry.getValue());
        }
        marshaller.writeShort(this.columns.length);
        for (int i = 0; i < this.columns.length; ++i) {
            marshaller.writeObject((Object)this.columns[i]);
        }
        marshaller.writeShort((int)((short)this.columnIndexMap.keySet().size()));
        for (Map.Entry entry : this.columnIndexMap.entrySet()) {
            marshaller.writeObject(entry.getKey());
            marshaller.writeObject(entry.getValue());
        }
        marshaller.writeInt(this.recordList.size());
        for (int i = 0; i < this.recordList.size(); ++i) {
            marshaller.writeObject(this.recordList.get(i));
        }
        marshaller.writeInt(this.virtualRowCount);
        marshaller.writeInt(this.recordIndex);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int i;
        int userMapSize = unmarshaller.readShort();
        this.userMap = new HashMap();
        for (int i2 = 0; i2 < userMapSize; ++i2) {
            Object key = unmarshaller.readObject();
            Object val = unmarshaller.readObject();
            this.userMap.put(key, val);
        }
        int columnCount = unmarshaller.readShort();
        this.columns = new String[columnCount];
        for (int i3 = 0; i3 < columnCount; ++i3) {
            this.columns[i3] = (String)unmarshaller.readObject();
        }
        int columnIndexSize = unmarshaller.readShort();
        this.columnIndexMap = new HashMap();
        for (i = 0; i < columnIndexSize; ++i) {
            Object key = unmarshaller.readObject();
            Object val = unmarshaller.readObject();
            this.columnIndexMap.put(key, val);
        }
        this.recordCount = unmarshaller.readInt();
        this.recordList = new ArrayList(this.recordCount);
        for (i = 0; i < this.recordCount; ++i) {
            this.recordList.add(unmarshaller.readObject());
        }
        this.virtualRowCount = unmarshaller.readInt();
        this.recordIndex = unmarshaller.readInt();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    @Override
    public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
        RptRowSet rowSet = new RptRowSet();
        rowSet.userMap = (Map)rptFilterMap.getObject("userMap");
        rowSet.columnIndexMap = (Map)rptFilterMap.getObject("columnIndexMap");
        rowSet.recordList = (List)rptFilterMap.getObject("recordList");
        rowSet.recordCount = rptFilterMap.getInt("recordCount");
        rowSet.recordIndex = rptFilterMap.getInt("recordIndex");
        rowSet.virtualRowCount = rptFilterMap.getInt("virtualRowCount");
        rowSet.columns = rptFilterMap.getStringArray("columns");
        return rowSet;
    }

    @Override
    public RptFilterInfo toRptFilterInfo() {
        RptFilterInfo rptInfo = new RptFilterInfo();
        rptInfo.setRptFilterObjectClassName(this.getClass().getName());
        rptInfo.setObject("userMap", this.userMap);
        rptInfo.setObject("columnIndexMap", this.columnIndexMap);
        rptInfo.setObject("recordList", this.recordList);
        rptInfo.setInt("recordCount", this.recordCount);
        rptInfo.setInt("recordIndex", this.recordIndex);
        rptInfo.setInt("virtualRowCount", this.virtualRowCount);
        rptInfo.setStringArray("columns", this.columns);
        return rptInfo;
    }
}

