/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RptTableHeader
implements Serializable {
    private List columnList = new ArrayList();
    private Object[][] labels;
    List mergedRegionList = new ArrayList();

    public RptTableColumn getColumn(int index) {
        return (RptTableColumn)this.columnList.get(index);
    }

    public RptTableColumn getColumn(String name) {
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            RptTableColumn col = (RptTableColumn)this.columnList.get(i);
            if (!this.equalsWithNull(col.getName(), name)) continue;
            return col;
        }
        return null;
    }

    public RptTableColumn[] getColumns(String name) {
        ArrayList<RptTableColumn> list = new ArrayList<RptTableColumn>();
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            RptTableColumn col = (RptTableColumn)this.columnList.get(i);
            if (!this.equalsWithNull(col.getName(), name)) continue;
            list.add(col);
        }
        RptTableColumn[] cols = new RptTableColumn[list.size()];
        list.toArray(cols);
        return cols;
    }

    public void addColumn(RptTableColumn column) {
        this.columnList.add(column);
    }

    public void addColumn(int index, RptTableColumn column) {
        this.columnList.add(index, column);
    }

    public RptTableColumn setColumn(int index, RptTableColumn column) {
        return this.columnList.set(index, column);
    }

    public RptTableColumn removeColumn(int index) {
        return (RptTableColumn)this.columnList.remove(index);
    }

    public boolean removeColumn(RptTableColumn column) {
        return this.columnList.remove(column);
    }

    public void dump() {
        StringBuffer sb = new StringBuffer();
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            RptTableColumn col = (RptTableColumn)this.columnList.get(i);
            sb.append(i).append("=").append(col.getName()).append('\n');
        }
        System.out.println(sb);
    }

    private boolean equalsWithNull(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    private void parseLabelFromColumn(boolean force) {
        if (force || this.labels == null) {
            int cols = this.columnList.size();
            this.labels = new Object[1][cols];
            for (int i = 0; i < cols; ++i) {
                this.labels[0][i] = ((RptTableColumn)this.columnList.get(i)).getName();
            }
        }
    }

    public void parseLabelFromColumn() {
        this.parseLabelFromColumn(true);
    }

    public boolean check() {
        this.parseLabelFromColumn(false);
        int cols = this.columnList.size();
        int n = this.labels.length;
        for (int i = 0; i < n; ++i) {
            if (cols == this.labels[i].length) continue;
            return false;
        }
        return true;
    }

    public Object[][] getLabels() {
        return this.labels;
    }

    public void setLabels(Object[][] labels) {
        this.setLabels(labels, false);
    }

    public void setLabels(Object[][] labels, boolean autoMatchMergeRegion) {
        this.labels = labels;
        if (autoMatchMergeRegion) {
            this.mergedRegionList.clear();
            this.mergedRegionList.addAll(CellMatrix.parseAutoMatchMergeRegion(labels));
        }
    }

    public int getMergedRegionCount() {
        return this.mergedRegionList.size();
    }

    public List getMergedRegionList() {
        return this.mergedRegionList;
    }

    public void clearMergedRegion() {
        this.mergedRegionList.clear();
    }

    public void addMergedRegion(int x1, int y1, int x2, int y2) {
        this.mergedRegionList.add(new int[]{x1, y1, x2, y2});
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public int getRowCount() {
        this.parseLabelFromColumn(false);
        return this.labels.length;
    }

    public Object getLabelValue(int row, int col) {
        return this.labels[row][col];
    }
}

