/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;

public class EntityUtility {
    public static UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    public static boolean isExistPropertyName(Context ctx, IObjectValue model, String propertyName) {
        EntityObjectInfo entity = EntityUtility.getBOSEntity(ctx, model);
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        return property != null;
    }

    public static EntityObjectInfo getBOSEntity(Context ctx, IObjectValue model) {
        return EntityUtility.getBOSEntity(ctx, model.getBOSType());
    }

    public static EntityObjectInfo getBOSEntity(Context ctx, BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(type);
        return entity;
    }

    public static EntityObjectInfo getBOSEntity(Context ctx, IMetaDataPK entityPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(entityPK);
        return entity;
    }

    public static PropertyInfo getBOSProperty(Context ctx, IObjectValue model, String propertyName) {
        BOSObjectType type = model.getBOSType();
        return EntityUtility.getBOSProperty(ctx, type, propertyName);
    }

    public static PropertyInfo getBOSProperty(Context ctx, BOSObjectType type, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(type);
        return entity.getPropertyByName(propertyName);
    }

    public static String getPropertyAlias(Context ctx, IObjectValue model, String propertyName) {
        EntityObjectInfo entity = null;
        entity = EntityUtility.getBOSEntity(ctx, model);
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    public static String getCurrentOrgId(Context ctx) {
        String OrgUnitId = null;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (company != null && company.getId() != null) {
            OrgUnitId = company.getId().toString();
        }
        return OrgUnitId;
    }

    public static String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo comInfo = EntityUtility.getRootOrgInCUNew(ctx);
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    public static CompanyOrgUnitInfo getRootOrgInCUNew(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo rootCompany = null;
        String pkId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        ObjectUuidPK pk = new ObjectUuidPK(pkId);
        CtrlUnitInfo rootCUInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk);
        if (rootCUInfo.isIsCompanyOrgUnit()) {
            rootCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        return rootCompany;
    }

    public static String getEntityName(BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = null;
        entity = loader.getEntity(type);
        return entity.getName();
    }
}

