/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.framework.util.DateUtility;
import java.sql.Timestamp;
import java.util.Calendar;

public class FilterUtility {
    public static boolean hasFilterItem(FilterInfo filter) {
        boolean hasFilterItem = false;
        if (filter != null && filter.getFilterItems().size() > 0) {
            return !hasFilterItem;
        }
        return hasFilterItem;
    }

    public static FilterInfo createFilterByDate(String key, Timestamp date, DateEnum dateEnum) {
        Timestamp fromTime = null;
        Timestamp toTime = null;
        FilterInfo filterInfo = new FilterInfo();
        Calendar calendar1 = DateUtility.startOfThisCalendar(date);
        Calendar calendar2 = DateUtility.endOfThisCalendar(date);
        boolean hasEnd = true;
        if (dateEnum.equals((Object)DateEnum.RECENTONEMONTH)) {
            calendar1.add(2, -1);
            hasEnd = false;
        } else if (dateEnum.equals((Object)DateEnum.RECENTTHREEMONTHS)) {
            calendar1.add(2, -3);
            hasEnd = false;
        } else if (dateEnum.equals((Object)DateEnum.RECENTHALFYEAR)) {
            calendar1.add(2, -6);
            hasEnd = false;
        } else if (dateEnum.equals((Object)DateEnum.RECENTONEYEAR)) {
            calendar1.add(2, -12);
            hasEnd = false;
        } else if (dateEnum.equals((Object)DateEnum.RECENTONEWEEK)) {
            calendar1.add(5, -6);
            hasEnd = false;
        } else if (dateEnum.equals((Object)DateEnum.YESTERDAY)) {
            calendar1.add(5, -1);
            calendar2.add(5, -1);
        } else if (dateEnum.equals((Object)DateEnum.TOMORROW)) {
            calendar1.add(5, 1);
            calendar2.add(5, 1);
        } else if (dateEnum.equals((Object)DateEnum.LASTWEEK)) {
            calendar1.set(7, calendar1.getFirstDayOfWeek());
            calendar1.add(5, -7);
            calendar2.set(7, calendar2.getFirstDayOfWeek());
            calendar2.add(5, -1);
        } else if (dateEnum.equals((Object)DateEnum.THISWEEK)) {
            calendar1.set(7, calendar1.getFirstDayOfWeek());
            calendar2.set(7, calendar2.getFirstDayOfWeek());
            calendar2.add(5, 6);
        } else if (dateEnum.equals((Object)DateEnum.NEXTWEEK)) {
            calendar1.set(7, calendar1.getFirstDayOfWeek());
            calendar1.add(5, 7);
            calendar2.set(7, calendar2.getFirstDayOfWeek());
            calendar2.add(5, 13);
        } else if (dateEnum.equals((Object)DateEnum.LASTMONTH)) {
            calendar1.set(5, 1);
            calendar1.add(2, -1);
            calendar2.set(5, 1);
            calendar2.add(5, -1);
        } else if (dateEnum.equals((Object)DateEnum.THISMONTH)) {
            calendar1.set(5, 1);
            calendar2.set(5, calendar2.getActualMaximum(5));
        } else if (dateEnum.equals((Object)DateEnum.NEXTMONTH)) {
            calendar1.set(5, 1);
            calendar1.add(2, 1);
            calendar2.set(5, 1);
            calendar2.add(2, 1);
            calendar2.set(5, calendar2.getActualMaximum(5));
        }
        fromTime = new Timestamp(calendar1.getTimeInMillis());
        toTime = new Timestamp(calendar2.getTimeInMillis());
        filterInfo.getFilterItems().add(new FilterItemInfo(key, (Object)fromTime, CompareType.GREATER_EQUALS));
        if (hasEnd) {
            filterInfo.getFilterItems().add(new FilterItemInfo(key, (Object)toTime, CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }
}

