/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class QueryUtility {
    private static Logger logger = Logger.getLogger(QueryUtility.class);
    static final String SIMPLE_ENTITY_TYPE = "SIMPLE_ENTITY";
    static final String F7_TYPE = "F7";

    private QueryUtility() {
    }

    public static String getMainOrgPropertyName(SimpleQuery queryInfo) {
        try {
            String className;
            Object obj;
            SimpleEntity entity = queryInfo.mainEntity();
            if (entity != null && (obj = Class.forName(className = entity.getObjectValueClass()).newInstance()) instanceof CoreBillBaseInfo) {
                return ((CoreBillBaseInfo)obj).getBizOrgPropertyName();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static String getMainOrgPropertyName(QueryInfo queryInfo) {
        try {
            SubObjectInfo mainObject = queryInfo.getMainObject();
            if (!(mainObject instanceof SubEntityInfo)) {
                return null;
            }
            EntityObjectInfo entityObjectInfo = ((SubEntityInfo)mainObject).getEntityRef();
            String className = entityObjectInfo.getObjectValueClassRuntime();
            Object obj = Class.forName(className).newInstance();
            if (obj instanceof CoreBillBaseInfo) {
                return ((CoreBillBaseInfo)obj).getBizOrgPropertyName();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static SimplePropertyUnitCollection getQueryFieldInfo(MetaDataPK queryPK, String ... queryFieldName) throws BOSException {
        if (queryPK == null || queryFieldName == null) {
            return null;
        }
        QuerySelect select = new QuerySelect(queryPK.getFullName());
        select.propertyUnitSelect().select(queryFieldName, new String[]{"displayName", "returnType"}).refPropertySelect().select(null, new String[]{"dataType", "enumType"});
        SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
        return query.propertyUnits();
    }

    public static QueryFieldInfo getQueryFieldInfo(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = new QueryFieldInfo();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !(queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName().equalsIgnoreCase(queryFieldName)) continue;
            return queryFieldInfo;
        }
        return queryFieldInfo;
    }

    public static DataObject getRefMetaData(QueryInfo queryInfo, String queryFieldName) {
        DataObject do1 = QueryUtility.getRefMetaData(null, queryInfo, queryFieldName);
        return QueryUtility.toClientDataObject(do1);
    }

    private static DataObject toClientDataObject(DataObject do1) {
        if (do1 == null) {
            return null;
        }
        DataObject dataObject = new DataObject();
        dataObject.setColLength(do1.getColLength());
        dataObject.setExtendValue(do1.getExtendValue());
        dataObject.setName(do1.getName());
        dataObject.setValue(do1.getValue());
        return dataObject;
    }

    public static DataObject getRefMetaData(Context ctx, QueryInfo queryInfo, String queryFieldName) {
        if (StringUtils.isEmpty((String)queryFieldName)) {
            return null;
        }
        if (queryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo uqInfo = (UnionQueryInfo)queryInfo;
            SubObjectInfo subObj = null;
            try {
                subObj = uqInfo.getMainObject();
                if (subObj instanceof SubQueryInfo) {
                    queryInfo = ((SubQueryInfo)subObj).getQueryRef();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        DataObject dataObject = null;
        ArrayList entityNames = QueryUtils.getEntitiyNames((QueryInfo)queryInfo);
        QueryFieldInfo queryFieldInfo = QueryUtility.getQueryFieldInfo(queryInfo, queryFieldName);
        PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
        int propertyRefCollectionSize = propertyRefCollection.size();
        for (int i = 0; i < propertyRefCollectionSize; ++i) {
            PropertyRefInfo propertyRefInfo = propertyRefCollection.get(i);
            String propEntityName = null;
            if (propertyRefInfo.getSubEntity() != null) {
                propEntityName = propertyRefInfo.getSubEntity().getName();
            } else if (propertyRefInfo.getSubQuery() != null) {
                QueryInfo subQueryInfo = propertyRefInfo.getSubQuery().getQueryRef();
                queryFieldName = queryFieldName.substring(queryFieldName.indexOf(".") + 1);
                return QueryUtility.getRefMetaData(ctx, subQueryInfo, queryFieldName);
            }
            String currentEntityName = QueryUtils.getEntityNameFromQuery((QueryInfo)queryInfo, (String)propEntityName);
            EntityObjectInfo entityObjectInfo = QueryUtils.getEntity((Context)ctx, (String)currentEntityName);
            if (currentEntityName.equalsIgnoreCase(entityNames.get(0).toString())) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)QueryUtils.getEntityPropertyByName((EntityObjectInfo)entityObjectInfo, (String)propertyRefInfo.getRefProperty().getName());
                return QueryUtility.getMainEntityPropertyDataTypeInfo(ctx, ownPropertyInfo);
            }
            if (QueryUtils.isPKField((Context)ctx, (QueryInfo)queryInfo, (String)queryFieldName)) {
                dataObject = new DataObject();
                if (QueryUtils.isSimpleEntity((EntityObjectInfo)entityObjectInfo)) {
                    dataObject.setName(SIMPLE_ENTITY_TYPE);
                    dataObject.setValue(currentEntityName);
                    return dataObject;
                }
                if (!QueryUtils.isUsingF7((QueryInfo)queryInfo, (String)queryFieldName)) continue;
                dataObject.setName(F7_TYPE);
                dataObject.setValue(currentEntityName);
                return dataObject;
            }
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)QueryUtils.getEntityPropertyByName((EntityObjectInfo)entityObjectInfo, (String)propertyRefInfo.getRefProperty().getName());
            boolean isUsingF7 = QueryUtils.isUsingF7((QueryInfo)queryInfo, (String)queryFieldName);
            dataObject = QueryUtility.getSubEntityPropertyDataTypeInfo(ctx, isUsingF7, ownPropertyInfo, currentEntityName);
            return dataObject;
        }
        return dataObject;
    }

    public static DataObject getMainEntityPropertyDataTypeInfo(Context ctx, OwnPropertyInfo ownPropertyInfo) {
        DataObject dataObject = new DataObject();
        dataObject.setName(ownPropertyInfo.getDataType().getName());
        if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
            String metaDataEnumName = ownPropertyInfo.getMetaDataRef();
            BizEnumInfo enum1 = QueryUtility.getEnum(ctx, metaDataEnumName);
            dataObject.setValue(enum1.getClassName());
        } else if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
            dataObject.setValue(BooleanEnum.class.getName());
        } else if (QueryUtility.isDateType(ownPropertyInfo.getDataType().getName()) || QueryUtility.isIntType(ownPropertyInfo.getDataType().getName())) {
            dataObject.setValue(null);
        }
        return dataObject;
    }

    public static DataObject getSubEntityPropertyDataTypeInfo(Context ctx, boolean isUsingF7, OwnPropertyInfo ownPropertyInfo, String entityName) {
        DataObject dataObject = new DataObject();
        dataObject.setName(ownPropertyInfo.getDataType().getName());
        if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
            String enumName = ownPropertyInfo.getMetaDataRef();
            BizEnumInfo enum1 = QueryUtility.getEnum(ctx, enumName);
            dataObject.setValue(enum1.getClassName());
        } else if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
            dataObject.setValue(BooleanEnum.class.getName());
        } else if (QueryUtility.isDateType(ownPropertyInfo.getDataType().getName())) {
            dataObject.setValue(null);
        } else if (QueryUtility.isIntType(ownPropertyInfo.getDataType().getName())) {
            if (isUsingF7) {
                dataObject.setValue(entityName);
            } else {
                dataObject.setValue(null);
            }
        } else if (isUsingF7) {
            dataObject.setName(F7_TYPE);
            dataObject.setValue(entityName);
        }
        return dataObject;
    }

    public static BizEnumInfo getEnum(Context ctx, String enumName) {
        MetaDataPK enumPK = MetaDataPK.create((String)enumName);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEnum((IMetaDataPK)enumPK);
    }

    private static boolean isDateType(String typeName) {
        return DataType.DATE.getName().equalsIgnoreCase(typeName) || DataType.TIMESTAMP.getName().equalsIgnoreCase(typeName) || DataType.TIME.getName().equalsIgnoreCase(typeName);
    }

    private static boolean isIntType(String typeName) {
        return DataType.SHORT.getName().equals(typeName) || DataType.INTEGER.getName().equals(typeName) || DataType.LONG.getName().equals(typeName) || DataType.FLOAT.getName().equals(typeName) || DataType.DOUBLE.getName().equals(typeName) || DataType.DECIMAL.getName().equals(typeName);
    }

    public static DataType getDataType(QueryFieldInfo queryFieldInfo) {
        PropertyInfo propertyInfo = QueryUtility.getPropertyInfoInQuery(queryFieldInfo);
        if (propertyInfo instanceof OwnPropertyInfo) {
            return ((OwnPropertyInfo)propertyInfo).getDataType();
        }
        return DataType.OBJECTPK;
    }

    public static PropertyInfo getPropertyInfoInQuery(QueryFieldInfo queryFieldInfo) {
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyInfo propertyInfo = entity.getPropertyByNameRuntime(propertyName);
        if (propertyInfo == null) {
            throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
        }
        return propertyInfo;
    }

    public static EntityObjectInfo getMainEntityInfo(QueryInfo queryInfo) {
        EntityObjectInfo entityObjectInfo = null;
        try {
            SubObjectInfo mainObject = queryInfo.getMainObject();
            if (!(mainObject instanceof SubEntityInfo)) {
                return entityObjectInfo;
            }
            entityObjectInfo = ((SubEntityInfo)mainObject).getEntityRef();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return entityObjectInfo;
    }

    public static BOSObjectType getMainEntityBOSType(IMetaDataPK queryPK) {
        return Utils.getBOSTypeFromQueryPK((IMetaDataPK)queryPK);
    }
}

