/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.data.modal.DataDef;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.Import;
import com.kingdee.cosmic.ctrl.data.modal.Imports;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.ProcessScript;
import com.kingdee.cosmic.ctrl.data.modal.io.Def2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.ExecDefIO;
import com.kingdee.cosmic.ctrl.data.modal.io.ParameterIO;
import com.kingdee.cosmic.ctrl.data.modal.io.XmlTool;
import com.kingdee.cosmic.ctrl.data.modal.types.ScriptType;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.io.OutputColumns2Xml;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataDef2Xml {
    private static final Logger log = LogUtil.getPackageLogger(DataDef2Xml.class);
    public static HashMap outputDefRegistry = new HashMap();
    public static final String T_DATAOBJECT = "Data";
    public static final String T_PARAMETERS = "Parameters";
    public static final String T_PARAMETER = "Parameter";
    public static final String T_IMPORTS = "Imports";
    public static final String T_IMPORT = "Import";
    public static final String T_PROCCESSSCRIPT = "ProccessScript";
    public static final String T_OUTPUTS = "Outputs";
    public static final String T_DESIGN_INFOES = "DesignInfoes";
    public static final String T_DESIGN_INFO = "DesignInfo";
    public static final String A_VERSION = "version";
    public static final String A_NAME = "name";
    public static final String A_TYPE = "type";
    public static final String A_ALIAS = "alias";
    public static final String A_DESC = "desc";
    public static final String A_DATA_TYPE = "dataType";
    public static final String A_EXPR = "expr";
    public static final String A_SCRIPT_TYPE = "script-type";
    public static final String A_AUTO_MAKE_CALLING = "auto-make-calling";
    public static final String A_SCOPE = "scope";
    public static final String A_ALLOW_NULL = "allowNull";
    public static final String A_DEFAULT_VALUE = "defaultValue";
    public static final String A_INPUT_TYPE = "inputType";
    public static final String A_DESIGN_STEPS = "design_steps";

    public static IXmlElement toXml(DataDef obj) {
        IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)T_DATAOBJECT);
        DataDef2Xml.toXml(e, obj);
        XmlUtil.printElement((IXmlElement)e);
        return e;
    }

    public static void toXml(IXmlElement e, DataDef obj) {
        IXmlElement designInfoes;
        Outputs outputs;
        ProcessScript script;
        Imports imports;
        if (obj == null) {
            return;
        }
        Def2Xml.makeDefObj((IDefObj)obj, (IXmlElement)e);
        List ps = obj.getParameters();
        if (ps != null && ps.size() > 0) {
            e.addChild(ParameterIO.makeParameters((List)ps));
        }
        if ((imports = obj.getImports()) != null && imports.size() > 0) {
            e.addChild(Imports2Xml.toXml(imports));
        }
        if ((script = obj.getProcessScript()) != null) {
            e.addChild(ProcessScript2Xml.toXml(script));
        }
        if ((outputs = obj.getOutputs()) != null && outputs.size() > 0) {
            e.addChild(Outputs2Xml.toXml(outputs));
        }
        if ((designInfoes = obj.getDesignInfoes()) != null) {
            e.addChild(designInfoes);
        }
    }

    static {
        outputDefRegistry.put(OutputColumns.class, OutputColumns2Xml.class);
    }

    public static final class ProcessScript2Xml {
        public static IXmlElement toXml(ProcessScript ps) {
            IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)DataDef2Xml.T_PROCCESSSCRIPT);
            if (ps != null) {
                Def2Xml.makeDefObj((IDefObj)ps, (IXmlElement)e);
                ScriptType st = ps.getType();
                if (st != null) {
                    e.setAttribute(DataDef2Xml.A_SCRIPT_TYPE, st.getName());
                }
                e.setAttribute(DataDef2Xml.A_AUTO_MAKE_CALLING, String.valueOf(ps.isAutoMakeCalling()));
                String text = ps.getScript();
                if (text != null) {
                    e.addCData(text);
                }
            }
            return e;
        }
    }

    public static final class Imports2Xml {
        public static IXmlElement toXml(Imports imports) {
            try {
                return XmlTool.list2Xml(DataDef2Xml.T_IMPORTS, imports, Import2Xml.class);
            }
            catch (Exception ex) {
                log.error((Object)"err", (Throwable)ex);
                return null;
            }
        }

        public static final class Import2Xml {
            public static IXmlElement toXml(Object o) {
                Map args;
                Import obj = (Import)((Object)o);
                IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)DataDef2Xml.T_IMPORT);
                if (obj == null) {
                    return e;
                }
                Def2Xml.makeDefObj((IDefObj)obj, (IXmlElement)e);
                if (obj.getExpr() != null) {
                    e.setAttribute(DataDef2Xml.A_EXPR, obj.getExpr());
                }
                if ((args = obj.getArgs()) != null) {
                    e.addChild(ExecDefIO.makeArgs(args));
                }
                return e;
            }
        }
    }

    public static final class Outputs2Xml {
        public static IXmlElement toXml(Outputs outputs) {
            IXmlElement e = com.kingdee.bos.qing.common.xml.XmlUtil.createNode((String)DataDef2Xml.T_OUTPUTS);
            for (Object obj : outputs) {
                IXmlElement eChild = Outputs2Xml.output2Xml(obj);
                if (eChild == null) continue;
                e.addChild(eChild);
            }
            return e;
        }

        public static IXmlElement output2Xml(Object obj) {
            Class obj2XMLClass = (Class)outputDefRegistry.get(obj.getClass());
            try {
                Method obj2Xmler = obj2XMLClass.getMethod("toXml", Object.class);
                return (IXmlElement)obj2Xmler.invoke(null, obj);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
        }
    }
}

