/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.data.modal.io.ExecDef;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExecDefIO {
    public static final String T_EXEC = "Exec";
    public static final String T_ARGS = "Args";
    public static final String T_ARG = "Arg";
    public static final String A_NAME = "name";
    public static final String A_INDEX = "index";
    public static final String A_URI = "uri";
    public static final String A_DESC = "desc";

    public static IXmlElement makeExec(ExecDef execDef) {
        Map args;
        String desc;
        IXmlElement xml = XmlUtil.createNode((String)T_EXEC);
        String url = execDef.getUri();
        if (url != null) {
            xml.setAttribute(A_URI, url);
        }
        if ((desc = execDef.getDesc()) != null) {
            xml.setAttribute(A_DESC, desc);
        }
        if ((args = execDef.getArgs()) != null) {
            xml.addChild(ExecDefIO.makeArgs(args));
        }
        return xml;
    }

    public static IXmlElement makeArgs(Map args) {
        IXmlElement xml = XmlUtil.createNode((String)T_ARGS);
        for (Map.Entry ent : args.entrySet()) {
            xml.addChild(ExecDefIO.makeArg((String)ent.getKey(), ent.getValue()));
        }
        return xml;
    }

    public static IXmlElement makeArg(String name, Object value) {
        IXmlElement xml = XmlUtil.createNode((String)T_ARG);
        xml.setAttribute(A_NAME, name);
        if (value != null) {
            xml.addCData(value.toString());
        }
        return xml;
    }

    public static ExecDef parseExec(IXmlElement xml) {
        ExecDef execDef = new ExecDef();
        execDef.setUri(xml.getAttribute(A_URI));
        execDef.setDesc(xml.getAttribute(A_DESC));
        IXmlElement xmlArgs = xml.getChild(T_ARGS);
        if (xmlArgs != null) {
            execDef.setArgs(ExecDefIO.parseArgs(xmlArgs));
        }
        return execDef;
    }

    public static HashMap parseArgs(IXmlElement xml) {
        HashMap args = new HashMap();
        Iterator itr = xml.searchChildren(T_ARG).iterator();
        while (itr.hasNext()) {
            ExecDefIO.parseArg((IXmlElement)itr.next(), args);
        }
        return args;
    }

    public static void parseArg(IXmlElement xml, Map args) {
        String name = xml.getAttribute(A_NAME);
        String text = xml.getText();
        args.put(name, text);
    }
}

