/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.query.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.io.Def2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.Ext2Xml;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.query.Condition;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.IQueryObjList;
import com.kingdee.cosmic.ctrl.data.modal.query.ITable;
import com.kingdee.cosmic.ctrl.data.modal.query.Join;
import com.kingdee.cosmic.ctrl.data.modal.query.Order;
import com.kingdee.cosmic.ctrl.data.modal.query.Table;
import java.util.Iterator;

public class Query2Xml {
    public static final String T_QUERY = "Query";
    public static final String T_COLUMNS = "Columns";
    public static final String T_COLUMN = "Column";
    public static final String T_TABLES = "Tables";
    public static final String T_TABLE = "Table";
    public static final String T_JOINS = "Joins";
    public static final String T_JOIN = "Join";
    public static final String T_CONDITION = "Condition";
    public static final String T_ORDERS = "Orders";
    public static final String T_ORDER = "Order";
    public static final String T_FILTER = "Filter";
    public static final String T_CONTENT = "Content";
    public static final String A_DISTINCT = "distinct";
    public static final String A_LEFT_TABLE = "leftTable";
    public static final String A_JOIN_TYPE = "joinType";
    public static final String A_RIGHT_TABLE = "rightTable";
    public static final String A_ORDER_TYPE = "orderType";
    public static final String V_VERSION = "1.0";
    public static final String V_ASC = "asc";
    public static final String V_DESC = "desc";

    public static IXmlElement toXml(IQuery obj) {
        IXmlElement e = XmlUtil.createNode((String)T_QUERY);
        if (obj != null) {
            Def2Xml.makeDefObj((IDefObj)obj, (IXmlElement)e);
            e.setAttribute("version", V_VERSION);
            if (obj.getQueryType() != null) {
                e.setAttribute("type", obj.getQueryType().getName());
            }
            if (obj.isDistinct()) {
                e.setAttribute(A_DISTINCT, Boolean.toString(obj.isDistinct()));
            }
            e.addChild(Query2Xml.makeColumns(obj.getColumns()));
            e.addChild(Query2Xml.makeTables(obj.getTables()));
            e.addChild(Query2Xml.makeJoins(obj.getJoins()));
            e.addChild(Query2Xml.makeOrders(obj.getOrders()));
            e.addChild(Query2Xml.makeFilter(obj.getFilter()));
            e.addChild(Query2Xml.makeContent(obj.getContent()));
        }
        return e;
    }

    public static void makeQueryExt(IQuery qry, IXmlElement xmlQry, Ext2Xml ext2xml) {
        if (qry.getQueryType().getCapital().equalsIgnoreCase("sql")) {
            Iterator xmlItr = xmlQry.getChild(T_TABLES).getChildren().iterator();
            Iterator objItr = qry.getTables().iterator();
            while (objItr.hasNext()) {
                ITable tbl = (ITable)objItr.next();
                IXmlElement tblXmlNode = (IXmlElement)xmlItr.next();
                ext2xml.makeExtObj(tbl.getExtObj(), tblXmlNode);
                if (!(tbl instanceof IQuery)) continue;
                Query2Xml.makeQueryExt((IQuery)((Object)tbl), tblXmlNode, ext2xml);
            }
            xmlItr = xmlQry.getChild(T_JOINS).searchChildren(T_JOIN).iterator();
            objItr = qry.getJoins().iterator();
            while (objItr.hasNext()) {
                ext2xml.makeExtObj(((Join)((Object)objItr.next())).getCondition().getExtObj(), (IXmlElement)((IXmlElement)xmlItr.next()).getChildren().get(0));
            }
            ext2xml.makeExtObj(qry.getFilter().getExtObj(), xmlQry.getChild(T_FILTER));
        }
    }

    public static IXmlElement makeColumns(IQueryObjList cols) {
        IXmlElement xmlCols = XmlUtil.createNode((String)T_COLUMNS);
        if (cols != null) {
            int len = cols.size();
            for (int i = 0; i < len; ++i) {
                xmlCols.addChild(Query2Xml.makeColumn((Column)((Object)cols.get(i))));
            }
        }
        return xmlCols;
    }

    public static IXmlElement makeColumn(Column col) {
        IXmlElement xmlCol = XmlUtil.createNode((String)T_COLUMN);
        if (col != null) {
            String s;
            Def2Xml.makeDefObj((IDefObj)col, (IXmlElement)xmlCol);
            if (col.getDataType() != null) {
                xmlCol.setAttribute("dataType", col.getDataType().getName());
            }
            if (!StringUtil.isEmptyString((String)(s = col.getExpr()))) {
                xmlCol.setAttribute("expr", s);
            }
        }
        return xmlCol;
    }

    public static IXmlElement makeTables(IQueryObjList tbls) {
        IXmlElement xmlTbls = XmlUtil.createNode((String)T_TABLES);
        if (tbls != null) {
            int len = tbls.size();
            for (int i = 0; i < len; ++i) {
                xmlTbls.addChild(Query2Xml.makeTable((ITable)tbls.get(i)));
            }
        }
        return xmlTbls;
    }

    public static IXmlElement makeTable(ITable tbl) {
        IXmlElement xmlTbl = null;
        if (tbl instanceof Table) {
            xmlTbl = XmlUtil.createNode((String)T_TABLE);
            Def2Xml.makeDefObj((IDefObj)tbl, (IXmlElement)xmlTbl);
            String s = tbl.getExpr();
            if (s != null) {
                xmlTbl.setAttribute("expr", s);
            }
        } else if (tbl instanceof IQuery) {
            xmlTbl = Query2Xml.toXml((IQuery)((Object)tbl));
        }
        return xmlTbl;
    }

    public static IXmlElement makeJoins(IQueryObjList joins) {
        IXmlElement xmlJoins = XmlUtil.createNode((String)T_JOINS);
        if (joins != null) {
            int len = joins.size();
            for (int i = 0; i < len; ++i) {
                xmlJoins.addChild(Query2Xml.makeJoin((Join)((Object)joins.get(i))));
            }
        }
        return xmlJoins;
    }

    public static IXmlElement makeJoin(Join join) {
        IXmlElement xmlJoin = XmlUtil.createNode((String)T_JOIN);
        if (join != null) {
            xmlJoin.setAttribute(A_LEFT_TABLE, join.getLeftTable());
            xmlJoin.setAttribute(A_JOIN_TYPE, join.getJoinType().getName());
            xmlJoin.setAttribute(A_RIGHT_TABLE, join.getRightTable());
            xmlJoin.addChild(Query2Xml.makeCondition(join.getCondition()));
        }
        return xmlJoin;
    }

    public static IXmlElement makeCondition(Condition condition) {
        IXmlElement xmlCondition = XmlUtil.createNode((String)T_CONDITION);
        if (condition != null) {
            xmlCondition.addCData(condition.getExpr());
        }
        return xmlCondition;
    }

    public static IXmlElement makeOrders(IQueryObjList ords) {
        IXmlElement xmlOrds = XmlUtil.createNode((String)T_ORDERS);
        if (ords != null) {
            int len = ords.size();
            for (int i = 0; i < len; ++i) {
                xmlOrds.addChild(Query2Xml.makeOrder((Order)((Object)ords.get(i))));
            }
        }
        return xmlOrds;
    }

    public static IXmlElement makeOrder(Order ord) {
        IXmlElement xmlOrd = XmlUtil.createNode((String)T_ORDER);
        if (ord != null) {
            Def2Xml.makeDefObj((IDefObj)ord, (IXmlElement)xmlOrd);
            String s = ord.getExpr();
            if (s != null) {
                xmlOrd.setAttribute("expr", s);
            }
            xmlOrd.setAttribute(A_ORDER_TYPE, ord.isAscending() ? V_ASC : V_DESC);
        }
        return xmlOrd;
    }

    public static IXmlElement makeFilter(Condition flt) {
        IXmlElement xml = XmlUtil.createNode((String)T_FILTER);
        if (flt != null && null != flt.getExpr()) {
            xml.addCData(flt.getExpr());
        }
        return xml;
    }

    public static IXmlElement makeContent(String content) {
        IXmlElement xml = XmlUtil.createNode((String)T_CONTENT);
        xml.addCData(content);
        return xml;
    }
}

