/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Properties;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyLoader;
import org.xerial.snappy.SnappyNative;

public class Snappy {
    private static SnappyNative impl;

    public static void cleanUp() {
        SnappyLoader.cleanUpExtractedNativeLib();
        SnappyLoader.setApi(null);
    }

    public static void arrayCopy(Object object, int n2, int n3, Object object2, int n4) throws IOException {
        impl.arrayCopy(object, n2, n3, object2, n4);
    }

    public static byte[] compress(byte[] byArray) throws IOException {
        return Snappy.rawCompress(byArray, byArray.length);
    }

    public static int compress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IOException {
        return Snappy.rawCompress(byArray, n2, n3, byArray2, n4);
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!byteBuffer2.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        int n4 = impl.rawCompress(byteBuffer, n2, n3, byteBuffer2, byteBuffer2.position());
        byteBuffer2.limit(byteBuffer2.position() + n4);
        return n4;
    }

    public static byte[] compress(char[] cArray) throws IOException {
        return Snappy.rawCompress(cArray, cArray.length * 2);
    }

    public static byte[] compress(double[] dArray) throws IOException {
        return Snappy.rawCompress(dArray, dArray.length * 8);
    }

    public static byte[] compress(float[] fArray) throws IOException {
        return Snappy.rawCompress(fArray, fArray.length * 4);
    }

    public static byte[] compress(int[] nArray) throws IOException {
        return Snappy.rawCompress(nArray, nArray.length * 4);
    }

    public static byte[] compress(long[] lArray) throws IOException {
        return Snappy.rawCompress(lArray, lArray.length * 8);
    }

    public static byte[] compress(short[] sArray) throws IOException {
        return Snappy.rawCompress(sArray, sArray.length * 2);
    }

    public static byte[] compress(String string) throws IOException {
        try {
            return Snappy.compress(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 encoder is not found");
        }
    }

    public static byte[] compress(String string, String string2) throws UnsupportedEncodingException, IOException {
        byte[] byArray = string.getBytes(string2);
        return Snappy.compress(byArray);
    }

    public static byte[] compress(String string, Charset charset) throws IOException {
        byte[] byArray = string.getBytes(charset);
        return Snappy.compress(byArray);
    }

    public static String getNativeLibraryVersion() {
        URL uRL = SnappyLoader.class.getResource("/org/xerial/snappy/VERSION");
        String string = "unknown";
        try {
            if (uRL != null) {
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                string = properties.getProperty("version", string);
                if (string.equals("unknown")) {
                    string = properties.getProperty("VERSION", string);
                }
                string = string.trim().replaceAll("[^0-9\\.]", "");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public static boolean isValidCompressedBuffer(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input is null");
        }
        return impl.isValidCompressedBuffer(byArray, n2, n3);
    }

    public static boolean isValidCompressedBuffer(byte[] byArray) throws IOException {
        return Snappy.isValidCompressedBuffer(byArray, 0, byArray.length);
    }

    public static boolean isValidCompressedBuffer(ByteBuffer byteBuffer) throws IOException {
        return impl.isValidCompressedBuffer(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    public static boolean isValidCompressedBuffer(long l2, long l3, long l4) throws IOException {
        return impl.isValidCompressedBuffer(l2, l3, l4);
    }

    public static int maxCompressedLength(int n2) {
        return impl.maxCompressedLength(n2);
    }

    public static long rawCompress(long l2, long l3, long l4) throws IOException {
        return impl.rawCompress(l2, l3, l4);
    }

    public static long rawUncompress(long l2, long l3, long l4) throws IOException {
        return impl.rawUncompress(l2, l3, l4);
    }

    public static byte[] rawCompress(Object object, int n2) throws IOException {
        byte[] byArray = new byte[Snappy.maxCompressedLength(n2)];
        int n3 = impl.rawCompress(object, 0, n2, byArray, 0);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static int rawCompress(Object object, int n2, int n3, byte[] byArray, int n4) throws IOException {
        if (object == null || byArray == null) {
            throw new NullPointerException("input or output is null");
        }
        int n5 = impl.rawCompress(object, n2, n3, byArray, n4);
        return n5;
    }

    public static int rawUncompress(byte[] byArray, int n2, int n3, Object object, int n4) throws IOException {
        if (byArray == null || object == null) {
            throw new NullPointerException("input or output is null");
        }
        return impl.rawUncompress(byArray, n2, n3, object, n4);
    }

    public static byte[] uncompress(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[Snappy.uncompressedLength(byArray)];
        int n2 = Snappy.uncompress(byArray, 0, byArray.length, byArray2, 0);
        return byArray2;
    }

    public static int uncompress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IOException {
        return Snappy.rawUncompress(byArray, n2, n3, byArray2, n4);
    }

    public static int uncompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!byteBuffer2.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        int n4 = impl.rawUncompress(byteBuffer, n2, n3, byteBuffer2, byteBuffer2.position());
        byteBuffer2.limit(byteBuffer2.position() + n4);
        return n4;
    }

    public static char[] uncompressCharArray(byte[] byArray) throws IOException {
        return Snappy.uncompressCharArray(byArray, 0, byArray.length);
    }

    public static char[] uncompressCharArray(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = Snappy.uncompressedLength(byArray, n2, n3);
        char[] cArray = new char[n4 / 2];
        int n5 = impl.rawUncompress(byArray, n2, n3, cArray, 0);
        return cArray;
    }

    public static double[] uncompressDoubleArray(byte[] byArray) throws IOException {
        int n2 = Snappy.uncompressedLength(byArray, 0, byArray.length);
        double[] dArray = new double[n2 / 8];
        int n3 = impl.rawUncompress(byArray, 0, byArray.length, dArray, 0);
        return dArray;
    }

    public static int uncompressedLength(byte[] byArray) throws IOException {
        return impl.uncompressedLength(byArray, 0, byArray.length);
    }

    public static int uncompressedLength(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("input is null");
        }
        return impl.uncompressedLength(byArray, n2, n3);
    }

    public static int uncompressedLength(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        return impl.uncompressedLength(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    public static long uncompressedLength(long l2, long l3) throws IOException {
        return impl.uncompressedLength(l2, l3);
    }

    public static float[] uncompressFloatArray(byte[] byArray) throws IOException {
        return Snappy.uncompressFloatArray(byArray, 0, byArray.length);
    }

    public static float[] uncompressFloatArray(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = Snappy.uncompressedLength(byArray, n2, n3);
        float[] fArray = new float[n4 / 4];
        int n5 = impl.rawUncompress(byArray, n2, n3, fArray, 0);
        return fArray;
    }

    public static int[] uncompressIntArray(byte[] byArray) throws IOException {
        return Snappy.uncompressIntArray(byArray, 0, byArray.length);
    }

    public static int[] uncompressIntArray(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = Snappy.uncompressedLength(byArray, n2, n3);
        int[] nArray = new int[n4 / 4];
        int n5 = impl.rawUncompress(byArray, n2, n3, nArray, 0);
        return nArray;
    }

    public static long[] uncompressLongArray(byte[] byArray) throws IOException {
        return Snappy.uncompressLongArray(byArray, 0, byArray.length);
    }

    public static long[] uncompressLongArray(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = Snappy.uncompressedLength(byArray, n2, n3);
        long[] lArray = new long[n4 / 8];
        int n5 = impl.rawUncompress(byArray, n2, n3, lArray, 0);
        return lArray;
    }

    public static short[] uncompressShortArray(byte[] byArray) throws IOException {
        return Snappy.uncompressShortArray(byArray, 0, byArray.length);
    }

    public static short[] uncompressShortArray(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = Snappy.uncompressedLength(byArray, n2, n3);
        short[] sArray = new short[n4 / 2];
        int n5 = impl.rawUncompress(byArray, n2, n3, sArray, 0);
        return sArray;
    }

    public static String uncompressString(byte[] byArray) throws IOException {
        try {
            return Snappy.uncompressString(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 decoder is not found");
        }
    }

    public static String uncompressString(byte[] byArray, int n2, int n3) throws IOException {
        try {
            return Snappy.uncompressString(byArray, n2, n3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 decoder is not found");
        }
    }

    public static String uncompressString(byte[] byArray, int n2, int n3, String string) throws IOException, UnsupportedEncodingException {
        byte[] byArray2 = new byte[Snappy.uncompressedLength(byArray, n2, n3)];
        int n4 = Snappy.uncompress(byArray, n2, n3, byArray2, 0);
        return new String(byArray2, string);
    }

    public static String uncompressString(byte[] byArray, int n2, int n3, Charset charset) throws IOException, UnsupportedEncodingException {
        byte[] byArray2 = new byte[Snappy.uncompressedLength(byArray, n2, n3)];
        int n4 = Snappy.uncompress(byArray, n2, n3, byArray2, 0);
        return new String(byArray2, charset);
    }

    public static String uncompressString(byte[] byArray, String string) throws IOException, UnsupportedEncodingException {
        byte[] byArray2 = Snappy.uncompress(byArray);
        return new String(byArray2, string);
    }

    public static String uncompressString(byte[] byArray, Charset charset) throws IOException, UnsupportedEncodingException {
        byte[] byArray2 = Snappy.uncompress(byArray);
        return new String(byArray2, charset);
    }

    static {
        try {
            impl = SnappyLoader.load();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

