/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xerial.snappy.PureJavaCrc32C;

final class SnappyFramed {
    public static final int COMPRESSED_DATA_FLAG = 0;
    public static final int UNCOMPRESSED_DATA_FLAG = 1;
    public static final int STREAM_IDENTIFIER_FLAG = 255;
    private static final int MASK_DELTA = -1568478504;
    private static final Class<? extends ByteBuffer> SUN_DIRECT_BUFFER = SnappyFramed.lookupClassQuietly("sun.nio.ch.DirectBuffer");
    private static final Method SUN_BUFFER_CLEANER;
    private static final Method SUN_CLEANER_CLEAN;
    public static final byte[] HEADER_BYTES;

    SnappyFramed() {
    }

    public static int maskedCrc32c(byte[] byArray) {
        return SnappyFramed.maskedCrc32c(byArray, 0, byArray.length);
    }

    public static int maskedCrc32c(byte[] byArray, int n2, int n3) {
        PureJavaCrc32C pureJavaCrc32C = new PureJavaCrc32C();
        pureJavaCrc32C.update(byArray, n2, n3);
        return SnappyFramed.mask(pureJavaCrc32C.getIntegerValue());
    }

    public static int mask(int n2) {
        return (n2 >>> 15 | n2 << 17) + -1568478504;
    }

    static final int readBytes(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2;
        int n3 = byteBuffer.remaining();
        int n4 = 0;
        n4 = n2 = readableByteChannel.read(byteBuffer);
        if (n2 < n3) {
            while (byteBuffer.remaining() != 0 && n2 != -1) {
                n2 = readableByteChannel.read(byteBuffer);
                if (n2 == -1) continue;
                n4 += n2;
            }
        }
        if (n4 > 0) {
            byteBuffer.limit(byteBuffer.position());
        } else {
            byteBuffer.position(byteBuffer.limit());
        }
        return n4;
    }

    static int skip(ReadableByteChannel readableByteChannel, int n2, ByteBuffer byteBuffer) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0 && n4 != -1) {
            byteBuffer.clear();
            if (n3 < byteBuffer.capacity()) {
                byteBuffer.limit(n3);
            }
            if ((n4 = readableByteChannel.read(byteBuffer)) <= 0) continue;
            n3 -= n4;
        }
        byteBuffer.clear();
        return n2 - n3;
    }

    private static Class<?> lookupClassQuietly(String string) {
        try {
            return SnappyFramed.class.getClassLoader().loadClass(string);
        }
        catch (Throwable throwable) {
            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Did not find requested class: " + string, throwable);
            return null;
        }
    }

    static void releaseDirectByteBuffer(ByteBuffer byteBuffer) {
        assert (byteBuffer != null && byteBuffer.isDirect());
        if (SUN_DIRECT_BUFFER != null && SUN_DIRECT_BUFFER.isAssignableFrom(byteBuffer.getClass())) {
            try {
                Object object = SUN_BUFFER_CLEANER.invoke((Object)byteBuffer, (Object[])null);
                SUN_CLEANER_CLEAN.invoke(object, (Object[])null);
            }
            catch (Throwable throwable) {
                Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Exception occurred attempting to clean up Sun specific DirectByteBuffer.", throwable);
            }
        }
    }

    static {
        Method method = null;
        Method method2 = null;
        try {
            if (SUN_DIRECT_BUFFER != null) {
                method = SUN_DIRECT_BUFFER.getMethod("cleaner", null);
                Class<?> clazz = SnappyFramed.lookupClassQuietly("sun.misc.Cleaner");
                method2 = clazz.getMethod("clean", null);
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Exception occurred attempting to lookup Sun specific DirectByteBuffer cleaner classes.", throwable);
        }
        SUN_BUFFER_CLEANER = method;
        SUN_CLEANER_CLEAN = method2;
        HEADER_BYTES = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    }
}

