/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.common.reflect;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.annotation.CheckForNull;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import shaded.com.google.common.reflect.TypeCapture;

@ElementTypesAreNonnullByDefault
public abstract class TypeParameter<T>
extends TypeCapture<T> {
    final TypeVariable<?> typeVariable;

    protected TypeParameter() {
        Type type = this.capture();
        Preconditions.checkArgument(type instanceof TypeVariable, "%s should be a type variable.", (Object)type);
        this.typeVariable = (TypeVariable)type;
    }

    public final int hashCode() {
        return this.typeVariable.hashCode();
    }

    public final boolean equals(@CheckForNull Object o2) {
        if (o2 instanceof TypeParameter) {
            TypeParameter that = (TypeParameter)o2;
            return this.typeVariable.equals(that.typeVariable);
        }
        return false;
    }

    public String toString() {
        return this.typeVariable.toString();
    }
}

