/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column;

import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.ColumnDescriptor;
import shaded.org.apache.parquet.column.ColumnWriteStore;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.impl.ColumnWriteStoreV1;
import shaded.org.apache.parquet.column.impl.ColumnWriteStoreV2;
import shaded.org.apache.parquet.column.page.PageWriteStore;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.boundedint.DevNullValuesWriter;
import shaded.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import shaded.org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import shaded.org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import shaded.org.apache.parquet.column.values.fallback.FallbackValuesWriter;
import shaded.org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import shaded.org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import shaded.org.apache.parquet.column.values.plain.PlainValuesWriter;
import shaded.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import shaded.org.apache.parquet.schema.MessageType;

public class ParquetProperties {
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final boolean enableDictionary;

    public ParquetProperties(int dictPageSize, WriterVersion writerVersion, boolean enableDict) {
        this.dictionaryPageSizeThreshold = dictPageSize;
        this.writerVersion = writerVersion;
        this.enableDictionary = enableDict;
    }

    public static ValuesWriter getColumnDescriptorValuesWriter(int maxLevel, int initialSizePerCol, int pageSize) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt(maxLevel), initialSizePerCol, pageSize);
    }

    private ValuesWriter plainWriter(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        switch (path.getType()) {
            case BOOLEAN: {
                return new BooleanPlainValuesWriter();
            }
            case INT96: {
                return new FixedLenByteArrayPlainValuesWriter(12, initialSizePerCol, pageSize);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), initialSizePerCol, pageSize);
            }
            case INT64: 
            case INT32: 
            case BINARY: 
            case FLOAT: 
            case DOUBLE: {
                return new PlainValuesWriter(initialSizePerCol, pageSize);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path, int initialSizePerCol) {
        Encoding encodingForDictionaryPage;
        Encoding encodingForDataPage;
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                encodingForDataPage = Encoding.PLAIN_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN_DICTIONARY;
                break;
            }
            case PARQUET_2_0: {
                encodingForDataPage = Encoding.RLE_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
            }
        }
        switch (path.getType()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            }
            case BINARY: {
                return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT32: {
                return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT64: {
                return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT96: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, 12, encodingForDataPage, encodingForDictionaryPage);
            }
            case DOUBLE: {
                return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case FLOAT: {
                return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, path.getTypeLength(), encodingForDataPage, encodingForDictionaryPage);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private ValuesWriter writerToFallbackTo(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return this.plainWriter(path, initialSizePerCol, pageSize);
            }
            case PARQUET_2_0: {
                switch (path.getType()) {
                    case BOOLEAN: {
                        return new RunLengthBitPackingHybridValuesWriter(1, initialSizePerCol, pageSize);
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return new DeltaByteArrayWriter(initialSizePerCol, pageSize);
                    }
                    case INT32: {
                        return new DeltaBinaryPackingValuesWriter(initialSizePerCol, pageSize);
                    }
                    case INT64: 
                    case FLOAT: 
                    case DOUBLE: 
                    case INT96: {
                        return this.plainWriter(path, initialSizePerCol, pageSize);
                    }
                }
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
    }

    private ValuesWriter dictWriterWithFallBack(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        ValuesWriter writerToFallBackTo = this.writerToFallbackTo(path, initialSizePerCol, pageSize);
        if (this.enableDictionary) {
            return FallbackValuesWriter.of(this.dictionaryWriter(path, initialSizePerCol), writerToFallBackTo);
        }
        return writerToFallBackTo;
    }

    public ValuesWriter getValuesWriter(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        switch (path.getType()) {
            case BOOLEAN: {
                return this.writerToFallbackTo(path, initialSizePerCol, pageSize);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return this.writerToFallbackTo(path, initialSizePerCol, pageSize);
            }
            case INT64: 
            case INT32: 
            case BINARY: 
            case FLOAT: 
            case DOUBLE: 
            case INT96: {
                return this.dictWriterWithFallBack(path, initialSizePerCol, pageSize);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore, int pageSize) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(pageStore, pageSize, this.dictionaryPageSizeThreshold, this.enableDictionary, this.writerVersion);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, pageSize, new ParquetProperties(this.dictionaryPageSizeThreshold, this.writerVersion, this.enableDictionary));
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            WriterVersion[] writerVersionArray = WriterVersion.values();
            int n2 = writerVersionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                WriterVersion v = writerVersionArray[n3];
                if (v.shortName.equals(name)) {
                    return v;
                }
                ++n3;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

