/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.impl;

import java.io.IOException;
import shaded.org.apache.parquet.Ints;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import shaded.org.apache.parquet.column.ColumnDescriptor;
import shaded.org.apache.parquet.column.ColumnWriter;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.ParquetProperties;
import shaded.org.apache.parquet.column.page.DictionaryPage;
import shaded.org.apache.parquet.column.page.PageWriter;
import shaded.org.apache.parquet.column.statistics.Statistics;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import shaded.org.apache.parquet.io.ParquetEncodingException;
import shaded.org.apache.parquet.io.api.Binary;

final class ColumnWriterV2
implements ColumnWriter {
    private static final Log LOG = Log.getLog(ColumnWriterV2.class);
    private static final boolean DEBUG = Log.DEBUG;
    private static final int MIN_SLAB_SIZE = 64;
    private final ColumnDescriptor path;
    private final PageWriter pageWriter;
    private RunLengthBitPackingHybridEncoder repetitionLevelColumn;
    private RunLengthBitPackingHybridEncoder definitionLevelColumn;
    private ValuesWriter dataColumn;
    private int valueCount;
    private Statistics<?> statistics;
    private long rowsWrittenSoFar = 0L;

    public ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties parquetProps, int pageSize) {
        this.path = path;
        this.pageWriter = pageWriter;
        this.resetStatistics();
        this.repetitionLevelColumn = new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt(path.getMaxRepetitionLevel()), 64, pageSize);
        this.definitionLevelColumn = new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt(path.getMaxDefinitionLevel()), 64, pageSize);
        int initialSlabSize = CapacityByteArrayOutputStream.initialSlabSizeHeuristic(64, pageSize, 10);
        this.dataColumn = parquetProps.getValuesWriter(path, initialSlabSize, pageSize);
    }

    private void log(Object value, int r2, int d2) {
        LOG.debug(this.path + " " + value + " r:" + r2 + " d:" + d2);
    }

    private void resetStatistics() {
        this.statistics = Statistics.getStatsBasedOnType(this.path.getType());
    }

    private void definitionLevel(int definitionLevel) {
        try {
            this.definitionLevelColumn.writeInt(definitionLevel);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("illegal definition level " + definitionLevel + " for column " + this.path, e2);
        }
    }

    private void repetitionLevel(int repetitionLevel) {
        try {
            this.repetitionLevelColumn.writeInt(repetitionLevel);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("illegal repetition level " + repetitionLevel + " for column " + this.path, e2);
        }
    }

    @Override
    public void writeNull(int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(null, repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.statistics.incrementNumNulls();
        ++this.valueCount;
    }

    @Override
    public void write(double value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeDouble(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(float value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(Float.valueOf(value), repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeFloat(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(Binary value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeBytes(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(boolean value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeBoolean(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(int value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeInteger(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    @Override
    public void write(long value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevel(repetitionLevel);
        this.definitionLevel(definitionLevel);
        this.dataColumn.writeLong(value);
        this.statistics.updateStats(value);
        ++this.valueCount;
    }

    public void finalizeColumnChunk() {
        DictionaryPage dictionaryPage = this.dataColumn.createDictionaryPage();
        if (dictionaryPage != null) {
            if (DEBUG) {
                LOG.debug("write dictionary");
            }
            try {
                this.pageWriter.writeDictionaryPage(dictionaryPage);
            }
            catch (IOException e2) {
                throw new ParquetEncodingException("could not write dictionary page for " + this.path, e2);
            }
            this.dataColumn.resetDictionary();
        }
    }

    public long getCurrentPageBufferedSize() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize();
    }

    public long getTotalBufferedSize() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize() + this.pageWriter.getMemSize();
    }

    public long allocatedSize() {
        return this.repetitionLevelColumn.getAllocatedSize() + this.definitionLevelColumn.getAllocatedSize() + this.dataColumn.getAllocatedSize() + this.pageWriter.allocatedSize();
    }

    public String memUsageString(String indent) {
        StringBuilder b2 = new StringBuilder(indent).append(this.path).append(" {\n");
        b2.append(indent).append(" r:").append(this.repetitionLevelColumn.getAllocatedSize()).append(" bytes\n");
        b2.append(indent).append(" d:").append(this.definitionLevelColumn.getAllocatedSize()).append(" bytes\n");
        b2.append(this.dataColumn.memUsageString(indent + "  data:")).append("\n");
        b2.append(this.pageWriter.memUsageString(indent + "  pages:")).append("\n");
        b2.append(indent).append(String.format("  total: %,d/%,d", this.getTotalBufferedSize(), this.allocatedSize())).append("\n");
        b2.append(indent).append("}\n");
        return b2.toString();
    }

    public long getRowsWrittenSoFar() {
        return this.rowsWrittenSoFar;
    }

    public void writePage(long rowCount) {
        int pageRowCount = Ints.checkedCast(rowCount - this.rowsWrittenSoFar);
        this.rowsWrittenSoFar = rowCount;
        if (DEBUG) {
            LOG.debug("write page");
        }
        try {
            BytesInput bytes = this.dataColumn.getBytes();
            Encoding encoding = this.dataColumn.getEncoding();
            this.pageWriter.writePageV2(pageRowCount, Ints.checkedCast(this.statistics.getNumNulls()), this.valueCount, this.path.getMaxRepetitionLevel() == 0 ? BytesInput.empty() : this.repetitionLevelColumn.toBytes(), this.path.getMaxDefinitionLevel() == 0 ? BytesInput.empty() : this.definitionLevelColumn.toBytes(), encoding, bytes, this.statistics);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write page for " + this.path, e2);
        }
        this.repetitionLevelColumn.reset();
        this.definitionLevelColumn.reset();
        this.dataColumn.reset();
        this.valueCount = 0;
        this.resetStatistics();
    }
}

