/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.bitpacking.ByteBasedBitPackingEncoder;
import shaded.org.apache.parquet.column.values.bitpacking.Packer;
import shaded.org.apache.parquet.io.ParquetEncodingException;

public class ByteBitPackingValuesWriter
extends ValuesWriter {
    private final Packer packer;
    private final int bitWidth;
    private ByteBasedBitPackingEncoder encoder;

    public ByteBitPackingValuesWriter(int bound, Packer packer) {
        this.packer = packer;
        this.bitWidth = BytesUtils.getWidthFromMaxInt(bound);
        this.encoder = new ByteBasedBitPackingEncoder(this.bitWidth, packer);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException(e2);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.BIT_PACKED;
    }

    @Override
    public BytesInput getBytes() {
        try {
            return this.encoder.toBytes();
        }
        catch (IOException e2) {
            throw new ParquetEncodingException(e2);
        }
    }

    @Override
    public void reset() {
        this.encoder = new ByteBasedBitPackingEncoder(this.bitWidth, this.packer);
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.encoder.memUsageString(prefix);
    }
}

