/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import shaded.org.apache.parquet.bytes.LittleEndianDataOutputStream;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import shaded.org.apache.parquet.io.ParquetEncodingException;
import shaded.org.apache.parquet.io.api.Binary;

public class DeltaLengthByteArrayValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(DeltaLengthByteArrayValuesWriter.class);
    private ValuesWriter lengthWriter;
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;

    public DeltaLengthByteArrayValuesWriter(int initialSize, int pageSize) {
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
        this.lengthWriter = new DeltaBinaryPackingValuesWriter(128, 4, initialSize, pageSize);
    }

    @Override
    public void writeBytes(Binary v) {
        try {
            this.lengthWriter.writeInteger(v.length());
            v.writeTo(this.out);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write bytes", e2);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.lengthWriter.getBufferedSize() + this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write page", e2);
        }
        if (Log.DEBUG) {
            LOG.debug("writing a buffer of size " + this.arrayOut.size());
        }
        return BytesInput.concat(this.lengthWriter.getBytes(), BytesInput.from(this.arrayOut));
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_LENGTH_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.lengthWriter.reset();
        this.arrayOut.reset();
    }

    @Override
    public long getAllocatedSize() {
        return this.lengthWriter.getAllocatedSize() + (long)this.arrayOut.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(this.lengthWriter.memUsageString(prefix) + " DELTA_LENGTH_BYTE_ARRAY");
    }
}

