/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.plain;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.LittleEndianDataInputStream;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.io.ParquetDecodingException;

public abstract class PlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(PlainValuesReader.class);
    protected LittleEndianDataInputStream in;

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in = new LittleEndianDataInputStream(new ByteArrayInputStream(in, offset, in.length - offset));
    }

    public static class LongPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(8);
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not skip long", e2);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.in.readLong();
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not read long", e2);
            }
        }
    }

    public static class IntegerPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(4);
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not skip int", e2);
            }
        }

        @Override
        public int readInteger() {
            try {
                return this.in.readInt();
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not read int", e2);
            }
        }
    }

    public static class FloatPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(4);
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not skip float", e2);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.in.readFloat();
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not read float", e2);
            }
        }
    }

    public static class DoublePlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(8);
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not skip double", e2);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.in.readDouble();
            }
            catch (IOException e2) {
                throw new ParquetDecodingException("could not read double", e2);
            }
        }
    }
}

