/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.plain;

import java.io.IOException;
import java.nio.charset.Charset;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import shaded.org.apache.parquet.bytes.LittleEndianDataOutputStream;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.io.ParquetEncodingException;
import shaded.org.apache.parquet.io.api.Binary;

public class PlainValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(PlainValuesWriter.class);
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;

    public PlainValuesWriter(int initialSize, int pageSize) {
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
    }

    @Override
    public final void writeBytes(Binary v) {
        try {
            this.out.writeInt(v.length());
            v.writeTo(this.out);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write bytes", e2);
        }
    }

    @Override
    public final void writeInteger(int v) {
        try {
            this.out.writeInt(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write int", e2);
        }
    }

    @Override
    public final void writeLong(long v) {
        try {
            this.out.writeLong(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write long", e2);
        }
    }

    @Override
    public final void writeFloat(float v) {
        try {
            this.out.writeFloat(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write float", e2);
        }
    }

    @Override
    public final void writeDouble(double v) {
        try {
            this.out.writeDouble(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write double", e2);
        }
    }

    @Override
    public void writeByte(int value) {
        try {
            this.out.write(value);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write byte", e2);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e2) {
            throw new ParquetEncodingException("could not write page", e2);
        }
        if (Log.DEBUG) {
            LOG.debug("writing a buffer of size " + this.arrayOut.size());
        }
        return BytesInput.from(this.arrayOut);
    }

    @Override
    public void reset() {
        this.arrayOut.reset();
    }

    @Override
    public long getAllocatedSize() {
        return this.arrayOut.getCapacity();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(prefix + " PLAIN");
    }
}

