/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Random;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntArrays;

public class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    private DoubleArrays() {
    }

    public static double[] ensureCapacity(double[] array, int length) {
        if (length > array.length) {
            double[] t2 = new double[length];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static double[] ensureCapacity(double[] array, int length, int preserve) {
        if (length > array.length) {
            double[] t2 = new double[length];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static double[] grow(double[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            double[] t2 = new double[newLength];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static double[] grow(double[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            double[] t2 = new double[newLength];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static double[] trim(double[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        double[] t2 = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, 0, t2, 0, length);
        return t2;
    }

    public static double[] setLength(double[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return DoubleArrays.trim(array, length);
        }
        return DoubleArrays.ensureCapacity(array, length);
    }

    public static double[] copy(double[] array, int offset, int length) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        double[] a2 = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static double[] copy(double[] array) {
        return (double[])array.clone();
    }

    public static void fill(double[] array, double value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(double[] array, int from, int to, double value) {
        DoubleArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(double[] a1, double[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(double[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(double[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(double[] x, int a2, int b2) {
        double t2 = x[a2];
        x[a2] = x[b2];
        x[b2] = t2;
    }

    private static void vecSwap(double[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            DoubleArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(double[] x, int a2, int b2, int c2, DoubleComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(double[] a2, int from, int to, DoubleComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (comp.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            double u2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u2;
        }
    }

    private static void insertionSort(double[] a2, int from, int to, DoubleComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            double t2 = a2[i2];
            int j2 = i2;
            double u2 = a2[j2 - 1];
            while (comp.compare(t2, u2) < 0) {
                a2[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = a2[--j2 - 1];
            }
            a2[j2] = t2;
        }
    }

    private static void selectionSort(double[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (Double.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            double u2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u2;
        }
    }

    private static void insertionSort(double[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            double t2 = a2[i2];
            int j2 = i2;
            double u2 = a2[j2 - 1];
            while (Double.compare(t2, u2) < 0) {
                a2[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = a2[--j2 - 1];
            }
            a2[j2] = t2;
        }
    }

    public static void quickSort(double[] x, int from, int to, DoubleComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            DoubleArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s2 = len / 8;
                l2 = DoubleArrays.med3(x, l2, l2 + s2, l2 + 2 * s2, comp);
                m2 = DoubleArrays.med3(x, m2 - s2, m2, m2 + s2, comp);
                n2 = DoubleArrays.med3(x, n2 - 2 * s2, n2 - s2, n2, comp);
            }
            m2 = DoubleArrays.med3(x, l2, m2, n2, comp);
        }
        double v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            DoubleArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s3 = Math.min(a2 - from, b2 - a2);
        DoubleArrays.vecSwap(x, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        DoubleArrays.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            DoubleArrays.quickSort(x, from, from + s3, comp);
        }
        if ((s3 = d2 - c2) > 1) {
            DoubleArrays.quickSort(x, n3 - s3, n3, comp);
        }
    }

    public static void quickSort(double[] x, DoubleComparator comp) {
        DoubleArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(double[] x, int a2, int b2, int c2) {
        int ab = Double.compare(x[a2], x[b2]);
        int ac = Double.compare(x[a2], x[c2]);
        int bc = Double.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    @Deprecated
    public static void quickSort(double[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            DoubleArrays.selectionSort(x, from, to);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s2 = len / 8;
                l2 = DoubleArrays.med3(x, l2, l2 + s2, l2 + 2 * s2);
                m2 = DoubleArrays.med3(x, m2 - s2, m2, m2 + s2);
                n2 = DoubleArrays.med3(x, n2 - 2 * s2, n2 - s2, n2);
            }
            m2 = DoubleArrays.med3(x, l2, m2, n2);
        }
        double v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = Double.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = Double.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            DoubleArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s3 = Math.min(a2 - from, b2 - a2);
        DoubleArrays.vecSwap(x, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        DoubleArrays.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            DoubleArrays.quickSort(x, from, from + s3);
        }
        if ((s3 = d2 - c2) > 1) {
            DoubleArrays.quickSort(x, n3 - s3, n3);
        }
    }

    @Deprecated
    public static void quickSort(double[] x) {
        DoubleArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(double[] a2, int from, int to, double[] supp) {
        int len = to - from;
        if (len < 7) {
            DoubleArrays.insertionSort(a2, from, to);
            return;
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, a2);
        DoubleArrays.mergeSort(supp, mid, to, a2);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && Double.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(double[] a2, int from, int to) {
        DoubleArrays.mergeSort(a2, from, to, (double[])a2.clone());
    }

    public static void mergeSort(double[] a2) {
        DoubleArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(double[] a2, int from, int to, DoubleComparator comp, double[] supp) {
        int len = to - from;
        if (len < 7) {
            DoubleArrays.insertionSort(a2, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, comp, a2);
        DoubleArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(double[] a2, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, from, to, comp, (double[])a2.clone());
    }

    public static void mergeSort(double[] a2, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(double[] a2, int from, int to, double key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            double midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(double[] a2, double key) {
        return DoubleArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(double[] a2, int from, int to, double key, DoubleComparator c2) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            double midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(double[] a2, double key, DoubleComparator c2) {
        return DoubleArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    private static final long fixDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return l2 >= 0L ? l2 : l2 ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[] a2) {
        DoubleArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(double[] a2, int from, int to) {
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(DoubleArrays.fixDouble(a2[first + i2]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 7 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                double t2 = a2[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    double z = t2;
                    int zz = c2;
                    t2 = a2[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    a2[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                a2[i4 + first] = t2;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, double[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t2 = perm[i2];
            int j2 = i2;
            int u2 = perm[j2 - 1];
            while (Double.compare(a2[t2], a2[u2]) < 0) {
                perm[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = perm[--j2 - 1];
            }
            perm[j2] = t2;
        }
    }

    public static void radixSortIndirect(int[] perm, double[] a2, boolean stable) {
        DoubleArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, double[] a2, int from, int to, boolean stable) {
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int i2;
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.insertionSortIndirect(perm, a2, first, first + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(DoubleArrays.fixDouble(a2[perm[first + i3]]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i3 = length;
            while (i3-- != 0) {
                int n3 = digit[i3] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 7 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n4 = digit[i2] & 0xFF;
                    int n5 = count[n4] - 1;
                    count[n4] = n5;
                    support[n5] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t2 = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n6 = c2;
                    int n7 = pos[n6] - 1;
                    pos[n6] = n7;
                    int d2 = n7;
                    if (n7 <= i4) break;
                    int z = t2;
                    int zz = c2;
                    t2 = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t2;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(double[] a2, double[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (!(a2[j2] < a2[m2]) && (a2[j2] != a2[m2] || !(b2[j2] < b2[m2]))) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            double t2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = t2;
            t2 = b2[i2];
            b2[i2] = b2[m2];
            b2[m2] = t2;
        }
    }

    public static void radixSort(double[] a2, double[] b2) {
        DoubleArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(double[] a2, double[] b2, int from, int to) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        int[] offsetStack = new int[3826];
        int offsetPos = 0;
        int[] lengthStack = new int[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.selectionSort(a2, b2, first, first + length);
                continue;
            }
            double[] k2 = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(DoubleArrays.fixDouble(k2[first + i2]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 15 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                double t2 = a2[i4 + first];
                double u2 = b2[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    double z = t2;
                    int zz = c2;
                    t2 = a2[d2 + first];
                    a2[d2 + first] = z;
                    z = u2;
                    u2 = b2[d2 + first];
                    b2[d2 + first] = z;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                a2[i4 + first] = t2;
                b2[i4 + first] = u2;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, double[] a2, double[] b2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t2 = perm[i2];
            int j2 = i2;
            int u2 = perm[j2 - 1];
            while (Double.compare(a2[t2], a2[u2]) < 0 || Double.compare(a2[t2], a2[u2]) == 0 && Double.compare(b2[t2], b2[u2]) < 0) {
                perm[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = perm[--j2 - 1];
            }
            perm[j2] = t2;
        }
    }

    public static void radixSortIndirect(int[] perm, double[] a2, double[] b2, boolean stable) {
        DoubleArrays.radixSortIndirect(perm, a2, b2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, double[] a2, double[] b2, int from, int to, boolean stable) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        int[] offsetStack = new int[3826];
        int offsetPos = 0;
        int[] lengthStack = new int[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int i2;
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.insertionSortIndirect(perm, a2, b2, first, first + length);
                continue;
            }
            double[] k2 = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(DoubleArrays.fixDouble(k2[perm[first + i3]]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i3 = length;
            while (i3-- != 0) {
                int n3 = digit[i3] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 15 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n4 = digit[i2] & 0xFF;
                    int n5 = count[n4] - 1;
                    count[n4] = n5;
                    support[n5] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t2 = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n6 = c2;
                    int n7 = pos[n6] - 1;
                    pos[n6] = n7;
                    int d2 = n7;
                    if (n7 <= i4) break;
                    int z = t2;
                    int zz = c2;
                    t2 = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t2;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(double[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 8;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            block1: for (int j2 = i2 + 1; j2 < to; ++j2) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j2] < a2[p2][m2]) {
                        m2 = j2;
                        continue block1;
                    }
                    if (a2[p2][j2] > a2[p2][m2]) continue block1;
                }
            }
            if (m2 == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                double u2 = a2[p3][i2];
                a2[p3][i2] = a2[p3][m2];
                a2[p3][m2] = u2;
            }
        }
    }

    public static void radixSort(double[][] a2) {
        DoubleArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(double[][] a2, int from, int to) {
        int layers = a2.length;
        int maxLevel = 8 * layers - 1;
        int p2 = layers;
        int l2 = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l2) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 8 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        double[] t2 = new double[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.selectionSort(a2, first, first + length, level);
                continue;
            }
            double[] k2 = a2[level / 8];
            int shift = (7 - level % 8) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(DoubleArrays.fixDouble(k2[first + i2]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p3 = 0;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < maxLevel && count[i3] > 1) {
                        offsetStack[offsetPos++] = p3 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p3 += count[i3];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t2[p4] = a2[p4][i4 + first];
                }
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    p4 = layers;
                    while (p4-- != 0) {
                        double u2 = t2[p4];
                        t2[p4] = a2[p4][d2 + first];
                        a2[p4][d2 + first] = u2;
                    }
                    int zz = c2;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                p4 = layers;
                while (p4-- != 0) {
                    a2[p4][i4 + first] = t2[p4];
                }
                count[c2] = 0;
            }
        }
    }

    public static double[] shuffle(double[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            double t2 = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t2;
        }
        return a2;
    }

    public static double[] shuffle(double[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            double t2 = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t2;
        }
        return a2;
    }

    public static double[] reverse(double[] a2) {
        int length = a2.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            double t2 = a2[length - i2 - 1];
            a2[length - i2 - 1] = a2[i2];
            a2[i2] = t2;
        }
        return a2;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(double[] a2, double[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

