/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import java.util.Random;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntComparator;

public class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new ArrayHashStrategy();

    private IntArrays() {
    }

    public static int[] ensureCapacity(int[] array, int length) {
        if (length > array.length) {
            int[] t2 = new int[length];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int length, int preserve) {
        if (length > array.length) {
            int[] t2 = new int[length];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static int[] grow(int[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            int[] t2 = new int[newLength];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static int[] grow(int[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            int[] t2 = new int[newLength];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static int[] trim(int[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        int[] t2 = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, 0, t2, 0, length);
        return t2;
    }

    public static int[] setLength(int[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return IntArrays.trim(array, length);
        }
        return IntArrays.ensureCapacity(array, length);
    }

    public static int[] copy(int[] array, int offset, int length) {
        IntArrays.ensureOffsetLength(array, offset, length);
        int[] a2 = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static int[] copy(int[] array) {
        return (int[])array.clone();
    }

    public static void fill(int[] array, int value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(int[] array, int from, int to, int value) {
        IntArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(int[] a1, int[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(int[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(int[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(int[] x, int a2, int b2) {
        int t2 = x[a2];
        x[a2] = x[b2];
        x[b2] = t2;
    }

    private static void vecSwap(int[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            IntArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(int[] x, int a2, int b2, int c2, IntComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(int[] a2, int from, int to, IntComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (comp.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            int u2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u2;
        }
    }

    private static void insertionSort(int[] a2, int from, int to, IntComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            int t2 = a2[i2];
            int j2 = i2;
            int u2 = a2[j2 - 1];
            while (comp.compare(t2, u2) < 0) {
                a2[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = a2[--j2 - 1];
            }
            a2[j2] = t2;
        }
    }

    private static void selectionSort(int[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2]) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            int u2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u2;
        }
    }

    private static void insertionSort(int[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t2 = a2[i2];
            int j2 = i2;
            int u2 = a2[j2 - 1];
            while (t2 < u2) {
                a2[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = a2[--j2 - 1];
            }
            a2[j2] = t2;
        }
    }

    public static void quickSort(int[] x, int from, int to, IntComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            IntArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s2 = len / 8;
                l2 = IntArrays.med3(x, l2, l2 + s2, l2 + 2 * s2, comp);
                m2 = IntArrays.med3(x, m2 - s2, m2, m2 + s2, comp);
                n2 = IntArrays.med3(x, n2 - 2 * s2, n2 - s2, n2, comp);
            }
            m2 = IntArrays.med3(x, l2, m2, n2, comp);
        }
        int v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            IntArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s3 = Math.min(a2 - from, b2 - a2);
        IntArrays.vecSwap(x, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        IntArrays.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            IntArrays.quickSort(x, from, from + s3, comp);
        }
        if ((s3 = d2 - c2) > 1) {
            IntArrays.quickSort(x, n3 - s3, n3, comp);
        }
    }

    public static void quickSort(int[] x, IntComparator comp) {
        IntArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(int[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = x[a2] < x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = x[a2] < x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = x[b2] < x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    @Deprecated
    public static void quickSort(int[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            IntArrays.selectionSort(x, from, to);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s2 = len / 8;
                l2 = IntArrays.med3(x, l2, l2 + s2, l2 + 2 * s2);
                m2 = IntArrays.med3(x, m2 - s2, m2, m2 + s2);
                n2 = IntArrays.med3(x, n2 - 2 * s2, n2 - s2, n2);
            }
            m2 = IntArrays.med3(x, l2, m2, n2);
        }
        int v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (x[b2] < v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (x[c2] < v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            IntArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s3 = Math.min(a2 - from, b2 - a2);
        IntArrays.vecSwap(x, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        IntArrays.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            IntArrays.quickSort(x, from, from + s3);
        }
        if ((s3 = d2 - c2) > 1) {
            IntArrays.quickSort(x, n3 - s3, n3);
        }
    }

    @Deprecated
    public static void quickSort(int[] x) {
        IntArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(int[] a2, int from, int to, int[] supp) {
        int len = to - from;
        if (len < 7) {
            IntArrays.insertionSort(a2, from, to);
            return;
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, from, mid, a2);
        IntArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && supp[p2] <= supp[q2] ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(int[] a2, int from, int to) {
        IntArrays.mergeSort(a2, from, to, (int[])a2.clone());
    }

    public static void mergeSort(int[] a2) {
        IntArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(int[] a2, int from, int to, IntComparator comp, int[] supp) {
        int len = to - from;
        if (len < 7) {
            IntArrays.insertionSort(a2, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, from, mid, comp, a2);
        IntArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(int[] a2, int from, int to, IntComparator comp) {
        IntArrays.mergeSort(a2, from, to, comp, (int[])a2.clone());
    }

    public static void mergeSort(int[] a2, IntComparator comp) {
        IntArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(int[] a2, int from, int to, int key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            int midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(int[] a2, int key) {
        return IntArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(int[] a2, int from, int to, int key, IntComparator c2) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            int midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(int[] a2, int key, IntComparator c2) {
        return IntArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    public static void radixSort(int[] a2) {
        IntArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(int[] a2, int from, int to) {
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (3 - level % 4) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(a2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 3 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t2 = a2[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    int z = t2;
                    int zz = c2;
                    t2 = a2[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    a2[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                a2[i4 + first] = t2;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, int[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t2 = perm[i2];
            int j2 = i2;
            int u2 = perm[j2 - 1];
            while (a2[t2] < a2[u2]) {
                perm[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = perm[--j2 - 1];
            }
            perm[j2] = t2;
        }
    }

    public static void radixSortIndirect(int[] perm, int[] a2, boolean stable) {
        IntArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, int[] a2, int from, int to, boolean stable) {
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int i2;
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.insertionSortIndirect(perm, a2, first, first + length);
                continue;
            }
            int shift = (3 - level % 4) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(a2[perm[first + i3]] >>> shift & 0xFF ^ signMask);
            }
            i3 = length;
            while (i3-- != 0) {
                int n3 = digit[i3] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 3 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n4 = digit[i2] & 0xFF;
                    int n5 = count[n4] - 1;
                    count[n4] = n5;
                    support[n5] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t2 = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n6 = c2;
                    int n7 = pos[n6] - 1;
                    pos[n6] = n7;
                    int d2 = n7;
                    if (n7 <= i4) break;
                    int z = t2;
                    int zz = c2;
                    t2 = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t2;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(int[] a2, int[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2] && (a2[j2] != a2[m2] || b2[j2] >= b2[m2])) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            int t2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = t2;
            t2 = b2[i2];
            b2[i2] = b2[m2];
            b2[m2] = t2;
        }
    }

    public static void radixSort(int[] a2, int[] b2) {
        IntArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(int[] a2, int[] b2, int from, int to) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.selectionSort(a2, b2, first, first + length);
                continue;
            }
            int[] k2 = level < 4 ? a2 : b2;
            int shift = (3 - level % 4) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 7 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t2 = a2[i4 + first];
                int u2 = b2[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    int z = t2;
                    int zz = c2;
                    t2 = a2[d2 + first];
                    a2[d2 + first] = z;
                    z = u2;
                    u2 = b2[d2 + first];
                    b2[d2 + first] = z;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                a2[i4 + first] = t2;
                b2[i4 + first] = u2;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, int[] a2, int[] b2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t2 = perm[i2];
            int j2 = i2;
            int u2 = perm[j2 - 1];
            while (a2[t2] < a2[u2] || a2[t2] == a2[u2] && b2[t2] < b2[u2]) {
                perm[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = perm[--j2 - 1];
            }
            perm[j2] = t2;
        }
    }

    public static void radixSortIndirect(int[] perm, int[] a2, int[] b2, boolean stable) {
        IntArrays.radixSortIndirect(perm, a2, b2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, int[] a2, int[] b2, int from, int to, boolean stable) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int i2;
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.insertionSortIndirect(perm, a2, b2, first, first + length);
                continue;
            }
            int[] k2 = level < 4 ? a2 : b2;
            int shift = (3 - level % 4) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(k2[perm[first + i3]] >>> shift & 0xFF ^ signMask);
            }
            i3 = length;
            while (i3-- != 0) {
                int n3 = digit[i3] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 7 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n4 = digit[i2] & 0xFF;
                    int n5 = count[n4] - 1;
                    count[n4] = n5;
                    support[n5] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t2 = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n6 = c2;
                    int n7 = pos[n6] - 1;
                    pos[n6] = n7;
                    int d2 = n7;
                    if (n7 <= i4) break;
                    int z = t2;
                    int zz = c2;
                    t2 = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t2;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(int[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 4;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            block1: for (int j2 = i2 + 1; j2 < to; ++j2) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j2] < a2[p2][m2]) {
                        m2 = j2;
                        continue block1;
                    }
                    if (a2[p2][j2] > a2[p2][m2]) continue block1;
                }
            }
            if (m2 == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                int u2 = a2[p3][i2];
                a2[p3][i2] = a2[p3][m2];
                a2[p3][m2] = u2;
            }
        }
    }

    public static void radixSort(int[][] a2) {
        IntArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(int[][] a2, int from, int to) {
        int layers = a2.length;
        int maxLevel = 4 * layers - 1;
        int p2 = layers;
        int l2 = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l2) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 4 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        int[] t2 = new int[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.selectionSort(a2, first, first + length, level);
                continue;
            }
            int[] k2 = a2[level / 4];
            int shift = (3 - level % 4) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p3 = 0;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < maxLevel && count[i3] > 1) {
                        offsetStack[offsetPos++] = p3 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p3 += count[i3];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t2[p4] = a2[p4][i4 + first];
                }
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    p4 = layers;
                    while (p4-- != 0) {
                        int u2 = t2[p4];
                        t2[p4] = a2[p4][d2 + first];
                        a2[p4][d2 + first] = u2;
                    }
                    int zz = c2;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                p4 = layers;
                while (p4-- != 0) {
                    a2[p4][i4 + first] = t2[p4];
                }
                count[c2] = 0;
            }
        }
    }

    public static int[] shuffle(int[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            int t2 = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t2;
        }
        return a2;
    }

    public static int[] shuffle(int[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            int t2 = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t2;
        }
        return a2;
    }

    public static int[] reverse(int[] a2) {
        int length = a2.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            int t2 = a2[length - i2 - 1];
            a2[length - i2 - 1] = a2[i2];
            a2[i2] = t2;
        }
        return a2;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<int[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(int[] a2, int[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

