/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift.server;

import shaded.parquet.org.apache.thrift.TException;
import shaded.parquet.org.apache.thrift.TProcessor;
import shaded.parquet.org.apache.thrift.protocol.TProtocol;
import shaded.parquet.org.apache.thrift.server.ServerContext;
import shaded.parquet.org.apache.thrift.server.TServer;
import shaded.parquet.org.apache.thrift.transport.TTransport;
import shaded.parquet.org.apache.thrift.transport.TTransportException;
import shaded.parquet.org.slf4j.Logger;
import shaded.parquet.org.slf4j.LoggerFactory;

public class TSimpleServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSimpleServer.class.getName());

    public TSimpleServer(TServer.AbstractServerArgs args) {
        super(args);
    }

    @Override
    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.setServing(true);
        while (!this.stopped_) {
            ServerContext connectionContext;
            TProtocol outputProtocol;
            TProtocol inputProtocol;
            TTransport outputTransport;
            TTransport inputTransport;
            block15: {
                TTransport client = null;
                TProcessor processor = null;
                inputTransport = null;
                outputTransport = null;
                inputProtocol = null;
                outputProtocol = null;
                connectionContext = null;
                try {
                    client = this.serverTransport_.accept();
                    if (client != null) {
                        processor = this.processorFactory_.getProcessor(client);
                        inputTransport = this.inputTransportFactory_.getTransport(client);
                        outputTransport = this.outputTransportFactory_.getTransport(client);
                        inputProtocol = this.inputProtocolFactory_.getProtocol(inputTransport);
                        outputProtocol = this.outputProtocolFactory_.getProtocol(outputTransport);
                        if (this.eventHandler_ != null) {
                            connectionContext = this.eventHandler_.createContext(inputProtocol, outputProtocol);
                        }
                        while (true) {
                            if (this.eventHandler_ != null) {
                                this.eventHandler_.processContext(connectionContext, inputTransport, outputTransport);
                            }
                            processor.process(inputProtocol, outputProtocol);
                        }
                    }
                }
                catch (TTransportException ttx) {
                    LOGGER.debug("Client Transportation Exception", ttx);
                }
                catch (TException tx) {
                    if (!this.stopped_) {
                        LOGGER.error("Thrift error occurred during processing of message.", tx);
                    }
                }
                catch (Exception x) {
                    if (this.stopped_) break block15;
                    LOGGER.error("Error occurred during processing of message.", x);
                }
            }
            if (this.eventHandler_ != null) {
                this.eventHandler_.deleteContext(connectionContext, inputProtocol, outputProtocol);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport == null) continue;
            outputTransport.close();
        }
        this.setServing(false);
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }
}

