/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.channel;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.message.SendMessageContext;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MessageChannelUtils {
    private static final String BS_MESSAGE_SERVICE_REGION = "MESSAGE_SERVICE";
    private static DistributeSessionlessCache messageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MESSAGE_SERVICE", new DistributeCacheHAPolicy());
    private static final String MSGCONFIG = "msgConfig";

    public static String getMessageChannelHashTag(String accountId) {
        String key = MessageChannelUtils.getWholeKey(accountId, MSGCONFIG);
        String hashTag = (String)messageCache.get(key);
        if (StringUtils.isBlank((CharSequence)hashTag)) {
            hashTag = MessageChannelUtils.updateMsgChannelTagKeyInCache();
        }
        return hashTag;
    }

    public static void clearMsgChannelTagKeyInCache() {
        String hashTag = "nohashtag";
        String key = MessageChannelUtils.getWholeKey(MessageChannelUtils.getAccountId(), MSGCONFIG);
        messageCache.put(key, (Object)hashTag);
    }

    public static String updateMsgChannelTagKeyInCache() {
        String selectedFields = "id, enable, number, category, name, createdate, modifydate";
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msg_channel", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        StringBuilder tag = new StringBuilder();
        if (channelObjects != null && channelObjects.length > 0) {
            for (DynamicObject channel : channelObjects) {
                Date modifyData = channel.getDate("modifyDate");
                if (modifyData == null) continue;
                tag.append(modifyData.getTime());
            }
        }
        String hashTag = "nohashtag";
        if (tag.length() > 0) {
            hashTag = String.valueOf(tag.toString().hashCode());
        }
        String key = MessageChannelUtils.getWholeKey(MessageChannelUtils.getAccountId(), MSGCONFIG);
        messageCache.put(key, (Object)hashTag);
        return hashTag;
    }

    public static boolean isEnable(String type) {
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)type);
        return msgChannelInfo != null;
    }

    private static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageChannelUtils.getAccountId()).append(".wf.");
        return MessageChannelUtils.strAppend(sb.toString(), ".", args);
    }

    private static String strAppend(String pref, String split, String[] args) {
        StringBuilder sb = new StringBuilder(pref);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                sb.append(arg).append(split);
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static String getAccountId() {
        return RequestContext.get().getAccountId();
    }

    public static Map<String, Object> getChannelRetryConfig(String channelNumber) {
        String retryConfig;
        Map m = null;
        MsgChannelInfo channelInfo = MessageChannelUtils.getChannelConfig(channelNumber);
        if (channelInfo != null && StringUtils.isNotBlank((Object)channelInfo) && StringUtils.isNotBlank((CharSequence)(retryConfig = channelInfo.getConfig()))) {
            m = (Map)JSONObject.parseObject((String)retryConfig, Map.class);
        }
        return m;
    }

    public static MsgChannelInfo getChannelConfig(String number) {
        MsgChannelInfo channelInfo = null;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            channelInfo = MsgServiceCache.getMsgChannel((String)number);
        }
        return channelInfo;
    }

    public static boolean isEmailChannel(String channelNumber) {
        MsgChannelInfo msgChannelInfo = null;
        if (!MessageChannels.MC.getNumber().equals(channelNumber)) {
            msgChannelInfo = MessageChannelUtils.getChannelInfo(channelNumber);
        }
        return MessageChannelUtils.isEmailChannel(channelNumber, msgChannelInfo);
    }

    public static boolean isEmailChannel(String channelNumber, SendMessageContext messageContext) {
        MsgChannelInfo msgChannelInfo = null;
        if (messageContext != null && !MessageChannels.MC.getNumber().equals(channelNumber)) {
            Map channelMapping = messageContext.getChannelMapping();
            msgChannelInfo = (MsgChannelInfo)channelMapping.get(channelNumber);
        }
        return MessageChannelUtils.isEmailChannel(channelNumber, msgChannelInfo);
    }

    public static boolean isEmailChannel(String channelNumber, MsgChannelInfo msgChannelInfo) {
        if (MessageChannels.EMAIL.getNumber().equals(channelNumber)) {
            return true;
        }
        if (msgChannelInfo == null) {
            return false;
        }
        String category = msgChannelInfo.getCategory();
        return MessageUtils.isNotEmpty((String)category) && MessageChannels.EMAIL.getNumber().equals(category);
    }

    public static boolean isOnlyEmailChannel(String channelsStr) {
        String[] channels;
        if (MessageUtils.isEmpty((String)channelsStr)) {
            return false;
        }
        boolean isEmailChannel = true;
        channelsStr = ",".equals(channelsStr.substring(0, 1)) ? channelsStr.substring(1, channelsStr.length()) : channelsStr;
        channelsStr = channelsStr.lastIndexOf(",") == channelsStr.length() - 1 ? channelsStr.substring(0, channelsStr.length() - 1) : channelsStr;
        for (String channle : channels = channelsStr.split(",")) {
            if (MessageChannelUtils.isEmailChannel(channle)) continue;
            isEmailChannel = false;
            break;
        }
        return isEmailChannel;
    }

    private static MsgChannelInfo getChannelInfo(String number) {
        String channel = MsgServiceCacheHelper.getChannelCache(number);
        if (MessageUtils.isNotEmpty((String)channel)) {
            return (MsgChannelInfo)SerializationUtils.fromJsonString((String)channel, MsgChannelInfo.class);
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject[] msgChannels = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id,number,name,category,enable", (QFilter[])filters);
        if (msgChannels == null || msgChannels.length == 0) {
            return null;
        }
        DynamicObject msgChannel = msgChannels[0];
        MsgChannelInfo msgChannelInfo = new MsgChannelInfo();
        msgChannelInfo.setNumber(msgChannel.getString("number"));
        msgChannelInfo.setName(SerializationUtils.toJsonString((Object)msgChannel.getLocaleString("name")));
        msgChannelInfo.setCategory(msgChannel.getString("category"));
        msgChannelInfo.setEnable(msgChannel.getBoolean("enable"));
        MsgServiceCacheHelper.putChannelCache(number, SerializationUtils.toJsonString((Object)msgChannelInfo));
        return msgChannelInfo;
    }
}

