/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.channel.cache;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.message.utils.MessageUtils;
import kd.bos.servicehelper.portal.NewPortalServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class MsgServiceCacheHelper {
    private static final String BS_MESSAGE_SERVICE_REGION = "MESSAGE_SERVICE";
    private static DistributeSessionlessCache messageCache = null;
    private static final int TPLTIMEOUT = 7200;
    private static final int TPLTIMEOUTALLDAY = 86400;
    private static final String KEY_WEIXINQYPUBLIC = "kingdee_sky_token";
    private static final String KEY_MCASYNCCOMPENSATION = "mcAsync";
    private static final String KEY_CONCURRENTCOUNTER = "CCounter";
    private static final String KEY_CONCURRENTDATA = "concurrentData";
    private static final String KEY_PERSONALSETTINGTOPN = "msgps_topn";
    private static final String KEY_PERSONALSETTINGTOP100 = "msgps_top100";
    private static final String KEY_QUANTITYSUMMARYINFO = "msgqsi";
    private static final String KEY_MESSAGELISTENER = "msglistener";
    private static final String KEY_TEMPLATE = "tpl";
    private static final String KEY_MCENTITYNAMES = "mc_entitynames";
    private static final String KEY_DEALMESSAGE = "dealmessage";
    private static final String KEY_SHOWSUBMITLOG = "showsubmitlog";
    private static final String KEY_LOGINUSERSIGNAME = "luserSign";
    private static final String KEY_CHECKRIGHTAPPIDS = "checkRightAppIds";
    private static final String KEY_OUTERTASKMODELDEFINITION = "existOuterTMDefinition";
    private static final String KEY_PERSONALSETTINGMSGTYPEENABLE = "menuconfig_enable";
    private static final String KEY_MSGCHANNEL = "msgChannel";
    private static final String KEY_ONE_KEY_READ_ALL = "onekeyreadall";

    private static DistributeSessionlessCache getDisCache() {
        if (messageCache == null) {
            messageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(BS_MESSAGE_SERVICE_REGION, new DistributeCacheHAPolicy());
        }
        return messageCache;
    }

    public static void putLoginUserSign(Long userId, int expire) {
        MsgServiceCacheHelper.putCache(MsgServiceCacheHelper.getLoginUserSignKey(userId), "1", expire);
    }

    public static String getLoginUserSign(Long userId) {
        return MsgServiceCacheHelper.getCache(MsgServiceCacheHelper.getLoginUserSignKey(userId));
    }

    public static String getLoginUserSignKey(Long userId) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_LOGINUSERSIGNAME, userId + "");
    }

    public static void putWxqyPublicTokenCache(String token, int expire) {
        String key = MsgServiceCacheHelper.getWxqyPublicTokenKey();
        MsgServiceCacheHelper.putCache(key, token, expire * 3 / 4);
    }

    public static String getWxqyPublicToken() {
        String key = MsgServiceCacheHelper.getWxqyPublicTokenKey();
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void removeWxqyPublicToken() {
        String key = MsgServiceCacheHelper.getWxqyPublicTokenKey();
        MsgServiceCacheHelper.deleteCache(key);
    }

    private static String getWxqyPublicTokenKey() {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_WEIXINQYPUBLIC);
    }

    public static String[] getMCAsyncOperateSource(String key) {
        return MsgServiceCacheHelper.getDisCache().getSetValues(key);
    }

    public static void putAsyncOperateSource(String key, List<String> values) {
        MsgServiceCacheHelper.getDisCache().addToSet(key, values.toArray(new String[0]), 130);
    }

    public static void RemoveAsyncOperateSource(String[] keys) {
        MsgServiceCacheHelper.getDisCache().remove(keys);
    }

    public static String wrapAsyncCompensationValue(String dataType, String billType, Long resourceId, int diff) {
        return dataType + "&" + billType + "&" + resourceId + "&" + diff;
    }

    public static String getMCAsyncOperateCompensationKey(String userId) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_MCASYNCCOMPENSATION, userId);
    }

    public static void putMCAsyncOperateCompensation(String userId, Map<String, List<String>> values) {
        String key = MsgServiceCacheHelper.getMCAsyncOperateCompensationKey(userId);
        MsgServiceCacheHelper.getDisCache().addToSet(key, values.keySet().toArray(new String[0]), 120);
        Set<Map.Entry<String, List<String>>> entrySet = values.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            String k = entry.getKey();
            if (k.startsWith("msg")) continue;
            MsgServiceCacheHelper.putAsyncOperateSource(k, values.get(k));
        }
    }

    public static void removeMCAsyncOperateCompensation(String userId, List<String> values) {
        String key = MsgServiceCacheHelper.getMCAsyncOperateCompensationKey(userId);
        if (MsgServiceCacheHelper.getDisCache().getSetLength(key) <= 0) {
            return;
        }
        String[] vs = values.toArray(new String[0]);
        HashSet<String> sourceKey = new HashSet<String>();
        for (String sk : vs) {
            if (sk.startsWith("msg")) continue;
            sourceKey.add(sk);
        }
        if (!sourceKey.isEmpty()) {
            MsgServiceCacheHelper.RemoveAsyncOperateSource(sourceKey.toArray(new String[0]));
        }
        MsgServiceCacheHelper.getDisCache().removeSetValues(key, vs);
    }

    public static JSONObject getMCAsyncOperateCompensation(String userId) {
        String key = MsgServiceCacheHelper.getMCAsyncOperateCompensationKey(userId);
        if (MsgServiceCacheHelper.getDisCache().getSetLength(key) <= 0) {
            return null;
        }
        String[] setValues = MsgServiceCacheHelper.getDisCache().getSetValues(key);
        JSONObject json = new JSONObject();
        for (String value : setValues) {
            MsgServiceCacheHelper.wrapData(value, json);
        }
        return json;
    }

    private static void wrapData(String value, JSONObject json) {
        if (value.startsWith("msg")) {
            json.put(value, (Object)"msg");
        } else {
            int setLength = MsgServiceCacheHelper.getDisCache().getSetLength(value);
            if (setLength <= 0) {
                return;
            }
            String[] dataTypes = MsgServiceCacheHelper.getMCAsyncOperateSource(value);
            JSONArray dts = new JSONArray();
            for (String dataType : dataTypes) {
                dts.add((Object)dataType);
            }
            json.put(value, (Object)dts);
        }
    }

    public static void incConcurrentCounter(String bizType) {
        String key = MsgServiceCacheHelper.getCounterKey(bizType);
        MsgServiceCacheHelper.getDisCache().inc(key);
    }

    public static void incConcurrentCounter(String bizType, int timeoutSeconds) {
        String key = MsgServiceCacheHelper.getCounterKey(bizType);
        MsgServiceCacheHelper.getDisCache().inc(key, timeoutSeconds, TimeUnit.SECONDS);
    }

    public static void decrConcurrentCounter(String bizType, int times) {
        String key = MsgServiceCacheHelper.getCounterKey(bizType);
        for (int i = 0; i < times; ++i) {
            MsgServiceCacheHelper.putConcurrentCounter(key);
        }
    }

    private static void putConcurrentCounter(String key) {
        MsgServiceCacheHelper.getDisCache().decr(key);
    }

    public static String getConcurrentCounter(String bizType) {
        String key = MsgServiceCacheHelper.getCounterKey(bizType);
        return (String)MsgServiceCacheHelper.getDisCache().get(key);
    }

    public static String getCounterKey(String bizType) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_CONCURRENTCOUNTER, bizType);
    }

    public static String getConcurrentDataSign(String bizType) {
        String key = MsgServiceCacheHelper.getConcurrentDataSignKey(bizType);
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void putConcurrentDatdSign(String bizType) {
        String key = MsgServiceCacheHelper.getConcurrentDataSignKey(bizType);
        MsgServiceCacheHelper.putCache(key, "true", 1800);
    }

    public static void removeConcurrentDataSign(String bizType) {
        String key = MsgServiceCacheHelper.getConcurrentDataSignKey(bizType);
        MsgServiceCacheHelper.deleteCache(key);
    }

    public static String getConcurrentDataSignKey(String bizType) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_CONCURRENTDATA, bizType);
    }

    public static String getMsgPersonalSettingDataTopIdsCache(Long userId) {
        String key = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsKey(userId);
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void putMsgPersonalSettingDataTopIdsCache(Long userId, String value) {
        String key = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsKey(userId);
        MsgServiceCacheHelper.putCache(key, value, 7200);
    }

    public static void removeMsgPersonalSettingDataTopIdsCache(Long userId) {
        String key = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsKey(userId);
        MsgServiceCacheHelper.deleteCache(key);
    }

    public static void removeMsgPersonalSettingDataTopIdsCacheAll(Long userId) {
        String oldKey = MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGTOPN, String.valueOf(userId));
        String newKey = MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGTOP100, String.valueOf(userId));
        MsgServiceCacheHelper.deleteCache(new String[]{oldKey, newKey});
    }

    private static String getMsgPersonalSettingDataTopIdsKey(Long userId) {
        if (NewPortalServiceHelper.isPersonalSettingNewPortal()) {
            return MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGTOP100, String.valueOf(userId));
        }
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGTOPN, String.valueOf(userId));
    }

    public static String getMsgQuantitySummaryCache(Long userId) {
        String key = MsgServiceCacheHelper.getQuantitySummaryKey(userId);
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void putMsgQuantitySummaryCache(Long userId, String value) {
        String key = MsgServiceCacheHelper.getQuantitySummaryKey(userId);
        MsgServiceCacheHelper.putCache(key, value, 7200);
    }

    public static void removeMsgQuantitySummaryCache(Long userId) {
        String key = MsgServiceCacheHelper.getQuantitySummaryKey(userId);
        MsgServiceCacheHelper.deleteCache(key);
    }

    private static String getQuantitySummaryKey(Long userId) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_QUANTITYSUMMARYINFO, String.valueOf(userId));
    }

    public static String getMsgEventListenerCache(String entityNumber, String msgType) {
        String key = MsgServiceCacheHelper.getMsgListenterKey(entityNumber, msgType);
        return MsgServiceCacheHelper.getCache(key);
    }

    public static String getMsgListenterKey(String entityNumber, String msgType) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_MESSAGELISTENER, msgType, entityNumber);
    }

    public static void putMsgEventListenerCache(String entityNumber, String msgType, String value) {
        String key = MsgServiceCacheHelper.getMsgListenterKey(entityNumber, msgType);
        MsgServiceCacheHelper.putCache(key, value, 7200);
    }

    public static String getTemplateCacheKey(String type, String channel, String scene, String entityNumber) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_TEMPLATE, type, channel, scene, entityNumber);
    }

    public static String getTemplateCacheKey(String templateNumber) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_TEMPLATE, templateNumber);
    }

    public static void putTemplateCache(String type, String channel, String scene, String entityNumber, String tplValue) {
        String key = MsgServiceCacheHelper.getTemplateCacheKey(type, channel, scene, entityNumber);
        MsgServiceCacheHelper.putCache(key, tplValue, 7200);
    }

    public static void putTemplateCache(String templateNumber, String tplValue) {
        String key = MsgServiceCacheHelper.getTemplateCacheKey(templateNumber);
        MsgServiceCacheHelper.putCache(key, tplValue, 7200);
    }

    public static String getTemplateCache(String type, String channel, String scene, String entityNumber) {
        String cacheKey = MsgServiceCacheHelper.getTemplateCacheKey(type, channel, scene, entityNumber);
        return MsgServiceCacheHelper.getCache(cacheKey);
    }

    public static String getTemplateCache(String templateNumber) {
        String cacheKey = MsgServiceCacheHelper.getTemplateCacheKey(templateNumber);
        return MsgServiceCacheHelper.getCache(cacheKey);
    }

    public static void putMessageTypeCache(String typeNumber, String value) {
        String key = MsgServiceCacheHelper.getTypeCahceKey(typeNumber);
        MsgServiceCacheHelper.putCache(key, value, 7200);
    }

    public static String getMessageTypeCache(String typeNumber) {
        String key = MsgServiceCacheHelper.getTypeCahceKey(typeNumber);
        String typeData = MsgServiceCacheHelper.getCache(key);
        return typeData;
    }

    public static void removeMessageTypeCache(String number) {
        String key = MsgServiceCacheHelper.getTypeCahceKey(number);
        MsgServiceCacheHelper.deleteCache(key);
    }

    public static String getTypeCahceKey(String typeNumber) {
        StringBuilder key = new StringBuilder(RequestContext.get().getAccountId());
        key.append("&&");
        key.append("msg.type");
        key.append("&&");
        key.append(typeNumber);
        return key.toString();
    }

    public static void putMCEntityNameCache(String value) {
        String key = MsgServiceCacheHelper.getMCEntityNameKey();
        MsgServiceCacheHelper.putCache(key, value, 1800);
    }

    public static String getMCEntityNameCache() {
        String key = MsgServiceCacheHelper.getMCEntityNameKey();
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void removeMCEntityNameCache() {
        String key = MsgServiceCacheHelper.getMCEntityNameKey();
        MsgServiceCacheHelper.deleteCache(key);
    }

    private static String getMCEntityNameKey() {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_MCENTITYNAMES);
        return key;
    }

    public static void putMenuConfigCache(String value) {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGMSGTYPEENABLE);
        MsgServiceCacheHelper.putCache(key, value, 14400);
    }

    public static String getMenuConfigCache() {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGMSGTYPEENABLE);
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void removeMenuConfigCache() {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_PERSONALSETTINGMSGTYPEENABLE);
        MsgServiceCacheHelper.deleteCache(key);
    }

    public static void putDealMessageCache(String key, String value) {
        MsgServiceCacheHelper.putCache(key, value, 180);
    }

    public static String getDealMessageKey(String messageId, String userId, String channel) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_DEALMESSAGE, messageId, userId, channel);
    }

    public static void putOneKeyReadAllTag(String value) {
        String key = MsgServiceCacheHelper.getOneKeyReadAllTagKey();
        MsgServiceCacheHelper.putCache(key, value, 1800);
    }

    public static String getOneKeyReadAllTag() {
        String key = MsgServiceCacheHelper.getOneKeyReadAllTagKey();
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void removeOneKeyReadAllTag() {
        String key = MsgServiceCacheHelper.getOneKeyReadAllTagKey();
        MsgServiceCacheHelper.deleteCache(key);
    }

    private static String getOneKeyReadAllTagKey() {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_ONE_KEY_READ_ALL, String.valueOf(RequestContext.get().getCurrUserId()));
        return key;
    }

    private static String cacheKeyMaker(String ... args) {
        StringBuilder key = new StringBuilder();
        String tenantId = RequestContext.get().getTenantCode();
        if (MessageUtils.isNotEmpty((String)tenantId)) {
            key.append(tenantId).append("_");
        }
        key.append(RequestContext.get().getAccountId()).append('_');
        for (int i = 0; i < args.length; ++i) {
            if (i != args.length - 1) {
                key.append(args[i]).append('_');
                continue;
            }
            key.append(args[i]);
        }
        return key.toString();
    }

    @SdkInternal
    public static void deleteCache(String key) {
        MsgServiceCacheHelper.getDisCache().remove(key);
    }

    public static void deleteCache(String[] keys) {
        MsgServiceCacheHelper.getDisCache().remove(keys);
    }

    public static void putCache(String key, String value, int timeout) {
        if (0 == timeout) {
            MsgServiceCacheHelper.getDisCache().put(key, (Object)value);
        } else {
            MsgServiceCacheHelper.getDisCache().put(key, (Object)value, timeout);
        }
    }

    public static void putCache(String type, String key, String value, int timeout) {
        if (0 == timeout) {
            MsgServiceCacheHelper.getDisCache().put(type, key, (Object)value);
        } else {
            MsgServiceCacheHelper.getDisCache().put(type, key, value, timeout);
        }
    }

    public static String getCache(String key) {
        return (String)MsgServiceCacheHelper.getDisCache().get(key);
    }

    public static String getCache(String type, String key) {
        return (String)MsgServiceCacheHelper.getDisCache().get(type, key);
    }

    public static void deleteCache(String type, String key) {
        MsgServiceCacheHelper.getDisCache().remove(type, key);
    }

    public static List<String> getCache(String type, String[] keys) {
        return MsgServiceCacheHelper.getDisCache().get(type, keys);
    }

    public static DistributeSessionlessCache getMessageCache() {
        return MsgServiceCacheHelper.getDisCache();
    }

    public static String getShowSubmitLogCache(Long userId) {
        String key = MsgServiceCacheHelper.getShowSubmitLogKey(userId);
        return MsgServiceCacheHelper.getCache(key);
    }

    private static String getShowSubmitLogKey(Long userId) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_SHOWSUBMITLOG, String.valueOf(userId));
    }

    public static void putShowSubmitLogCache(Long userId, String value) {
        String key = MsgServiceCacheHelper.getShowSubmitLogKey(userId);
        MsgServiceCacheHelper.putCache(key, value, 86400);
    }

    public static String getCheckRightAppIdCache(String formNumber) {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_CHECKRIGHTAPPIDS, formNumber);
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void putCheckRightAppIdCache(String formNumber, String appNumber) {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_CHECKRIGHTAPPIDS, formNumber);
        MsgServiceCacheHelper.putCache(key, appNumber, 86400);
    }

    public static void removeCheckRightAppIdCache(String formNumber) {
        String key = MsgServiceCacheHelper.cacheKeyMaker(KEY_CHECKRIGHTAPPIDS, formNumber);
        MsgServiceCacheHelper.getDisCache().remove(key);
    }

    private static String getOuterTaskModelDefinitionSignKey() {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_OUTERTASKMODELDEFINITION);
    }

    public static String getOuterTaskModelDefinitionSign() {
        String key = MsgServiceCacheHelper.getOuterTaskModelDefinitionSignKey();
        return MsgServiceCacheHelper.getCache(key);
    }

    public static void putOuterTaskModelDefintionSign(String isExist) {
        String key = MsgServiceCacheHelper.getOuterTaskModelDefinitionSignKey();
        MsgServiceCacheHelper.putCache(key, isExist, 86400);
    }

    public static void removeOuterTaskModelDefintionSign() {
        String key = MsgServiceCacheHelper.getOuterTaskModelDefinitionSignKey();
        MsgServiceCacheHelper.getDisCache().remove(key);
    }

    private static String getChannelCacheKey(String number) {
        return MsgServiceCacheHelper.cacheKeyMaker(KEY_MSGCHANNEL, number);
    }

    public static String getChannelCache(String number) {
        return MsgServiceCacheHelper.getCache(MsgServiceCacheHelper.getChannelCacheKey(number));
    }

    public static void putChannelCache(String number, String channel) {
        MsgServiceCacheHelper.putCache(MsgServiceCacheHelper.getChannelCacheKey(number), channel, 7200);
    }
}

