/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.handler.config.ChannelRuntimeConfig;
import kd.bos.message.service.handler.config.DyanmicChannelConfig;
import kd.bos.message.service.utils.MessageUtils;

public class EmailHandler {
    private static Log logger = LogFactory.getLog(EmailHandler.class);
    private static final String CONNECTIONTIMEOUT = "30000";
    private static final String TIMEOUT = "30000";
    private static final String PORT465 = "465";

    public static Map<String, Object> sendEmail(EmailInfo emailInfo) {
        logger.info("sendEmail--postemail");
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)"email");
        if (msgChannelInfo == null) {
            return MessageUtils.wrapResult((String)ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6d88\u606f\u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6/\u77ed\u4fe1\u3002", (String)"EmailHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        String fromaccount = msgChannelInfo.getFromaccount();
        String fromusername = msgChannelInfo.getFromusername();
        ChannelRuntimeConfig emailRuntimeConfig = EmailHandler.getEmailRuntimeConfig(msgChannelInfo.getConfig(), emailInfo);
        if (emailRuntimeConfig != null) {
            if (StringUtils.isNotBlank((CharSequence)emailRuntimeConfig.getFromAccount())) {
                fromaccount = emailRuntimeConfig.getFromAccount();
            }
            if (StringUtils.isNotBlank((CharSequence)emailRuntimeConfig.getFromUserName())) {
                fromusername = emailRuntimeConfig.getFromUserName();
            }
            logger.debug(String.format("get emailRuntimeConfig fromaccount:[%s], fromusername:[%s]", fromaccount, fromusername));
        }
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", msgChannelInfo.getSmtphost());
        props.setProperty("mail.smtp.port", msgChannelInfo.getSmtpport());
        props.setProperty("mail.smtp.connectiontimeout", "30000");
        props.setProperty("mail.smtp.timeout", "30000");
        String domain = msgChannelInfo.getDomain();
        if (domain != null && StringUtils.isNotBlank((CharSequence)domain)) {
            props.setProperty("mail.smtp.connectiontimeout", "40000");
            props.setProperty("mail.smtp.timeout", "40000");
            props.setProperty("mail.smtp.auth.ntlm.domain", domain);
            logger.debug("sendEmail--email domain is setted");
        } else {
            props.setProperty("mail.smtp.connectiontimeout", "30000");
            props.setProperty("mail.smtp.timeout", "30000");
            props.remove("mail.smtp.auth.ntlm.domain");
        }
        boolean auth = EmailHandler.setAuthAndProtocol(msgChannelInfo.getMobileappconfig(), props);
        logger.debug(String.format("EmailHandlerTest- mail.smtp.starttls.enable value is %s", props.getProperty("mail.smtp.starttls.enable")));
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.socketFactory.port", msgChannelInfo.getSmtpport());
        props.setProperty("java.net.preferIPv4Stack", "true");
        props.setProperty("mail.mime.splitlongparameters", "false");
        props.setProperty("mail.mime.charset", "UTF-8");
        Session session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        session.setDebug(false);
        EmailHandler.wrapProps(msgChannelInfo.getConfig(), props, session);
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(fromaccount, fromusername));
            InternetAddress[] receiverAddress = null;
            if (emailInfo.getReceiver() != null && !emailInfo.getReceiver().isEmpty()) {
                receiverAddress = EmailHandler.getInternetAddress(emailInfo.getReceiver());
            }
            if (receiverAddress == null || receiverAddress.length == 0) {
                logger.debug("sendEmail--email receiver is null and stop send email");
                return MessageUtils.wrapResult((String)"email receiver is null and stop send email");
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])receiverAddress);
            if (emailInfo.getCopyReceiver() != null && !emailInfo.getCopyReceiver().isEmpty()) {
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])EmailHandler.getInternetAddress(emailInfo.getCopyReceiver()));
            }
            if (emailInfo.getSecretReceiver() != null && !emailInfo.getSecretReceiver().isEmpty()) {
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])EmailHandler.getInternetAddress(emailInfo.getSecretReceiver()));
            }
            mimeMessage.setSubject(emailInfo.getTitle());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentMimeBody = new MimeBodyPart();
            String contentType = "TEXT".equalsIgnoreCase(emailInfo.getContentMimeType()) ? "text/plain;charset=UTF-8" : "text/html;charset=UTF-8";
            contentMimeBody.setContent((Object)emailInfo.getContent(), contentType);
            multipart.addBodyPart((BodyPart)contentMimeBody);
            if (EmailHandler.isAttachment(emailInfo)) {
                EmailHandler.wrapEmailAttachments(emailInfo, (Multipart)multipart);
            }
            mimeMessage.setContent((Multipart)multipart);
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
            return MessageUtils.wrapResult((String)"success");
        }
        catch (Exception e) {
            logger.error(kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e));
            return MessageUtils.wrapResult((String)e.getMessage());
        }
    }

    private static boolean setAuthAndProtocol(String mobileAppConfig, Properties props) {
        String smtpProtocol;
        boolean auth = Boolean.TRUE;
        if (StringUtils.isBlank((CharSequence)mobileAppConfig)) {
            return auth;
        }
        JSONObject jsonConfig = JSONObject.parseObject((String)mobileAppConfig);
        if (jsonConfig == null) {
            return auth;
        }
        if (StringUtils.isNotBlank((Object)jsonConfig.getBoolean("auth"))) {
            auth = jsonConfig.getBoolean("auth");
            props.setProperty("mail.smtp.auth", String.valueOf(auth));
        }
        if ("ssl".equalsIgnoreCase(smtpProtocol = jsonConfig.getString("smtpProtocol"))) {
            props.setProperty("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else if ("tls".equalsIgnoreCase(smtpProtocol)) {
            props.setProperty("mail.smtp.starttls.enable", "true");
        } else if ("all".equalsIgnoreCase(smtpProtocol)) {
            props.setProperty("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.ssl.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else {
            props.remove("mail.smtp.ssl.enable");
            props.remove("mail.smtp.socketFactory.class");
            props.remove("mail.smtp.starttls.enable");
        }
        return auth;
    }

    private static void wrapProps(String config, Properties props, Session session) {
        try {
            JSONArray deleteProps;
            if (StringUtils.isBlank((CharSequence)config)) {
                return;
            }
            JSONObject jsonConfig = JSONObject.parseObject((String)config);
            if (jsonConfig == null) {
                return;
            }
            JSONObject jsonProps = jsonConfig.getJSONObject("mailSmtpProps");
            if (jsonProps == null) {
                return;
            }
            JSONObject addProps = jsonProps.getJSONObject("addProps");
            if (addProps != null) {
                for (Map.Entry entry : addProps.entrySet()) {
                    if ("session.debug".equalsIgnoreCase((String)entry.getKey())) {
                        session.setDebug(((Boolean)entry.getValue()).booleanValue());
                        continue;
                    }
                    props.setProperty((String)entry.getKey(), addProps.getString((String)entry.getKey()));
                }
            }
            if ((deleteProps = jsonProps.getJSONArray("deleteProps")) != null) {
                for (int i = 0; i < deleteProps.size(); ++i) {
                    props.remove(deleteProps.get(i));
                }
            }
        }
        catch (Exception e) {
            logger.warn("wrapProps is error");
        }
    }

    private static void wrapEmailAttachments(EmailInfo emailInfo, Multipart multipart) throws UnsupportedEncodingException, MessagingException {
        List attachments = emailInfo.getAttachments();
        List attachmentNames = emailInfo.getAttachmentNames();
        if (kd.bos.message.utils.MessageUtils.isAttachmentBeyondLimit((List)attachments)) {
            logger.debug("sendEmail--attachment size beyond limit");
            return;
        }
        for (int i = 0; i < attachments.size(); ++i) {
            byte[] bt = (byte[])attachments.get(i);
            if (bt == null || bt.length == 0) continue;
            MimeBodyPart attachmentBody = new MimeBodyPart();
            DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(bt, "application/octet-stream"));
            attachmentBody.setDataHandler(dataHandler);
            String encodedName = MimeUtility.encodeText((String)((String)attachmentNames.get(i)), (String)"UTF-8", (String)"B");
            attachmentBody.setFileName(encodedName);
            attachmentBody.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + "\"");
            multipart.addBodyPart((BodyPart)attachmentBody);
        }
    }

    private static boolean isAttachment(EmailInfo emailInfo) {
        boolean isAttachment = false;
        List attachments = emailInfo.getAttachments();
        List attachmentNames = emailInfo.getAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty() && attachments != null && !attachments.isEmpty() && attachmentNames.size() == attachments.size()) {
            isAttachment = true;
        }
        return isAttachment;
    }

    private static InternetAddress[] getInternetAddress(List<String> userAddress) throws AddressException {
        LinkedHashSet<String> addresses = new LinkedHashSet<String>();
        for (String ua : userAddress) {
            if (!StringUtils.isNotBlank((CharSequence)ua)) continue;
            addresses.add(ua);
        }
        InternetAddress[] ia = null;
        if (!addresses.isEmpty()) {
            int i = 0;
            ia = new InternetAddress[addresses.size()];
            for (String address : addresses) {
                ia[i++] = new InternetAddress(address);
            }
        }
        return ia;
    }

    private static List<byte[]> getEmailAttachementByte(List<String> attachmentWebUrls) {
        ArrayList<byte[]> attachments = new ArrayList<byte[]>();
        try {
            for (String path : attachmentWebUrls) {
                attachments.add(EmailHandler.getDataByte(path));
            }
        }
        catch (Exception e) {
            logger.warn("sendEmail--get attachment byte data error by attachmentWebUrls");
        }
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDataByte(String path) throws IOException {
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.connect();
        conn.setReadTimeout(5000);
        conn.setConnectTimeout(5000);
        byte[] bt = null;
        try (InputStream is = conn.getInputStream();){
            bt = EmailHandler.input2byte(is);
        }
        return bt;
    }

    private static byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 1024)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    private static ChannelRuntimeConfig getEmailRuntimeConfig(String config, EmailInfo emailInfo) {
        try {
            if (StringUtils.isBlank((CharSequence)config)) {
                return null;
            }
            JSONObject jc = JSONObject.parseObject((String)config);
            if (jc == null) {
                return null;
            }
            if (jc.get((Object)"dynamicModifyConfig") == null || !((Boolean)jc.get((Object)"dynamicModifyConfig")).booleanValue()) {
                return null;
            }
            String msgConsumerClass = "kd.bos.message.service.handler.config.DyanmicChannelConfig";
            DyanmicChannelConfig dyanmicChannelConfig = (DyanmicChannelConfig)Class.forName(msgConsumerClass).newInstance();
            return dyanmicChannelConfig.getChannelRuntimeConfig(emailInfo.getParams());
        }
        catch (Exception e) {
            logger.error(String.format("getRuntimeEmailConfig is error [%s]", e.getMessage()));
            return null;
        }
    }
}

