/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.MessageUtils;
import kd.bos.message.utils.SMSProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.math.NumberUtils;

public class MessageHandler {
    private static final Log logger = LogFactory.getLog(MessageHandler.class);
    @Deprecated
    public static final String CLIENT_ID = "client_id";
    @Deprecated
    public static final String CLIENT_SECRET = "client_secret";
    public static final String HEADER_CLIENT_ID = "X-Api-ClientID";
    public static final String HEADER_CLIENT_SECRET = "X-Api-ClientSecret";
    public static final String PHONE = "phone";
    public static final String USERID_AND_PHONE = "useridAndPhone";
    public static final String SMSCODE = "smscode";
    private static final String PARAM_CONTENT = "content";
    public static final String SIGNATURE = "signature";
    public static final String COUNTRY_CODE = "country_code";
    private static final int CONNECTIONTIMEOUT = 5000;
    private static final int READTIMEOUT = 10000;
    private static final String DEFAULTSMSCODE = "10725";
    public static final String SMSID = "smsid";
    private static final String ERRORCODE = "errcode";
    private static final String TIMESTAMP = "timestamp";
    public static final String SMSSTANDERSERVICE = "kd.bos.workflow.engine.msg.handler.SMSServiceHandler";
    private static final String OLDVERSIONAPI1 = "https://api.kingdee.com/msgsrv/sms";
    private static final String OLDVERSIONAPI2 = "https://api.kingdee.com/msgsrv/sms2";
    private static final String PARAM_ACTION = "action";
    private static final String SEND = "send";
    private static final String PARAM_ACCOUNT = "account";
    private static final String PARAM_EXTNO = "extno";
    private static final String PARAM_RT = "rt";
    private static final String JSON_STR = "json";
    private static final String PARAM_MOBILE = "mobile";
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_VAL = "application/json;charset=UTF-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_VAL = "application/json;charset=UTF-8";
    private static final String STATUS = "status";

    public static Map<String, Object> sendShortMessage(ShortMessageInfo shortMessageInfo) {
        return MessageHandler.sendShortMessage(shortMessageInfo, null);
    }

    public static Map<String, Object> sendShortMessage(ShortMessageInfo shortMessageInfo, Map<String, Object> param) {
        logger.debug("sendShortMessage--into messageHandler begine start");
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)"sms");
        if (msgChannelInfo == null) {
            return MessageUtils.wrapResult((String)ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6d88\u606f\u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e\u201d\u914d\u7f6e\u3002", (String)"MessageHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        String smsProvider = msgChannelInfo.getSmsProvider();
        if (SMSProvider.isWeiGouTong((String)smsProvider)) {
            return MessageHandler.sendWeiGouTongShortMessage(msgChannelInfo, shortMessageInfo, param);
        }
        if (!SMSProvider.isCloudPlat((String)smsProvider)) {
            return MessageUtils.wrapResult((String)"It doesn't support analyzing the current service provider, and only supports \"WeiGouTong SMS Platform\" SMS service provider, please reconfigure it.");
        }
        String smsapiurl = msgChannelInfo.getSmsapiurl();
        String serviceClass = msgChannelInfo.getServiceclass();
        if (StringUtils.isNotBlank((CharSequence)serviceClass) && SMSSTANDERSERVICE.equalsIgnoreCase(serviceClass.trim()) && StringUtils.isNotBlank((CharSequence)smsapiurl) && (smsapiurl.trim().equals(OLDVERSIONAPI1) || smsapiurl.trim().equals(OLDVERSIONAPI2))) {
            return MessageUtils.wrapResult((String)ResManager.loadKDString((String)"\u6807\u51c6\u77ed\u4fe1\u6e20\u9053\uff0c\u9700\u8981\u5347\u7ea7\u65b0\u7248\u77ed\u4fe1\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5\u77ed\u4fe1\u914d\u7f6e\u3002", (String)"MessageHandler_1", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put(ACCEPT, "application/json;charset=UTF-8");
            header.put(CONTENT_TYPE, "application/json;charset=UTF-8");
            String clientId = msgChannelInfo.getClientid();
            header.put(HEADER_CLIENT_ID, clientId);
            String clientSecret = msgChannelInfo.getClientsecret();
            header.put(HEADER_CLIENT_SECRET, clientSecret);
            String urlPart = MessageHandler.getPostUrlPart(shortMessageInfo, msgChannelInfo);
            JSONObject phones = MessageHandler.getPhones(shortMessageInfo.getCountryCode(), shortMessageInfo.getPhone());
            Iterator countryCodes = phones.keySet().iterator();
            JSONArray content = new JSONArray();
            content.add((Object)shortMessageInfo.getMessage());
            JSONObject messageBody = new JSONObject();
            SortedMap<String, Object> bodyData = MessageHandler.getPostBody();
            Set<Map.Entry<String, Object>> entries = bodyData.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                messageBody.put(entry.getKey(), entry.getValue());
            }
            messageBody.put(PARAM_CONTENT, (Object)content);
            while (countryCodes.hasNext()) {
                String countryCode = (String)countryCodes.next();
                if (StringUtils.isBlank((CharSequence)phones.getString(countryCode))) continue;
                String allPhone = URLEncoder.encode(phones.getString(countryCode), StandardCharsets.UTF_8.name());
                StringBuilder fullUrl = new StringBuilder(urlPart);
                fullUrl.append("&").append(COUNTRY_CODE).append("=").append(countryCode);
                fullUrl.append("&").append(PHONE).append("=").append(allPhone);
                Long currentTime = System.currentTimeMillis() / 1000L;
                bodyData.put(TIMESTAMP, currentTime);
                messageBody.put(TIMESTAMP, (Object)currentTime);
                messageBody.put("nonce", (Object)MessageHandler.getNonce(bodyData));
                logger.debug("sms everything is ready, go !!!");
                String result = HttpClientUtils.postjson((String)fullUrl.toString(), header, (String)messageBody.toJSONString(), (int)5000, (int)10000);
                logger.info("sms result : " + result);
                try {
                    if (param != null && !param.isEmpty() && (!((Boolean)param.get("isSmsVerificationCode")).booleanValue() || !StringUtils.isNotBlank((CharSequence)result))) continue;
                    MessageHandler.saveSmsIdRecord(shortMessageInfo, JSON.parseObject((String)result));
                }
                catch (Exception e) {
                    logger.warn("sms response saveSmsIdRecord is error: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.warn(String.format("push sms iserror [%s]", kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e)));
            return MessageUtils.wrapResult((String)e.getMessage());
        }
        return MessageUtils.wrapResult((String)"success");
    }

    private static Map<String, Object> sendWeiGouTongShortMessage(MsgChannelInfo msgChannelInfo, ShortMessageInfo shortMessageInfo, Map<String, Object> param) {
        logger.debug("sendWeiGouTongShortMessage--into messageHandler begine start");
        ImmutableMap header = ImmutableMap.of((Object)ACCEPT, (Object)"application/json;charset=UTF-8", (Object)CONTENT_TYPE, (Object)"application/json;charset=UTF-8");
        try {
            List phoneList = shortMessageInfo.getPhone();
            String phones = String.join((CharSequence)",", MessageHandler.wrapPhones(phoneList));
            Map<String, Object> body = MessageHandler.getWeiGouTongPostBody(msgChannelInfo, phones, shortMessageInfo.getMessage());
            logger.debug("weiGouTong sms everything is ready, go !!!");
            String urlPart = msgChannelInfo.getWeiGouTongSmsApiUrl();
            String result = HttpClientUtils.post((String)urlPart, (Map)header, body, (int)5000, (int)10000);
            logger.info("weiGouTong sms result : " + result);
            if (StringUtils.isBlank((CharSequence)result)) {
                return MessageUtils.wrapResult((String)"Http response empty");
            }
            JSONObject resJson = JSON.parseObject((String)result);
            Integer errCode = resJson.getInteger(STATUS);
            if (!Objects.equals(NumberUtils.INTEGER_ZERO, errCode)) {
                return MessageUtils.wrapResult((String)result);
            }
        }
        catch (Exception e) {
            logger.warn(MessageFormat.format("push weiGouTong sms is error [{0}]", kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e)));
            return MessageUtils.wrapResult((String)e.getMessage());
        }
        return MessageUtils.wrapResult((String)"success");
    }

    private static JSONObject getPhones(String countryCode, List<String> phoneList) {
        JSONObject phones = new JSONObject();
        if (StringUtils.isBlank((CharSequence)countryCode)) {
            for (String phoneNumber : phoneList) {
                if (phoneNumber.contains("-")) {
                    String[] p = phoneNumber.split("-");
                    MessageHandler.wrapPhones(phones, p[0], p[1]);
                    continue;
                }
                MessageHandler.wrapPhones(phones, "86", phoneNumber);
            }
        } else {
            for (String phoneNumber : phoneList) {
                MessageHandler.wrapPhones(phones, countryCode, phoneNumber);
            }
        }
        return phones;
    }

    private static void wrapPhones(JSONObject phones, String countryCode, String phoneNumber) {
        if (phones.containsKey((Object)countryCode)) {
            String pn = phones.getString(countryCode) + ";" + phoneNumber;
            phones.put(countryCode, (Object)pn);
        } else {
            phones.put(countryCode, (Object)phoneNumber);
        }
    }

    private static List<String> wrapPhones(List<String> phoneList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String phone : phoneList) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            if (phone.contains("-")) {
                String[] p = phone.split("-");
                list.add(p[1]);
                continue;
            }
            if (phone.length() < 11) continue;
            list.add(phone.substring(phone.length() - 11));
        }
        return list;
    }

    private static void saveSmsIdRecord(ShortMessageInfo shortMessageInfo, JSONObject pushSmsResult) {
        if (0 != pushSmsResult.getInteger(ERRORCODE)) {
            return;
        }
        ArrayList<DynamicObject> objList = null;
        if (pushSmsResult.get((Object)"detail") != null) {
            logger.debug("sms pushSmsResult detail is not empty");
            JSONArray details = pushSmsResult.getJSONArray("detail");
            objList = new ArrayList<DynamicObject>(details.size());
            for (int i = 0; i < details.size(); ++i) {
                JSONObject detailData = details.getJSONObject(i);
                if (0 != detailData.getInteger(ERRORCODE)) continue;
                logger.debug("sms pushSmsResult detail packageAndSaveSmsInfo");
                Long smsId = detailData.getLong(SMSID);
                String phone = detailData.getString(PHONE);
                DynamicObject object = MessageHandler.packageAndSaveSmsInfo(shortMessageInfo, smsId, phone);
                objList.add(object);
            }
        } else {
            logger.debug("sms pushSmsResult detail is empty");
            Long smsId = pushSmsResult.getLong(SMSID);
            String phone = pushSmsResult.getString(PHONE);
            if (StringUtils.isNotBlank((Object)smsId)) {
                logger.debug("sms pushSmsResult one packageAndSaveSmsInfo");
                objList = new ArrayList(1);
                DynamicObject object = MessageHandler.packageAndSaveSmsInfo(shortMessageInfo, smsId, phone);
                objList.add(object);
            }
        }
        logger.debug("sms pushSmsResult save objList");
        if (objList != null && !objList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject packageAndSaveSmsInfo(ShortMessageInfo shortMessageInfo, Long smsid, String phone) {
        String content;
        DynamicObject smsInfoObj = BusinessDataServiceHelper.newDynamicObject((String)"wf_smsinfo");
        Date currentDate = TimeServiceHelper.now();
        smsInfoObj.set(SMSID, (Object)smsid);
        smsInfoObj.set("retryNumber", (Object)0);
        smsInfoObj.set("createdate", (Object)currentDate);
        smsInfoObj.set("modifydate", (Object)currentDate);
        smsInfoObj.set("entitynumber", (Object)shortMessageInfo.getEntityNumber());
        smsInfoObj.set("bizdataid", (Object)shortMessageInfo.getBizDataId());
        smsInfoObj.set("tag", (Object)shortMessageInfo.getTag());
        Map useridAndPhone = shortMessageInfo.getUseridAndPhone();
        if (!useridAndPhone.isEmpty() && StringUtils.isNotBlank((CharSequence)phone)) {
            smsInfoObj.set("userId", useridAndPhone.get(phone));
        }
        if (StringUtils.isNotBlank((CharSequence)(content = shortMessageInfo.getMessage())) && content.length() > 1900) {
            content = content.substring(0, 1899);
        }
        smsInfoObj.set(PARAM_CONTENT, (Object)content);
        smsInfoObj.set("messageid", (Object)shortMessageInfo.getMessageId());
        smsInfoObj.set("type", (Object)shortMessageInfo.getType());
        smsInfoObj.set("state", (Object)0);
        return smsInfoObj;
    }

    private static SortedMap<String, Object> getPostBody() {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String prodInstCode = (String)productInfo.get("prodInstCode");
        String productVersion = MessageHandler.getProductVersion();
        TenantInfo tenantInfo = RequestContext.get().getTenantInfo();
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        TreeMap<String, Object> bodyData = new TreeMap<String, Object>();
        bodyData.put(TIMESTAMP, System.currentTimeMillis() / 1000L);
        bodyData.put("req_id", tenantInfo.getName() + "&" + account.getAccountNumber());
        bodyData.put("prod_inst_code", prodInstCode);
        bodyData.put("prod_line_code", "C26");
        bodyData.put("prod_version", productVersion);
        return bodyData;
    }

    private static String getProductVersion() {
        String[] split;
        String version = "";
        IndustryVersionInfo csVersion = IndustryVersionServiceHelper.getVersion((String)"cosmic_bos", (String)"kingdee");
        if (csVersion != null) {
            version = csVersion.getVersion();
        }
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }

    private static String getNonce(SortedMap<String, Object> params) {
        StringBuilder values = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = params.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            values.append(entry.getValue());
        }
        String salt = MessageServiceProperties.smsSalt;
        values.append(salt);
        String str = values.toString();
        String encodeNonce = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            String temp = null;
            for (int i = 0; i < bytes.length; ++i) {
                temp = Integer.toHexString(bytes[i] & 0xFF);
                if (temp.length() == 1) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(temp);
            }
            encodeNonce = stringBuilder.toString();
        }
        catch (Exception e) {
            logger.error(String.format("sendSms getNonce error [%s]", kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e)));
        }
        return encodeNonce;
    }

    private static String getPostUrlPart(ShortMessageInfo shortMessageInfo, MsgChannelInfo msgChannelInfo) {
        String signature = MessageHandler.getSmsSignature(shortMessageInfo, msgChannelInfo);
        String smsCode = msgChannelInfo.getSmscode();
        StringBuilder url = new StringBuilder(msgChannelInfo.getSmsapiurl());
        url.append("?").append(SMSCODE).append("=").append(smsCode);
        if (StringUtils.isNotBlank((CharSequence)signature)) {
            url.append("&").append(SIGNATURE).append("=").append(signature);
        }
        return url.toString();
    }

    private static Map<String, Object> getWeiGouTongPostBody(MsgChannelInfo msgChannelInfo, String allPhone, String encodeContent) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)PARAM_ACTION, (Object)SEND);
        builder.put((Object)PARAM_ACCOUNT, (Object)msgChannelInfo.getWeiGouTongClientId());
        builder.put((Object)"password", (Object)msgChannelInfo.getWeiGouTongClientSecret());
        builder.put((Object)PARAM_EXTNO, (Object)msgChannelInfo.getWeiGouTongExtNo());
        builder.put((Object)PARAM_RT, (Object)JSON_STR);
        builder.put((Object)PARAM_MOBILE, (Object)allPhone);
        builder.put((Object)PARAM_CONTENT, (Object)encodeContent);
        return builder.build();
    }

    private static String getSmsSignature(ShortMessageInfo shortMessageInfo, MsgChannelInfo msgChannelInfo) {
        String signature = shortMessageInfo.getSignature();
        if (StringUtils.isBlank((CharSequence)signature) && StringUtils.isNotBlank((CharSequence)msgChannelInfo.getMobileappconfig())) {
            JSONObject mobilAppConfig = JSON.parseObject((String)msgChannelInfo.getMobileappconfig());
            Map signatureMap = (Map)SerializationUtils.fromJsonString((String)mobilAppConfig.getString(SIGNATURE), Map.class);
            Object st = signatureMap.get(RequestContext.get().getLang().toString());
            signature = StringUtils.isNotBlank(st) ? st.toString() : "";
        }
        return signature;
    }
}

