/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.job;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.task.entity.TaskJobEntity;
import kd.bos.workflow.task.entity.TaskJobEntityManager;
import kd.bos.workflow.task.utils.TaskJobUtils;

public class CreateOrUpdateTaskJobFromEntityCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = -8205191735752830826L;
    protected static Log log = LogFactory.getLog(CreateOrUpdateTaskJobFromEntityCmd.class);
    public static final String SUCCESS = "success";
    public static final String NOCODE = "nocode";
    private Entity entity;
    private String eventType;

    public CreateOrUpdateTaskJobFromEntityCmd(Entity entity) {
        this.entity = entity;
    }

    public CreateOrUpdateTaskJobFromEntityCmd(Entity entity, String eventType) {
        this.entity = entity;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void execute(CommandContext commandContext) {
        JobEntity jobEntity = (JobEntity)this.entity;
        if (!"async-todo".equalsIgnoreCase(jobEntity.getJobHandlerType())) {
            return null;
        }
        String configuration = jobEntity.getJobHandlerConfiguration();
        Map<String, Object> payload = this.restoreContext(configuration);
        if (WfUtils.isEmptyForMap(payload)) {
            return null;
        }
        String jsonModel = (String)payload.get("model");
        ToDoInfo model = (ToDoInfo)SerializationUtils.fromJsonString((String)jsonModel, ToDoInfo.class);
        if (!(ToDoInfo.State.NEW.equals((Object)model.getState()) || ToDoInfo.State.DEAL.equals((Object)model.getState()) || ToDoInfo.State.DELETE.equals((Object)model.getState()) || ToDoInfo.State.DELETEANDCREATE.equals((Object)model.getState()))) {
            return null;
        }
        String service = (String)payload.get("service");
        String jsonContext = (String)payload.get("context");
        MessageContext ctx = (MessageContext)SerializationUtils.fromJsonString((String)jsonContext, MessageContext.class);
        String separateStorageKey = (String)payload.get("separateStorageKey");
        log.debug("CreateOrUpdateTaskJobFromEntityCmd separateStorageKey: " + separateStorageKey);
        try {
            TaskJobEntityManager taskJobEntityManager;
            if (NOCODE.equalsIgnoreCase(separateStorageKey)) {
                ThreadTruck.put((Object)"separateStorageKey", (Object)NOCODE);
            }
            if ((taskJobEntityManager = (TaskJobEntityManager)commandContext.getEntityManagerByEntityNumber(EntityNumberConstant.getTaskJobEntityNumber())) == null) {
                taskJobEntityManager = (TaskJobEntityManager)commandContext.getEntityManager(TaskJobEntityManager.class);
            }
            Long rootJobId = WfUtils.isEmpty((Long)jobEntity.getRootJobId()) ? jobEntity.getId() : jobEntity.getRootJobId();
            log.info("CreateOrUpdateTaskJobFromEntityCmd rootJobId: " + rootJobId);
            TaskJobEntity taskJobEntity = taskJobEntityManager.getTaskJobByRootJobId(rootJobId);
            if (taskJobEntity == null) {
                if (ActivitiEventType.ENTITY_CREATED.getCode().equals(this.eventType)) {
                    this.insertTaskJob(commandContext, taskJobEntityManager, jobEntity, ctx, model, service, rootJobId, null);
                } else if (ActivitiEventType.ENTITY_UPDATED.getCode().equals(this.eventType)) {
                    TaskJobEntity.TodoState todoState = jobEntity.isSuccess() ? TaskJobEntity.TodoState.DEALSUCCESS : TaskJobEntity.TodoState.DEALFAIL;
                    this.insertTaskJob(commandContext, taskJobEntityManager, jobEntity, ctx, model, service, rootJobId, todoState);
                    log.info("CreateOrUpdateTaskJobFromEntityCmd not find taskJobEntity and insert log when updateListener: rootJobId " + rootJobId);
                }
                log.debug("CreateOrUpdateTaskJobFromEntityCmd insert success, rootJobId : " + rootJobId);
            } else {
                if (ActivitiEventType.ENTITY_CREATED.getCode().equals(this.eventType)) {
                    taskJobEntity.setTodoState(TaskJobEntity.TodoState.UNTREATED.name());
                    taskJobEntityManager.update((Entity)taskJobEntity);
                } else if (ActivitiEventType.ENTITY_UPDATED.getCode().equals(this.eventType)) {
                    this.updateTaskJob(commandContext, taskJobEntityManager, taskJobEntity, jobEntity);
                } else {
                    this.updateTaskJob(commandContext, taskJobEntityManager, taskJobEntity, jobEntity);
                    log.info("CreateOrUpdateTaskJobFromEntityCmd find taskJobEntity and update log when deleteListener: taskJobId " + taskJobEntity.getId());
                }
                log.info("CreateOrUpdateTaskJobFromEntityCmd update success, taskJobId : " + taskJobEntity.getId());
            }
        }
        catch (Exception e) {
            log.error("CreateOrUpdateTaskJobFromEntityCmd is error,errorInfo is " + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        finally {
            if (NOCODE.equalsIgnoreCase(separateStorageKey)) {
                ThreadTruck.remove((Object)"separateStorageKey");
            }
        }
        return null;
    }

    private void updateTaskJob(CommandContext commandContext, TaskJobEntityManager taskJobEntityManager, TaskJobEntity taskJobEntity, JobEntity jobEntity) {
        String jobState = jobEntity.getState();
        if (!JobStateEnum.COMPLETED.getNumber().equalsIgnoreCase(jobState) && !JobStateEnum.ERRORED.getNumber().equalsIgnoreCase(jobState)) {
            return;
        }
        TaskJobUtils.updateTaskJob(commandContext, taskJobEntityManager, taskJobEntity, jobEntity);
    }

    private void insertTaskJob(CommandContext commandContext, TaskJobEntityManager taskJobEntityManager, JobEntity jobEntity, MessageContext ctx, ToDoInfo model, String service, Long rootJobId, TaskJobEntity.TodoState todoState) {
        TaskJobEntity taskJobEntity = taskJobEntityManager.copyFromJobEntity(jobEntity);
        taskJobEntity.setTraceId(RequestContext.get().getTraceId());
        taskJobEntity.setRootJobId(rootJobId);
        if (todoState == null) {
            todoState = TaskJobEntity.TodoState.UNTREATED;
        }
        taskJobEntityManager.packageTaskJobEntity(taskJobEntity, commandContext, ctx, model, service, todoState.name());
        taskJobEntityManager.insert((Entity)taskJobEntity);
    }

    private Map<String, Object> restoreContext(String configuration) {
        Map<String, Object> payload = new HashMap<String, Object>();
        if (WfUtils.isEmpty((String)configuration)) {
            return payload;
        }
        payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        if (WfUtils.isNotEmptyForMap(payload) && payload.get("_requestContext_") != null) {
            payload.remove("_requestContext_");
        }
        return payload;
    }
}

