/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.service.impl;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.task.cmd.job.CreateOrUpdateTaskJobFromEntityCmd;
import kd.bos.workflow.task.cmd.job.InsertTaskJobCmd;
import kd.bos.workflow.task.cmd.job.RetryTaskJobByIdsCmd;
import kd.bos.workflow.task.cmd.job.TaskJobsByIdsCmd;
import kd.bos.workflow.task.cmd.job.UpdateTaskJobByRootJobIdCmd;
import kd.bos.workflow.task.service.MessageLogService;

public class MessageLogServiceImpl
extends ServiceImpl
implements MessageLogService {
    private static Log logger = LogFactory.getLog(MessageLogServiceImpl.class);

    public MessageLogServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public void createOrUpdateTaskJobFromEntity(Entity entity) {
        this.commandExecutor.execute((Command)new CreateOrUpdateTaskJobFromEntityCmd(entity));
    }

    public void createOrUpdateTaskJobFromEntity(Entity entity, String eventType) {
        this.commandExecutor.execute((Command)new CreateOrUpdateTaskJobFromEntityCmd(entity, eventType));
    }

    public <T extends Entity> List<T> retryTaskJobByIds(List<Long> taskJobIds) {
        return (List)this.commandExecutor.execute((Command)new RetryTaskJobByIdsCmd(taskJobIds));
    }

    public <T extends Entity> List<T> getTaskJobsByIds(List<Long> ids, String fields) {
        return (List)this.commandExecutor.execute((Command)new TaskJobsByIdsCmd(ids, fields));
    }

    public void insertTaskJob(MessageContext ctx, ToDoInfo model, String channelNumber, String todoState) {
        this.commandExecutor.execute((Command)new InsertTaskJobCmd(ctx, model, channelNumber, todoState));
    }

    public void updateTaskJobByRootJobId(Long rootJobId, Entity jobEntity) {
        this.commandExecutor.execute((Command)new UpdateTaskJobByRootJobIdCmd(rootJobId, jobEntity));
    }
}

