/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.cmd.job;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.BecSystemParamterUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class DeleteFinishedEvtJobCmd
implements Command<Void> {
    private static Log log = LogFactory.getLog(DeleteFinishedEvtJobCmd.class);
    private static final String KEY_DELETEEVENTCLOSEDJOB = "bec.schedule.deleteEventClosedJob";
    private static final String VALUE_RETENTIONTIME = "retentionTime";
    private static final String VALUE_STARTINGTIME = "startingTime";
    private static final String VALUE_SCOPE = "scope";
    private static final String CREATEDATE = "createdate";
    private static final String VALUE = "value";
    private static final String KEYWORD = "key";
    private static final String VALUE_MAXDELETECOUNT = "maxDeleteCount";
    private static final String VALUE_EVERYTIMEDELETECOUNT = "everytimeDeleteCount";
    private static final String VALUE_MAXDELETECOUNTLOG = "maxDeleteCountLog";
    private static final String VALUE_EVERYTIMEDELETECOUNTLOG = "everytimeDeleteCountLog";
    private static final String VALUE_BECDELETELOGCURSOR = "becDeleteLogCursor";
    Integer sysParam = BecSystemParamterUtils.getRetentionTime();

    public Void execute(CommandContext commandContext) {
        log.debug("\u83b7\u53d6\u4e8b\u4ef6\u5220\u9664\u96c6\u5408\u53c2\u6570\u3002");
        String timeSql = "SELECT TOP 1 FCREATEDATE FROM T_EVT_JOBRECORD WHERE FSTATE in ('completed','errored') ORDER BY FID ;";
        Map<String, Object> value = this.getValue(KEY_DELETEEVENTCLOSEDJOB, 3, timeSql, "FCREATEDATE");
        if (value == null || value.isEmpty()) {
            log.debug("\u83b7\u53d6\u4e8b\u4ef6\u5220\u9664\u96c6\u5408\u53c2\u6570\u5931\u8d25\u3002");
            return null;
        }
        try {
            Integer maxDeleteCount = this.convertInt(5000000, value.get(VALUE_MAXDELETECOUNT));
            Integer everytimeDeleteCount = this.convertInt(50000, value.get(VALUE_EVERYTIMEDELETECOUNT));
            this.deleteEventClosedJobLoop(maxDeleteCount, everytimeDeleteCount, value, "evt_job");
            Integer maxDeleteCountLog = this.convertInt(2000000, value.get(VALUE_MAXDELETECOUNTLOG));
            Integer everytimeDeleteCountLog = this.convertInt(50000, value.get(VALUE_EVERYTIMEDELETECOUNTLOG));
            this.deleteEventClosedJobLoop(maxDeleteCountLog, everytimeDeleteCountLog, value, "evt_log");
        }
        catch (Exception e) {
            log.error(String.format("\u4e8b\u4ef6\u4e2d\u5fc3\u5b9a\u65f6\u5220\u9664\u5931\u8d25\u3002 %s", WfUtils.getExceptionStacktrace(e)));
        }
        return null;
    }

    private Integer convertInt(Integer defaultVal, Object obj) {
        if (obj != null) {
            return (Integer)obj;
        }
        return defaultVal;
    }

    private Long convertLong(Long defaultVal, Object obj) {
        if (obj != null) {
            return Long.valueOf(obj.toString());
        }
        return defaultVal;
    }

    private void deleteEventClosedJobLoop(Integer maxCount, Integer everytimeCount, Map<String, Object> value, String type) {
        int i;
        int times = maxCount / everytimeCount + (maxCount % everytimeCount != 0 ? 1 : 0);
        for (i = 0; i < times; ++i) {
            Map<String, Object> valueMap = this.deleteEventClosedJob(value, everytimeCount, type);
            if (valueMap == null) {
                log.debug(String.format("\u7b2c%1$s\u6279%2$s\u5220\u9664\u7ed3\u675f\u3002", i + 1, type));
                break;
            }
            value = valueMap;
        }
        if (i > 0) {
            log.debug(String.format("\u7b2c%1$s\u5168\u90e8%2$s\u5220\u9664\u7ed3\u675f\u3002", i, type));
            if ("evt_job".equals(type)) {
                value.put(VALUE_MAXDELETECOUNT, maxCount);
                value.put(VALUE_EVERYTIMEDELETECOUNT, everytimeCount);
            }
            if ("evt_log".equals(type)) {
                value.put(VALUE_MAXDELETECOUNTLOG, maxCount);
                value.put(VALUE_EVERYTIMEDELETECOUNTLOG, everytimeCount);
            }
            this.updateValue(KEY_DELETEEVENTCLOSEDJOB, value);
        }
    }

    private Map<String, Object> deleteEventClosedJob(Map<String, Object> value, Integer maxcount, String type) {
        Long startingTime = (Long)value.get(VALUE_STARTINGTIME);
        Date startingDate = new Date(startingTime);
        QFilter[] filters = null;
        String algoKey = null;
        String orderBy = null;
        Date endTime = null;
        if ("evt_job".equals(type)) {
            Integer scope = (Integer)value.get(VALUE_SCOPE);
            Integer retentionTime = (Integer)value.get(VALUE_RETENTIONTIME);
            endTime = this.getTargetTime(startingTime, scope);
            Long timeStamp = System.currentTimeMillis();
            Date maxDeleteTime = this.getTargetTime(timeStamp, -retentionTime.intValue());
            if (endTime == null || maxDeleteTime.compareTo(endTime) <= 0) {
                log.debug("\u6700\u5927\u53ef\u5220\u9664\u65f6\u95f4>\u6b64\u6b21\u8981\u5220\u9664\u7684\u6700\u540e\u65f6\u95f4");
                return null;
            }
            QFilter filter0 = new QFilter(CREATEDATE, "is not null", null);
            QFilter filter1 = new QFilter(CREATEDATE, ">=", (Object)startingDate);
            QFilter filter2 = new QFilter(CREATEDATE, "<", (Object)endTime);
            QFilter filter3 = new QFilter("state", "in", (Object)new String[]{"completed", "errored"});
            filters = new QFilter[]{filter0, filter1, filter2, filter3};
            algoKey = "DeleteFinishedEvtJobRecordCmd";
            orderBy = "createdate asc";
        }
        if ("evt_log".equals(type)) {
            Long becDeleteLogCursor = this.convertLong(-1L, value.get(VALUE_BECDELETELOGCURSOR));
            QFilter filter = new QFilter(CREATEDATE, "<", (Object)startingDate);
            QFilter filter1 = new QFilter("id", ">", (Object)becDeleteLogCursor);
            filters = new QFilter[]{filter, filter1};
            algoKey = "DeleteFinishedEvtLogCmd";
            orderBy = "id asc";
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet(algoKey, (String)type, (String)"id", filters, orderBy, (int)maxcount);){
            Map<String, Object> map;
            int i = 0;
            ArrayList<Object> idList = new ArrayList<Object>(16);
            Long id = null;
            while (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                id = Long.valueOf(row.getString("id"));
                idList.add(id);
                if (++i % 2000 != 0) continue;
                this.deleteEventClosedExecute(idList, type);
                idList.clear();
            }
            if (i % 2000 > 0) {
                this.deleteEventClosedExecute(idList, type);
            }
            if ("evt_job".equals(type)) {
                log.debug(String.format("the jobreocrd size is %s", i));
                if (i < maxcount && endTime != null) {
                    value.put(VALUE_STARTINGTIME, endTime.getTime());
                }
                map = value;
                return map;
            }
            if ("evt_log".equals(type)) {
                log.debug(String.format("the log size is %s", i));
                if (id == null) {
                    map = null;
                    return map;
                }
                value.put(VALUE_BECDELETELOGCURSOR, id);
                map = value;
                return map;
            }
            map = null;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEventClosedExecute(List<Object> idList, String type) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        Integer batchCount = 500;
        int totalCount = idList.size();
        int j = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
        for (int x = 0; x < j; ++x) {
            int end = (x + 1) * batchCount > totalCount ? totalCount : (x + 1) * batchCount;
            List<Object> subList = idList.subList(x * batchCount, end);
            if (null == subList || subList.size() <= 0) continue;
            try (TXHandle handle = TX.requiresNew();){
                String sql;
                if ("evt_job".equals(type)) {
                    sql = "DELETE FROM T_EVT_LOG WHERE FJOBID in ( ? );";
                    WfDBUtils.executeBatchDeleteByIn(sql, subList, true);
                    sql = "DELETE FROM T_EVT_JOBRECORD WHERE FID in ( ? ) ;";
                    WfDBUtils.executeBatchDeleteByIn(sql, subList, true);
                }
                if (!"evt_log".equals(type)) continue;
                sql = "DELETE FROM T_EVT_LOG WHERE FID in ( ? ) ;";
                WfDBUtils.executeBatchDeleteByIn(sql, subList, true);
                continue;
            }
        }
    }

    private Map<String, Object> getValue(String key, int scope, String timeSql, String findValue) {
        QFilter selectValueFilter = new QFilter(KEYWORD, "=", (Object)key);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"key,value", (QFilter[])selectValueFilters);
        if (dynamicObject == null) {
            Date startingTime = null;
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.selectHiprocinstTime", (DBRoute)DBRoute.workflow, (String)timeSql, null);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    startingTime = row.getDate(findValue);
                }
            }
            if (null == startingTime) {
                return null;
            }
            HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
            valueMap.put(VALUE_STARTINGTIME, startingTime.getTime());
            valueMap.put(VALUE_SCOPE, scope);
            valueMap.put(VALUE_RETENTIONTIME, this.sysParam);
            valueMap.put(VALUE_MAXDELETECOUNT, 5000000);
            valueMap.put(VALUE_EVERYTIMEDELETECOUNT, 50000);
            valueMap.put(VALUE_MAXDELETECOUNTLOG, 2000000);
            valueMap.put(VALUE_EVERYTIMEDELETECOUNTLOG, 50000);
            valueMap.put(VALUE_BECDELETELOGCURSOR, -1);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"wf_confcenter");
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)mainEntityType);
            dynObj.set(KEYWORD, (Object)key);
            dynObj.set(VALUE, (Object)JSONObject.toJSONString(valueMap));
            DynamicObject[] dynObjs = new DynamicObject[]{dynObj};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
            return valueMap;
        }
        Object dynamicObjectValue = dynamicObject.get(VALUE);
        log.debug("\u8868\u4e2d\u5df2\u7ecf\u5b58\u5728\u4e8b\u4ef6\u4e2d\u5fc3\u5b9a\u65f6\u6e05\u7406\u7684\u53c2\u6570\u6570\u636e\u3002\u53c2\u6570\u4e3a" + dynamicObjectValue.toString());
        Map timeMap = (Map)SerializationUtils.fromJsonString((String)dynamicObjectValue.toString(), Map.class);
        Integer day = Integer.valueOf(String.valueOf(timeMap.get(VALUE_RETENTIONTIME)));
        log.debug(String.format("\u8868\u4e2d\u9ed8\u8ba4\u4fdd\u7559  %s \u5929\u3002", day));
        log.debug(String.format("\u7cfb\u7edf\u53c2\u6570\u9ed8\u8ba4\u4fdd\u7559  %s \u5929\u3002", this.sysParam));
        if (day.equals(this.sysParam)) {
            return (Map)SerializationUtils.fromJsonString((String)dynamicObject.get(VALUE).toString(), Map.class);
        }
        timeMap.put(VALUE_RETENTIONTIME, this.sysParam);
        dynamicObject.set(VALUE, (Object)JSONObject.toJSONString((Object)timeMap));
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        return timeMap;
    }

    private Date getTargetTime(Long time, int scope) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.add(6, scope);
        return c.getTime();
    }

    private void updateValue(String key, Map<String, Object> valueMap) {
        QFilter selectValueFilter = new QFilter(KEYWORD, "=", (Object)key);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject value = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"id,value", (QFilter[])selectValueFilters);
        if (value == null) {
            value = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_confcenter"));
            value.set(KEYWORD, (Object)key);
        }
        value.set(VALUE, (Object)JSONObject.toJSONString(valueMap));
        DynamicObject[] dynObjs = new DynamicObject[]{value};
        SaveServiceHelper.save((DynamicObject[])dynObjs);
    }
}

