/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.cmd.job;

import java.io.Serializable;
import java.util.Date;
import kd.bos.bec.engine.EvtEngineUtils;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobFinishNotification;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WfJobException;
import kd.bos.workflow.service.EvtTraceType;
import org.apache.commons.lang.time.DateFormatUtils;

public class ExecuteAsyncEvtJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ExecuteAsyncEvtJobCmd.class);
    protected ExecuteJob job;
    protected boolean saveByVerifySql;

    public ExecuteAsyncEvtJobCmd(ExecuteJob job) {
        this.job = job;
        this.saveByVerifySql = !WfConfigurationUtil.notSaveByVerifySql();
    }

    public Object execute(CommandContext commandContext) {
        if (this.job == null) {
            log.error("ExecuteAsyncJobCmd Job is null!");
            return null;
        }
        MsgStatus info = this.canExecute(this.job, commandContext);
        if (info.canExecute()) {
            log.info(String.format("job[%s] is sutiable for executing because of [%s]", this.job.getId(), info.getMsg()));
            if (this.saveByVerifySql) {
                EvtTraceType.getOrCreate().getEvtTraceJobInfo().setIsUpdate(!info.isWillInsert());
            }
            this.executeJob(commandContext, info.isWillInsert());
            return null;
        }
        log.info(String.format("job[%s] is not sutiable for executing because of [%s]", this.job.getId(), info.getMsg()));
        if (info.isFinished()) {
            String state;
            commandContext.addCloseListener((CommandContextCloseListener)new JobFinishNotification(this.job));
            ILocalJobHandleStrategy localJobHandleStrategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(this.job.getJobType());
            ExecuteJob localJob = localJobHandleStrategy.findJob(this.job.getId(), false);
            String string = state = localJob == null ? "" : localJob.getState();
            if (localJob != null && (JobStateEnum.CREATED.getNumber().equals(state) || JobStateEnum.PREEXECUTING.getNumber().equals(state))) {
                localJob.setState(info.getResult());
                commandContext.getExecuteJobManager().saveOrUpdate(localJob);
            }
            log.error(String.format("\u6d88\u606f[%s]\u5df2\u7ecf\u88ab\u5904\u7406,\u539f\u56e0[%s]\uff01", this.job.getId(), info.getMsg()));
        } else if (info.isExecuting()) {
            log.error(String.format("\u6d88\u606f[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u6b63\u5e38\u60c5\u51b5\u4e0b\u4e0d\u4f1a\u8d70\u5230\u8fd9\u91cc.", this.job.getId()));
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createAsyncMessageEvent((ActivitiEventType)ActivitiEventType.JOB_EXECUTION_SUCCESS, (String)this.job.getJobHandlerType(), (Object)String.format(ResManager.loadKDString((String)"job[%1$s]\u76ee\u524d\u65e0\u6cd5\u5904\u7406\uff0c\u539f\u56e0[%2$s]", (String)"ExecuteAsyncJobCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.job.getId(), info.getMsg()), (AbstractJobEntity)this.job));
        }
        return null;
    }

    private void executeJob(CommandContext commandContext, boolean ifWillInsert) {
        JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy(this.job.getSource(), this.job.getJobType());
        if (strategy != null) {
            this.job.setState(JobStateEnum.EXECUTING.getNumber());
            this.job.setRootTraceNo(RequestContext.get().getTraceId());
            strategy.updateJobState(this.job, false);
        }
        log.debug("start Executing async job [" + this.job.getId() + "] really!");
        long start = Context.getProcessEngineConfiguration().getClock().getCurrentTime().getTime();
        this.job.setExceptionMessage(" ");
        try {
            commandContext.getJobManager().execute((Job)this.job);
        }
        catch (Throwable exception) {
            if (!EvtEngineUtils.ifMatchWhiteList((ExecuteJob)this.job, (Throwable)exception)) {
                throw exception;
            }
            log.warn(String.format("[%s]\u5f02\u5e38\u767d\u540d\u5355\u5339\u914d\u6210\u529f\u3002", this.job.getId()));
        }
        if (ifWillInsert) {
            JobFinishNotification deleteOtherDBJob = new JobFinishNotification(this.job);
            commandContext.addCloseListener((CommandContextCloseListener)deleteOtherDBJob);
        }
        this.job.setState(JobStateEnum.COMPLETED.getNumber());
        this.job.setEndTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        this.job.setDuration(this.job.getEndTime().getTime() - start);
        this.job.setSuccess(true);
        if (this.saveByVerifySql) {
            commandContext.getExecuteJobManager().saveOrUpdateByVerifySql(ifWillInsert, this.job);
        } else {
            commandContext.getExecuteJobManager().saveOrUpdate(this.job);
        }
        this.collectMessageData(this.job);
        log.debug("Executing async job successful [" + this.job.getId() + "]");
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createAsyncMessageEvent((ActivitiEventType)ActivitiEventType.JOB_EXECUTION_SUCCESS, (String)this.job.getJobHandlerType(), (Object)this.job.getJobHandlerConfiguration(), (AbstractJobEntity)this.job));
        }
    }

    private void collectMessageData(ExecuteJob job) {
        try {
            IndicatorInfo info = new IndicatorInfo("becAsyncMessage", (Object)"success");
            info.addToSpecialProperty("procDefId", (Object)job.getProcessDefinitionId());
            info.addToSpecialProperty("createDate", (Object)job.getCreateDate());
            if (WfUtils.isNotEmpty(job.getExecutionId())) {
                info.addToSpecialProperty("endTime", (Object)DateFormatUtils.format((Date)job.getEndTime(), (String)"yyyyMMdd"));
                info.addToSpecialProperty("subscriptionId", (Object)job.getExecutionId());
                info.addToSpecialProperty("eventId", (Object)job.getProcessInstanceId());
                info.addToSpecialProperty("completedTotal", (Object)1);
                info.addToSpecialProperty("completedDuration", (Object)job.getDuration());
                info.addToSpecialProperty("subFullDuration", (Object)(job.getEndTime().getTime() - job.getCreateDate().getTime()));
            }
            WorkflowDevopsService.create().exceutionDataCollection(info);
        }
        catch (Exception e) {
            log.error(EvtUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private MsgStatus canExecute(ExecuteJob wfJob, CommandContext commandContext) {
        try {
            MsgStatus status = this.getRetState(wfJob);
            if (!status.canExecute()) {
                return status;
            }
            if (!"async-event-dispatch".equals(this.job.getJobHandlerType())) {
                return status;
            }
            ILocalJobHandleStrategy localJobHandleStrategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(wfJob.getJobType());
            localJobHandleStrategy.setProcessEngineConfiguration(commandContext.getProcessEngineConfiguration());
            ExecuteJob localJob = localJobHandleStrategy.findJob(wfJob.getId(), false);
            if (localJob != null) {
                localJob.setRootTraceNo(this.job.getRootTraceNo());
                localJob.setExecutor(this.job.getExecutor());
                ((EvtJobEntity)localJob).setQueueName(((EvtJobEntity)this.job).getQueueName());
                this.job = localJob;
                return this.getRetState(localJob);
            }
            if (localJobHandleStrategy.isLocalJob(JobHandleStrategyFactory.getDBRouteKey(wfJob.getSource()))) {
                return new MsgStatus(JobStateEnum.UNKNOWN.getNumber(), String.format(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\uff0c\u65e0\u6cd5\u4ecedbRouteKey[%1$s]\u4e2d\u67e5\u8be2\u5230Job[%2$s],\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"ExecuteAsyncJobCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), wfJob.getSource(), wfJob.getId()));
            }
            ExecuteJob localHiJob = (ExecuteJob)commandContext.getEvtHiJobEntityManager().findById(wfJob.getId());
            if (localHiJob != null) {
                return this.getRetState(localHiJob);
            }
            localJobHandleStrategy.insertJobToLocal(wfJob);
            return new MsgStatus(wfJob.getState(), ResManager.loadKDString((String)"\u7b2c\u4e00\u6b21\u6267\u884c", (String)"ExecuteAsyncJobCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), true);
        }
        catch (Exception e) {
            throw new WfJobException((Throwable)e, WFErrorCode.jobHandledError(), new Object[]{wfJob.getId(), e});
        }
    }

    private MsgStatus getRetState(ExecuteJob wfJob) {
        JobStateEnum state;
        JobStateEnum jobStateEnum = state = wfJob.getState() == null ? JobStateEnum.UNKNOWN : JobStateEnum.of((String)wfJob.getState());
        if (state != null) {
            if (JobStateEnum.CREATED == state || JobStateEnum.PREEXECUTING == state) {
                return new MsgStatus(state.getNumber(), ResManager.loadKDString((String)"\u72b6\u6001OK,\u53ef\u4ee5\u6267\u884c", (String)"ExecuteAsyncJobCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            if (JobStateEnum.EXECUTING == state) {
                return new MsgStatus(state.getNumber(), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u88ab\u6267\u884c,\u72b6\u6001\u662f[%s]", (String)"ExecuteAsyncJobCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), state.getName()));
            }
            return new MsgStatus(state.getNumber(), String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u6267\u884c,\u72b6\u6001\u662f[%s]", (String)"ExecuteAsyncJobCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), state.getName()));
        }
        return new MsgStatus(JobStateEnum.UNKNOWN.getNumber(), String.format(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\uff0c\u65e0\u6cd5\u4ecedbRouteKey[%1$s]\u4e2d\u67e5\u8be2\u5230Job[%2$s]\u6216\u8005state\u4e0d\u6b63\u786e", (String)"ExecuteAsyncJobCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), wfJob.getSource(), wfJob.getId()));
    }

    private static class MsgStatus {
        private String result;
        private String msg;
        private boolean willInsert;
        private ExecuteJob localJob;

        public boolean isWillInsert() {
            return this.willInsert;
        }

        public MsgStatus(String ret, String msg) {
            this.result = ret;
            this.msg = msg;
        }

        public MsgStatus(String ret, String msg, ExecuteJob localJob) {
            this.result = ret;
            this.msg = msg;
            this.localJob = localJob;
        }

        public MsgStatus(String ret, String msg, boolean willInsert) {
            this.result = ret;
            this.msg = msg;
            this.willInsert = willInsert;
        }

        public boolean isExecuting() {
            return JobStateEnum.EXECUTING.getNumber().equals(this.result);
        }

        public boolean isFinished() {
            return JobStateEnum.COMPLETED.getNumber().equals(this.result) || JobStateEnum.ERRORED.getNumber().equals(this.result);
        }

        public boolean canExecute() {
            return JobStateEnum.CREATED.getNumber().equals(this.result) || JobStateEnum.PREEXECUTING.getNumber().equals(this.result);
        }

        public String getResult() {
            return this.result;
        }

        public String getMsg() {
            return this.msg;
        }

        public ExecuteJob getLocalJob() {
            return this.localJob;
        }
    }
}

