/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.entity.DeleteEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;

public class LocalEvtJobHandleStrategy
implements ILocalJobHandleStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ProcessEngineConfigurationImpl pf;

    public EvtJobEntity extraMessageToJob(Map jsonObject) {
        if (jsonObject != null) {
            String configuration = (String)jsonObject.get("jobHandlerConfiguration");
            if (WfUtils.isNotEmpty(configuration)) {
                WfUtils.restoreRequestContext(configuration);
            }
            Long id = (Long)jsonObject.get("id");
            return this.findJob(id, true);
        }
        return null;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.pf = processEngineConfiguration;
    }

    public void setSource(String source) {
        this.logger.debug("enter setSource");
    }

    public void notifyJobFinished(ExecuteJob jobEntity) {
        this.logger.debug("enter notifyJobFinished");
    }

    public EvtJobEntity findJob(Long id, boolean cache) {
        if (cache) {
            CommandContext ctx = Context.getCommandContext();
            if (ctx == null) {
                return (EvtJobEntity)this.pf.getCommandExecutor().execute((Command)new GetSingleEntityCmd(id, "evt_job"));
            }
            return (EvtJobEntity)new GetSingleEntityCmd(id, "evt_job").execute(ctx);
        }
        try {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"evt_job");
            return (EvtJobEntity)this.pf.getEvtJobEntityManager().create(obj);
        }
        catch (Exception e) {
            this.logger.warn(String.format("find no job, %1$s--%2$s", id, WfUtils.getExceptionStacktrace(e)));
            return null;
        }
    }

    public List<EvtJobEntity> findExpiredJobs(String dbKey) {
        return (List)this.pf.getCommandExecutor().execute((Command)new Command<List<EvtJobEntity>>(){

            public List<EvtJobEntity> execute(CommandContext commandContext) {
                return LocalEvtJobHandleStrategy.this.pf.getEvtJobEntityManager().findEvtJobsToExecute(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobState(ExecuteJob wfJob, boolean cache) {
        if (cache) {
            this.pf.getCommandExecutor().execute((Command)new SaveEntityCmd((Entity)wfJob));
        } else {
            TXHandle h = TX.beginNew();
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{wfJob.getDynamicObject()});
            }
            catch (Exception e) {
                h.markRollback();
                this.logger.warn(WfUtils.getExceptionStacktrace(e));
            }
            finally {
                h.end();
            }
        }
    }

    public void updateJobErrorMsg(Long jobId, String error) {
        try {
            EvtJobEntity jobEntity = this.findJob(jobId, false);
            if (jobEntity != null) {
                jobEntity.setExceptionMessage(error);
                this.updateJobState((ExecuteJob)jobEntity, false);
            }
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    public void deleteJob(ExecuteJob wfJob) {
        this.pf.getCommandExecutor().execute((Command)new DeleteEntityCmd(wfJob.getId(), "evt_job"));
    }

    @Override
    public void insertJobToLocal(ExecuteJob job) {
        this.pf.getExecuteJobManager().saveOrUpdate(job);
    }

    @Override
    public boolean isLocalJob(String dBRouteKey) {
        return DBRoute.workflow.getRouteKey().equals(dBRouteKey);
    }

    @Override
    public boolean exsitDeadLetterJob(Long id) {
        return this.pf.getEvtDeadLetterJobEntityManager().exist(id);
    }

    public List<ExecuteJob> findJobs(List<Long> ids, boolean cache) {
        return new ArrayList<ExecuteJob>();
    }

    @Override
    public DynamicObjectCollection findChannelTasksByJobExecuteJob(JobEntity jobEntity) {
        return null;
    }
}

