/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.graph.codec;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecRegistry;
import kd.bos.workflow.bpmn.graph.codec.GraphObjectCodec;
import kd.bos.workflow.bpmn.graph.model.IValueContext;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.SimpleUserInfo;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.beanutils.PropertyUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class GraphCodecUtils {
    protected static Log logger = LogFactory.getLog(GraphCodecUtils.class);
    private static Map<String, DomainModelType> modelMap = new ConcurrentHashMap<String, DomainModelType>();

    public static DomainModelType getBizFlowDomainType() {
        DomainModelType domainModel = GraphCodecUtils.getDomainType("BizFlowModel");
        if (domainModel != null) {
            return domainModel;
        }
        throw new WFException("BizFlowModel not found!");
    }

    public static DomainModelType getAuditFlowDomainType() {
        DomainModelType domainModel = GraphCodecUtils.getDomainType("WorkflowModel");
        if (domainModel != null) {
            return domainModel;
        }
        throw new WFException("AuditFlowModel not found!");
    }

    public static DomainModelType getDomainType(String name) {
        DomainModelType type = null;
        try {
            String lang = Lang.get().toString();
            logger.debug(String.format("getDomainType, name[%s], lang[%s]", name, lang));
            type = modelMap.computeIfAbsent(String.format("%s_%s", name, lang), k -> DomainModelTypeFactory.getDomainModelType((String)name, (boolean)true, (String)lang));
        }
        catch (KDException e) {
            logger.error(String.format("getDomainModelType from %s error! %s", name, WfUtils.getExceptionStacktrace(e)));
        }
        return type;
    }

    public static Node convertBpmnModelToNode(BpmnModel model, GraphCodecContext context) {
        GraphObjectCodec codec = GraphCodecRegistry.getCodec(model.getClass());
        return codec.encode(context, (Object)model);
    }

    public static Node convertBpmnModelToNode(BpmnModel model) {
        GraphObjectCodec codec = GraphCodecRegistry.getCodec(model.getClass());
        GraphCodecContext ctx = new GraphCodecContext(model);
        return codec.encode(ctx, (Object)model);
    }

    public static String convertBpmnModelToXML(BpmnModel model) {
        return GraphCodecUtils.convertBpmnModelToNode(model).asXML();
    }

    public static String convertDefaultElementToXML(GraphCodecContext ctx, BaseElement element) {
        GraphObjectCodec codec = GraphCodecRegistry.getCodec(element.getClass());
        return codec.encodeFlowElement(ctx, element);
    }

    public static String convertDefaultElementToJSON(BaseElement element) {
        ObjectNode jsonNode = new BpmnJsonConverter().convertDefaultFlowElementToJson(element);
        return jsonNode.toString();
    }

    public static String convertBpmnModelToXML(BpmnModel model, GraphCodecContext context) {
        return GraphCodecUtils.convertBpmnModelToNode(model, context).asXML();
    }

    public static Document createDocument() {
        return DocumentHelper.createDocument();
    }

    public static Node appendNode(Node node, String nodeName, String id) {
        Element cell = null;
        if (node != null) {
            cell = ((Element)node).addElement(nodeName);
            cell.addAttribute("id", id);
        }
        return cell;
    }

    public static boolean isBaseDataType(Class<?> clazz) {
        try {
            return clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class) || clazz.isPrimitive();
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isIgnore(String name) {
        return "class".equals(name) || "inserted".equals(name) || "deleted".equals(name) || "updated".equals(name) || "dynamicObject".equals(name) || "dynObjTypeName".equals(name) || "attributes".equals(name) || "values".equals(name) || "persistentState".equals(name) || "extensionElements".equals(name) || "xmlRowNumber".equals(name) || "xmlColumnNumber".equals(name) || "extensionAttributesImpl".equals(name);
    }

    public static Object safeGetPropertyValue(Object obj, String name) {
        try {
            String[] paths = name.split("\\.");
            int length = paths.length;
            if (length == 1) {
                if (!PropertyUtils.isReadable((Object)obj, (String)name)) {
                    return null;
                }
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)obj, (String)name);
                return PropertyUtils.getReadMethod((PropertyDescriptor)descriptor).invoke(obj, new Object[0]);
            }
            Object propValue = obj;
            String key = "";
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    key = key + ".";
                }
                if (!PropertyUtils.isReadable((Object)obj, (String)(key = key + paths[i]))) continue;
                propValue = PropertyUtils.getNestedProperty((Object)obj, (String)key);
                if (propValue == null) {
                    return null;
                }
                return GraphCodecUtils.safeGetPropertyValue(propValue, name.replaceFirst(key + "\\.?", ""));
            }
            return null;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    public static void safeSetPropertyValue(Object obj, String name, Object value) {
        try {
            String[] paths = name.split("\\.");
            int length = paths.length - 1;
            Object propValue = obj;
            StringBuilder keySB = new StringBuilder();
            String key = "";
            PropertyDescriptor desc = null;
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    keySB.append(".");
                }
                keySB.append(paths[i]);
                key = keySB.toString();
                if (!PropertyUtils.isReadable((Object)obj, (String)key) || (propValue = PropertyUtils.getNestedProperty((Object)obj, (String)key)) != null) continue;
                desc = PropertyUtils.getPropertyDescriptor((Object)obj, (String)key);
                propValue = TypesContainer.createInstance(desc.getPropertyType());
                PropertyUtils.setNestedProperty((Object)obj, (String)key, (Object)propValue);
            }
            if (PropertyUtils.isWriteable((Object)obj, (String)(key = key + (key.length() == 0 ? "" : ".") + paths[length]))) {
                PropertyUtils.setNestedProperty((Object)obj, (String)key, (Object)value);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof String) {
            return " ".equals(obj.toString());
        }
        return false;
    }

    public static List<Property> getNodeProperties(String modelType, String nodeType) {
        List<Object> list = new ArrayList();
        DomainModelType domainType = GraphCodecUtils.getDomainType(modelType);
        ElementType elemType = null;
        if (domainType != null) {
            elemType = domainType.getElementType(nodeType);
        }
        if (elemType != null) {
            list = elemType.getProperties();
        } else {
            String extendedModel = GraphCodecUtils.getExtendedModel(modelType);
            if (extendedModel != null && !"".equals(extendedModel.trim())) {
                String name;
                String[] stringArray = extendedModel.split(";");
                int n = stringArray.length;
                for (int i = 0; i < n && ((list = GraphCodecUtils.getNodePropertiesFromModel(name = stringArray[i], nodeType)) == null || list.isEmpty()); ++i) {
                }
            }
        }
        return list;
    }

    private static List<Property> getNodePropertiesFromModel(String modelName, String nodeType) {
        ElementType elemType;
        List<Object> list = new ArrayList<Property>();
        DomainModelType domainModel = GraphCodecUtils.getDomainType(modelName);
        if (domainModel != null && (elemType = domainModel.getElementType(nodeType)) != null) {
            list = elemType.getProperties();
        }
        return list;
    }

    public static Object handlSpecialValue(IValueContext valueContext, Object defaultVal) {
        try {
            if (defaultVal instanceof String) {
                return valueContext.getExpressionValue((String)defaultVal);
            }
            if (defaultVal instanceof Map) {
                Map map = (Map)defaultVal;
                HashMap ret = new HashMap();
                for (Map.Entry set : map.entrySet()) {
                    Object value = set.getValue();
                    if (value instanceof String) {
                        ret.put(set.getKey(), valueContext.getExpressionValue((String)value));
                        continue;
                    }
                    ret.put(set.getKey(), value);
                }
                return ret;
            }
            return defaultVal;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.startEventInitError(), e.getMessage(), (Throwable)e);
        }
    }

    private static Object getExpressionValue(Object obj, String expression) throws Exception {
        String EXPRESSION_NODEID = "${nodeId}";
        if ("${nodeId}".equals(expression)) {
            if (obj instanceof Map) {
                return ((Map)obj).get("itemId");
            }
            return GraphCodecUtils.safeGetPropertyValue(obj, "id");
        }
        return expression;
    }

    public static String convertBpmnModelToJSON(BpmnModel bpmnModel) {
        BpmnJsonConverter convert = new BpmnJsonConverter();
        return convert.convertToJson(bpmnModel).toString();
    }

    public static BpmnModel getDefaultBpmnModel(String modelType, List<Map<String, Object>> configs) {
        GraphObjectCodec codec = GraphCodecRegistry.getCodec(BpmnModel.class);
        BpmnModel bpmnModel = (BpmnModel)codec.create();
        GraphCodecContext context = new GraphCodecContext(bpmnModel);
        context.setModelType(modelType);
        codec.initiation(null, context);
        if (configs == null || configs.isEmpty()) {
            return bpmnModel;
        }
        String stencilType = null;
        for (Map<String, Object> config : configs) {
            stencilType = config.get("type").toString();
            modelType = config.get("ModelType") == null ? modelType : (String)config.get("ModelType");
            Object element = GraphCodecUtils.getDefaultElement(modelType, stencilType, bpmnModel, config);
            if (element instanceof FlowElement) {
                bpmnModel.getMainProcess().addFlowElement((FlowElement)element);
                continue;
            }
            if (!(element instanceof Process)) continue;
            bpmnModel.getProcesses().add((Process)element);
        }
        return bpmnModel;
    }

    public static Object getDefaultElement(Class<?> clazz, BpmnModel bpmnModel, Map<String, Object> config) {
        return GraphCodecUtils.initiationElement("AbstractWorkflowModel", GraphCodecRegistry.getCodec(clazz), null, bpmnModel, config);
    }

    public static Object getDefaultElement(String modelType, Class<?> clazz, BpmnModel bpmnModel, Map<String, Object> config) {
        return GraphCodecUtils.initiationElement(modelType, GraphCodecRegistry.getCodec(clazz), null, bpmnModel, config);
    }

    public static Object getDefaultElement(String stencilType, BpmnModel bpmnModel, Map<String, Object> config) {
        return GraphCodecUtils.getDefaultElement("AbstractWorkflowModel", stencilType, bpmnModel, config);
    }

    public static Object getDefaultElement(String modelType, String stencilType, BpmnModel bpmnModel, Map<String, Object> config) {
        GraphObjectCodec codec = null;
        codec = "WorkflowModel".equalsIgnoreCase(modelType) || "BizFlowModel".equalsIgnoreCase(modelType) ? GraphCodecRegistry.getCodec((String)stencilType) : GraphCodecRegistry.getCodec((String)ModelConfigUtil.getExtendNodeInheritStencilType((String)stencilType));
        codec.setType(stencilType);
        ElementType elementType = null;
        DomainModelType domainType = GraphCodecUtils.getDomainType(modelType);
        if (domainType != null) {
            elementType = domainType.getElementType(stencilType);
        }
        return GraphCodecUtils.initiationElement(modelType, codec, elementType, bpmnModel, config);
    }

    public static <T> T getFlowElement(String modelType, Class<T> clazz) {
        GraphObjectCodec codec = GraphCodecRegistry.getCodec(clazz);
        ElementType elementType = null;
        DomainModelType domainType = GraphCodecUtils.getDomainType(modelType);
        if (domainType != null) {
            elementType = domainType.getElementType(codec.getType());
        }
        return (T)codec.initDefaultElement(elementType);
    }

    private static Object initiationElement(String modelType, GraphObjectCodec codec, ElementType elementType, BpmnModel bpmnModel, Map<String, Object> config) {
        DomainModelType domainModel;
        if (elementType == null && (domainModel = GraphCodecUtils.getDomainType(modelType)) != null) {
            elementType = domainModel.getElementType(codec.getType());
            GraphCodecUtils.setDefaultNameConfig(codec, elementType, config);
        }
        GraphCodecContext context = new GraphCodecContext(bpmnModel);
        context.setModelType(modelType);
        context.setConfig(config);
        return codec.initiation(elementType, context);
    }

    private static void setDefaultNameConfig(GraphObjectCodec codec, ElementType elementType, Map<String, Object> config) {
        if ("SequenceFlow".equals(codec.getType())) {
            return;
        }
        if (config.get("name") == null && elementType != null && elementType.getName() != null) {
            config.put("name", elementType.getName().getLocaleValue());
        }
    }

    public static String getModelTypeByProcessType(String processType) {
        return ModelType.BizFlow.name().equals(processType) ? "BizFlowModel" : "WorkflowModel";
    }

    public static Property getPropertyByName(List<Property> properties, String name) {
        for (Property prop : properties) {
            if (!name.equals(prop.getPropertyName())) continue;
            return prop;
        }
        return null;
    }

    public static Object getParsedPropValue(String key, Process process) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Pattern pattern;
        Matcher matcher;
        String regex = "\\$\\{process\\.(\\w+)\\}";
        if (key.matches(regex) && (matcher = (pattern = Pattern.compile(regex)).matcher(key)).find()) {
            key = matcher.group(1);
            if ("process_id".equals(key)) {
                return process.getId();
            }
            if (PropertyUtils.isReadable((Object)process, (String)key)) {
                return PropertyUtils.getProperty((Object)process, (String)key);
            }
            return null;
        }
        return key;
    }

    public static String getStyleValue(String style, String key, String defaultValue) {
        if (style == null || key == null) {
            return defaultValue;
        }
        Pattern pattern = Pattern.compile("" + key + "=([\\w#\\$&\\.]+);?");
        Matcher matcher = pattern.matcher(style);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return defaultValue;
    }

    public static String updateStyleProperty(String style, String property, String value) {
        style = style.replaceFirst(String.format("%s=.+?;", property), "").replaceFirst("(.+);$", "$1");
        style = style + String.format(";%s=%s;", property, value);
        return style;
    }

    public static String getExtendedModel(String modelType) {
        List categories = new ArrayList();
        DomainModelType domainType = GraphCodecUtils.getDomainType(modelType);
        if (domainType != null) {
            categories = domainType.getCategories();
        }
        int index = categories.size();
        Category category = null;
        while (index-- > 0) {
            category = (Category)categories.get(index);
            if (!"ExtendControl".equals(category.getId())) continue;
            String name = category.getName().toString();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return name;
            }
            for (String value : category.getName().values()) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                return value;
            }
        }
        return null;
    }

    public static String getHandleStateName(GraphCodecContext ctx) {
        BaseElement current = ctx.getCurrentNode();
        Long procInstId = ctx.getProcInstId();
        String activityId = current.getId();
        String type = GraphCodecUtils.getElementType(current);
        if (!GraphCodecUtils.isSSCApprove(type)) {
            if (GraphCodecUtils.isWaitingForProcessing(ctx, current)) {
                return WFMultiLangConstants.getWaitingForProcessingStateName();
            }
            return GraphCodecUtils.getHandleStateNameNotSSC(ctx);
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        String state = service.getHistoryService().getLatestTaskHandleState(procInstId, activityId);
        if (ctx.getManualHangUpNodeIds().get(activityId) != null) {
            state = "4";
        }
        return GraphCodecUtils.getSSCStateName(state);
    }

    private static boolean isWaitingForProcessing(GraphCodecContext ctx, BaseElement current) {
        if (current instanceof FlowNode) {
            FlowNode node = (FlowNode)current;
            if (!Boolean.TRUE.equals(node.getJoin())) {
                return false;
            }
            Set currentNodeIds = ctx.getCurrentNodeIds();
            if (WfUtils.isNullObject(ctx.getModelWithOutDynamic())) {
                WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                RepositoryService repositoryService = service.getRepositoryService();
                String fields = String.format("%s,%s", "processDefinitionId", "schemeId");
                HistoricProcessInstanceEntity hiProcInst = (HistoricProcessInstanceEntity)repositoryService.findEntityById(ctx.getProcInstId(), EntityNumberConstant.getHiProcInstEntityNumber(), fields);
                if (WfUtils.isNotNullObject(hiProcInst)) {
                    long processDefinitionId = hiProcInst.getProcessDefinitionId();
                    long schemeId = hiProcInst.getSchemeId();
                    BpmnModel bpmnModel = repositoryService.getBpmnModel(Long.valueOf(processDefinitionId), Long.valueOf(schemeId), null);
                    ctx.setModelWithOutDynamic(bpmnModel);
                }
            }
            return BpmnModelUtil.getPreviousNodes((BpmnModel)(WfUtils.isNullObject(ctx.getModelWithOutDynamic()) ? ctx.getModel() : ctx.getModelWithOutDynamic()), (String)current.getId()).stream().map(BaseElement::getId).anyMatch(currentNodeIds::contains);
        }
        return false;
    }

    public static String getElementType(BaseElement element) {
        String type = "";
        try {
            type = (String)GraphCodecUtils.safeGetPropertyValue(element, "type");
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return type;
    }

    public static String getHandleStateName(Long procInstId, String activityId) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        String suspensionState = service.getRuntimeService().getSuspensionState(procInstId, activityId);
        Long durations = GraphCodecUtils.getDurationsByFilter(procInstId, activityId);
        if (durations > 0L) {
            return WFMultiLangConstants.getManualHangUpStateName();
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(suspensionState)) {
            return WFMultiLangConstants.getHangUpStateName();
        }
        return WFMultiLangConstants.getDefaultStateName();
    }

    public static Long getDurationsByFilter(Long procInstId, String activityId) {
        return GraphCodecUtils.getDurationsByFilter(procInstId, activityId, null);
    }

    public static Long getDurationsByFilter(Long procInstId, String activityId, Long taskId) {
        Long durations = 0L;
        if (WfUtils.isEmpty(procInstId)) {
            return durations;
        }
        QFilter filterProcInstId = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter filterActivityId = new QFilter("activityid", "=", (Object)activityId);
        QFilter filterSuspendType = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
        QFilter filterTime = new QFilter("undosuspendtime", "is null", null);
        QFilter[] filters = null;
        if (WfUtils.isNotEmpty(taskId)) {
            QFilter filterTaskId = new QFilter("taskid", "=", (Object)taskId);
            filters = new QFilter[]{filterProcInstId, filterActivityId, filterSuspendType, filterTime, filterTaskId};
        } else {
            filters = new QFilter[]{filterProcInstId, filterActivityId, filterSuspendType, filterTime};
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        durations = service.getRepositoryService().getEntityCountByFilter("wf_durationdetail", filters);
        return durations;
    }

    public static String getSSCStateName(String state) {
        String defaultState = WFMultiLangConstants.getSSCStateName0();
        if (state == null) {
            return defaultState;
        }
        switch (state) {
            case "0": {
                return WFMultiLangConstants.getSSCStateName0();
            }
            case "1": {
                return WFMultiLangConstants.getSSCStateName1();
            }
            case "2": {
                return WFMultiLangConstants.getSSCStateName2();
            }
            case "3": {
                return WFMultiLangConstants.getSSCStateName3();
            }
            case "4": {
                return WFMultiLangConstants.getManualHangUpStateName();
            }
            case "5": {
                return WFMultiLangConstants.getSSCStateName5();
            }
            case "6": {
                return WFMultiLangConstants.getSSCStateName6();
            }
        }
        return defaultState;
    }

    public static String getCurrentParticipants(GraphCodecContext ctx, String stateName, String currentNodeId) {
        String userNames;
        BaseElement current = ctx.getCurrentNode();
        String type = GraphCodecUtils.getElementType(current);
        if (GraphCodecUtils.isSSCApprove(type) && (WFMultiLangConstants.getSSCStateName0().equals(stateName) || WFMultiLangConstants.getSSCStateName3().equals(stateName))) {
            return "";
        }
        List users = (List)ctx.getCurrentNodeUsersMap().get(currentNodeId);
        StringBuilder result = new StringBuilder();
        int size = 0;
        if (users != null && (size = users.size()) > 0) {
            int separator = 12289;
            SimpleUserInfo user = null;
            for (int i = 0; i < size; ++i) {
                user = (SimpleUserInfo)users.get(i);
                if (user == null || WfUtils.isEmpty(user.getName())) continue;
                result.append(user.getName());
                if (i >= size - 1) continue;
                result.append('\u3001');
            }
        }
        return WfUtils.isNotEmpty(userNames = result.toString()) ? userNames + " " : "";
    }

    public static boolean isSSCApprove(String type) {
        return "SSCApprove".equals(type);
    }

    public static String getUserNames(List<String> userNames) {
        StringBuilder result = new StringBuilder();
        if (WfUtils.isNotEmptyForCollection(userNames)) {
            int separator = 12289;
            for (String userName : userNames) {
                if (!WfUtils.isNotEmpty(userName)) continue;
                result.append(userName).append('\u3001');
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
        }
        return result.toString();
    }

    private static String getHandleStateNameNotSSC(GraphCodecContext ctx) {
        BaseElement current = ctx.getCurrentNode();
        Long procInstId = ctx.getProcInstId();
        String activityId = current.getId();
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        String suspensionState = service.getRuntimeService().getSuspensionState(procInstId, activityId);
        if (ctx.getManualHangUpNodeIds().get(activityId) != null) {
            return WFMultiLangConstants.getManualHangUpStateName();
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(suspensionState)) {
            return WFMultiLangConstants.getHangUpStateName();
        }
        return WFMultiLangConstants.getDefaultStateName();
    }
}

