/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;

public class WfDBUtils {
    private static Log logger = LogFactory.getLog(WfDBUtils.class);

    public static boolean executeBatchDeleteByIn(String deleteSql, List<Object> args, Integer batchCount, boolean cacheException) {
        boolean result;
        block5: {
            result = true;
            if (WfUtils.isNotEmptyForCollection(args)) {
                int totalCount;
                if (null == batchCount || batchCount <= 0) {
                    batchCount = 500;
                }
                int j = (totalCount = args.size()) % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
                try {
                    for (int x = 0; x < j; ++x) {
                        int end = (x + 1) * batchCount > totalCount ? totalCount : (x + 1) * batchCount;
                        List<Object> subList = args.subList(x * batchCount, end);
                        if (null == subList || subList.size() <= 0) continue;
                        String sql = deleteSql.replaceAll("\\?", WfDBUtils.getQuestionMarkList(subList.size()));
                        boolean batchResult = DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])subList.toArray());
                        result &= batchResult;
                    }
                }
                catch (Exception e) {
                    logger.warn(WfUtils.getExceptionStacktrace(e));
                    if (!cacheException) break block5;
                    throw new KDBizException("execute batch delete by in exception : " + e.getMessage());
                }
            }
        }
        return result;
    }

    public static boolean executeBatchDeleteByIn(String deleteSql, List<Object> subList, boolean cacheException) {
        boolean result;
        block3: {
            result = true;
            if (WfUtils.isNotEmptyForCollection(subList)) {
                try {
                    String sql = deleteSql.replaceAll("\\?", WfDBUtils.getQuestionMarkList(subList.size()));
                    boolean batchResult = DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])subList.toArray());
                    result &= batchResult;
                }
                catch (Exception e) {
                    logger.warn(WfUtils.getExceptionStacktrace(e));
                    if (!cacheException) break block3;
                    throw new KDBizException("execute batch delete by in exception : " + e.getMessage());
                }
            }
        }
        return result;
    }

    private static String getQuestionMarkList(int size) {
        StringBuilder questionMark = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            questionMark.append(" ?");
            if (i == size - 1) continue;
            questionMark.append(',');
        }
        return questionMark.toString();
    }

    public static int executeBatch(String batchSql, List<Object[]> paramsList, Integer batchCount) {
        return WfDBUtils.executeBatch(DBRoute.workflow, batchSql, paramsList, batchCount);
    }

    public static int executeBatch(DBRoute dbRoute, String batchSql, List<Object[]> paramsList, Integer batchCount) {
        int count = 0;
        if (WfUtils.isNotEmptyForCollection(paramsList)) {
            int billCount;
            if (null == batchCount || batchCount <= 0) {
                batchCount = 1000;
            }
            int j = (billCount = paramsList.size()) % batchCount != 0 ? billCount / batchCount + 1 : billCount / batchCount;
            try {
                for (int x = 0; x < j; ++x) {
                    int[] countForUpdate;
                    int end = (x + 1) * batchCount > billCount ? billCount : (x + 1) * batchCount;
                    List<Object[]> subList = paramsList.subList(x * batchCount, end);
                    if (subList == null || subList.size() <= 0 || (countForUpdate = DB.executeBatch((DBRoute)dbRoute, (String)batchSql, subList)).length <= 0) continue;
                    for (int i : countForUpdate) {
                        count += i;
                    }
                }
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
                throw new KDBizException("executeBatch exception : " + e.getMessage());
            }
        }
        return count;
    }

    public static DataSet batchQueryByInWithParams(String sql, List<String> paramsAfterIn, String algoKey, Object[] params, boolean cacheException) {
        DataSet unionDs = null;
        for (String paramAfterIn : paramsAfterIn) {
            DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)(sql + paramAfterIn), (Object[])params);
            Throwable throwable = null;
            try {
                if (unionDs == null) {
                    unionDs = ds;
                    continue;
                }
                unionDs = unionDs.union(ds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return unionDs;
    }
}

