/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine;

import com.alibaba.fastjson.JSONObject;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.utils.BecUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.portal.NewPortalServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.ParticipantParseProcess;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.relservice.BusinessObjectQueryHelper;
import kd.bos.workflow.relservice.biz.BusinessObjectQueryContextHelper;
import kd.bos.workflow.relservice.biz.context.BusinessObjectQueryContext;
import kd.bos.workflow.service.WfTraceType;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.util.WfComMultiLangUtil;
import kd.bos.workflow.util.WfCommonUtil;
import org.apache.commons.lang.exception.ExceptionUtils;

public class WfUtils {
    private static final String ENTITY_NAME = "entityName";
    public static final String BPMAPPID = "194JD185SVFC";
    public static final String APPIDFORWF = "a479ec06000000ac";
    public static final String APPIDFORWFTASK = "wftask";
    public static final String WFAPPNUMBER = "wf";
    public static final String BPMAPPNUMBER = "bpm";
    public static final String TASKHANDLECONTEXT = "taskHandleContext";
    public static final DBRoute WFS = new DBRoute("wfs");
    private static final Log logger = LogFactory.getLog(WfUtils.class);
    private static boolean localSyncRun = "true".equals(System.getProperty("workflow.runtime.sync"));
    private static final String USERID = "userId";
    private static final String ORGID = "orgId";
    private static final String BOS_USER = "bos_user";
    private static final String NUMBER = "number";
    private static final String ISPASS = "ispass";
    private static final String ISOVER = "isover";
    private static final String FTRUENAME = "ftruename";
    private static final String CLIENT = "client";
    private static String curNodeIp;
    private static final String BYBILLNAME = "bybillname";
    private static final String[] ids;
    private static final String DESENSITIZED_IP = "******";

    public static boolean isTesting() {
        return WfTraceType.getOrCreate().isTesting() || WfConfigurationUtil.isPerformanceTesting();
    }

    public static boolean isSyncRun() {
        boolean syncRunning = false;
        String FIELD_VALUE = "value";
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)"workflow.runtime.sync")};
        Map config = BusinessDataServiceHelper.loadFromCache((String)"wf_confcenter", (String)"value", (QFilter[])filters);
        if (config != null && !config.isEmpty()) {
            syncRunning = "true".equals(((DynamicObject)config.entrySet().iterator().next().getValue()).getString("value"));
        }
        return syncRunning || localSyncRun;
    }

    public static String subStringForMax(String value, int max) {
        if (value != null && value.length() > max) {
            return value.substring(0, max);
        }
        return value;
    }

    public static ILocaleString subILocaleString(ILocaleString value, int max) {
        if (value != null && !value.isEmpty()) {
            for (Map.Entry entry : value.entrySet()) {
                String val = (String)entry.getValue();
                value.put(entry.getKey(), (Object)WfUtils.subStringForMax(val, max));
            }
        }
        return value;
    }

    public static boolean exist(String[] arr, String value) {
        for (String tmp : arr) {
            if (tmp == null || !tmp.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestingPlan() {
        return false;
    }

    public static boolean isEmpty(ILocaleString value) {
        if (value == null || value.keySet().isEmpty()) {
            return true;
        }
        for (String key : value.keySet()) {
            if (!WfUtils.isNotEmpty((String)value.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(ILocaleString value) {
        return !WfUtils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() <= 0;
    }

    public static boolean isNotEmpty(String value) {
        return !WfUtils.isEmpty(value);
    }

    public static boolean isNullObject(Object obj) {
        return obj == null;
    }

    public static boolean isNotNullObject(Object obj) {
        return !WfUtils.isNullObject(obj);
    }

    public static boolean isEmptyString(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String || value instanceof Number || value instanceof Character || value instanceof Boolean || value instanceof StringBuffer || value instanceof StringBuilder) {
            return WfUtils.isEmpty(value.toString());
        }
        return false;
    }

    public static boolean isNotEmptyString(Object value) {
        if (value == null) {
            return false;
        }
        return WfUtils.isNotEmpty(value.toString());
    }

    public static String getTraceType(String defaultVal) {
        defaultVal = defaultVal != null ? defaultVal : "WORKFLOW";
        return WfTraceType.get() != null && WfTraceType.get().getTraceType() != null ? WfTraceType.get().getTraceType() : defaultVal;
    }

    public static Map<String, Object> dumpRequestContext(RequestContext context) {
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        requestContext.put(USERID, context.getUserId());
        requestContext.put("userName", context.getUserName());
        requestContext.put(ORGID, context.getOrgId());
        requestContext.put("clientUrl", context.getClientUrl());
        requestContext.put("unitTest", WfTraceType.getOrCreate().isTesting());
        requestContext.put("loginIp", context.getLoginIP());
        requestContext.put("clientFullContextPath", context.getClientFullContextPath());
        requestContext.put(CLIENT, context.getClient());
        return requestContext;
    }

    private static void restoreRequestContext(RequestContext context, Map<String, Object> requestContext) {
        context.setUserId((String)requestContext.get(USERID));
        context.setUserName((String)requestContext.get("userName"));
        if (requestContext.get(ORGID) != null && !requestContext.get(ORGID).equals("null")) {
            context.setOrgId(Long.parseLong(String.valueOf(requestContext.get(ORGID))));
        }
        context.setClientUrl((String)requestContext.get("clientUrl"));
        context.setLoginIP((String)requestContext.get("loginIp"));
        context.setClientFullContextPath((String)requestContext.get("clientFullContextPath"));
        context.setClient((String)requestContext.get(CLIENT));
        Object unitTest = requestContext.get("unitTest");
        if (unitTest != null) {
            WfTraceType.getOrCreate().setTesting(((Boolean)unitTest).booleanValue());
        }
        if (requestContext.get("srcLang") != null) {
            context.setLang(Lang.from((String)((String)requestContext.get("srcLang"))));
        }
    }

    public static void restoreRequestContext(JobEntity wfJob) {
        WfUtils.restoreRequestContext(wfJob.getJobHandlerConfiguration());
    }

    public static void restoreRequestContext(String configuration) {
        if (WfUtils.isSyncRun()) {
            return;
        }
        Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        Map context = (Map)payload.get("_requestContext_");
        String traceId = RequestContext.get().getTraceId();
        String tenantId = RequestContext.get().getTenantId();
        String tenantCode = RequestContext.get().getTenantCode();
        String accountId = RequestContext.get().getAccountId();
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        RequestContext rc = RequestContext.create();
        WfUtils.restoreRequestContext(rc, context);
        rc.setAccountId(accountId);
        rc.setTraceId(traceId);
        rc.setTenantCode(tenantCode);
        rc.setTenantId(tenantId);
        rc.setGlobalSessionId(globalSessionId);
    }

    public static void restoreRequestContext(String configuration, String userId) {
        if (WfUtils.isSyncRun()) {
            return;
        }
        Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        Map context = (Map)payload.get("_requestContext_");
        context.put(USERID, userId);
        String traceId = RequestContext.get().getTraceId();
        String tenantId = RequestContext.get().getTenantId();
        String tenantCode = RequestContext.get().getTenantCode();
        String accountId = RequestContext.get().getAccountId();
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        RequestContext rc = RequestContext.create();
        WfUtils.restoreRequestContext(rc, context);
        rc.setAccountId(accountId);
        rc.setTraceId(traceId);
        rc.setTenantCode(tenantCode);
        rc.setTenantId(tenantId);
        rc.setGlobalSessionId(globalSessionId);
    }

    public static Object pop(Map<String, Object> payload, String property) {
        if (payload != null) {
            Object val = payload.remove(property);
            return val;
        }
        return null;
    }

    public static String getExceptionStacktrace(Throwable exception) {
        if (exception == null) {
            return "exception is null!!!!";
        }
        if (exception instanceof WFEngineException && ((WFEngineException)exception).getErrorCode() != null && (WFErrorCode.licenseVerifyException().getCode().equalsIgnoreCase(((WFEngineException)exception).getErrorCode().getCode()) || WFErrorCode.licenseExceedLimitException().getCode().equalsIgnoreCase(((WFEngineException)exception).getErrorCode().getCode()))) {
            return exception.getMessage();
        }
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    public static String getLocaleValue(ILocaleString val) {
        if (val == null) {
            return "";
        }
        String localValue = val.getLocaleValue();
        if (WfUtils.isEmpty(localValue)) {
            localValue = (String)val.getItem("GLang");
        }
        return localValue;
    }

    public static String getDynObjectTypeName(String className) {
        String entityName = "wf_" + className.substring(0, className.length() - 10).toLowerCase();
        return entityName;
    }

    public static User findUserById(long userId) {
        try {
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)BOS_USER, (String)"id,name,number,picturefield,useropenid");
            UserInfo ret = new UserInfo(user);
            return ret;
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
            return new UserInfo(null);
        }
    }

    public static ILocaleString getILocaleUsersName(List<Long> userIds) {
        LocaleString userName = new LocaleString();
        if (userIds == null || userIds.isEmpty()) {
            return userName;
        }
        Lang[] languages = WfUtils.getSupportLangs();
        for (Long uid : userIds) {
            ILocaleString uName = WfUtils.findUserName(uid);
            if (uName == null) {
                logger.debug("unfinduser:" + uid);
                continue;
            }
            for (Lang language : languages) {
                String name;
                String lang = language.toString();
                String string = name = WfUtils.isEmpty((String)uName.getItem(lang)) ? (String)uName.get((Object)"GLang") : (String)uName.getItem(lang);
                if (WfUtils.isEmpty((String)userName.getItem(lang))) {
                    userName.setItem(lang, (Object)name);
                    continue;
                }
                userName.setItem(lang, (Object)String.format("%s,%s", userName.getItem(lang), name));
            }
        }
        return userName;
    }

    public static String getUsersName(List<Long> userIds) {
        StringBuilder usb = new StringBuilder();
        ILocaleString userName = null;
        for (Long uid : userIds) {
            userName = WfUtils.findUserName(uid);
            if (null == userName || userName.getLocaleValue() == null) continue;
            usb.append(",").append(userName.toString());
        }
        if (usb.length() > 0) {
            return usb.substring(1);
        }
        return "";
    }

    public static ILocaleString findUserName(Long userId) {
        LocaleString userName = new LocaleString();
        if (userId == null || WfUtils.isEmpty(userId)) {
            return userName;
        }
        if (userId.equals(-1L)) {
            return WfUtils.getAutoApproverName();
        }
        try {
            ILocaleString ls = WfCacheHelper.getUserName((String)String.valueOf(userId));
            if (WfUtils.isNotEmpty(ls)) {
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    if (!WfUtils.isNotEmpty((String)ls.get((Object)lang.name()))) continue;
                    userName.put((Object)lang.name(), ls.get((Object)lang.name()));
                }
                if (WfUtils.isEmpty((ILocaleString)userName)) {
                    String lang = RequestContext.get().getLang().toString();
                    userName.put((Object)"GLang", ls.get((Object)"GLang"));
                    userName.put((Object)lang, ls.get((Object)"GLang"));
                }
                return userName;
            }
            LocaleString userNameTemp = new LocaleString();
            User user = WfUtils.findUserById(userId);
            if (user == null) {
                return userName;
            }
            ILocaleString nameFromUser = user.getName();
            if (WfUtils.isEmpty(nameFromUser)) {
                return userName;
            }
            for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                userNameTemp.put((Object)lang.name(), nameFromUser.get((Object)lang.name()));
            }
            userNameTemp.put((Object)"GLang", (Object)nameFromUser.toString());
            String number = null;
            String name = userNameTemp.getLocaleValue();
            if (name != null && WfUtils.isNotEmpty(name) && WfUtils.isUserNameRepeat(name, userId)) {
                number = user.getNumber();
            }
            Set userKeySet = userNameTemp.keySet();
            String value = null;
            for (String key : userKeySet) {
                value = (String)userNameTemp.get((Object)key);
                if (value == null || WfUtils.isEmpty(value)) continue;
                if (WfUtils.isNotEmptyString(number) && number != null && !value.contains(number.toString())) {
                    userName.put((Object)key, (Object)String.format("%s(%s)", value, number));
                    continue;
                }
                userName.put((Object)key, (Object)String.format("%s", value));
            }
            WfCacheHelper.putUserName((String)String.valueOf(userId), (ILocaleString)userName);
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        String lang = RequestContext.get().getLang().toString();
        if (WfUtils.isNotEmpty((ILocaleString)userName) && WfUtils.isEmpty((String)userName.get((Object)lang))) {
            userName.put((Object)lang, userName.get((Object)"GLang"));
        }
        return userName;
    }

    public static String findUserNameForSimplifiedCHINESE(Long userId) {
        String userName = null;
        if (WfUtils.isNotEmpty(userId)) {
            if (userId.equals(-1L)) {
                return ResManager.loadKDString((String)"\u81ea\u52a8\u5ba1\u6838", (String)"WfUtils_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            try {
                ILocaleString userNameLocal;
                User user = WfUtils.findUserById(userId);
                if (null != user && null != (userNameLocal = user.getName())) {
                    return userNameLocal.getLocaleValue_zh_CN();
                }
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return userName;
    }

    public static boolean isUserNameRepeat(String userName, Long userId) {
        boolean enableUserNameRepeatFormat = WfConfigurationUtil.isEnableUserNameRepeatFormat();
        if (!enableUserNameRepeatFormat) {
            return false;
        }
        String sql = "select 1 from t_wf_secuserrepeat where ftruename= ? and flocaleid = ? ";
        Object[] params = new Object[]{userName, RequestContext.get().getLang()};
        try (DataSet ds = DB.queryDataSet((String)"isUserNameRepeat", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            boolean bl = null == ds ? false : !ds.isEmpty();
            return bl;
        }
    }

    public static String getUserNameForFinal(Long userId, String userName, String userNumber) {
        Object userNameForFinal = null;
        if (WfUtils.isEmpty(userId) || WfUtils.isEmpty(userName)) {
            return "";
        }
        if (WfUtils.isNotEmpty(userNumber) && WfUtils.isUserNameRepeat(userName, userId)) {
            return userName + "(" + userNumber + ")";
        }
        return userName;
    }

    public static void replaceLocaleString(ILocaleString src, ILocaleString val, String newVal) {
        if (WfUtils.isEmpty(src) || WfUtils.isEmpty(val) || newVal == null) {
            return;
        }
        String srcValForReplace = null;
        String tgtValForReplace = null;
        for (String key : src.keySet()) {
            String srcVal = (String)src.get((Object)key);
            String tgtVal = (String)val.get((Object)key);
            if (!WfUtils.isNotEmpty(srcVal) || !WfUtils.isNotEmpty(tgtVal)) continue;
            srcValForReplace = srcVal.replaceAll("\\(", "").replaceAll("\\)", "");
            tgtValForReplace = tgtVal.replaceAll("\\(", "").replaceAll("\\)", "");
            String nv = srcValForReplace.replaceAll(String.format("%s,?", tgtValForReplace), newVal);
            nv = nv.endsWith("\uff0c") || nv.endsWith(",") ? nv.substring(0, nv.length() - 1) : nv;
            src.put((Object)key, (Object)nv);
        }
    }

    public static void replaceLocaleString(ILocaleString src, ILocaleString val, ILocaleString newVal) {
        if (WfUtils.isEmpty(src) || WfUtils.isEmpty(val) || WfUtils.isEmpty(newVal)) {
            return;
        }
        for (String key : src.keySet()) {
            String value = (String)src.get((Object)key);
            if (value == null || val.get((Object)key) == null || newVal.get((Object)key) == null) continue;
            src.put((Object)key, (Object)value.replace((CharSequence)val.get((Object)key), (CharSequence)newVal.get((Object)key)));
        }
    }

    public static void replaceFirstLocaleString(ILocaleString src, ILocaleString val, ILocaleString newVal) {
        if (WfUtils.isEmpty(src) || WfUtils.isEmpty(val) || WfUtils.isEmpty(newVal)) {
            return;
        }
        for (String key : src.keySet()) {
            String value = (String)src.get((Object)key);
            if (value == null || val.get((Object)key) == null || newVal.get((Object)key) == null) continue;
            src.put((Object)key, (Object)StringUtils.replace((String)value, (String)((String)val.get((Object)key)), (String)((String)newVal.get((Object)key)), (int)1));
        }
    }

    public static void removeLocaleString(ILocaleString src, ILocaleString val) {
        if (WfUtils.isEmpty(src) || WfUtils.isEmpty(val)) {
            return;
        }
        for (String key : src.keySet()) {
            String value = (String)src.get((Object)key);
            if (value == null || val.get((Object)key) == null) continue;
            String sn = value.replace((CharSequence)val.get((Object)key), "");
            sn = sn.endsWith("\uff0c") || sn.endsWith(",") ? sn.substring(0, sn.length() - 1) : sn;
            src.put((Object)key, (Object)sn);
        }
    }

    public static Long getCurrentUser() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static boolean isEmpty(Long val) {
        return val == null || val == 0L;
    }

    public static boolean isNotEmpty(Long val) {
        return !WfUtils.isEmpty(val);
    }

    public static Long normalizeId(long id) {
        if (id == 0L) {
            return null;
        }
        return id;
    }

    public static Long normalizeId(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        return id;
    }

    public static Long normalizeId(String val) {
        if (WfUtils.isNotEmpty(val)) {
            return Long.parseLong(val) == 0L ? null : Long.valueOf(val);
        }
        return null;
    }

    public static String idToString(Long taskid) {
        if (taskid == null) {
            return null;
        }
        return String.valueOf(taskid);
    }

    public static Object normalizeId(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj == 0 ? null : obj;
        }
        if (obj instanceof Long) {
            return WfUtils.normalizeId((Long)obj);
        }
        if (obj instanceof String) {
            return WfUtils.normalizeId((String)obj);
        }
        return obj;
    }

    public static <T> T requireNonNull(T arg) {
        if (arg == null) {
            throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{ResManager.loadKDString((String)"\u7a7a\u6307\u9488", (String)"WfUtils_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return arg;
    }

    public static String createAlgoKey(String className) {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(className).append(".").append(methodName).toString();
    }

    public static DynamicObject findBusinessObject(String businessKey, String entityNumber) {
        return WfUtils.findBusinessObject(businessKey, entityNumber, null);
    }

    public static DynamicObject findBusinessObject(String businessKey, String entityNumber, String fields) {
        return WfUtils.findBusinessObject(businessKey, entityNumber, fields, new HashMap<String, Object>());
    }

    public static DynamicObject findBusinessObject(String businessKey, String entityNumber, String fields, Map<String, Object> variables) {
        if (WfUtils.isEmpty(businessKey)) {
            return null;
        }
        try {
            DynamicObject obj;
            CommandContext commandContext = Context.getCommandContext();
            String cacheKey = String.format("findbizobj_%s.%s", entityNumber, businessKey);
            if (commandContext != null && fields == null && (obj = (DynamicObject)commandContext.getCachedDynamicObj().get(cacheKey)) != null) {
                return obj;
            }
            BusinessObjectQueryContext context = BusinessObjectQueryContextHelper.buildContext((String)businessKey, (String)entityNumber, variables);
            DynamicObject dynObj = BusinessObjectQueryHelper.findBusinessObject((String)businessKey, (String)entityNumber, (String)fields, (BusinessObjectQueryContext)context);
            if (commandContext != null && fields == null) {
                commandContext.getCachedDynamicObj().put(cacheKey, dynObj);
            }
            return dynObj;
        }
        catch (Exception e) {
            logger.info(String.format("\u5355\u636e[%s]\u53ef\u80fd\u5df2\u88ab\u5220\u9664,\u9519\u8bef\u539f\u56e0[%s]", businessKey, e.getMessage()));
            return null;
        }
    }

    public static String buildTrdBillShowPageURL(String businessKey, String entityNumber) {
        if (WfUtils.isEmpty(businessKey) || WfUtils.isEmpty(entityNumber)) {
            return null;
        }
        BusinessObjectQueryContext context = BusinessObjectQueryContextHelper.buildContext((String)businessKey, (String)entityNumber, new HashMap());
        return BusinessObjectQueryHelper.buildTrdBillShowPageURL((String)businessKey, (String)entityNumber, (BusinessObjectQueryContext)context);
    }

    public static String getBizTraceNo(String entityNumber, String businessKey) {
        String bizTraceNo = null;
        QFilter[] filters = new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber)};
        DynamicObject result = QueryServiceHelper.queryOne((String)"wf_billsubjectmodel", (String)"biztraceno", (QFilter[])filters);
        if (result != null && WfUtils.isNotEmpty(bizTraceNo = result.getString("biztraceno"))) {
            DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, entityNumber);
            BusinessModelVariableScope bizScope = new BusinessModelVariableScope(dynamicObject);
            bizTraceNo = ExpressionCalculatorUtil.contentParser((String)bizTraceNo, (DynamicObject)dynamicObject, (VariableScope)bizScope, (boolean)false);
        }
        if (WfUtils.isEmpty(bizTraceNo)) {
            return TaskBehaviorUtil.getTaskBillNo(entityNumber, businessKey);
        }
        return WfUtils.subStringForMax(bizTraceNo, 255);
    }

    public static boolean exist(String entityNumber, Object businessKey) {
        return WfUtils.exist(entityNumber, businessKey, new HashMap<String, Object>());
    }

    public static boolean exist(String entityNumber, Object businessKey, Map<String, Object> variables) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(businessKey))) {
            return false;
        }
        try {
            BusinessObjectQueryContext context = BusinessObjectQueryContextHelper.buildContext((String)String.valueOf(businessKey), (String)entityNumber, variables);
            return BusinessObjectQueryHelper.exist((String)entityNumber, (Object)businessKey, (BusinessObjectQueryContext)context);
        }
        catch (Exception e) {
            logger.info(String.format("\u5355\u636e[%s]\u53ef\u80fd\u5df2\u88ab\u5220\u9664,\u9519\u8bef\u539f\u56e0[%s]", businessKey, e.getMessage()));
            return false;
        }
    }

    public static String getServerHost() {
        if (WfUtils.isNotEmpty(curNodeIp)) {
            return curNodeIp;
        }
        Enumeration<NetworkInterface> allNetInterfaces = null;
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException arg5) {
            return WfUtils.getTargetAddRess();
        }
        InetAddress ip = null;
        boolean hasGet = false;
        String ipStr = null;
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ip = addresses.nextElement();
                if (!(ip instanceof Inet4Address) || (ipStr = ip.getHostAddress()) == null || ipStr.equals(WfUtils.getTargetAddRess())) continue;
                curNodeIp = ipStr;
                hasGet = true;
                break;
            }
            if (!hasGet) continue;
            break;
        }
        return ipStr;
    }

    private static String getTargetAddRess() {
        return StringUtils.join((Object[])ids, (char)'.');
    }

    public static Long[] stringListToLongArray(Collection<String> otherSrcBills) {
        if (otherSrcBills == null || otherSrcBills.isEmpty()) {
            return new Long[0];
        }
        Long[] ret = new Long[otherSrcBills.size()];
        int i = 0;
        for (String st : otherSrcBills) {
            ret[i] = Long.parseLong(st);
            ++i;
        }
        return ret;
    }

    public static Collection<String> stringToStringCollection(String val, String split) {
        ArrayList<String> list = new ArrayList<String>();
        if (WfUtils.isNotEmpty(val)) {
            String[] arr;
            for (String t : arr = StringUtils.split((String)val, (String)split)) {
                if (!WfUtils.isNotEmpty(t)) continue;
                list.add(t);
            }
        }
        return list;
    }

    public static Collection<Long> stringToCollection(String val, String split) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (WfUtils.isNotEmpty(val)) {
            String[] arr;
            for (String t : arr = StringUtils.split((String)val, (String)split)) {
                if (!WfUtils.isNotEmpty(t)) continue;
                list.add(Long.valueOf(t));
            }
        }
        return list;
    }

    public static String listToString(Collection<?> userIds, String split) {
        StringBuilder sb = new StringBuilder();
        if (userIds != null && !userIds.isEmpty()) {
            for (Object obj : userIds) {
                sb.append(String.valueOf(obj)).append(split);
            }
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public static String listToStringWithQuotes(Collection<?> keys, String split) {
        StringBuilder sb = new StringBuilder();
        if (keys != null && !keys.isEmpty()) {
            for (Object obj : keys) {
                sb.append("'").append(String.valueOf(obj)).append("'").append(split);
            }
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public static String strAppend(String pref, String split, String[] args) {
        StringBuilder sb = new StringBuilder(pref);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                sb.append(arg).append(split);
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static DecisionOption getDefaultDecision(AuditTask auditTask) {
        if (auditTask != null && auditTask.getDecisionOptions() != null) {
            for (DecisionOption decision : auditTask.getDecisionOptions()) {
                if (!decision.isDefaultDecision()) continue;
                return decision;
            }
        }
        return null;
    }

    public static DecisionOption getDecisionOption(AuditTask auditTask, String autoDecisionWhenMatch) {
        if (auditTask != null && auditTask.getDecisionOptions() != null) {
            for (DecisionOption option : auditTask.getDecisionOptions()) {
                if (!option.getNumber().equalsIgnoreCase(autoDecisionWhenMatch)) continue;
                return option;
            }
        }
        return null;
    }

    public static String getOperationName(String entityNumber, String value) {
        if (WfUtils.isEmpty(value) || WfUtils.isEmpty(entityNumber)) {
            return "";
        }
        Map map = null;
        try {
            map = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)value);
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        if (map != null && map.get("name") != null) {
            return (String)((Map)map.get("name")).get(RequestContext.get().getLang().name());
        }
        return null;
    }

    public static ILocaleString getOperationLocaleName(String entityNumber, String operation) {
        Map name;
        LocaleString localName = new LocaleString();
        Map opInfo = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operation);
        if (opInfo != null && !opInfo.isEmpty() && WfUtils.isNotEmptyForMap(name = (Map)opInfo.get("name"))) {
            localName = LocaleString.fromMap((Map)name);
        }
        return localName;
    }

    public static void checkLicense() {
        LicenseCheckResult ret = LicenseServiceHelper.checkPerformGroup((String)"CP_WFS");
        if (!ret.getHasLicense().booleanValue()) {
            throw new WFEngineException(WFErrorCode.licenseVerifyException(), null);
        }
    }

    private static String[] processObjects(Object ... objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = String.valueOf(objects[i]);
        }
        return strings;
    }

    public static void addOpLog(String entityNumber, String opKey, String opName, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            WfUtils.addOpLogByAppType(WFAPPNUMBER, entityNumber, opKey, opName, descBridge, args);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    public static void addOpLogByAppType(String appType, String entityNumber, String opKey, String opName, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            OpLogAppInfo info = WfUtils.getOpLogInfo(entityNumber, opKey, opName, descBridge, args);
            if (WFAPPNUMBER.equals(appType)) {
                info.setBizAppID(APPIDFORWF);
            } else if (BPMAPPNUMBER.equals(appType)) {
                info.setBizAppID(BPMAPPID);
            }
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private static OpLogAppInfo getOpLogInfo(String entityNumber, String opKey, String opName, MultiLangEnumBridge descBridge, Object ... args) {
        OpLogAppInfo info = new OpLogAppInfo();
        info.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        info.setBizObjID(entityNumber);
        info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        info.setOpTime(WfUtils.now());
        info.setClientType(RequestContext.get().getClient());
        info.setClientIP(RequestContext.get().getLoginIP());
        info.setOpName(opKey, opName);
        String[] strArgs = WfUtils.processObjects(args);
        if (descBridge == null) {
            info.setOpDescription(strArgs[0]);
        } else {
            info.setOpDesc(descBridge, strArgs);
        }
        return info;
    }

    public static void addOpLog(String entityNumber, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            WfUtils.addOpLogByAppId(APPIDFORWF, entityNumber, opKey, opNameBridge, descBridge, args);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    public static void addOpLogByAppId(String appId, String entityNumber, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            OpLogAppInfo info = WfUtils.getOpLogInfo(entityNumber, opKey, opNameBridge, descBridge, args);
            info.setBizAppID(appId);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    public static void addOpLogByAppType(String appType, String entityNumber, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            OpLogAppInfo info = WfUtils.getOpLogInfo(entityNumber, opKey, opNameBridge, descBridge, args);
            if (WFAPPNUMBER.equals(appType)) {
                info.setBizAppID(APPIDFORWF);
            } else if (BPMAPPNUMBER.equals(appType)) {
                info.setBizAppID(BPMAPPID);
            }
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private static OpLogAppInfo getOpLogInfo(String entityNumber, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, Object ... args) {
        OpLogAppInfo info = new OpLogAppInfo();
        info.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        info.setBizObjID(entityNumber);
        info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        info.setOpTime(WfUtils.now());
        info.setClientType(RequestContext.get().getClient());
        info.setClientIP(RequestContext.get().getLoginIP());
        info.setOpName(opKey, opNameBridge);
        String[] strArgs = WfUtils.processObjects(args);
        if (descBridge == null) {
            info.setOpDescription(strArgs[0]);
        } else {
            info.setOpDesc(descBridge, strArgs);
        }
        return info;
    }

    @Deprecated
    public static void addLog(String entityNumber, String opName, String opDescription) {
        try {
            WfUtils.addLog(entityNumber, opName, opDescription, WFAPPNUMBER);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    @Deprecated
    public static void addLog(String entityNumber, String opName, String opDescription, String appType) {
        try {
            AppLogInfo info = WfUtils.getAppLogInfo(entityNumber, opName, opDescription);
            if (WFAPPNUMBER.equals(appType)) {
                info.setBizAppID(APPIDFORWF);
            } else if (BPMAPPNUMBER.equals(appType)) {
                info.setBizAppID(BPMAPPID);
            }
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    @Deprecated
    public static void addLogByAppId(String entityNumber, String opName, String opDescription, String appId) {
        try {
            AppLogInfo info = WfUtils.getAppLogInfo(entityNumber, opName, opDescription);
            info.setBizAppID(appId);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    @Deprecated
    private static AppLogInfo getAppLogInfo(String entityNumber, String opName, String opDescription) {
        AppLogInfo info = new AppLogInfo();
        info.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        info.setBizObjID(entityNumber);
        info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        info.setOpTime(WfUtils.now());
        info.setClientType(RequestContext.get().getClient());
        info.setClientIP(RequestContext.get().getLoginIP());
        info.setOpName(opName);
        info.setOpDescription(opDescription);
        return info;
    }

    public static String getAppIdForEntity(String entitynumber) {
        return FormMetadataCache.getFormConfig((String)entitynumber).getAppId();
    }

    public static String getApplicationIdByBillId(String entraBillId) {
        String applicationId = "";
        DynamicObject dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)entraBillId);
        if (dynamicObject != null) {
            applicationId = (String)dynamicObject.get("id");
        }
        return applicationId;
    }

    public static String checkPath(String path) {
        return path.replace("../", "#");
    }

    public static String getFullPachForStaticResource(String relativePath) {
        return UrlService.getDomainContextUrl() + relativePath;
    }

    public static boolean isEmptyForCollection(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmptyForCollection(Collection collection) {
        return !WfUtils.isEmptyForCollection(collection);
    }

    public static boolean isEmptyForMap(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmptyForMap(Map map) {
        return !WfUtils.isEmptyForMap(map);
    }

    private static String getOpDescriptionForLog(String preTitle, List numbers) {
        if (WfUtils.isNotEmptyForCollection(numbers)) {
            StringBuilder opDescriptionForLog = new StringBuilder();
            opDescriptionForLog.append(preTitle).append('\uff1a');
            for (Object primaryKey : numbers) {
                opDescriptionForLog.append(primaryKey).append('\uff0c');
            }
            return opDescriptionForLog.substring(0, opDescriptionForLog.length() - 1);
        }
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WfUtils_3", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    @Deprecated
    public static void addLogForBatch(String entityNumber, String opName, String preTitle, List numbers) {
        WfUtils.addLogForBatch(entityNumber, opName, preTitle, numbers, null);
    }

    public static String getFinalInfo(String preTitle, List numbers, String detailInfo) {
        StringBuilder finalInfo = new StringBuilder();
        finalInfo.append(WfUtils.getOpDescriptionForLog(preTitle, numbers));
        if (WfUtils.isNotEmpty(detailInfo)) {
            finalInfo.append(' ').append(detailInfo);
        }
        return finalInfo.toString();
    }

    public static Object getUserText(Long userId) {
        String userText = null;
        Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
        if (WfUtils.isNotEmptyForMap(userInfo) && WfUtils.isEmptyString(userText = (String)userInfo.get("name"))) {
            userText = String.format(ResManager.loadKDString((String)"\u5de5\u53f7_%1$s", (String)"WfUtils_4", (String)"bos-wf-engine", (Object[])new Object[0]), userInfo.get(NUMBER));
        }
        return userText;
    }

    @Deprecated
    public static void addLogForBatch(String entityNumber, String opName, String preTitle, List numbers, String detailInfo) {
        StringBuilder finalInfo = new StringBuilder();
        finalInfo.append(WfUtils.getOpDescriptionForLog(preTitle, numbers));
        if (WfUtils.isNotEmpty(detailInfo)) {
            finalInfo.append(' ').append(detailInfo);
        }
        WfUtils.addLog(entityNumber, opName, finalInfo.toString());
    }

    public static boolean inArray(String[] arr, String val) {
        boolean find = false;
        if (arr != null && arr.length > 0) {
            for (String a : arr) {
                if (a == null || !a.equalsIgnoreCase(val)) continue;
                find = true;
                break;
            }
        }
        return find;
    }

    public static boolean isPassByFraction(int numForVote, int numForTotal, String passFraction) {
        String[] passFractionArr = passFraction.split("/");
        int passFractionOne = Integer.parseInt(passFractionArr[0]);
        int passFractionTwo = Integer.parseInt(passFractionArr[1]);
        return Integer.compare(numForVote * passFractionTwo, numForTotal * passFractionOne) > -1;
    }

    public static boolean isPassForVote(String passType, double passPercentage, String passfraction, int numForVote, int numForTotal) {
        boolean pass = false;
        if (WfUtils.isEmpty(passType) || "passByPercent".equals(passType)) {
            pass = (double)(numForVote * 100) / Double.parseDouble(String.valueOf(numForTotal)) >= passPercentage;
        } else if ("passByFraction".equals(passType)) {
            pass = WfUtils.isPassByFraction(numForVote, numForTotal, passfraction);
        } else if ("passByAnyOne".equals(passType)) {
            pass = numForVote >= 1;
        }
        return pass;
    }

    public static Map<String, Boolean> isPassByPassProportion(String passType, double passPercentage, String passFraction, int approveResult, int nrOfCompletedInstances, int nrOfInstances) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        double passProportion = (double)(approveResult * 100) / Double.parseDouble(String.valueOf(nrOfInstances));
        double targetPassProportion = 0.0;
        if (WfUtils.isEmpty(passType) || "passByPercent".equals(passType)) {
            targetPassProportion = passPercentage;
        } else if ("passByFraction".equals(passType)) {
            String[] passFractionArr = passFraction.split("/");
            int passFractionOne = Integer.parseInt(passFractionArr[0]);
            int passFractionTwo = Integer.parseInt(passFractionArr[1]);
            targetPassProportion = (double)(passFractionOne * 100) / Double.parseDouble(String.valueOf(passFractionTwo));
        }
        if (passProportion >= targetPassProportion) {
            result.put(ISPASS, Boolean.TRUE);
            result.put(ISOVER, Boolean.TRUE);
            return result;
        }
        if (nrOfCompletedInstances == nrOfInstances) {
            result.put(ISPASS, Boolean.FALSE);
            result.put(ISOVER, Boolean.TRUE);
            return result;
        }
        double ifPassProportion = (double)((nrOfInstances - nrOfCompletedInstances + approveResult) * 100) / Double.parseDouble(String.valueOf(nrOfInstances));
        if (ifPassProportion >= targetPassProportion) {
            result.put(ISPASS, Boolean.FALSE);
            result.put(ISOVER, Boolean.FALSE);
        } else {
            result.put(ISPASS, Boolean.FALSE);
            result.put(ISOVER, Boolean.TRUE);
        }
        return result;
    }

    @Deprecated
    public static int executeBatch(String batchSql, List<Object[]> paramsList, Integer batchCount) {
        return WfDBUtils.executeBatch(batchSql, paramsList, batchCount);
    }

    public static List<String> formatInQueryParam(List<Object> args, int size, boolean hasQuotes) {
        int argsLen = args.size();
        int loopCount = args.size() / size + 1;
        ArrayList<String> ret = new ArrayList<String>(loopCount);
        for (int cursor = 0; cursor < loopCount; ++cursor) {
            int left = cursor * size;
            int right = left + size > argsLen ? argsLen : left + size;
            StringBuilder ps = new StringBuilder();
            ps.append('(');
            for (Object p : args.subList(left, right)) {
                char c = hasQuotes ? (char)'\'' : ' ';
                ps.append(c).append(p).append(c).append(',');
            }
            if (!ps.toString().endsWith(",")) continue;
            ret.add(ps.substring(0, ps.length() - 1) + ')');
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet batchQueryByIn(String sql, List<String> params, String algoKey, boolean cacheException) {
        DataSet unionDs = null;
        boolean closeDataSet = false;
        try {
            for (String param : params) {
                DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)(sql + param));
                if (unionDs == null) {
                    unionDs = ds;
                    continue;
                }
                unionDs = unionDs.union(ds);
            }
        }
        catch (Exception e) {
            closeDataSet = true;
            if (cacheException) {
                throw e;
            }
        }
        finally {
            if (closeDataSet && unionDs != null) {
                unionDs.close();
                unionDs = null;
            }
        }
        return unionDs;
    }

    public static <T> T transferToTypeValueFromStringValue(String value, Class<?> valueType) {
        Object typeValue = null;
        if (WfUtils.isNotEmpty(value)) {
            try {
                typeValue = SerializationUtils.fromJsonString((String)value, valueType);
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return (T)typeValue;
    }

    public static String getEntityNumberFromVariableScope(VariableScope variableScope) {
        String entityNumber = null;
        if (variableScope instanceof BusinessModelVariableScope) {
            BusinessModelVariableScope scope = (BusinessModelVariableScope)variableScope;
            entityNumber = scope.getModel() != null ? scope.getModel().getDataEntityType().getName() : scope.getEntityNumber();
        } else if (variableScope instanceof ExecutionEntityImpl) {
            entityNumber = ((ExecutionEntityImpl)variableScope).getEntityNumber();
        } else if (variableScope instanceof PreComputatorExecutionEntityImpl) {
            entityNumber = ((PreComputatorExecutionEntityImpl)variableScope).getEntityNumber();
        } else if (variableScope instanceof TaskEntityImpl) {
            entityNumber = ((TaskEntityImpl)variableScope).getEntityNumber();
        }
        return entityNumber;
    }

    @Deprecated
    public static ILocaleString getMultiLangValue(String value) {
        return WfMultiLangUtils.getMultiLangValue((String)value);
    }

    @Deprecated
    public static ILocaleString getMultiLangValue(String zhValue, String twValue, String enValue) {
        LocaleString result = new LocaleString();
        result.put((Object)Locale.SIMPLIFIED_CHINESE.toString(), (Object)zhValue);
        result.put((Object)Locale.TRADITIONAL_CHINESE.toString(), (Object)twValue);
        result.put((Object)Locale.US.toString(), (Object)enValue);
        return result;
    }

    public static ILocaleString getAutoApproverName() {
        return WfUtils.getPromptWordLocaleString("\u81ea\u52a8\u5ba1\u6838", "WfUtils_5", "bos-wf-engine");
    }

    public static ILocaleString getLocaleStringVariable(Map<String, Object> variables, String key) {
        if (variables == null) {
            return null;
        }
        Object value = variables.get(key);
        if (value instanceof ILocaleString) {
            return (ILocaleString)value;
        }
        if (value != null) {
            return WfUtils.getMultiLangValue(value.toString());
        }
        return null;
    }

    public static WorkflowService getWfService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    public static void getCacheMapForFilter(Map<String, String> cacheMap) {
        if (WfUtils.isNotEmptyForMap(cacheMap)) {
            Set<Map.Entry<String, String>> entrySet = cacheMap.entrySet();
            Iterator<Map.Entry<String, String>> setIte = entrySet.iterator();
            Map.Entry<String, String> entry = null;
            while (setIte.hasNext()) {
                entry = setIte.next();
                if (!WfUtils.isEmptyString(entry.getValue())) continue;
                setIte.remove();
            }
        }
    }

    public static void mapFilter(Map<String, Object> map) {
        if (null == map || 0 == map.size()) {
            return;
        }
        if (map.containsKey(null)) {
            map.remove(null);
        }
    }

    public static Map<String, Object> shallowCopyMap(Map<String, Object> sourceMap) {
        HashMap<String, Object> targetMap = null;
        if (sourceMap != null) {
            targetMap = new HashMap<String, Object>(sourceMap.size());
            targetMap.putAll(sourceMap);
        }
        return targetMap;
    }

    public static LocaleString getEntityNameByNumber(String entityNumber) {
        LocaleString localString = new LocaleString();
        if (WfCommonUtil.isEmpty((String)entityNumber)) {
            return localString;
        }
        try {
            MainEntityType entityType = BusinessObjectQueryHelper.getDataEntityType((String)entityNumber);
            if (null == entityType) {
                return localString;
            }
            LocaleString str = entityType.getDisplayName();
            if (WfCommonUtil.isEmpty((ILocaleString)str)) {
                return localString;
            }
            for (Lang lang : WfComMultiLangUtil.getSupportLangs()) {
                localString.put(lang.name(), str.get((Object)lang.name()));
            }
        }
        catch (Exception e) {
            logger.error(WfCommonUtil.getExceptionDetailStacktrace((Throwable)e));
        }
        return localString;
    }

    private static LocaleString getEntityNameByBillType(String billType) {
        LocaleString entityName = null;
        if (WfUtils.isNotEmpty(billType)) {
            try {
                QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)billType)};
                DynamicObject billTypeDyobj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])filters);
                if (billTypeDyobj != null) {
                    ILocaleString name = billTypeDyobj.getLocaleString("name");
                    entityName = new LocaleString();
                    for (Map.Entry entry : name.entrySet()) {
                        entityName.setItem((String)entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (Exception e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return null == entityName ? new LocaleString() : entityName;
    }

    public static LocaleString getEntityNameProperty(String entityNumber, String billType) {
        LocaleString entityName = null;
        if (WfUtils.isEmpty(entityNumber)) {
            entityName = WfUtils.getEntityNameByBillType(billType);
        } else if (WfUtils.isEmpty(billType)) {
            entityName = WfUtils.getEntityNameByNumber(entityNumber);
        } else if (entityNumber.equalsIgnoreCase(billType) || BYBILLNAME.equals(MessageSystemParamterUtils.getTaskType())) {
            entityName = WfUtils.getEntityNameByNumber(entityNumber);
        } else {
            String formId;
            FormMetadata formMetadata;
            entityName = WfUtils.getEntityNameByBillType(billType);
            if (entityName.isEmpty() && (formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)(formId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form)), (MetaCategory)MetaCategory.Form)) != null) {
                entityName = formMetadata.getName();
            }
        }
        return entityName;
    }

    public static LocaleString getEntityName(String entityNumber, String businessKey) {
        LocaleString entityName = null;
        Map<String, Object> entityMap = WfUtils.getEntityProperties(entityNumber, businessKey);
        if (!entityMap.isEmpty()) {
            entityName = (LocaleString)entityMap.get(ENTITY_NAME);
        }
        return null == entityName ? new LocaleString() : entityName;
    }

    public static Map<String, Object> getEntityProperties(String entityNumber, String businessKey) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        String billType = "";
        LocaleString entityName = null;
        boolean noBillTypeProperty = true;
        try {
            Object billTypeObjet;
            DynamicObject dynObj;
            String billTypeName;
            MainEntityType entityType;
            if (WfUtils.isNotEmpty(businessKey) && !BYBILLNAME.equals(MessageSystemParamterUtils.getTaskType()) && (entityType = BusinessObjectQueryHelper.getDataEntityType((String)entityNumber)) instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billTypeName = ((BillEntityType)entityType).getBillType())) && (dynObj = WfUtils.findBusinessObject(businessKey, entityNumber, null)) != null && (billTypeObjet = dynObj.get(billTypeName)) != null) {
                DynamicObject billTypeDynObj = (DynamicObject)billTypeObjet;
                ILocaleString entityNameMap = billTypeDynObj.getLocaleString("name");
                entityName = LocaleString.fromMap((Map)entityNameMap);
                billType = billTypeDynObj.getString(NUMBER);
                noBillTypeProperty = false;
            }
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        if (noBillTypeProperty) {
            entityName = WfUtils.getEntityNameByNumber(entityNumber);
            billType = entityNumber;
        }
        resMap.put("billType", billType);
        resMap.put(ENTITY_NAME, entityName);
        return resMap;
    }

    public static List<Map<String, Object>> getEntityProperties(String sql, Object[] params) {
        try (DataSet ds = DB.queryDataSet((String)"WFUtils.getEntityProperties", (DBRoute)WFS, (String)sql, (Object[])params);){
            Iterator iterator = ds.iterator();
            HashMap entitysMap = new HashMap();
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                String billType = r.getString("billtype");
                String entityName = r.getString("entityname");
                if (entitysMap.get(billType) != null) continue;
                String entityNumber = r.getString("entitynumber");
                LocaleString localEntityName = WfUtils.getEntityNameProperty(entityNumber, billType);
                if (WfUtils.isNotEmpty((ILocaleString)localEntityName)) {
                    entityName = localEntityName.getLocaleValue();
                }
                HashMap<String, String> m = new HashMap<String, String>();
                m.put(ENTITY_NAME, entityName);
                m.put("entityNumber", billType);
                entitysMap.put(billType, m);
            }
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(entitysMap.values());
            return arrayList;
        }
    }

    public static Long getLongValueFromObj(Object obj) {
        return null == obj ? null : WfUtils.normalizeId(obj.toString());
    }

    public static Map<String, String> getUserInfo(Map<Long, Map<String, String>> userInfos, Long uid, String uName, boolean isWithJobInfo) {
        if (WfUtils.isEmptyForMap(userInfos) || !userInfos.containsKey(uid)) {
            String userNameForFinal = null;
            String fields = "useropenid,name,picturefield,id";
            QFilter filter = new QFilter("id", "=", (Object)uid);
            QFilter[] qFilters = new QFilter[]{filter};
            DynamicObject dynObjs = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_USER, (String)fields, (QFilter[])qFilters);
            if (null == dynObjs) {
                dynObjs = BusinessDataServiceHelper.loadSingle((String)BOS_USER, (String)fields, (QFilter[])qFilters);
            }
            if (null != dynObjs) {
                HashMap<String, String> m = new HashMap<String, String>();
                Long uId = dynObjs.getLong("id");
                m.put("imgsrc", WfUtils.getAbsAvatarPath(dynObjs.get("picturefield")));
                userNameForFinal = WfUtils.isNotEmpty(uName) ? uName : dynObjs.getString("name");
                if (WfUtils.isNotEmpty(userNameForFinal)) {
                    String job = "";
                    try {
                        job = UserServiceHelper.getUserMainJob((long)uId);
                    }
                    catch (Exception e) {
                        logger.warn(WfUtils.getExceptionStacktrace(e));
                    }
                    if (job != null && job.length() > 0) {
                        m.put("fjob", job);
                        if (isWithJobInfo) {
                            m.put(FTRUENAME, userNameForFinal + " | " + job);
                        } else {
                            m.put(FTRUENAME, userNameForFinal);
                        }
                    } else {
                        m.put(FTRUENAME, userNameForFinal);
                    }
                    m.put("name", userNameForFinal);
                } else {
                    m.put(FTRUENAME, "");
                }
                if (dynObjs.get("useropenid") != null) {
                    m.put("fopenid", dynObjs.get("useropenid").toString());
                } else {
                    m.put("fopenid", "");
                }
                if (WfUtils.isEmptyForMap(userInfos)) {
                    userInfos = new HashMap<Long, Map<String, String>>();
                }
                userInfos.put(uId, m);
            }
        }
        if (WfUtils.isNotEmptyForMap(userInfos)) {
            return userInfos.get(uid);
        }
        return new HashMap<String, String>();
    }

    public static Object getBusinessKeyFromEntityType(String businessKey, String entityNumber) {
        MainEntityType entity;
        if (WfUtils.isNotEmpty(entityNumber) && null != (entity = EntityMetadataCache.getDataEntityType((String)entityNumber))) {
            if (entity.getPrimaryKey() instanceof LongProp) {
                return Long.valueOf(businessKey);
            }
            return businessKey;
        }
        return null;
    }

    @Deprecated
    public static String getPromptWord(String srcTran, String resId, String language, String projectNum) {
        PromptWordCacheNew promptWordCacheNew = new PromptWordCacheNew();
        return promptWordCacheNew.getPromptWord(srcTran, resId, language, projectNum);
    }

    @Deprecated
    public static ILocaleString getPromptWordLocaleString(String srcTran, String resId, String projectNum) {
        LocaleString result = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            result.put((Object)lang.name(), (Object)WfUtils.getPromptWord(srcTran, resId, lang.name(), projectNum));
        }
        return result;
    }

    public static Date parseToUserZoneDate(Date date, boolean onlyDate) {
        if (date == null) {
            return null;
        }
        try {
            Date dateParse = WfUtils.getUserZoneDate(date);
            SimpleDateFormat simpleDateFormat = WfUtils.getUserDateFormat(onlyDate);
            if (simpleDateFormat != null) {
                String dateFormatString = simpleDateFormat.format(dateParse);
                return simpleDateFormat.parse(dateFormatString);
            }
        }
        catch (ParseException arg3) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8f6c\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"WfUtils_7", (String)"bos-wf-engine", (Object[])new Object[0]), arg3.getMessage())});
        }
        return date;
    }

    public static String parseToUserZoneDateString(Date date, boolean onlyDate) {
        if (date == null) {
            return null;
        }
        Date dateParse = WfUtils.getUserZoneDate(date);
        SimpleDateFormat simpleDateFormat = WfUtils.getUserDateFormat(onlyDate);
        if (simpleDateFormat != null) {
            return simpleDateFormat.format(dateParse);
        }
        return null;
    }

    public static String parseToUserZoneDateString(Date date) {
        return WfUtils.parseToUserZoneDateString(date, false);
    }

    public static Date getUserZoneDate(Date date) {
        if (date == null) {
            return null;
        }
        try {
            DateFormat userZoneDateFormat = KDDateFormatUtils.getUserZoneDateFormat();
            if (userZoneDateFormat != null) {
                String dateString = userZoneDateFormat.format(date);
                DateFormat systemTimeZoneDateFormat = KDDateFormatUtils.getSystemTimeZoneDateFormat();
                if (systemTimeZoneDateFormat != null) {
                    return systemTimeZoneDateFormat.parse(dateString);
                }
            }
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8f6c\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"WfUtils_7", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage())});
        }
        return date;
    }

    public static SimpleDateFormat getUserDateFormat(boolean date) {
        IFormat format;
        FormatObject formatObject = FormatFactory.getFormat((Long)WfUtils.getCurrentUser());
        if (formatObject != null && (format = FormatFactory.get((FormatTypes)(date ? FormatTypes.Date : FormatTypes.Time))) != null) {
            return (SimpleDateFormat)format.getFormat(formatObject);
        }
        return null;
    }

    public static Object numberOrCurrencyFormat(Object object, FormatTypes type, DynamicObject currency) {
        if (object == null) {
            return null;
        }
        FormatObject formatObject = FormatFactory.getFormat((Long)WfUtils.getCurrentUser());
        if (FormatTypes.Number.equals((Object)type) && (object instanceof Integer || object instanceof Long)) {
            formatObject.getNumberFormat().setMinimumFractionDigits(0);
        } else if (FormatTypes.Currency.equals((Object)type) && currency != null) {
            String currencySymbols;
            String currencyNumber = (String)currency.get(NUMBER);
            if (WfUtils.isNotEmpty(currencyNumber)) {
                formatObject.getCurrencyFormat().setCurrencyNumber(currencyNumber);
            }
            if (WfUtils.isNotEmpty(currencySymbols = (String)currency.get("sign"))) {
                formatObject.getCurrencyFormat().setCurrencySymbols(currencySymbols);
            }
        }
        Format format = FormatFactory.get((FormatTypes)type).getFormat(formatObject);
        return format == null ? null : format.format(object);
    }

    public static Date now() {
        return TimeServiceHelper.now();
    }

    public static <T> boolean isNotEmptyForArrays(T[] arrays) {
        return !WfUtils.isEmptyForArrays(arrays);
    }

    public static <T> boolean isEmptyForArrays(T[] arrays) {
        return null == arrays || 0 == arrays.length;
    }

    public static String getEmptyStringValue(String value) {
        if (WfUtils.isNotEmpty(value)) {
            return value;
        }
        return "";
    }

    @Deprecated
    public static String getEmptyStringValue(ILocaleString value, String language) {
        return WfMultiLangUtils.getValueFromLocalString((ILocaleString)value, (String)language);
    }

    public static ILocaleString substringLocaleStr(ILocaleString str, int length, String suffix) {
        LocaleString ret = new LocaleString();
        if (str != null && !str.isEmpty()) {
            for (Map.Entry entry : str.entrySet()) {
                String subVal = WfUtils.substring((String)entry.getValue(), length, "");
                ret.put(entry.getKey(), (Object)subVal);
            }
        }
        return ret;
    }

    public static String substring(String str, int length, String suffix) {
        if (str != null && str.length() > length && length > 0) {
            suffix = suffix == null ? "" : suffix;
            int tmp = length - suffix.length();
            return str.substring(0, tmp) + suffix;
        }
        return str;
    }

    public static String getUserFormatInfo(List<Long> dest) {
        if (dest != null && dest.size() > 10) {
            return WfUtils.listToString(dest, ",");
        }
        StringBuilder msg = new StringBuilder();
        List ubs = UserServiceHelper.getUserInfoByID(dest);
        if (ubs != null && !ubs.isEmpty()) {
            for (Map user : ubs) {
                msg.append(user.get("name")).append('(').append(user.get(NUMBER)).append(')').append(',');
            }
        }
        if (msg.length() > 0) {
            return msg.substring(0, msg.length() - 1);
        }
        return msg.toString();
    }

    @Deprecated
    public static String getOrgName(String orgFun, Long org) {
        Map ret = OrgServiceHelper.getOrgLongProperty((String)orgFun, (long)org);
        return ret == null ? null : (String)ret.get("name");
    }

    @Deprecated
    public static Lang[] getSupportLangs() {
        return WfMultiLangUtils.getSupportLangs();
    }

    public static List<Long> filterEnableUsers(List<Long> userIds) {
        ArrayList<Long> unenbleUser = new ArrayList<Long>();
        if (userIds != null && !userIds.isEmpty()) {
            Map ret = UserServiceHelper.isUserEnable(userIds);
            Iterator<Long> userIdsIterator = userIds.iterator();
            while (userIdsIterator.hasNext()) {
                Long userId = userIdsIterator.next();
                if (((Boolean)ret.get(userId)).booleanValue()) continue;
                unenbleUser.add(userId);
                userIdsIterator.remove();
            }
            if (unenbleUser.size() > 0) {
                RunTimeLog.get().addlnLog(String.format(ParticipantParseProcess.PARTICIPANTUNENABLE.getDesc(), RunTimeLog.get().collectAndSubstitution(unenbleUser, "user")));
            }
        }
        return userIds;
    }

    public static boolean isAuditTypeNode(String nodeType) {
        return "UserTask".equalsIgnoreCase(nodeType) || "AuditTask".equalsIgnoreCase(nodeType) || "YunzhijiaTask".equalsIgnoreCase(nodeType);
    }

    public static String getOrderBy(Object sortField, Object sortType) {
        StringBuilder sb = new StringBuilder();
        if (WfUtils.isNotEmptyString(sortField)) {
            if (WfUtils.isNotEmptyString(sortType)) {
                sb.append(sortField).append(" ").append(sortType);
            } else {
                sb.append(sortField);
            }
        }
        return sb.toString().toLowerCase();
    }

    public static String formatTime(Long ms) {
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = ms / (long)dd.intValue();
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        String dayStr = ResManager.loadKDString((String)"\u5929", (String)"WfUtils_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        String hourStr = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"WfUtils_9", (String)"bos-wf-engine", (Object[])new Object[0]);
        String minuteStr = ResManager.loadKDString((String)"\u5206", (String)"WfUtils_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        String secondStr = ResManager.loadKDString((String)"\u79d2", (String)"WfUtils_11", (String)"bos-wf-engine", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        if (day > 0L) {
            sb.append(day).append(dayStr);
        }
        if (hour > 0L) {
            sb.append(hour).append(hourStr);
        }
        if (minute > 0L) {
            sb.append(minute).append(minuteStr);
        }
        if (second > 0L) {
            sb.append(second).append(secondStr);
        }
        return sb.toString();
    }

    public static double timeMillisConvertToDoubleHour(Long timeMillis) {
        double result = 0.0;
        if (!WfUtils.isEmpty(timeMillis)) {
            Double doubleTimeMillis = (double)timeMillis;
            result = (double)Math.round(doubleTimeMillis / 3600000.0 * 100.0) / 100.0;
        }
        return result;
    }

    public static String getAbsAvatarPath(Object avatarPath) {
        String absAvatarPath = null;
        if (StringUtils.isBlank((Object)avatarPath)) {
            absAvatarPath = WfUtils.getAbsAvatarPathDefault("/images/pc/emotion/default_person_82_82.png");
        } else {
            String avatarPathStr = avatarPath.toString().toLowerCase(Locale.getDefault());
            if (avatarPathStr.startsWith("http")) {
                absAvatarPath = avatarPath.toString();
            } else {
                String AVATAR_ADMIN = "/icons/pc/other/superAdministrators_38_38.png";
                String AVATAR_COSMIC_AD = "/private/universe_ad.png";
                String AVATAR_SUPER_AD = "/private/super_ad.png";
                String AVATAR_AUDIT_AD = "/private/audit_ad.png";
                String AVATAR_SAFE_AD = "/private/safe_ad.png";
                absAvatarPath = !AVATAR_ADMIN.equals(avatarPath) && !AVATAR_COSMIC_AD.equals(avatarPath) && !AVATAR_SUPER_AD.equals(avatarPath) && !AVATAR_AUDIT_AD.equals(avatarPath) && !AVATAR_SAFE_AD.equals(avatarPath) ? UrlService.getImageFullUrl((String)avatarPath.toString()) : WfUtils.getAbsAvatarPathDefault(avatarPath.toString());
            }
        }
        return absAvatarPath;
    }

    public static String getBillNo(DynamicObject model) {
        try {
            if (model == null) {
                return "";
            }
            IDataEntityType dataEntityType = model.getDataEntityType();
            if (dataEntityType instanceof MainEntityType) {
                MainEntityType type = (MainEntityType)dataEntityType;
                return TaskBehaviorUtil.getTaskBillNo(type, model);
            }
        }
        catch (Throwable error) {
            logger.warn("\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u5931\u8d25" + error);
        }
        return "";
    }

    public static String getAbsAvatarPathDefault(String avatarPath) {
        String domainConfig = UrlService.getDomainContextUrl();
        if (null != domainConfig && domainConfig.endsWith("/")) {
            domainConfig = domainConfig.substring(0, domainConfig.length() - 1);
        }
        return domainConfig + avatarPath;
    }

    public static String validateBusinessId(String businessId) {
        String errorMsg = "";
        if (businessId == null || !Pattern.matches("^[A-Za-z][A-Za-z0-9_]*$", businessId)) {
            errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u6d41\u7a0b\u6807\u8bc6\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"MainProcessValidator_14", (String)"bos-wf-engine", (Object[])new Object[0]), errorMsg);
        } else if (businessId.length() > 80) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u6807\u8bc6\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26\u3002", (String)"MainProcessValidator_16", (String)"bos-wf-engine", (Object[])new Object[0]), errorMsg);
        } else if (Pattern.matches("([A-Za-z0-9_])*[A-Za-z](Task|Activity|SubProcess|Node|Element|Gateway|Flow|Event)([A-Za-z0-9_])*", businessId)) {
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u6807\u8bc6\u201d\u4e0d\u80fd\u5305\u542b\u201cTask\u201d\u3001\u201cActivity\u201d\u3001\u201cSubProcess\u201d\u3001\u201cNode\u201d\u3001\u201cElement\u201d\u3001\u201cGateway\u201d\u3001\u201cFlow\u201d\u7b49\u6d41\u7a0b\u5173\u952e\u5b57\u3002", (String)"MainProcessValidator_17", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    public static boolean compareToArr(Object[] arr1, Object[] arr2) {
        if (arr1 == null || arr2 == null || arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i] != null && arr1[i].equals(arr2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isUserDisplaySetting(UserTask task) {
        return task.getParticipant().isDisplaySetting() || WfConfigurationUtil.isDisplaySetting();
    }

    public static String getUserMainJob(Long userId, String lang) {
        DynamicObject dynamicObject;
        String position = null;
        String selectFields = "user.id,position";
        QFilter idFilter = new QFilter("user.id", "=", (Object)userId);
        QFilter mainFilter = new QFilter("ispartjob", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{idFilter, mainFilter};
        DynamicObject[] userCol = BusinessDataServiceHelper.load((String)"bos_userposition", (String)selectFields, (QFilter[])filters);
        DynamicObject dynamicObject2 = dynamicObject = userCol != null && userCol.length > 0 ? userCol[0] : null;
        if (dynamicObject != null) {
            ILocaleString positionLocaleString = dynamicObject.getLocaleString("position");
            if (positionLocaleString != null && WfUtils.isNotEmpty(positionLocaleString)) {
                position = WfUtils.isNotEmpty((String)positionLocaleString.getItem(lang)) ? (String)positionLocaleString.getItem(lang) : (String)positionLocaleString.getDefaultItem();
            }
            logger.debug("positionLocaleString" + positionLocaleString + ";position:" + position);
        }
        return position;
    }

    public static ILocaleString getUserMainJobByUserId(Long userId) {
        String selectFields = "user.id,position";
        QFilter idFilter = new QFilter("user.id", "=", (Object)userId);
        QFilter mainFilter = new QFilter("ispartjob", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{idFilter, mainFilter};
        DynamicObject[] userCol = BusinessDataServiceHelper.load((String)"bos_userposition", (String)selectFields, (QFilter[])filters);
        DynamicObject dynamicObject = userCol != null && userCol.length > 0 ? userCol[0] : null;
        return dynamicObject != null ? dynamicObject.getLocaleString("position") : new LocaleString();
    }

    public static boolean isJSONFormat(Object object) {
        if (null != object) {
            String objectStr = object.toString();
            return objectStr.startsWith("{") && objectStr.endsWith("}");
        }
        return false;
    }

    public static boolean isJSONObject(Object object) {
        if (StringUtils.isNotBlank((Object)object)) {
            try {
                JSONObject.parseObject((String)object.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String mapToStr(Object obj) {
        String value = "";
        value = obj instanceof Map ? SerializationUtils.toJsonString((Object)obj) : (String)obj;
        return value;
    }

    public static String mapToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (!(object instanceof Map)) {
            return (String)object;
        }
        Map map = (Map)object;
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry entry : map.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static String buildUrlInfo(DynamicObject obj, VariableScope bvs, Map<String, Object> configMap, String pk) {
        String formId = "";
        String mobFormId = "";
        Long pkId = null;
        if (!StringUtils.isBlank((CharSequence)pk)) {
            pkId = Long.valueOf(pk);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            if ("formId".equals(entry.getKey())) {
                formId = (String)ExpressionCalculatorUtil.parseValue((DynamicObject)obj, (VariableScope)bvs, (String)((String)entry.getValue()), new HashMap());
                continue;
            }
            if ("mob_formId".equals(entry.getKey())) {
                mobFormId = (String)ExpressionCalculatorUtil.parseValue((DynamicObject)obj, (VariableScope)bvs, (String)((String)entry.getValue()), new HashMap());
                continue;
            }
            param.put(entry.getKey(), (String)ExpressionCalculatorUtil.parseValue((DynamicObject)obj, (VariableScope)bvs, (String)((String)entry.getValue()), new HashMap()));
        }
        param.put("src", WFAPPNUMBER);
        Map builMessageUrl = MessageCenterServiceHelper.builMessageUrl((String)formId, (String)mobFormId, (Long)pkId, param);
        return (String)builMessageUrl.get("data");
    }

    @Deprecated
    public static String pluginCalculator(Map<String, Object> pluginMap, EventDispatchContext edContext) {
        return BecUtils.pluginCalculator(pluginMap, (EventDispatchContext)edContext);
    }

    public static void wrapMessageInfoMutil(String title, String content, String busineseeKey, String entityNumber, BusinessModelVariableScope bvs, MessageInfo messageInfo) {
        String lang = RequestContext.get().getLang().toString();
        LocaleString emailContentLocales = new LocaleString();
        LocaleString emailTitleLocales = new LocaleString();
        if (WfUtils.isJSONObject(title) || WfUtils.isJSONObject(content)) {
            JSONObject contentObj = JSONObject.parseObject((String)content);
            Set entrySetContent = contentObj.entrySet();
            for (Map.Entry entry : entrySetContent) {
                emailContentLocales.setItem((String)entry.getKey(), (Object)ExpressionCalculatorUtil.contentParser((String)((String)entry.getValue()), (String)busineseeKey, (String)entityNumber, (VariableScope)bvs, (String)((String)entry.getKey()), (boolean)Boolean.FALSE));
            }
            JSONObject titleObj = JSONObject.parseObject((String)title);
            Set entrySetTitle = titleObj.entrySet();
            for (Map.Entry entry : entrySetTitle) {
                emailTitleLocales.setItem((String)entry.getKey(), (Object)ExpressionCalculatorUtil.contentParser((String)((String)entry.getValue()), (String)busineseeKey, (String)entityNumber, (VariableScope)bvs, (String)((String)entry.getKey()), (boolean)Boolean.FALSE));
            }
        } else {
            emailContentLocales.setItem(lang, (Object)ExpressionCalculatorUtil.contentParser((String)content, (String)busineseeKey, (String)entityNumber, (VariableScope)bvs, (String)lang, (boolean)Boolean.FALSE));
            emailTitleLocales.setItem(lang, (Object)ExpressionCalculatorUtil.contentParser((String)title, (String)busineseeKey, (String)entityNumber, (VariableScope)bvs, (String)lang, (boolean)Boolean.FALSE));
        }
        messageInfo.setMessageContent((ILocaleString)emailContentLocales);
        messageInfo.setMessageTitle((ILocaleString)emailTitleLocales);
    }

    public static void wrapMessageInfoMutil(String title, String content, VariableScope vs, MessageInfo messageInfo) {
        String lang = RequestContext.get().getLang().toString();
        LocaleString emailContentLocales = new LocaleString();
        LocaleString emailTitleLocales = new LocaleString();
        if (WfUtils.isJSONObject(title) || WfUtils.isJSONObject(content)) {
            JSONObject contentObj = JSONObject.parseObject((String)content);
            Set entrySetContent = contentObj.entrySet();
            for (Map.Entry entry : entrySetContent) {
                vs.setTransientVariable("lang", entry.getKey());
                emailContentLocales.setItem((String)entry.getKey(), (Object)ExpressionCalculatorUtil.contentParser((String)((String)entry.getValue()), null, (VariableScope)vs, (boolean)false));
            }
            JSONObject titleObj = JSONObject.parseObject((String)title);
            Set entrySetTitle = titleObj.entrySet();
            for (Map.Entry entry : entrySetTitle) {
                vs.setTransientVariable("lang", entry.getKey());
                emailTitleLocales.setItem((String)entry.getKey(), (Object)ExpressionCalculatorUtil.contentParser((String)((String)entry.getValue()), null, (VariableScope)vs, (boolean)false));
            }
        } else {
            vs.setTransientVariable("lang", (Object)RequestContext.get().getLang().toString());
            emailContentLocales.setItem(lang, (Object)ExpressionCalculatorUtil.contentParser((String)content, null, (VariableScope)vs, (boolean)false));
            emailTitleLocales.setItem(lang, (Object)ExpressionCalculatorUtil.contentParser((String)title, null, (VariableScope)vs, (boolean)false));
        }
        vs.removeTransientVariable("lang");
        messageInfo.setMessageContent((ILocaleString)emailContentLocales);
        messageInfo.setMessageTitle((ILocaleString)emailTitleLocales);
    }

    public static boolean isEmailChannel(String channelName) {
        return MessageChannelUtils.isEmailChannel((String)channelName);
    }

    public static boolean contains(Object[] arrays, Object obj) {
        if (WfUtils.isNotEmptyForArrays(arrays) && StringUtils.isNotBlank((Object)obj)) {
            List<Object> list = Arrays.asList(arrays);
            return list.contains(obj);
        }
        return false;
    }

    public static String getQuestionMarkList(int size) {
        StringBuilder questionMark = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            questionMark.append(" ?");
            if (i == size - 1) continue;
            questionMark.append(',');
        }
        return questionMark.toString();
    }

    public static Map<String, Object> parseUrlParams(String url) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String[] urlParts = url.split("\\?");
        String[] params = urlParts[urlParts.length - 1].split("&");
        String urlPartKey = null;
        String urlPartValue = null;
        String urlPartValueTemp = null;
        for (String param : params) {
            if (!param.contains("=")) continue;
            String[] keyValue = param.split("=");
            urlPartKey = keyValue[0];
            urlPartValue = null;
            urlPartValueTemp = null;
            if (keyValue.length > 1) {
                urlPartValueTemp = keyValue[1];
            }
            if (WfUtils.isNotEmpty(urlPartKey) && WfUtils.isNotEmpty(urlPartValueTemp)) {
                urlPartValue = "pCaption".equals(urlPartKey) || "mCaption".equals(urlPartKey) ? YunzhijiaCommonUtil.decode((String)urlPartValueTemp) : urlPartValueTemp;
            }
            paramMap.put(urlPartKey, urlPartValue);
        }
        return paramMap;
    }

    public static String transBlank(Object value) {
        if (WfUtils.isNullObject(value)) {
            return "";
        }
        return value.toString();
    }

    public static boolean isTileMenuModel() {
        CustomParam customParam = new CustomParam();
        customParam.setGroupNumber("kd_svc_customerparam");
        HashSet<String> keys = new HashSet<String>();
        keys.add("tile_menu_mode_enable");
        customParam.setSearchKeySet(keys);
        Map parameterMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        String tileMenuModeEnable = (String)parameterMap.get("tile_menu_mode_enable");
        if (WfUtils.isNotEmpty(tileMenuModeEnable) && "true".equalsIgnoreCase(tileMenuModeEnable)) {
            return NewPortalServiceHelper.isPersonalSettingNewPortal();
        }
        return false;
    }

    static {
        ids = new String[]{"127", "0", "0", "1"};
    }
}

