/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.Pair;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.AuditPoint;
import kd.bos.workflow.bpmn.model.AuditPointModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoCoordinate;
import kd.bos.workflow.bpmn.model.AutoCoordinateModel;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.bpmn.model.ExpireModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculator;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.LastAssigneeMacroParserImpl;
import kd.bos.workflow.engine.impl.calculator.MacroParser;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.GetParticipantByInstanceFirstCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.impl.util.workCalendar.WorkCalendarUtil;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.engine.task.auditpoint.AuditPointCheckResult;
import kd.bos.workflow.engine.task.auditpoint.AuditPointType;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.relservice.BusinessObjectQueryHelper;
import kd.bos.workflow.service.WfTraceType;
import org.apache.commons.lang.StringUtils;

public class TaskBehaviorUtil {
    public static final String SPLITFORVALIDATEOPERATION = ",";
    private static final String REGEX = "^((\\{.+?\\})|([a-zA-Z_\\d]+))?,((\\{.+?\\})|([a-zA-Z_\\d]+))?$";
    private static final String ISPASSED = "isPassed";
    private static final char TRUSTNAMEFORMATSTR = '|';
    public static final String SPLITSTR = "_";
    public static final String EXTRAS = "extras";
    public static final String NODE_EXT_AUDIT_NUMS = "extNum";
    public static final String ALLOW_SIGN = "aS";
    public static final String FORCE_SIGN = "fS";
    public static final String TASK_CONTROL = "taskcontrol";
    protected static Log logger = LogFactory.getLog(TaskBehaviorUtil.class);

    public static TaskEntity buildTaskEntityWithParticipant(DelegateExecution execution, UserTask userTask, Map<String, String> nodeIdMapAuditNumber, Map<String, String> nodeIdMapAgreePersonId, String lastAssign, Map<String, String> nodeIdMapExecutionType) {
        TaskEntity task;
        block3: {
            task = TaskBehaviorUtil.buildTaskEntityForNextNode(execution, userTask);
            Object throwExceptionObj = execution.getTransientVariable("throwException");
            execution.removeTransientVariable("throwException");
            try {
                ((ExecutionEntity)execution).setCurrentTaskOnly(task);
                CommandContext commandContext = Context.getCommandContext();
                ParticipantCalculator participantCalculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
                List userIds = participantCalculator.getNextTaskUsers(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getBusinessKey(), (VariableScope)execution, nodeIdMapAuditNumber, nodeIdMapAgreePersonId, lastAssign, nodeIdMapExecutionType);
                TaskBehaviorUtil.updateParticipantVariable(task, userIds, userTask == null || userTask.getParticipant() == null ? false : userTask.getParticipant().isAllowNoneParticipant());
            }
            catch (Exception e) {
                if (userTask != null) {
                    logger.warn(String.format("\u8282\u70b9[%s]\u8ba1\u7b97\u53c2\u4e0e\u4eba\u51fa\u9519,\u9519\u8bef\u4fe1\u606f[%s]", userTask.getName(), e.getMessage()));
                }
                if (null == throwExceptionObj || !Boolean.parseBoolean(throwExceptionObj.toString())) break block3;
                throw e;
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskEntity buildTaskEntity(DelegateExecution execution, UserTask userTask) {
        BillSetting billSetting;
        ExecutionEntity mainExecution;
        Long startUserId;
        CommandContext commandContext = Context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        TaskEntity task = (TaskEntity)taskEntityManager.create();
        ExecutionEntity branchExecution = (ExecutionEntity)execution;
        task.setExecution((ExecutionEntity)execution);
        task.setTaskDefinitionKey(userTask.getId());
        task.setProcessDefinitionId(execution.getProcessDefinitionId());
        task.setProcessInstanceId(execution.getProcessInstanceId());
        task.setExecutionId(execution.getId());
        task.setProcessType(((ExecutionEntity)execution).getProcessType());
        String activeTaskDescription = null;
        ExpireModel activeTaskDueDate = null;
        String activeTaskPriority = null;
        String activeTaskFormKey = null;
        String activeTaskMobileFormKey = null;
        String activeTaskProcessingPage = null;
        String activeTaskProcessingMobilePage = null;
        boolean activeTaskDisplay = true;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        TaskHelper taskHelper = processEngineConfiguration.getTaskHelper();
        activeTaskDescription = userTask.getDocumentation();
        activeTaskDueDate = userTask.getExpireModel();
        activeTaskPriority = userTask.getPriority();
        activeTaskFormKey = userTask.getBillSetting().getFormKey();
        activeTaskMobileFormKey = userTask.getBillSetting().getMobilFormKey();
        activeTaskProcessingPage = userTask.getProcessingPage();
        activeTaskProcessingMobilePage = userTask.getProcessingMobilePage();
        activeTaskDisplay = !userTask.isHideTaskInCenter();
        task.setName(TaskBehaviorUtil.getTaskName(execution, userTask, expressionManager));
        task.setDescription(TaskBehaviorUtil.getTaskDescription(execution, activeTaskDescription, expressionManager));
        task.setDueDate(TaskBehaviorUtil.getTaskDueDate(execution, userTask, expressionManager));
        task.setPriority(TaskBehaviorUtil.getTaskPriority(execution, expressionManager, userTask.getPriority()));
        task.setFormKey(TaskBehaviorUtil.getTaskFormKey(execution, expressionManager, activeTaskFormKey));
        String businessKey = execution.getBusinessKey();
        String entityNumber = branchExecution.getEntityNumber();
        task.setBusinessKey(businessKey);
        task.setEntityNumber(entityNumber);
        TaskBehaviorUtil.setEntityProperties(task, entityNumber, businessKey);
        task.setSource("WF");
        if (WfUtils.isNotEmpty(activeTaskMobileFormKey)) {
            task.setMobileFormKey(activeTaskMobileFormKey);
        }
        String processingPage = activeTaskProcessingPage;
        task.setProcessingPage(processingPage);
        String processingMobilePage = activeTaskProcessingMobilePage;
        task.setProcessingMobilePage(processingMobilePage);
        task.setExecutionType("byHand");
        task.setHandleState("willHandled");
        if (taskHelper.isRejectTask(execution.getProcessInstanceId(), execution.getCurrentActInstId(), userTask.getId())) {
            task.setHandleState("dismissed");
        }
        if (WfUtils.isEmpty(startUserId = branchExecution.getStartUserId()) && null != (mainExecution = branchExecution.getProcessInstance())) {
            startUserId = mainExecution.getStartUserId();
        }
        task.setStarterId(startUserId);
        task.setStartName(WfUtils.findUserName(startUserId));
        task.setStartNameFormat(branchExecution.getStarUserNameFormat());
        try {
            MacroParser macroParser = processEngineConfiguration.getMacroParser("lastAssignee");
            String senderIds = (String)macroParser.parseMacro(task.getExecution());
            task.setSenderId(senderIds);
            if (macroParser instanceof LastAssigneeMacroParserImpl) {
                Map senderNamesMap = ((LastAssigneeMacroParserImpl)macroParser).getAssigneeNameFormat(task.getExecution());
                ILocaleString senderNames = (ILocaleString)senderNamesMap.get("senderNames");
                ILocaleString senderNameFormats = (ILocaleString)senderNamesMap.get("senderNameFormats");
                task.setSenderName(senderNames);
                task.setSenderNameFormat(senderNameFormats);
            }
        }
        finally {
            commandContext.removeAttribute("lastAssignee");
        }
        task.setDisplay(activeTaskDisplay);
        task.setEndType(TaskBehaviorUtil.getTaskEndType(userTask));
        task.setCategory(userTask.getType());
        task.setTransientVariablesLocal(TaskBehaviorUtil.processVariables(userTask.getVariables(), (FlowElement)userTask));
        task.setYzjGroupId("0");
        task.setBillNo(branchExecution.getBillNo());
        Object bizTraceNo = execution.getVariable("biztraceno");
        if (bizTraceNo != null) {
            task.setBizTraceNo(String.valueOf(bizTraceNo));
        }
        if (BpmnModelUtil.instanceofAuditTask((String)userTask.getType()) && (billSetting = userTask.getBillSetting()) != null) {
            String operationWhenSubmit = billSetting.getOperationWhenSubmit();
            String operationWhenReject = billSetting.getOperationWhenReject();
            if (WfUtils.isNotEmpty(operationWhenSubmit) || WfUtils.isNotEmpty(operationWhenReject)) {
                String validateOperation = operationWhenSubmit + SPLITFORVALIDATEOPERATION + operationWhenReject;
                task.setValidateOperation(validateOperation);
            }
        }
        TaskBehaviorUtil.buildControl(userTask, task);
        return task;
    }

    private static void buildControl(UserTask element, TaskEntity task) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List nodeCustomParams = element.getCustomParams();
        if (nodeCustomParams != null && nodeCustomParams.size() > 0) {
            HashMap<String, String> controlMap = new HashMap<String, String>();
            for (CustomParam customParam : nodeCustomParams) {
                String[] strArray;
                String number = customParam.getNumber();
                if (!WfUtils.isNotEmpty(number) || !number.contains(SPLITSTR) || !WfUtils.isNotEmptyForArrays(strArray = number.split(SPLITSTR)) || !WfUtils.isNotEmpty(number = strArray[0]) || controlMap.get(number) != null && !"true".equals(customParam.getValue())) continue;
                controlMap.put(number, customParam.getValue());
            }
            if (WfUtils.isNotEmptyForMap(controlMap)) {
                map.put(EXTRAS, controlMap);
            }
        }
        if (null != element && null != element.getCirculateModel()) {
            map.put("circulate", String.valueOf(element.getCirculateModel().isCirculateWhenMatch()));
        }
        if (element instanceof AuditTask) {
            BillSetting billSetting = ((AuditTask)element).getBillSetting();
            if (null != billSetting) {
                map.put("dataSignedAdd", billSetting.isDataSignedAdd());
                map.put("dataSignedVerify", billSetting.isDataSignedVerify());
            }
            AuditTask auditTask = (AuditTask)element;
            TaskBehaviorUtil.handleAuditNodeExtInMap(auditTask, map);
            TaskBehaviorUtil.handleForceSignature(auditTask, map);
        }
        map.put("transfer", element.isAllowTransfer());
        String latestForkNodeKey = TaskBehaviorUtil.getLatestForkNodeId(element, task);
        if (WfUtils.isNotEmpty(latestForkNodeKey)) {
            map.put("lfn", latestForkNodeKey);
        }
        if (!map.isEmpty()) {
            task.setControl(SerializationUtils.toJsonString(map));
        }
    }

    private static String getLatestForkNodeId(UserTask element, TaskEntity task) {
        if (element instanceof AuditTask && ((AuditTask)element).isDynamicReject()) {
            Process process = ProcessDefinitionUtil.getProcess((Long)task.getProcessDefinitionId(), (Long)task.getProcessInstanceId());
            Map models = process.getForkJoinModels();
            NodeForkJoinModel model = (NodeForkJoinModel)models.get(element.getId());
            if (model == null || WfUtils.isEmpty(model.getLatestForkNode())) {
                return null;
            }
            String forkNodeId = model.getLatestForkNode();
            int cycle = ForkJoinUtils.getEnterForkCycle((String)forkNodeId, (ExecutionEntity)task.getProcessInstance());
            return String.format("%s_%s_%s", process.getFlowElement(forkNodeId).getNumber(), cycle, "forkRejectKey");
        }
        return null;
    }

    private static String getExpire(Object expireObject, String timeType) {
        String expire = "";
        if (expireObject instanceof Number) {
            long expireLong = ((Number)expireObject).longValue();
            expire = expireLong + timeType;
        } else if (expireObject instanceof String) {
            try {
                String str = expireObject.toString().trim();
                if (str.matches("^-?\\d+$")) {
                    Long expireObjectLong = Long.valueOf(str);
                    expire = expireObjectLong + timeType;
                    return expire;
                }
                if (str.matches("^(-?\\d+)(\\.\\d+)?$")) {
                    BigDecimal expireObjectBigDecimal = new BigDecimal(str);
                    expire = expireObjectBigDecimal.longValue() + timeType;
                }
            }
            catch (NumberFormatException e) {
                return expire;
            }
        }
        return expire;
    }

    public static TaskEntity buildTaskEntityForNextNode(DelegateExecution execution, UserTask userTask) {
        CommandContext commandContext = Context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        TaskEntity task = (TaskEntity)taskEntityManager.create();
        ExecutionEntity mainExecution = ((ExecutionEntity)execution).getProcessInstance();
        task.setExecution((ExecutionEntity)execution);
        task.setTaskDefinitionKey(userTask.getId());
        task.setProcessDefinitionId(execution.getProcessDefinitionId());
        task.setProcessInstanceId(execution.getProcessInstanceId());
        task.setExecutionId(execution.getId());
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        String activeTaskDescription = userTask.getDocumentation();
        String activeTaskFormKey = userTask.getBillSetting().getFormKey();
        if (userTask.isAddSign()) {
            task.setName(TaskBehaviorUtil.getTaskName(commandContext, execution, userTask));
        } else {
            task.setName(TaskBehaviorUtil.getTaskName(execution, userTask, expressionManager));
        }
        task.setDescription(activeTaskDescription);
        task.setFormKey(activeTaskFormKey);
        task.setSource("WF");
        String businessKey = execution.getBusinessKey();
        String entityNumber = userTask.getEntityNumber();
        task.setBusinessKey(businessKey);
        task.setEntityNumber(entityNumber);
        TaskBehaviorUtil.setEntityProperties(task, entityNumber, businessKey);
        task.setExecutionType("byHand");
        task.setHandleState("willHandled");
        if (BpmnModelUtil.instanceofAuditTask((String)userTask.getType())) {
            task.setHandleState("willApproval");
        }
        task.setStarterId(mainExecution.getStartUserId());
        ILocaleString startName = (ILocaleString)commandContext.getResoledResult("buildTask_startName");
        if (startName != null && mainExecution != null) {
            startName = WfUtils.findUserName(mainExecution.getStartUserId());
            commandContext.setResolvedResult("buildTask_startName", (Object)startName);
        }
        task.setStartName(startName);
        task.setCategory(userTask.getType());
        task.setTransientVariablesLocal(TaskBehaviorUtil.processVariables(userTask.getVariables(), (FlowElement)userTask));
        task.setYzjGroupId("0");
        String billnoKey = entityNumber + "." + businessKey + ".buildTask_billno";
        String billno = (String)commandContext.getResoledResult(billnoKey);
        if (WfUtils.isEmpty(billno)) {
            billno = TaskBehaviorUtil.getTaskBillNoWithJob(entityNumber, businessKey);
            commandContext.setResolvedResult(billnoKey, (Object)billno);
        }
        task.setBillNo(billno);
        Long id = TaskHelper.addGroupInfo((TaskEntity)task, (ExecutionEntity)mainExecution);
        task.setGroupNumber(id);
        return task;
    }

    protected static void setEntityProperties(TaskEntity task, String entityNumber, String businessKey) {
        Map<String, Object> entityProperties = WfUtils.getEntityProperties(entityNumber, businessKey);
        if (!entityProperties.isEmpty()) {
            LocaleString entityName;
            String billType = (String)entityProperties.get("billType");
            if (WfUtils.isNotEmpty(billType)) {
                task.setBillType(billType);
            }
            if (WfUtils.isNotEmpty((ILocaleString)(entityName = (LocaleString)entityProperties.get("entityName")))) {
                task.setEntityName((ILocaleString)entityName);
            }
        }
    }

    public static String getTaskDescription(DelegateExecution execution, String activeTaskDescription, ExpressionManager expressionManager) {
        return activeTaskDescription;
    }

    public static String getTaskFormKey(DelegateExecution execution, ExpressionManager expressionManager, String activeTaskFormKey) {
        return activeTaskFormKey;
    }

    public static String getTaskEndType(UserTask userTask) {
        if (userTask instanceof BillTask) {
            return "pc";
        }
        if (WfUtils.isEmpty(userTask.getEndType())) {
            return "all";
        }
        return userTask.getEndType();
    }

    public static int getTaskPriority(DelegateExecution execution, ExpressionManager expressionManager, String activeTaskPriority) {
        Object priority;
        int taskPriority = 0;
        if (StringUtils.isNotEmpty((String)activeTaskPriority) && (priority = expressionManager.createExpression(activeTaskPriority).getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    taskPriority = Integer.parseInt((String)priority);
                }
                catch (NumberFormatException e) {
                    throw new WFIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                taskPriority = ((Number)priority).intValue();
            } else {
                throw new WFIllegalArgumentException("Priority expression does not resolve to a number: " + activeTaskPriority);
            }
        }
        return taskPriority;
    }

    public static Date getTaskDueDate(DelegateExecution execution, UserTask userTask, ExpressionManager expressionManager) {
        Date taskDueDate = null;
        ExpireModel activeTaskDueDate = userTask.getExpireModel();
        if (activeTaskDueDate != null && activeTaskDueDate.isExpirebtn() && WfUtils.isNotEmpty(activeTaskDueDate.getExpireTime())) {
            String expire = activeTaskDueDate.getExpireTime();
            String type = activeTaskDueDate.getExpireType();
            String timeType = activeTaskDueDate.getTimeUnit();
            String expressionType = activeTaskDueDate.getExpressionType();
            if ("plugin".equals(type)) {
                expire = String.valueOf(ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.TIMECONTROL, expire, execution)) + timeType;
            } else if ("expression".equals(type) && expire.startsWith("${")) {
                Object expireObject = expressionManager.createExpression(expire).getValue((VariableScope)execution);
                if (expireObject instanceof List) {
                    List expireList = (List)expireObject;
                    for (int i = 0; i < expireList.size(); ++i) {
                        String expireSingle = String.valueOf(expireList.get(i));
                        if (!WfUtils.isNotEmpty(expireSingle)) continue;
                        if (ExpressionPropUtils.isExpressionDateType((String)expressionType)) {
                            return TaskBehaviorUtil.directGetDate(expireList.get(i));
                        }
                        expire = TaskBehaviorUtil.getExpire(expireList.get(i), timeType);
                        break;
                    }
                } else {
                    if (ExpressionPropUtils.isExpressionDateType((String)expressionType)) {
                        return TaskBehaviorUtil.directGetDate(expireObject);
                    }
                    expire = TaskBehaviorUtil.getExpire(expireObject, timeType);
                }
            } else if ("fixedValue".equals(type)) {
                expire = expire + timeType;
            }
            if (WfUtils.isNotEmpty(expire)) {
                Long orgId = TaskBehaviorUtil.getOrgUnitId(execution);
                taskDueDate = TaskBehaviorUtil.expireGetDueDate(expire, orgId);
                logger.debug(String.format("get calculate expire date is-[%s]", taskDueDate));
            }
        }
        return taskDueDate;
    }

    private static void handleAuditNodeExtInMap(AuditTask element, Map<String, Object> map) {
        List extPluginList = NodeTemplateUtil.getExtPluginsByType((FlowElement)element, (String)element.getType(), (String)"auditListeners");
        Set collect = extPluginList.stream().map(t -> TaskBehaviorUtil.buildNodeExdNumControlKey(t.getString("nodeTemplateNum"), t.getString("pluginNumber"))).collect(Collectors.toSet());
        if (WfUtils.isEmptyForCollection(collect)) {
            return;
        }
        map.put(NODE_EXT_AUDIT_NUMS, collect);
    }

    private static void handleForceSignature(AuditTask auditTask, Map<String, Object> map) {
        Pair signatureValue = SignatureUtils.getSignatureValue((AuditTask)auditTask);
        if (((Boolean)signatureValue.getKey()).booleanValue()) {
            map.put(ALLOW_SIGN, Boolean.TRUE);
        }
        if (((Boolean)signatureValue.getValue()).booleanValue()) {
            map.put(FORCE_SIGN, Boolean.TRUE);
        }
    }

    public static String buildNodeExdNumControlKey(String nodeTemplateNum, String pluginNumber) {
        return nodeTemplateNum + "#" + pluginNumber;
    }

    private static Date directGetDate(Object expireObject) {
        Date expireDate = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (expireObject instanceof Date) {
                expireDate = (Date)expireObject;
            } else if (expireObject instanceof String) {
                expireDate = dateFormat.parse(expireObject.toString().trim());
            }
        }
        catch (ParseException ex) {
            logger.warn(WfUtils.getExceptionStacktrace(ex));
            return expireDate;
        }
        return expireDate;
    }

    private static ILocaleString getTaskName(CommandContext commandContext, DelegateExecution execution, UserTask userTask) {
        LocaleString taskName = new LocaleString();
        DynamicResourceEntityManager dynamicResourceEntityManager = commandContext.getProcessEngineConfiguration().getDynamicResourceEntityManager();
        dynamicResourceEntityManager.findByActivityId(execution.getProcessInstanceId(), execution.getCurrentActivityId());
        QFilter q1 = new QFilter("processinstanceid", "=", (Object)execution.getProcessInstanceId());
        QFilter q2 = new QFilter("activityinstanceid", "=", (Object)execution.getCurrentActInstId());
        List dynamicResourceEntities = dynamicResourceEntityManager.findByQueryFilters(new QFilter[]{q1, q2});
        if (dynamicResourceEntities != null && !dynamicResourceEntities.isEmpty()) {
            for (DynamicResourceEntity dynamicResourceEntity : dynamicResourceEntities) {
                ILocaleString contentString = dynamicResourceEntity.getContent();
                for (Lang lang : WfUtils.getSupportLangs()) {
                    String key = lang.name();
                    String content = (String)contentString.get((Object)key);
                    BpmnModel dynBpmnModel = ProcessDefinitionUtil.getBpmnModel((String)content);
                    FlowElement flowElement = dynBpmnModel.getFlowElement(userTask.getId());
                    if (flowElement == null) continue;
                    taskName.put(key, (Object)flowElement.getName());
                }
            }
        }
        return taskName;
    }

    public static ILocaleString getTaskSubject(UserTask userTask, TaskEntity task, String businessKey, String entityNumber) {
        ILocaleString subject = null;
        if (StringUtils.isNotEmpty((String)businessKey.trim())) {
            BillSubjectCalculator billSubjectCalculator = Context.getCommandContext().getProcessEngineConfiguration().getBillSubjectCalculator();
            List billSubjectModels = userTask.getSubject();
            subject = billSubjectCalculator.getSubjectByBillSubjectModel(billSubjectModels, businessKey, entityNumber, (VariableScope)task);
        }
        return subject;
    }

    public static String getTaskBillNoWithJob(String entityNumber, String businessKey) {
        String billNo = "";
        if (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
            billNo = WfTraceType.get().getJobInfo().getBillNo();
        }
        if (WfUtils.isNotEmpty(billNo)) {
            return billNo;
        }
        return TaskBehaviorUtil.getTaskBillNo(entityNumber, businessKey);
    }

    public static String getTaskBillNo(String entityNumber, String businessKey) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String fields = null;
        if (entityType instanceof BasedataEntityType) {
            String number = ((BasedataEntityType)entityType).getNumberProperty();
            String name = ((BasedataEntityType)entityType).getNameProperty();
            fields = number + ", " + name;
        } else if (entityType instanceof BillEntityType) {
            fields = ((BillEntityType)entityType).getBillNo();
        }
        DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber, fields);
        return TaskBehaviorUtil.getTaskBillNo(entityType, dynObj);
    }

    public static String getTaskBillNo(String entityNumber, DynamicObject dynObj) {
        MainEntityType entityType = BusinessObjectQueryHelper.getDataEntityType((String)entityNumber);
        return TaskBehaviorUtil.getTaskBillNo(entityType, dynObj);
    }

    public static String getTaskBillNo(MainEntityType entityType, DynamicObject dynObj) {
        if (dynObj != null && entityType != null) {
            if (entityType instanceof BasedataEntityType) {
                String baseDataNumber = TaskBehaviorUtil.getBaseDataNumber(entityType, dynObj);
                String baseDataName = TaskBehaviorUtil.getBaseDataName(entityType, dynObj);
                StringBuilder taskBillNo = new StringBuilder();
                if (baseDataNumber != null) {
                    taskBillNo = taskBillNo.append(baseDataNumber);
                }
                if (baseDataName != null) {
                    if (taskBillNo.length() == 0) {
                        taskBillNo = taskBillNo.append(baseDataName);
                    } else if (WfConfigurationUtil.isBillNoWithName()) {
                        taskBillNo = taskBillNo.append("/").append(baseDataName);
                    }
                }
                return taskBillNo == null ? "" : taskBillNo.toString();
            }
            if (entityType instanceof BillEntityType) {
                String billNoNumber = ((BillEntityType)entityType).getBillNo();
                if (StringUtils.isNotBlank((String)billNoNumber)) {
                    String billNo = dynObj.getString(billNoNumber);
                    return billNo == null ? "" : billNo;
                }
            } else {
                logger.debug(String.format("cannot get billno from business object,[%s],exception is has no billno", dynObj.getPkValue()));
            }
        }
        return "";
    }

    private static String getBaseDataName(MainEntityType entityType, DynamicObject dynObj) {
        String name = ((BasedataEntityType)entityType).getNameProperty();
        ILocaleString dynNameLocaleString = null;
        String dynName = null;
        if (StringUtils.isNotBlank((String)name)) {
            Object noTypeName = dynObj.get(name);
            if (noTypeName instanceof ILocaleString) {
                dynNameLocaleString = dynObj.getLocaleString(name);
                String lang = RequestContext.get().getLang().toString();
                dynName = WfMultiLangUtils.getCurrentLang((ILocaleString)dynNameLocaleString, (String)lang);
            } else if (noTypeName instanceof String) {
                dynName = dynObj.getString(name);
            }
        }
        return dynName;
    }

    private static String getBaseDataNumber(MainEntityType entityType, DynamicObject dynObj) {
        String number = ((BasedataEntityType)entityType).getNumberProperty();
        String dynNumber = null;
        if (StringUtils.isNotBlank((String)number)) {
            dynNumber = dynObj.getString(number);
        }
        return dynNumber;
    }

    public static Long getMainOrgId(String entityNumber, DynamicObject dynObj) {
        MainEntityType entityType;
        String orgProp;
        if (dynObj != null && StringUtils.isNotBlank((String)(orgProp = (entityType = EntityMetadataCache.getDataEntityType((String)entityNumber)).getMainOrg()))) {
            DynamicObject org = dynObj.getDynamicObject(orgProp);
            return org != null ? (Long)org.getPkValue() : 0L;
        }
        return null;
    }

    public static String getMainOrgViewId(String entityNumber, DynamicObject dynObj) {
        String orgProp;
        MainEntityType entityType;
        DynamicProperty company;
        if (dynObj != null && (company = ((BillEntityType)(entityType = EntityMetadataCache.getDataEntityType((String)entityNumber))).getProperty(orgProp = entityType.getMainOrg())) instanceof MainOrgProp) {
            MainOrgProp mainOrgProp = (MainOrgProp)company;
            return mainOrgProp.getOrgFunc();
        }
        return "";
    }

    @Deprecated
    public static void calcTaskSubject(UserTask userTask, TaskEntity task, String businessKey) {
        if (StringUtils.isNotEmpty((String)businessKey.trim())) {
            BillSubjectCalculator billSubjectCalculator = Context.getCommandContext().getProcessEngineConfiguration().getBillSubjectCalculator();
            List billSubjectModel = userTask.getSubject();
            ILocaleString subject = billSubjectCalculator.getSubjectByBillSubjectModel(billSubjectModel, businessKey, task.getEntityNumber(), (VariableScope)task);
            task.setSubject(subject);
            DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, task.getEntityNumber(), "billno");
            if (dynObj != null) {
                try {
                    task.setBillNo(dynObj.getString("billno"));
                }
                catch (Exception e) {
                    logger.debug(String.format("cannot get billno from business object,[%s],exception is [%s]", businessKey, e.getMessage()));
                }
            }
        }
    }

    public static void updateParticipantVariable(TaskEntity task, List<Long> userIds, boolean allowNoneParticipant) {
        StringBuilder sb = new StringBuilder();
        if (userIds != null && userIds.size() > 0) {
            for (Long id : userIds) {
                sb.append(id).append(',');
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("currentParticipant", sb.toString().substring(0, sb.toString().length() - 1));
            task.setTransientVariablesLocal(map);
        } else if (allowNoneParticipant) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("currentParticipant", "0");
            task.setTransientVariablesLocal(map);
        }
    }

    public static ILocaleString getUserName(long userId) {
        User user = WfUtils.findUserById(userId);
        return user != null ? user.getName() : null;
    }

    public static Map<String, Object> processVariables(List<Variable> variables, FlowElement elem) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (variables != null) {
            for (Variable variable : variables) {
                if ("auditNumber".equalsIgnoreCase(variable.getName())) {
                    String val = BpmnModelUtil.getDefaultOptionNumber((FlowElement)elem);
                    if (WfUtils.isEmpty(val)) {
                        val = (String)variable.getDefaultValue();
                    }
                    variablesMap.put(variable.getName(), val);
                    continue;
                }
                variablesMap.put(variable.getName(), variable.getDefaultValue());
            }
        }
        return variablesMap;
    }

    private static Date expireGetDueDate(String expire, Long orgId) {
        if (expire.startsWith("0")) {
            return null;
        }
        try {
            char t = expire.charAt(expire.length() - 1);
            int type = 10;
            switch (t) {
                case 'd': {
                    type = 6;
                    break;
                }
                case 'm': {
                    type = 12;
                    break;
                }
            }
            boolean isOpenWorkCalendarForOrg = WfConfigurationUtil.getIsOpenWorkCalendarForOrg(orgId);
            logger.info(String.format("IsOpenWorkCalendarForOrg-[%s],orgId-[%s]", isOpenWorkCalendarForOrg, orgId));
            if (isOpenWorkCalendarForOrg && WfConfigurationUtil.enableWorkCalendar()) {
                String expireTimeStr = expire.substring(0, expire.length() - 1);
                String timeUnit = null;
                timeUnit = type == 10 ? "hour" : (type == 12 ? "min" : "day");
                return WorkCalendarUtil.getCalculationWorkCalendar(timeUnit, expireTimeStr);
            }
            int time = Integer.parseInt(expire.substring(0, expire.length() - 1));
            Date now = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(now);
            c.add(type, time);
            return c.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ILocaleString getTaskName(DelegateExecution execution, UserTask userTask, ExpressionManager expressionManager) {
        FlowElement currentFlowElement = execution.getCurrentFlowElement();
        if (currentFlowElement != null && currentFlowElement.isAddSign()) {
            return BPMNUtil.getAddSignNodeName((ExecutionEntity)((ExecutionEntity)execution), (FlowElement)currentFlowElement);
        }
        String multiKey = BpmnModelUtil.getActivityNameMultiKey((String)userTask.getId());
        ILocaleString localeName = BpmnModelUtil.getMultiLangFieldValue((Long)execution.getProcessInstanceId(), (String)multiKey, (String)userTask.getName());
        if (localeName != null) {
            return localeName;
        }
        return new LocaleString(userTask.getName());
    }

    public static ILocaleString getOperationName(String entityNumber, String operation, ILocaleString defaultValue) {
        Map op;
        if (WfUtils.isNotEmpty(operation) && (op = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operation)) != null && op.get("name") instanceof Map) {
            Map name = (Map)op.get("name");
            LocaleString ret = new LocaleString();
            if (WfUtils.isNotEmptyForMap(name)) {
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    String v = String.valueOf(name.get(lang.name()));
                    if (WfUtils.isEmpty(v) || "null".equalsIgnoreCase(v)) {
                        v = " ";
                    }
                    ret.put((Object)lang.name(), (Object)v);
                }
            }
            return ret;
        }
        return defaultValue;
    }

    public static String getValidateOpByAuditTypeForTask(String validateOp, String auditType, String category) {
        String validate = null;
        if (WfUtils.isNotEmpty(validateOp)) {
            if (validateOp.contains(SPLITFORVALIDATEOPERATION)) {
                validate = TaskBehaviorUtil.getValidationValue(validateOp, auditType);
            } else if ("SSCApprove".equalsIgnoreCase(category)) {
                if ("approve".equalsIgnoreCase(auditType)) {
                    validate = validateOp;
                }
            } else {
                validate = validateOp;
            }
        }
        return validate;
    }

    private static String getValidationValue(String value, String auditType) {
        if ("approve".equalsIgnoreCase(auditType)) {
            return value.replaceFirst(REGEX, "$1");
        }
        return value.replaceFirst(REGEX, "$4");
    }

    public static String getValidateByAuditTypeForBillSetting(BillSetting billSetting, String auditType) {
        String validate = null;
        if (null != billSetting) {
            if ("approve".equalsIgnoreCase(auditType)) {
                validate = billSetting.getOperationWhenSubmit();
            } else if ("reject".equalsIgnoreCase(auditType) || "forceReject".equalsIgnoreCase(auditType)) {
                validate = billSetting.getOperationWhenReject();
            }
        }
        return validate;
    }

    public static List<Long> calcAutoCoordinatorIds(CommandContext commandContext, ExecutionEntity execution, TaskEntity taskEntity, UserTask userTask) {
        List autoCoordinatorIds = null;
        AutoCoordinateModel autoCoordinateModel = userTask.getAutoCoordinateModel();
        if (autoCoordinateModel != null && autoCoordinateModel.getAutoCoordinate() != null && autoCoordinateModel.getAutoCoordinate().getParticipant() != null) {
            AutoCoordinate autoCoordinate = autoCoordinateModel.getAutoCoordinate();
            List autoCoordinateParticipants = autoCoordinate.getParticipant();
            ProcessEngineConfigurationImpl processEngineConfigurationImpl = commandContext.getProcessEngineConfiguration();
            ParticipantCalculator participantCalculator = processEngineConfigurationImpl.getParticipantCalculator();
            ConditionType.logConditionKey((String)"participantAutoCoordinator");
            autoCoordinatorIds = participantCalculator.getUserIds(execution.getBusinessKey(), (VariableScope)execution, autoCoordinateParticipants);
            ConditionType.removeConditionKey();
            List<Long> excludeUserIds = TaskBehaviorUtil.getExcludeUserIds(commandContext, execution, taskEntity, participantCalculator, userTask);
            if (excludeUserIds != null && !excludeUserIds.isEmpty() && autoCoordinatorIds != null && !autoCoordinatorIds.isEmpty()) {
                for (Long excludeUserId : excludeUserIds) {
                    if (!autoCoordinatorIds.contains(excludeUserId)) continue;
                    autoCoordinatorIds.remove(excludeUserId);
                }
            }
        }
        return autoCoordinatorIds;
    }

    private static List<Long> getExcludeUserIds(CommandContext commandContext, ExecutionEntity execution, TaskEntity task, ParticipantCalculator participantCalculator, UserTask userTask) {
        Collection participants;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((Long)task.getProcessDefinitionId(), (Long)task.getProcessInstanceId());
        List<Long> excludeUserIds = new ArrayList();
        AllowNextPersonSettingModel allowNextPersonSettingModel = bpmnModel.getMainProcess().getAllowNextPersonSettingModel();
        boolean allowNextParticipant = WfConfigurationUtil.isAllowNextParticipant();
        if (allowNextParticipant && allowNextPersonSettingModel != null && allowNextPersonSettingModel.isAllowNextPersonWhenMatch()) {
            if (userTask instanceof YunzhijiaTask) {
                participants = new GetParticipantByInstanceFirstCmd(String.valueOf(task.getId()), execution.getActivityId(), execution.getBusinessKey(), userTask.getEntityNumber(), execution.getProcessDefinitionId(), execution.getProcessInstanceId(), null).execute(commandContext);
                excludeUserIds.addAll(participants);
            } else {
                participants = execution.getCurrentTask().getParticipants();
                if (CollectionUtil.isNotEmpty((Collection)participants)) {
                    for (Long participant : participants) {
                        excludeUserIds.add(participant);
                    }
                }
            }
        } else {
            participants = userTask.getParticipant().getParticipant();
            excludeUserIds = participantCalculator.getUserIdsWithPlugin(execution.getBusinessKey(), (VariableScope)execution, userTask, bpmnModel, (List)participants);
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List centerRules = commandContext.getTaskCenterRuleEntityManager().getTaskCenterRulesByUserId(userId);
        block3: for (TaskCenterRuleEntity taskCenterRuleEntity : centerRules) {
            String activitState = taskCenterRuleEntity.getActivitstate();
            if (!"enable".equals(activitState)) continue;
            List operationList = taskCenterRuleEntity.getOperationMetas();
            for (TaskCenterOperationMetaEntity taskCenterOperationMetaEntity : operationList) {
                Map paramMap;
                Object transferUsers;
                if (!"Transfer".equals(taskCenterOperationMetaEntity.getOperationkey())) continue;
                String key = ConditionUtil.getConInstKey((String)(task.getId() + SPLITSTR + userId), (String)"taskAutoRule");
                boolean passVerifyConditions = false;
                try {
                    passVerifyConditions = ConditionUtil.hasTrueCondition((String)taskCenterRuleEntity.getExpression(), (VariableScope)task, (String)key);
                }
                catch (Exception e) {
                    logger.warn(String.format("error occur for rule1[%s],exception is [%s]", taskCenterRuleEntity.getExpression(), e.getMessage()));
                }
                if (!passVerifyConditions || !((transferUsers = (paramMap = (Map)SerializationUtils.fromJsonString((String)taskCenterOperationMetaEntity.getOperateparams(), Map.class)).get("Transfer")) instanceof List) || ((List)transferUsers).size() <= 0) continue;
                Map valMap = (Map)((List)transferUsers).get(0);
                String value = (String)valMap.get("value");
                if (excludeUserIds.contains(Long.valueOf(value))) continue block3;
                excludeUserIds.add(Long.valueOf(value));
                continue block3;
            }
        }
        return excludeUserIds;
    }

    public static void calculateAuditPoint(DelegateExecution execution, AuditTask auditTask) {
        AuditPointModel auditPointModel = auditTask.getAuditPointModel();
        if (auditPointModel == null) {
            return;
        }
        if (!auditPointModel.isAuditPointWhenMatch()) {
            return;
        }
        List auditPoints = auditPointModel.getAuditPoints();
        if (auditPoints == null || auditPoints.isEmpty()) {
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        AuditPointInstanceEntityManager auditPointEntityManager = Context.getCommandContext().getAuditPointInstanceEntityManager();
        int i = 1;
        for (AuditPoint auditPoint : auditPoints) {
            String instructionMultiKey;
            ILocaleString instructionDef;
            AuditPointInstanceEntity auditPointEntity = (AuditPointInstanceEntity)auditPointEntityManager.create();
            String auditPointId = auditPoint.getId();
            auditPointEntity.setAuditPointSeq(i);
            Long processInstanceId = executionEntity.getProcessInstanceId();
            auditPointEntity.setProcessInstanceId(processInstanceId);
            auditPointEntity.setExecutionId(executionEntity.getId());
            auditPointEntity.setActivityInstanceId(executionEntity.getCurrentActInstId());
            auditPointEntity.setTaskId(executionEntity.getCurrentTaskId());
            String activityId = executionEntity.getActivityId();
            auditPointEntity.setActId(activityId);
            Long assigneeId = Long.valueOf(RequestContext.get().getUserId());
            auditPointEntity.setAssigneeId(assigneeId);
            auditPointEntity.setAssigneeName(WfUtils.findUserName(assigneeId));
            String entityNumber = executionEntity.getEntityNumber();
            auditPointEntity.setEntityNumber(entityNumber);
            String businessKey = executionEntity.getBusinessKey();
            auditPointEntity.setBusinessKey(businessKey);
            String auditPointType = auditPoint.getType();
            auditPointEntity.setType(auditPointType);
            ConditionalRuleEntity auditPointRule = auditPoint.getRule();
            String condition = TaskBehaviorUtil.getAuditPointCondRule(auditPointRule);
            auditPointEntity.setCondition(condition);
            Map<String, Object> result = TaskBehaviorUtil.getAuditPointRuleResult((DelegateExecution)executionEntity, auditPointRule, (FlowElement)auditTask);
            Boolean isDisplay = Boolean.FALSE;
            isDisplay = WfUtils.isEmpty(condition) ? Boolean.TRUE : (Boolean)result.get(ISPASSED);
            auditPointEntity.setDisplay(isDisplay);
            DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, entityNumber);
            LocaleString displayName = new LocaleString();
            String displayNameMultiKey = String.format("%s.auditPointModel.auditPoints.[%s].displayname", activityId, auditPointId);
            ILocaleString displayNameExpr = BpmnModelUtil.getMultiLangFieldValue((Long)processInstanceId, (String)displayNameMultiKey, (String)auditPoint.getDisplayname());
            if (WfUtils.isNotEmpty(displayNameExpr)) {
                for (Map.Entry entry : displayNameExpr.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    String displayNameParsered = ExpressionCalculatorUtil.contentParser((String)value, (DynamicObject)dynamicObject, (VariableScope)executionEntity, (boolean)true);
                    if (displayNameParsered.length() > 510) {
                        displayNameParsered = displayNameParsered.substring(0, 509);
                    }
                    displayName.put((Object)key, (Object)displayNameParsered);
                }
                auditPointEntity.setDisplayname((ILocaleString)displayName);
            }
            if (WfUtils.isEmpty(instructionDef = BpmnModelUtil.getMultiLangFieldValue((Long)processInstanceId, (String)(instructionMultiKey = String.format("%s.auditPointModel.auditPoints.[%s].instruction", activityId, auditPointId)), (String)auditPoint.getInstruction()))) {
                instructionDef = new LocaleString(auditPoint.getInstruction());
            }
            auditPointEntity.setDescriptionExpression(instructionDef);
            LocaleString instruction = new LocaleString();
            for (Map.Entry entry : instructionDef.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String instructionParsered = ExpressionCalculatorUtil.contentParser((String)value, (DynamicObject)dynamicObject, (VariableScope)executionEntity, (boolean)true);
                if (instructionParsered.length() > 510) {
                    instructionParsered = instructionParsered.substring(0, 509);
                }
                instruction.put((Object)key, (Object)instructionParsered);
            }
            auditPointEntity.setDescription((ILocaleString)instruction);
            if (AuditPointType.AUTOMATICCHECKS.getNumber().equals(auditPointType)) {
                ConditionalRuleEntity bizRuleEntity = auditPoint.getBizrule();
                auditPointEntity.setBusinessRule(TaskBehaviorUtil.getAuditPointCondRule(bizRuleEntity));
                Map<String, Object> checkResult = TaskBehaviorUtil.getAuditPointRuleResult(execution, bizRuleEntity, (FlowElement)auditTask);
                Boolean isPassed = (Boolean)checkResult.get(ISPASSED);
                String failedReasonMultiKey = String.format("%s.auditPointModel.auditPoints.[%s].errormessage", activityId, auditPointId);
                ILocaleString failedReasonDef = BpmnModelUtil.getMultiLangFieldValue((Long)processInstanceId, (String)failedReasonMultiKey, (String)auditPoint.getErrormessage());
                if (WfUtils.isEmpty(failedReasonDef)) {
                    failedReasonDef = new LocaleString(auditPoint.getErrormessage());
                }
                auditPointEntity.setFailedReasonExpression(failedReasonDef);
                String exceptionMessage = (String)checkResult.get("failedReason");
                if (isPassed.booleanValue()) {
                    auditPointEntity.setCheckResult(AuditPointCheckResult.APPROVE.getNumber());
                } else {
                    auditPointEntity.setCheckResult(AuditPointCheckResult.FAILED.getNumber());
                    LocaleString failedReason = new LocaleString();
                    if (!WfUtils.isEmpty(exceptionMessage)) {
                        if (exceptionMessage.length() > 2000) {
                            exceptionMessage = exceptionMessage.substring(0, 1999);
                        }
                        failedReason = WfUtils.getMultiLangValue(exceptionMessage);
                    } else if (WfUtils.isNotEmpty(failedReasonDef)) {
                        for (Map.Entry entry : failedReasonDef.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            String failedReasonParsered = ExpressionCalculatorUtil.contentParser((String)value, (DynamicObject)dynamicObject, (VariableScope)executionEntity, (boolean)true);
                            if (failedReasonParsered.length() > 2000) {
                                failedReasonParsered = failedReasonParsered.substring(0, 1999);
                            }
                            failedReason.put((Object)key, (Object)failedReasonParsered);
                        }
                    }
                    auditPointEntity.setFailedReason((ILocaleString)failedReason);
                }
                auditPointEntity.setImmediately(Boolean.valueOf(auditPoint.isImmediately()));
            } else if (AuditPointType.MANUALCHECKS.getNumber().equals(auditPointType)) {
                auditPointEntity.setCheckResult(AuditPointCheckResult.UNCONFIRMED.getNumber());
                auditPointEntity.setNeedMark(Boolean.valueOf(auditPoint.isNeedmark()));
                auditPointEntity.setNeedReason(Boolean.valueOf(auditPoint.isNeedreason()));
            }
            auditPointEntityManager.insert((Entity)auditPointEntity);
            ++i;
        }
    }

    private static String getAuditPointCondRule(ConditionalRuleEntity ruleEntity) {
        if (ruleEntity == null) {
            return "";
        }
        if (!WfUtils.isEmpty(ruleEntity.getExpression())) {
            return ruleEntity.getExpression();
        }
        return ruleEntity.getPlugin();
    }

    private static Map<String, Object> getAuditPointRuleResult(DelegateExecution execution, ConditionalRuleEntity conditionRule, FlowElement flowElement) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Boolean isPassed = Boolean.FALSE;
        try {
            if (conditionRule != null) {
                ConditionType.logOpDesc((ConditionalRuleEntity)conditionRule);
                String key = ConditionUtil.getConInstKey((String)flowElement.getNumber(), (String)"auditPoint");
                isPassed = ConditionUtil.hasTrueCondition((ConditionalRuleEntity)conditionRule, (VariableScope)execution, (String)key);
            }
        }
        catch (KDBizException e) {
            result.put("failedReason", e.getMessage());
        }
        result.put(ISPASSED, isPassed);
        return result;
    }

    @Deprecated
    public static void taskDelegate(TaskEntity task, List<Long> nodeParticipantIds, List<Long> autoCoordinatorIds) {
    }

    public static void dispatchTaskAssignListener(TaskEntity taskEntity, String taskCategory) {
        if (!taskEntity.isDisplay()) {
            return;
        }
        boolean canDispatchListener = Boolean.FALSE;
        if (WfUtils.isNotEmpty(taskCategory) && taskCategory.equals(taskEntity.getCategory())) {
            if ("YunzhijiaTask".equals(taskEntity.getCategory())) {
                if (taskEntity.getParentTaskId() != null) {
                    canDispatchListener = Boolean.TRUE;
                }
            } else {
                canDispatchListener = Boolean.TRUE;
            }
        } else if (taskEntity.isBizTask()) {
            canDispatchListener = Boolean.TRUE;
        }
        if (canDispatchListener && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_ASSIGN, (Object)taskEntity));
        }
    }

    public static Set<Long> findTrustParticipants(DelegateSettingEntityManager delegateEntityManager, Long participantId, TaskEntity task, Map<Long, DelegateSettingEntity> taskTrusteeAndDelegate) {
        List enableDelegates = delegateEntityManager.getEnableDelegateByAssignorId(participantId);
        if (enableDelegates == null || enableDelegates.isEmpty()) {
            return new HashSet<Long>();
        }
        logger.debug(String.format("the size of delegateSetting of [%s] is [%s]", participantId, enableDelegates.size()));
        HashSet<Long> trusteeIds = new HashSet<Long>(enableDelegates.size());
        for (DelegateSettingEntity enableDelegate : enableDelegates) {
            if (!TaskBehaviorUtil.hasTrueDelegateCondition(enableDelegate, task)) continue;
            HashMap<Long, DelegateSettingEntity> trusteeAndDelegate = new HashMap<Long, DelegateSettingEntity>();
            TaskBehaviorUtil.findTargetTrustee(delegateEntityManager, enableDelegate, task, participantId, taskTrusteeAndDelegate, trusteeAndDelegate);
            if (taskTrusteeAndDelegate != null) {
                taskTrusteeAndDelegate.putAll(trusteeAndDelegate);
            }
            trusteeIds.addAll(trusteeAndDelegate.keySet());
        }
        return trusteeIds;
    }

    private static boolean hasTrueDelegateCondition(DelegateSettingEntity delegateSetting, TaskEntity task) {
        String delegateExpression = delegateSetting.getDelegateExpression();
        if (WfUtils.isEmpty(delegateExpression)) {
            return true;
        }
        try {
            String key = ConditionUtil.getConInstKey((String)task.getTaskDefinitionKey(), (String)"delegateSetting");
            boolean ret = ConditionUtil.hasTrueCondition((String)delegateExpression, (VariableScope)task, (String)key);
            logger.debug(String.format("delegateSetting[%s-%s] condition[%s],result[%s]", delegateSetting.getAssignorId(), delegateSetting.getTrusteeId(), delegateSetting.getDelegateExpression(), ret));
            return ret;
        }
        catch (Exception e) {
            logger.warn(String.format("Id\u4e3a[%s]\u7684\u5f85\u529e\u4efb\u52a1\u5728\u8fdb\u884c\u59d4\u6258\u6761\u4ef6\u7684\u89e3\u6790\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", task.getId(), WfUtils.getExceptionStacktrace(e)));
            logger.debug(String.format("delegateSetting[%s-%s] condition[%s],result is not match", delegateSetting.getAssignorId(), delegateSetting.getTrusteeId(), delegateSetting.getDelegateExpression()));
            return false;
        }
    }

    private static Map<Long, DelegateSettingEntity> findTargetTrustee(DelegateSettingEntityManager delegateEntityManager, DelegateSettingEntity originDelegate, TaskEntity task, Long assignorId, Map<Long, DelegateSettingEntity> taskTrusteeAndDelegate, Map<Long, DelegateSettingEntity> trusteeAndDelegate) {
        logger.debug(String.format("findTargetTrustee[%s]", assignorId));
        Long procDefId = task.getProcessDefinitionId();
        List actDelegations = delegateEntityManager.getEnableDelegateByAssignorIdAndActivityId(assignorId, procDefId, task.getTaskDefinitionKey());
        logger.debug(String.format("getEnableDelegateByAssignorIdAndActivityId[%s-%s-%s],size is:[%s]", assignorId, procDefId, task.getTaskDefinitionKey(), actDelegations == null ? 0 : actDelegations.size()));
        TaskBehaviorUtil.putTrusteeAndDelegate(delegateEntityManager, originDelegate, task, actDelegations, taskTrusteeAndDelegate, trusteeAndDelegate);
        if (trusteeAndDelegate.isEmpty()) {
            List procDefDelegations = delegateEntityManager.getEnableDelegateByAssignorIdAndProcDefId(assignorId, procDefId);
            logger.debug(String.format("getEnableDelegateByAssignorIdAndProcDefId[%s-%s],size is:[%s]", assignorId, procDefId, procDefDelegations == null ? 0 : procDefDelegations.size()));
            TaskBehaviorUtil.putTrusteeAndDelegate(delegateEntityManager, originDelegate, task, procDefDelegations, taskTrusteeAndDelegate, trusteeAndDelegate);
        }
        if (trusteeAndDelegate.isEmpty()) {
            String entraBillId = MetadataDao.getIdByNumber((String)task.getEntityNumber(), (MetaCategory)MetaCategory.Entity);
            List entraBillDelegations = delegateEntityManager.getEnableDelegateByAssignorIdAndEntraBillId(assignorId, entraBillId);
            logger.debug(String.format("getEnableDelegateByAssignorIdAndEntraBillId[%s-%s],size is:[%s]", assignorId, entraBillId, entraBillDelegations == null ? 0 : entraBillDelegations.size()));
            TaskBehaviorUtil.putTrusteeAndDelegate(delegateEntityManager, originDelegate, task, entraBillDelegations, taskTrusteeAndDelegate, trusteeAndDelegate);
        }
        if (trusteeAndDelegate.isEmpty()) {
            List assignorDelegations = delegateEntityManager.getEnableDelegateEmptyPorcAndBillByAssignorId(assignorId);
            logger.debug(String.format("getEnableDelegateEmptyPorcAndBillByAssignorId[%s],size is:[%s]", assignorId, assignorDelegations == null ? 0 : assignorDelegations.size()));
            TaskBehaviorUtil.putTrusteeAndDelegate(delegateEntityManager, originDelegate, task, assignorDelegations, taskTrusteeAndDelegate, trusteeAndDelegate);
        }
        return trusteeAndDelegate;
    }

    private static void putTrusteeAndDelegate(DelegateSettingEntityManager delegateEntityManager, DelegateSettingEntity originDelegate, TaskEntity task, List<DelegateSettingEntity> delegates, Map<Long, DelegateSettingEntity> taskTrusteeAndDelegate, Map<Long, DelegateSettingEntity> trusteeAndDelegate) {
        if (delegates == null || delegates.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (DelegateSettingEntity delegate : delegates) {
            if (!TaskBehaviorUtil.hasTrueDelegateCondition(delegate, task)) continue;
            Long trusteeId = delegate.getTrusteeId();
            if (originDelegate.getAssignorId().equals(trusteeId)) {
                trusteeAndDelegate.put(delegate.getAssignorId(), originDelegate);
                continue;
            }
            Map<Long, DelegateSettingEntity> newTrusteeAndDelegates = TaskBehaviorUtil.findTargetTrustee(delegateEntityManager, originDelegate, task, trusteeId, taskTrusteeAndDelegate, trusteeAndDelegate);
            sb.append(String.format("findTargetTrustee[%s],size is [%s]", trusteeId, newTrusteeAndDelegates == null ? 0 : newTrusteeAndDelegates.size()));
            if (taskTrusteeAndDelegate != null && taskTrusteeAndDelegate.containsKey(trusteeId)) continue;
            TaskBehaviorUtil.findFinalTrustee(delegateEntityManager, originDelegate, task, trusteeAndDelegate, trusteeId, newTrusteeAndDelegates, sb);
        }
        logger.debug(sb.toString());
    }

    private static void findFinalTrustee(DelegateSettingEntityManager delegateEntityManager, DelegateSettingEntity originDelegate, TaskEntity task, Map<Long, DelegateSettingEntity> trusteeAndDelegate, Long trusteeId, Map<Long, DelegateSettingEntity> newTrusteeAndDelegates, StringBuilder sb) {
        sb.append(String.format("[%s] newTrusteeAndDelegates size:[%s]", trusteeId, newTrusteeAndDelegates == null ? 0 : newTrusteeAndDelegates.size()));
        if (newTrusteeAndDelegates == null || newTrusteeAndDelegates.isEmpty()) {
            EntityQueryBuilder<DelegateSettingEntity> actQueryBuilder = TaskBehaviorUtil.getCommonQueryBuilder(delegateEntityManager, trusteeId);
            actQueryBuilder.addFilter("processdefinitionid", "=", (Object)task.getProcessDefinitionId());
            actQueryBuilder.addFilter("delegatenodeid", "=", (Object)task.getTaskDefinitionKey());
            long cunnt = delegateEntityManager.countByFilter("id", actQueryBuilder.getFilters(), false);
            sb.append(String.format("delegate node[%s-%s-%s],count[%s]", trusteeId, task.getProcessDefinitionId(), task.getTaskDefinitionKey(), cunnt));
            if (cunnt == 0L) {
                EntityQueryBuilder<DelegateSettingEntity> procDefBuilder = TaskBehaviorUtil.getCommonQueryBuilder(delegateEntityManager, trusteeId);
                procDefBuilder.addFilter("processdefinitionid", "=", (Object)task.getProcessDefinitionId());
                String[] parameter = new String[]{task.getTaskDefinitionKey(), " "};
                procDefBuilder.addFilter("delegatenodeid", "in", (Object)parameter);
                cunnt = delegateEntityManager.countByFilter("id", procDefBuilder.getFilters(), false);
                sb.append(String.format("delegate procdef[%s-%s],count[%s]", trusteeId, task.getProcessDefinitionId(), cunnt));
            }
            if (cunnt == 0L) {
                String entraBillId = MetadataDao.getIdByNumber((String)task.getEntityNumber(), (MetaCategory)MetaCategory.Entity);
                EntityQueryBuilder<DelegateSettingEntity> entraBillIdBuilder = TaskBehaviorUtil.getCommonQueryBuilder(delegateEntityManager, trusteeId);
                entraBillIdBuilder.addFilter("entrabillid", "=", (Object)entraBillId);
                cunnt = delegateEntityManager.countByFilter("id", entraBillIdBuilder.getFilters(), false);
                sb.append(String.format("delegate entraBillId[%s-%s],count[%s]", trusteeId, entraBillId, cunnt));
            }
            if (cunnt == 0L) {
                EntityQueryBuilder<DelegateSettingEntity> assignorBuilder = TaskBehaviorUtil.getCommonQueryBuilder(delegateEntityManager, trusteeId);
                assignorBuilder.addFilter("delegatenodeid", "=", (Object)Character.valueOf(' '));
                assignorBuilder.addFilter("processdefinitionid", "=", (Object)0L);
                assignorBuilder.addFilter("entrabillid", "=", (Object)Character.valueOf(' '));
                cunnt = delegateEntityManager.countByFilter("id", assignorBuilder.getFilters(), false);
                sb.append(String.format("delegate person[%s],count[%s]", trusteeId, cunnt));
            }
            if (cunnt == 0L) {
                trusteeAndDelegate.put(trusteeId, originDelegate);
                sb.append(String.format("last trusteeAndDelegate is %s", trusteeId));
            }
        }
    }

    private static EntityQueryBuilder<DelegateSettingEntity> getCommonQueryBuilder(DelegateSettingEntityManager delegateEntityManager, Long assignorId) {
        return delegateEntityManager.getCommonQueryBuilder(assignorId);
    }

    private static void removeInvalidTrusteeForIdentity(Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, List<Long> nodeParticipantIds, List<Long> autoCoordinatorIds, Set<Long> yunzhijiaTrusteeIds) {
        if (assignorIdAndDelegateSettingEntitys == null || assignorIdAndDelegateSettingEntitys.isEmpty()) {
            return;
        }
        ArrayList<Long> trusteeIds = new ArrayList<Long>(assignorIdAndDelegateSettingEntitys.size());
        Set<Map.Entry<Long, List<DelegateSettingEntity>>> trusteeAndDelegateEntrySet = assignorIdAndDelegateSettingEntitys.entrySet();
        Iterator<Map.Entry<Long, List<DelegateSettingEntity>>> trusteeAndDelegateIterator = trusteeAndDelegateEntrySet.iterator();
        while (trusteeAndDelegateIterator.hasNext()) {
            Map.Entry<Long, List<DelegateSettingEntity>> entry = trusteeAndDelegateIterator.next();
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            for (DelegateSettingEntity delegateSettingEntity : entry.getValue()) {
                trusteeIds.add(delegateSettingEntity.getTrusteeId());
            }
        }
        logger.debug(String.format("nodeParticipantIds:%s", WfUtils.listToString(nodeParticipantIds, SPLITFORVALIDATEOPERATION)));
        logger.debug(String.format("autoCoordinatorIds:%s", WfUtils.listToString(autoCoordinatorIds, SPLITFORVALIDATEOPERATION)));
        logger.debug(String.format("yunzhijiaTrusteeIds:%s", WfUtils.listToString(yunzhijiaTrusteeIds, SPLITFORVALIDATEOPERATION)));
        Map userEnableInfo = UserServiceHelper.isUserEnable(trusteeIds);
        if (userEnableInfo == null || userEnableInfo.isEmpty()) {
            return;
        }
        while (trusteeAndDelegateIterator.hasNext()) {
            Map.Entry<Long, List<DelegateSettingEntity>> entry = trusteeAndDelegateIterator.next();
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Iterator<DelegateSettingEntity> delegateSettingIterator = entry.getValue().iterator();
            while (delegateSettingIterator.hasNext()) {
                DelegateSettingEntity delegateSettingEntity = delegateSettingIterator.next();
                Long trusteeId = delegateSettingEntity.getTrusteeId();
                if (nodeParticipantIds != null && nodeParticipantIds.contains(trusteeId)) {
                    delegateSettingIterator.remove();
                }
                if (autoCoordinatorIds != null && autoCoordinatorIds.contains(trusteeId)) {
                    delegateSettingIterator.remove();
                }
                if (yunzhijiaTrusteeIds != null && yunzhijiaTrusteeIds.contains(trusteeId)) {
                    delegateSettingIterator.remove();
                }
                if (userEnableInfo.get(trusteeId) == null || ((Boolean)userEnableInfo.get(trusteeId)).booleanValue()) continue;
                delegateSettingIterator.remove();
            }
        }
    }

    private static void removeInvalidTrusteeForOpLog(List<Long> nodeParticipantIds, List<Long> autoCoordinatorIds, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, Set<Long> yunzhijiaTrusteeIds) {
        Set<Map.Entry<Long, List<DelegateSettingEntity>>> assignorAndTrusteeEntrySet = assignorIdAndDelegateSettingEntitys.entrySet();
        for (Map.Entry<Long, List<DelegateSettingEntity>> entry : assignorAndTrusteeEntrySet) {
            Iterator<DelegateSettingEntity> trusteeIdsIterator = entry.getValue().iterator();
            while (trusteeIdsIterator.hasNext()) {
                Long trusteeId = trusteeIdsIterator.next().getTrusteeId();
                if (!UserServiceHelper.isUserEnable((long)trusteeId) || nodeParticipantIds != null && nodeParticipantIds.contains(trusteeId) || autoCoordinatorIds != null && autoCoordinatorIds.contains(trusteeId)) {
                    trusteeIdsIterator.remove();
                }
                if (yunzhijiaTrusteeIds == null || !yunzhijiaTrusteeIds.contains(trusteeId)) continue;
                trusteeIdsIterator.remove();
            }
        }
    }

    public static ILocaleString getMultiNameById(String userIds) {
        LocaleString result = new LocaleString();
        LocaleString name = new LocaleString();
        for (String userId : userIds.split(SPLITFORVALIDATEOPERATION)) {
            ILocaleString userNameStr = WfUtils.findUserName(Long.valueOf(userId));
            if (WfUtils.isEmpty(userNameStr)) continue;
            for (String key : userNameStr.keySet()) {
                String userName = (String)userNameStr.get((Object)key);
                if (WfUtils.isEmpty(userName)) continue;
                String value = (String)name.get((Object)key);
                if (WfUtils.isNotEmpty(value)) {
                    name.put((Object)key, (Object)(value + userName + SPLITFORVALIDATEOPERATION));
                    continue;
                }
                name.put((Object)key, (Object)(userName + SPLITFORVALIDATEOPERATION));
            }
        }
        for (String key : name.keySet()) {
            String value = (String)name.get((Object)key);
            if (value.length() < 1) continue;
            result.put((Object)key, (Object)WfUtils.substring(value, value.length() - 1, null));
        }
        return result;
    }

    private static Long getOrgUnitId(DelegateExecution execution) {
        Long orgUnitId = 0L;
        try {
            orgUnitId = ((ExecutionEntity)execution).getMainOrgId();
            if (WfUtils.isNotEmpty(orgUnitId)) {
                return orgUnitId;
            }
            Long proDefId = execution.getProcessDefinitionId();
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processEngineConfiguration.getProcessDefinitionEntityManager().findById(proDefId);
            if (processDefinition != null) {
                orgUnitId = processDefinition.getOrgUnitId();
            }
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return orgUnitId;
    }
}

