/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.DeadLetterJobLastHandleCmd;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class DistributeJobHandleStrategy
implements JobHandleStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ProcessEngineConfigurationImpl pf;
    private String dbRouteKey;
    private boolean sourceCanChange = true;

    public DistributeJobHandleStrategy() {
    }

    public DistributeJobHandleStrategy(String source, boolean sourceCanChange) {
        this.dbRouteKey = JobHandleStrategyFactory.getDBRouteKey(source);
        this.sourceCanChange = sourceCanChange;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.pf = processEngineConfiguration;
    }

    public void setSource(String source) {
        if (this.sourceCanChange) {
            this.logger.info("DistributeJobHandleStrategy#setSource:dbRouteKey={},source={}", (Object)this.dbRouteKey, (Object)source);
            this.dbRouteKey = JobHandleStrategyFactory.getDBRouteKey(source);
        }
    }

    public JobEntity extraMessageToJob(Map jsonObject) {
        if (jsonObject != null) {
            String entityNumber;
            Long id = (Long)jsonObject.get("id");
            JobEntity jobEntity = this.findJob(id, false);
            if (jobEntity != null && WfUtils.isNotEmpty(jobEntity.getJobHandlerConfiguration())) {
                WfUtils.restoreRequestContext(jobEntity.getJobHandlerConfiguration());
            }
            if (WfCacheHelper.existWithdrawDeleteBizJobs((String)(entityNumber = (String)jsonObject.get("entityNumber")), (Long)id)) {
                return null;
            }
            return jobEntity;
        }
        return null;
    }

    public void notifyJobFinished(ExecuteJob jobEntity) {
        this.deleteJob(jobEntity);
    }

    public void deleteJob(ExecuteJob jobEntity) {
        JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        dao.deleteJob((JobEntity)jobEntity);
    }

    public JobEntity findJob(Long id, boolean cache) {
        JobDAO jobDao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        return jobDao.findById(id, this.dbRouteKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobEntity> findExpiredJobs(String dbKey) {
        ArrayList<JobEntity> result = new ArrayList<JobEntity>();
        JobDAO jobDao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        List ret = jobDao.findExpiredJobs(dbKey);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (ret != null && ret.size() > 0) {
            List services = WfCommonUtil.getServiceNodes();
            for (JobEntity entity : ret) {
                if (WfUtils.isEmpty(entity.getId())) continue;
                DLockInfo tmp = DLock.getLockInfo((String)String.format("wf/jobexecute/%s", entity.getRootJobId()));
                if (tmp != null) {
                    this.logger.info(String.format("job[%s] \u6b63\u5728\u88ab\u6267\u884c,\u4e0d\u4f1a\u91cd\u590d\u53d1\u9001\u6d88\u606f\u3002", entity.getId()));
                    continue;
                }
                if (JobStateEnum.PREEXECUTING.getNumber().equals(entity.getState()) || JobStateEnum.EXECUTING.getNumber().equals(entity.getState())) {
                    boolean alive = WfCommonUtil.isServiceNodeAlive((List)services, (String)entity.getExecutor());
                    if (alive) {
                        this.logger.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6267\u884c\u673a\u72b6\u6001\u6b63\u5e38\uff0c\u66f4\u65b0\u7f13\u5b58\u3002", entity.getId()));
                        WfCacheHelper.putCurrentExecuteJobState((Long)entity.getId(), (String)entity.getBusinessKey(), (String)entity.getEntityNumber());
                        continue;
                    }
                    this.logger.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u539f\u6267\u884c\u673a\u5df2\u5b95\u673a\uff0c\u5220\u9664\u7f13\u5b58\u3002", entity.getId()));
                    WfCacheHelper.removeCurrentExecuteJobState((Long)entity.getId(), (String)entity.getBusinessKey());
                }
                try {
                    if (entity.getCreateDate() != null && new Date(WfUtils.now().getTime() - 86400000L).after(entity.getCreateDate())) {
                        String markId = String.format("wf/movetodeadjob/%s", entity.getId());
                        boolean flag = false;
                        try {
                            if (WfCacheHelper.putCurrentExecuteBySceneAndKey((String)markId) <= 0) continue;
                            flag = true;
                            DeadLetterJobEntity deadJob = (DeadLetterJobEntity)this.pf.getCommandExecutor().execute((Command)new GetSingleEntityCmd(entity.getRootJobId(), "wf_deadletterjob"));
                            if (deadJob == null) {
                                CommandConfig commandConfig = this.pf.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                                WFEngineException e = new WFEngineException((Throwable)new RuntimeException(ResManager.loadKDString((String)"\u5e95\u5c42\u7ec4\u4ef6\u5f02\u5e38", (String)"EvtJobEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.jobUnKnowError(), new Object[0]);
                                this.pf.getCommandExecutor().execute(commandConfig, (Command)new DeadLetterJobLastHandleCmd(entity, (Throwable)e, true));
                            }
                            this.deleteJob((ExecuteJob)entity);
                            continue;
                        }
                        finally {
                            if (flag) {
                                WfCacheHelper.removeCurrentExecuteBySceneAndKey((String)markId);
                            }
                            continue;
                        }
                    }
                    JobUtil.setJobLockProperty((ExecuteJob)entity, (ProcessEngineConfigurationImpl)this.pf, (AsyncExecutor)this.pf.getAsyncExecutor());
                    if (JobStateEnum.EXECUTING.getNumber().equalsIgnoreCase(entity.getState())) {
                        entity.setState(JobStateEnum.PREEXECUTING.getNumber());
                    }
                    params.add(new Object[]{entity.getLockExpirationTime(), entity.getLockOwnerId(), entity.getRetries(), entity.getState(), entity.getId()});
                    result.add(entity);
                }
                catch (Exception e) {
                    this.logger.error(String.format("job[%s] occurs error when acquiring query in distributejob, error msg is [%s]", entity.getId(), e.getMessage()));
                }
            }
            if (!params.isEmpty()) {
                jobDao.update(dbKey, params);
            }
        }
        return result;
    }

    public void updateJobState(ExecuteJob wfJob, boolean cache) {
        JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        dao.updateState(this.dbRouteKey, wfJob);
    }

    public void updateJobErrorMsg(Long jobId, String error) {
        JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        dao.updateErrorMsg(this.dbRouteKey, jobId, error);
    }

    public List<ExecuteJob> findJobs(List<Long> ids, boolean cache) {
        JobDAO jobDao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        return jobDao.findByIds(ids, this.dbRouteKey);
    }
}

