/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.ErrorHandlerStrategy;
import kd.bos.workflow.engine.impl.jobexecutor.JobFinishNotification;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.service.EvtTraceType;
import kd.bos.workflow.service.WfTraceType;

public abstract class JobErrorHandleCmd
implements Command<Object> {
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    protected Long jobId;
    protected ExecuteJob job;
    protected Throwable exception;
    protected ErrorHandlerStrategy errorStrategy;
    private String exceptionMsg = null;

    public JobErrorHandleCmd(ExecuteJob job, Throwable exception, ErrorHandlerStrategy strategy) {
        this.job = job;
        this.exception = exception;
        this.jobId = job.getId();
        this.errorStrategy = strategy;
    }

    public Object execute(CommandContext commandContext) {
        if (this.job == null) {
            this.job = (ExecuteJob)commandContext.getJobEntityManager().findById(this.jobId);
            if (this.job == null) {
                return null;
            }
        }
        AbstractJobEntity newJobEntity = null;
        if (this.job instanceof JobEntity && WfUtils.isNotEmpty(this.job.getExecutionId()) && !QueryServiceHelper.exists((String)"wf_execution", (Object)this.job.getExecutionId())) {
            JobEntityImpl t = new JobEntityImpl(BusinessDataServiceHelper.loadSingle((Object)this.job.getId(), (String)"wf_job", (String)"state"));
            if (JobStateEnum.COMPLETED.getNumber().equalsIgnoreCase(t.getState())) {
                String expMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\uff0cjob\u5bf9\u5e94\u7684\u6267\u884c\u5b9e\u4f8b\u5df2\u5220\u9664\uff0c\u5e76\u4e14\u5f53\u524djob\u5df2\u6267\u884c\u5b8c\u6210\u3002", (String)"JobRetryCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.job.getExceptionMessage());
                this.job.setExceptionMessage(expMsg);
                this.log.warn(expMsg);
                return null;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5b9e\u4f8b\u201c%1$s\u201d\u5df2\u5220\u9664\uff0c\u6d88\u606f\u201c%2$s\u201d\uff0c\u5c06\u5176\u79fb\u52a8\u5230\u5f02\u5e38\u8868\u4e2d\u3002", (String)"JobRetryCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), this.job.getExecutionId(), this.job.getId());
            this.log.warn(msg);
            this.job.setExceptionMessage(msg);
            newJobEntity = commandContext.getJobManager().moveJobToDeadLetterJob((AbstractJobEntity)this.job, this.exception);
            commandContext.getExecuteJobManager().delete(this.job);
            return newJobEntity;
        }
        ILocalJobHandleStrategy strategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(this.job.getJobType());
        ExecuteJob localJob = strategy.findJob(this.job.getId(), true);
        if (localJob == null) {
            commandContext.getExecuteJobManager().saveOrUpdate(this.job);
        }
        commandContext.addCloseListener((CommandContextCloseListener)new JobFinishNotification(this.job));
        newJobEntity = this.innerExecute(commandContext, strategy);
        if (newJobEntity != null) {
            if (newJobEntity instanceof DeadLetterJobEntity) {
                ((DeadLetterJobEntity)newJobEntity).setExceptionStackMessage(this.exceptionMsg);
            } else {
                newJobEntity.setExceptionMessage(this.exceptionMsg);
            }
        }
        return newJobEntity;
    }

    protected abstract AbstractJobEntity innerExecute(CommandContext var1, ILocalJobHandleStrategy var2);

    public String getExceptionMsg() {
        if (this.exceptionMsg == null && this.exception != null) {
            Throwable readlExcpetion = this.exception;
            if (this.exception instanceof WFEngineException && this.exception.getCause() != null) {
                readlExcpetion = this.exception.getCause();
            }
            this.exceptionMsg = WfUtils.getExceptionStacktrace(readlExcpetion);
            String gzl = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41", (String)"JobRetryCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            if ("event".equals(this.job.getJobType()) && this.exceptionMsg.startsWith(gzl)) {
                this.exceptionMsg = this.exceptionMsg.substring(gzl.length());
            }
        }
        return this.exceptionMsg;
    }

    public void updateJobStatus(CommandContext commandContext, ILocalJobHandleStrategy strategy) {
        ExecuteJob tmp = strategy.findJob(this.job.getId(), true);
        if (tmp != null) {
            boolean ifSaveByVerifySql;
            if ("async-event-dispatch".equals(this.job.getJobHandlerType())) {
                ((EvtJobEntity)tmp).setRootEventInstId(((EvtJobEntity)this.job).getRootEventInstId());
                this.log.warn(String.format("\u8bbe\u7f6e\u5931\u8d25evtjob%s\u7684\u6839\u5b9e\u4f8bId%s", this.job.getId(), ((EvtJobEntity)this.job).getRootEventInstId()));
                if (WfUtils.isEmpty(((EvtJobEntity)tmp).getBizKey())) {
                    ((EvtJobEntity)tmp).setBizKey(((EvtJobEntity)this.job).getBizKey());
                }
            }
            tmp.setState(JobStateEnum.ERRORED.getNumber());
            tmp.setEndTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            tmp.setDuration(tmp.getEndTime().getTime() - tmp.getCreateDate().getTime());
            tmp.setSuccess(false);
            tmp.setExceptionMessage(this.getExceptionMsg());
            boolean bl = ifSaveByVerifySql = !WfConfigurationUtil.notSaveByVerifySql();
            if (ifSaveByVerifySql) {
                if (tmp instanceof EvtJobEntity) {
                    EvtTraceType.EvtTraceJobInfo evtTraceJobInfo = EvtTraceType.getOrCreate().getEvtTraceJobInfo();
                    boolean bl2 = ifSaveByVerifySql = evtTraceJobInfo.getIsUpdate() != null;
                    if (ifSaveByVerifySql) {
                        commandContext.getExecuteJobManager().saveOrUpdateByVerifySql(evtTraceJobInfo.getIsUpdate() == false, tmp);
                        return;
                    }
                } else {
                    WfTraceType.WfTraceJobInfo jobInfo = WfTraceType.getOrCreate().getJobInfo();
                    boolean bl3 = ifSaveByVerifySql = jobInfo != null && jobInfo.getIsUpdate() != null;
                    if (ifSaveByVerifySql) {
                        commandContext.getExecuteJobManager().saveOrUpdateByVerifySql(jobInfo.getIsUpdate() == false, tmp);
                        return;
                    }
                }
            }
            commandContext.getExecuteJobManager().saveOrUpdate(tmp);
        } else {
            this.log.warn(String.format("job[%s] is not exist", this.job.getId()));
        }
    }
}

