/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bec.engine.consumer.DistributeEvtJobHandleStrategy;
import kd.bos.bec.engine.consumer.LocalEvtJobHandleStrategy;
import kd.bos.dataentity.TypesContainer;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.impl.cmd.job.DistributeJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.LocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.OtherSystemJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.TaskJobHelper;
import kd.bos.workflow.engine.runtime.ExecuteJob;

public class JobHandleStrategyFactory {
    public static final String DBROUTE = "dbRoute";
    public static final String MQ = "MQ";
    private static Map<String, JobHandleStrategy> distruteStrategy = new ConcurrentHashMap<String, JobHandleStrategy>(4);

    public static String getWFSource() {
        return "dbRoute_" + DBRoute.workflow.getRouteKey();
    }

    public static boolean isFromWF(String source) {
        if (source == null) {
            return false;
        }
        String DBKEY_WF = String.format("%s_wf", DBROUTE);
        String DBKEY_WFS = String.format("%s_wfs", DBROUTE);
        String DBKEY_WFTASK = String.format("%s_wftask", DBROUTE);
        return DBKEY_WF.equals(source) || DBKEY_WFS.equals(source) || DBKEY_WFTASK.equals(source);
    }

    public static boolean isEventJob(ExecuteJob job) {
        return job != null && "event".equals(job.getJobType()) && (DBRoute.log.getRouteKey().equals(job.getSource()) || "dbRoute_log".equals(job.getSource()));
    }

    public static String getDBRouteKey(String source) {
        if (source != null && source.indexOf("dbRoute_") > -1) {
            return source.substring(source.indexOf("dbRoute_") + 8);
        }
        return source;
    }

    public static String genenateSource(String dbRouteKey) {
        return "dbRoute_" + dbRouteKey;
    }

    public static JobHandleStrategy getJobHandleStrategy(String source, String jobType) {
        if (source == null) {
            return null;
        }
        if ("event".equals(jobType)) {
            if (DBRoute.workflow.getRouteKey().equals(source) || JobHandleStrategyFactory.genenateSource(DBRoute.workflow.getRouteKey()).equals(source) || "dbRoute_wfs".equals(source)) {
                return (LocalEvtJobHandleStrategy)TypesContainer.getOrRegisterSingletonInstance((String)LocalEvtJobHandleStrategy.class.getName());
            }
            String key = String.format("BEC_%s", source);
            JobHandleStrategy ret = distruteStrategy.get(key);
            if (ret == null) {
                ret = new DistributeEvtJobHandleStrategy(source, false);
                distruteStrategy.put(key, ret);
            }
            return ret;
        }
        if ("taskMessage".equals(jobType) || "taskTimer".equals(jobType)) {
            if (DBRoute.workflow.getRouteKey().equals(source) || JobHandleStrategyFactory.genenateSource(DBRoute.workflow.getRouteKey()).equals(source) || "dbRoute_wfs".equals(source)) {
                return TaskJobHelper.getTaskJobStrategyProvider();
            }
        } else {
            if (JobHandleStrategyFactory.isFromWF(source)) {
                return (JobHandleStrategy)TypesContainer.getOrRegisterSingletonInstance((String)LocalJobHandleStrategy.class.getName());
            }
            if (source.startsWith(DBROUTE)) {
                String key = String.format("JOB_%s", source);
                JobHandleStrategy ret = distruteStrategy.get(key);
                if (ret == null) {
                    ret = new DistributeJobHandleStrategy(source, false);
                    distruteStrategy.put(key, ret);
                }
                return ret;
            }
            if (source.startsWith(MQ)) {
                return (JobHandleStrategy)TypesContainer.getOrRegisterSingletonInstance((String)OtherSystemJobHandleStrategy.class.getName());
            }
        }
        return null;
    }

    public static ILocalJobHandleStrategy getLocalJobHandleStrategy(String jobType) {
        if ("event".equals(jobType)) {
            return (LocalEvtJobHandleStrategy)TypesContainer.getOrRegisterSingletonInstance((String)LocalEvtJobHandleStrategy.class.getName());
        }
        if ("taskMessage".equals(jobType) || "taskTimer".equals(jobType)) {
            return (ILocalJobHandleStrategy)TaskJobHelper.getTaskJobStrategyProvider();
        }
        return (LocalJobHandleStrategy)TypesContainer.getOrRegisterSingletonInstance((String)LocalJobHandleStrategy.class.getName());
    }
}

