/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.entity.DeleteEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.FindEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.util.WfBOUtil;

public class LocalJobHandleStrategy
implements ILocalJobHandleStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ProcessEngineConfigurationImpl pf;
    private String dbRouteKey;

    public JobEntity extraMessageToJob(Map jsonObject) {
        if (jsonObject != null) {
            Long id = (Long)jsonObject.get("id");
            JobEntity jobEntity = this.findJob(id, true);
            if (jobEntity != null && WfUtils.isNotEmpty(jobEntity.getJobHandlerConfiguration())) {
                WfUtils.restoreRequestContext(jobEntity.getJobHandlerConfiguration());
            }
            return jobEntity;
        }
        return null;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.pf = processEngineConfiguration;
    }

    public void setSource(String source) {
        this.dbRouteKey = DBRoute.workflow.getRouteKey();
    }

    public void notifyJobFinished(ExecuteJob jobEntity) {
        if (WfUtils.isNotEmpty(jobEntity.getProcessInstanceId()) && !QueryServiceHelper.exists((String)"wf_hiprocinst", (Object)jobEntity.getProcessInstanceId())) {
            ActivitiEventDispatcher eventDispatcher;
            DeleteServiceHelper.delete((String)"wf_job", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobEntity.getId())});
            if ("async-todo".equalsIgnoreCase(jobEntity.getJobHandlerType()) && (eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher()).isEnabled()) {
                eventDispatcher.dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.ENTITY_DELETED, (Object)jobEntity));
            }
        }
    }

    public JobEntity findJob(Long id, boolean cache) {
        if (cache) {
            CommandContext ctx = Context.getCommandContext();
            if (ctx == null) {
                return (JobEntity)this.pf.getCommandExecutor().execute((Command)new GetSingleEntityCmd(id, "wf_job"));
            }
            return (JobEntity)new GetSingleEntityCmd(id, "wf_job").execute(ctx);
        }
        if (WfBOUtil.existByORM((String)"wf_job", (Object)id)) {
            try {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"wf_job");
                return (JobEntity)this.pf.getJobEntityManager().create(obj);
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
        return null;
    }

    public List<JobEntity> findExpiredJobs(String dbKey) {
        return (List)this.pf.getCommandExecutor().execute((Command)new Command<List<JobEntity>>(){

            public List<JobEntity> execute(CommandContext commandContext) {
                return LocalJobHandleStrategy.this.pf.getJobEntityManager().findJobsToExecute(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobState(ExecuteJob wfJob, boolean cache) {
        if (cache) {
            this.pf.getCommandExecutor().execute((Command)new SaveEntityCmd((Entity)wfJob));
        } else {
            TXHandle h = TX.beginNew();
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{wfJob.getDynamicObject()});
            }
            catch (Exception e) {
                h.markRollback();
                this.logger.info(WfUtils.getExceptionStacktrace(e));
            }
            finally {
                h.end();
            }
        }
    }

    public void updateJobErrorMsg(Long jobId, String error) {
        try {
            JobEntity jobEntity = this.findJob(jobId, false);
            if (jobEntity != null) {
                jobEntity.setExceptionMessage(error);
                this.updateJobState((ExecuteJob)jobEntity, false);
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace(e));
        }
    }

    public void deleteJob(ExecuteJob wfJob) {
        this.pf.getCommandExecutor().execute((Command)new DeleteEntityCmd(wfJob.getId(), "wf_job"));
    }

    @Override
    public void insertJobToLocal(ExecuteJob job) {
        this.pf.getExecuteJobManager().saveOrUpdate(job);
    }

    @Override
    public boolean isLocalJob(String dBRouteKey) {
        return DBRoute.workflow.getRouteKey().equals(dBRouteKey);
    }

    @Override
    public boolean exsitDeadLetterJob(Long id) {
        return this.pf.getDeadLetterJobEntityManager().exist(id);
    }

    public List<ExecuteJob> findJobs(List<Long> ids, boolean cache) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        int size = ids.size();
        ArrayList<ExecuteJob> list = new ArrayList<ExecuteJob>(size);
        if (size == 1) {
            list.add((ExecuteJob)this.findJob(ids.get(0), cache));
            return list;
        }
        if (cache) {
            CommandContext ctx = Context.getCommandContext();
            EntityQueryBuilder eb = this.pf.getJobEntityManager().createQueryBuilder();
            eb.addFilter("id", "in", (Object)ids.toArray());
            List jobEntityList = null;
            jobEntityList = ctx == null ? (List)this.pf.getCommandExecutor().execute((Command)new FindEntityCmd(eb, "wf_job")) : new FindEntityCmd(eb, "wf_job").execute(ctx);
            if (jobEntityList != null && jobEntityList.size() > 0) {
                list.addAll(jobEntityList);
            }
            return list;
        }
        try {
            EntityMetadataCache.getDataEntityType((String)"wf_job");
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_job"));
            if (objs != null && objs.length > 0) {
                for (DynamicObject obj : objs) {
                    list.add((ExecuteJob)this.pf.getJobEntityManager().create(obj));
                }
            }
            return list;
        }
        catch (Exception e) {
            this.logger.debug(String.format("find no job, %1$s--%2$s", ids, WfUtils.getExceptionStacktrace(e)));
            this.logger.warn(String.format("find no job, %s", ids));
            return null;
        }
    }

    @Override
    public DynamicObjectCollection findChannelTasksByJobExecuteJob(JobEntity jobEntity) {
        try {
            QFilter[] qFilters = new QFilter[]{new QFilter("businesskey", "=", (Object)jobEntity.getBusinessKey()), new QFilter("elementid", "=", (Object)jobEntity.getElementId()), new QFilter("jobHandlerType", "=", (Object)jobEntity.getJobHandlerType())};
            return QueryServiceHelper.query((String)"wf_job", (String)this.pf.getJobEntityManager().getSelectFields(), (QFilter[])qFilters);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            return null;
        }
    }
}

